/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.wizard.exampleproject;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.util.JavaUtil;
import org.eclipse.hyades.ui.internal.util.ResourceUtil;
import org.eclipse.hyades.ui.internal.util.StringUtil;
import org.eclipse.hyades.ui.internal.util.UIMessages;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.hyades.ui.internal.wizard.exampleproject.CreationOperation;
import org.eclipse.hyades.ui.internal.wizard.exampleproject.CreationWizardPage;
import org.eclipse.hyades.ui.internal.wizard.exampleproject.IProjectAdjuster;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class CreationWizard
extends BasicNewResourceWizard
implements INewWizard,
IExecutableExtension {
    private CreationWizardPage[] pages;
    private IConfigurationElement wizardConfigurationElement;
    private IConfigurationElement sampleConfigurationElement;
    private CreationOperation runnable;
    private IProjectAdjuster adjuster;
    private boolean disableOpenResources;

    public CreationWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        IConfigurationElement[] children;
        String windowTitle;
        super.addPages();
        this.disableOpenResources = false;
        if ((this.getWindowTitle() == null || this.getWindowTitle().trim().length() == 0) && (windowTitle = UIMessages._53) != null) {
            this.setWindowTitle(windowTitle);
        }
        if ((children = this.sampleConfigurationElement.getChildren("projectsetup")) == null || children.length == 0) {
            HyadesUIPlugin.logError(UIMessages._34);
            return;
        }
        this.pages = new CreationWizardPage[children.length];
        int i = 0;
        while (i < children.length) {
            CreationWizardPage page = this.createWizardPage("newProject" + i, children[i]);
            if (page != null) {
                this.pages[i] = page;
                this.addPage((IWizardPage)this.pages[i]);
            }
            ++i;
        }
    }

    protected CreationWizardPage createWizardPage(String suggestedName, IConfigurationElement configurationElement) {
        return new CreationWizardPage(this, suggestedName, configurationElement);
    }

    protected CreationWizardPage[] getCreationWizardPages() {
        return this.pages;
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        int i = 0;
        while (i < this.pages.length) {
            this.pages[i].setHelpId();
            ++i;
        }
    }

    public IProjectAdjuster getAdjuster() {
        return this.adjuster;
    }

    public void setAdjuster(IProjectAdjuster adjuster) {
        this.adjuster = adjuster;
        if (this.runnable != null) {
            this.runnable.setAdjuster(adjuster);
        }
    }

    private void adjustClasspathVariable() {
        IConfigurationElement[] classpathVars = this.sampleConfigurationElement.getChildren("classpathVariable");
        int i = 0;
        while (i < classpathVars.length) {
            String name = classpathVars[i].getAttribute("name");
            String value = classpathVars[i].getAttribute("value");
            boolean overwrite = Boolean.valueOf(classpathVars[i].getAttribute("overwrite"));
            if (name != null && value != null && (overwrite || JavaUtil.getVariableValue(name) == null) && (value = this.replaceClasspathVariables(value)) != null) {
                try {
                    JavaUtil.setVariableValue(name, value, null);
                }
                catch (Exception exception) {}
            }
            ++i;
        }
    }

    protected String replaceClasspathVariables(String value) {
        value = this.replaceVariableByPluginDirectory(value, "${plugins}", this.wizardConfigurationElement.getDeclaringExtension().getNamespace(), true);
        value = this.replaceVariableByPluginDirectory(value, "${base.plugins}", "org.eclipse.core.boot", true);
        String[] pluginIds = this.getPluginIdsToResolve(value);
        int i = 0;
        while (i < pluginIds.length) {
            value = this.replaceVariableByPluginDirectory(value, "${pluginId=\"" + pluginIds[i] + "\"}", pluginIds[i], false);
            ++i;
        }
        return value;
    }

    protected String replaceVariableByPluginDirectory(String text, String var, String pluginId, boolean useParentDir) {
        File dir;
        if (text.indexOf(var) >= 0 && (dir = ResourceUtil.getPluginDirectory(pluginId)) != null) {
            if (useParentDir) {
                dir = dir.getAbsoluteFile().getParentFile();
            }
            if (dir != null) {
                text = StringUtil.replace(text, var, dir.getAbsolutePath());
            }
        }
        return text;
    }

    protected String[] getPluginIdsToResolve(String text) {
        String[] tokens = StringUtil.tokenizer(text, "${pluginId=\"", false);
        if (tokens.length <= 1) {
            return new String[0];
        }
        HashSet<String> variables = new HashSet<String>(tokens.length - 1);
        int i = 1;
        while (i < tokens.length) {
            int index = tokens[i].indexOf("\"}");
            if (index >= 0) {
                variables.add(tokens[i].substring(0, index));
            }
            ++i;
        }
        return variables.toArray(new String[variables.size()]);
    }

    protected boolean finishWork() {
        return true;
    }

    public boolean performFinish() {
        this.adjustClasspathVariable();
        this.runnable = new CreationOperation(this, new ImportOverwriteQuery());
        this.runnable.setAdjuster(this.adjuster);
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation((IRunnableWithProgress)this.runnable);
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            this.handleException(e.getTargetException());
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        if (this.adjuster != null) {
            this.adjuster.beforeWorspaceRefresh(this.pages);
        }
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.wizardConfigurationElement);
        if (this.adjuster != null) {
            this.adjuster.afterWorspaceRefresh(this.pages);
        }
        if (!this.disableOpenResources) {
            IResource[] resources = this.runnable.getResourcesToOpen();
            this.finishWork();
            int i = 0;
            while (i < resources.length) {
                if (resources[i] instanceof IFile) {
                    String editorId = this.runnable.getEditorId(resources[i]);
                    boolean editorOpened = false;
                    try {
                        editorOpened = UIUtil.openEditor((IFile)resources[i], editorId, false) != null;
                    }
                    catch (Throwable t) {
                        HyadesUIPlugin.logError(t);
                    }
                    if (!editorOpened) {
                        try {
                            UIUtil.openEditor((IFile)resources[i], null, false);
                        }
                        catch (Throwable t) {
                            HyadesUIPlugin.logError(t);
                        }
                    }
                }
                ++i;
            }
            if (resources.length > 0) {
                this.selectAndReveal(resources[resources.length - 1]);
            }
        }
        this.runnable.dispose();
        return true;
    }

    private void handleException(Throwable throwable) {
        HyadesUIPlugin.logError(throwable);
        String[] options = new String[]{IDialogConstants.OK_LABEL};
        new MessageDialog(this.getShell(), UIMessages._8, null, UIMessages._35, 1, options, 0);
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        String wizardId;
        this.wizardConfigurationElement = cfig;
        if (this.wizardConfigurationElement != null && (wizardId = this.wizardConfigurationElement.getAttribute("id")) != null) {
            IConfigurationElement[] configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(HyadesUIPlugin.getID(), "sampleWizards");
            int i = 0;
            int max = configurationElements.length;
            while (i < max) {
                if ("sampleWizard".equals(configurationElements[i].getName()) && wizardId.equals(configurationElements[i].getAttribute("wizardId"))) {
                    this.sampleConfigurationElement = configurationElements[i];
                    break;
                }
                ++i;
            }
        }
        if (this.sampleConfigurationElement == null) {
            throw new RuntimeException("This sample doesn't have a Sample Project extension point associated with the wizard.");
        }
    }

    protected String getPluginId() {
        if (this.wizardConfigurationElement == null) {
            return null;
        }
        return this.wizardConfigurationElement.getDeclaringExtension().getNamespace();
    }

    protected void initializeDefaultPageImageDescriptor() {
        ImageDescriptor imageDescriptor;
        String banner = this.sampleConfigurationElement.getAttribute("banner");
        if (banner != null && (imageDescriptor = UIUtil.getImageDescriptorFromPlugin(Platform.getBundle((String)this.wizardConfigurationElement.getDeclaringExtension().getNamespace()), banner)) != null) {
            this.setDefaultPageImageDescriptor(imageDescriptor);
            return;
        }
        super.initializeDefaultPageImageDescriptor();
    }

    public void disableResourceOpening(boolean disableOpening) {
        this.disableOpenResources = disableOpening;
    }

    private class ImportOverwriteQuery
    implements IOverwriteQuery {
        ImportOverwriteQuery() {
        }

        public String queryOverwrite(String file) {
            String[] returnCodes = new String[]{"YES", "NO", "ALL", "CANCEL"};
            int returnVal = this.openDialog(file);
            return returnVal < 0 ? "CANCEL" : returnCodes[returnVal];
        }

        private int openDialog(String file) {
            int[] result = new int[]{1};
            CreationWizard.this.getShell().getDisplay().syncExec(new Runnable(this, file, result){
                final /* synthetic */ ImportOverwriteQuery this$1;
                private final /* synthetic */ String val$file;
                private final /* synthetic */ int[] val$result;
                {
                    this.this$1 = importOverwriteQuery;
                    this.val$file = string;
                    this.val$result = nArray;
                }

                public void run() {
                    String msg = NLS.bind((String)UIMessages._32, (Object)this.val$file);
                    String title = UIMessages._7;
                    String[] options = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.CANCEL_LABEL};
                    MessageDialog dialog = new MessageDialog(ImportOverwriteQuery.access$0(this.this$1).getShell(), title, null, msg, 3, options, 0);
                    this.val$result[0] = dialog.open();
                }
            });
            return result[0];
        }

        static /* synthetic */ CreationWizard access$0(ImportOverwriteQuery importOverwriteQuery) {
            return importOverwriteQuery.CreationWizard.this;
        }
    }
}

