/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.wizard.selection;

import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.util.UIMessages;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.hyades.ui.internal.wizard.selection.IWizardElement;
import org.eclipse.hyades.ui.internal.wizard.selection.WizardElementWorkbenchAdapter;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.jface.wizard.WizardSelectionPage;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.model.WorkbenchViewerSorter;

public class SelectionPage
extends WizardSelectionPage
implements ISelectionChangedListener,
IDoubleClickListener {
    private static final String SET_SELECTED_WIZARD_ID = "SelectionPage.STORE_SELECTED_WIZARD_ID";
    private static final int SIZING_LISTS_HEIGHT = 200;
    private IWorkbench workbench;
    private IStructuredSelection structuredSelection;
    private IWizardElement[] wizardElements;
    private String message;
    private TableViewer wizardSelectionViewer;
    static /* synthetic */ Class class$0;

    public SelectionPage(String pageName, IWorkbench workbench, IStructuredSelection structuredSelection, IWizardElement[] wizardElements, String message) {
        super(pageName);
        this.workbench = workbench;
        this.structuredSelection = structuredSelection;
        this.wizardElements = wizardElements;
        this.message = message;
        this.setTitle(UIMessages._49);
        this.setMessage(UIMessages._50);
    }

    public void dispose() {
        this.workbench = null;
        this.structuredSelection = null;
        this.wizardElements = null;
        super.dispose();
    }

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    public IStructuredSelection getStructuredSelection() {
        return this.structuredSelection;
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite outerContainer = new Composite(parent, 0);
        outerContainer.setLayout((Layout)new GridLayout());
        outerContainer.setLayoutData((Object)new GridData(1808));
        outerContainer.setFont(font);
        Label messageLabel = new Label(outerContainer, 0);
        messageLabel.setText(this.message);
        messageLabel.setFont(font);
        Table table = new Table(outerContainer, 2048);
        GridData data = new GridData(1808);
        int availableRows = UIUtil.availableRows(parent);
        data.heightHint = availableRows > 50 ? 200 : availableRows * 3;
        table.setLayoutData((Object)data);
        table.setFont(font);
        this.wizardSelectionViewer = new TableViewer(table);
        this.wizardSelectionViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.wizardSelectionViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.wizardSelectionViewer.setSorter((ViewerSorter)new WorkbenchViewerSorter());
        this.wizardSelectionViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.wizardSelectionViewer.addDoubleClickListener((IDoubleClickListener)this);
        this.wizardSelectionViewer.setInput((Object)new WizardElementWorkbenchAdapter(this.wizardElements));
        this.restoreWidgetValues();
        table.setFocus();
        this.addCustomPart(outerContainer);
        this.setControl((Control)outerContainer);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.wizardSelectionViewer.getControl(), String.valueOf(HyadesUIPlugin.getID()) + ".swip0001");
    }

    protected void addCustomPart(Composite parent) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.setErrorMessage(null);
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        IWizardElement wizardElement = (IWizardElement)selection.getFirstElement();
        if (wizardElement == null) {
            this.setMessage(null);
            this.setSelectedNode(null);
            return;
        }
        this.setSelectedNode(this.createWizardNode(wizardElement));
        this.setMessage(wizardElement.getDescription());
    }

    public void doubleClick(DoubleClickEvent event) {
        this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this.wizardSelectionViewer, this.wizardSelectionViewer.getSelection()));
        this.getContainer().showPage(this.getNextPage());
    }

    public void saveWidgetValues() {
        IWizardElement wizardElement;
        if (this.getDialogSettings() == null) {
            return;
        }
        IStructuredSelection sSelection = (IStructuredSelection)this.wizardSelectionViewer.getSelection();
        if (!sSelection.isEmpty() && (wizardElement = (IWizardElement)sSelection.getFirstElement()).getId() != null) {
            this.getDialogSettings().put(SET_SELECTED_WIZARD_ID, wizardElement.getId());
        }
    }

    private void restoreWidgetValues() {
        if (this.getDialogSettings() == null) {
            return;
        }
        String wizardElementId = this.getDialogSettings().get(SET_SELECTED_WIZARD_ID);
        if (wizardElementId == null) {
            return;
        }
        IWizardElement wizardElement = this.findWizardElement(wizardElementId);
        if (wizardElement == null) {
            return;
        }
        StructuredSelection selection = new StructuredSelection((Object)wizardElement);
        this.wizardSelectionViewer.setSelection((ISelection)selection);
        this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this.wizardSelectionViewer, (ISelection)selection));
    }

    protected IWizardElement findWizardElement(String wizardElementId) {
        int i = 0;
        while (i < this.wizardElements.length) {
            if (wizardElementId.equals(this.wizardElements[i].getId())) {
                return this.wizardElements[i];
            }
            ++i;
        }
        return null;
    }

    protected IWizardNode createWizardNode(IWizardElement wizardElement) {
        IWizard wizard;
        IWizardNode wizardNode;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.wizard.IWizardNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((wizardNode = (IWizardNode)wizardElement.getAdapter(clazz)) != null && !wizardNode.isContentCreated() && (wizard = wizardNode.getWizard()) instanceof IWorkbenchWizard) {
            ((IWorkbenchWizard)wizard).init(this.getWorkbench(), this.getStructuredSelection());
            wizard.addPages();
        }
        return wizardNode;
    }

    public void setWizardElements(IWizardElement[] elements) {
        this.wizardElements = elements;
        this.wizardSelectionViewer.setInput((Object)new WizardElementWorkbenchAdapter(this.wizardElements));
        this.restoreWidgetValues();
    }
}

