/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.provisional.context;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.context.ContextMappingPreference;
import org.eclipse.hyades.ui.internal.context.ContextOpenSourceHandler;
import org.eclipse.hyades.ui.provisional.context.ContextManager;
import org.eclipse.hyades.ui.provisional.context.IContextLanguage;
import org.eclipse.hyades.ui.provisional.context.IContextOpenSourceHandler;
import org.eclipse.hyades.ui.provisional.context.IContextOpenSourceProvider;

public class ContextOpenSourceHandlerManager {
    private static ContextOpenSourceHandlerManager instance;
    protected final String CONTEXT_OPEN_SRC_HANDLER_EXTENTION_POINT = "contextOpenSourceProviders";
    protected final String CONTEXT_OPEN_SRC_HANDLER_ELEMENT = "contextOpenSourceProvider";
    private Map contextOpenSourceHandlers;
    private ContextMappingPreference contextMappingPreference = new ContextMappingPreference(HyadesUIPlugin.getInstance().getPreferenceStore());

    private ContextOpenSourceHandlerManager() {
    }

    public static ContextOpenSourceHandlerManager instance() {
        if (instance == null) {
            instance = new ContextOpenSourceHandlerManager();
        }
        return instance;
    }

    private void initialize() {
        this.contextOpenSourceHandlers = new HashMap();
        IContextLanguage[] contexts = ContextManager.getContextLanguages();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.hyades.ui", "contextOpenSourceProviders");
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement elem = elements[i];
                if (elem.getName().equals("contextOpenSourceProvider")) {
                    String id = elem.getAttribute("id");
                    IContextOpenSourceProvider contextOpenSourceProvider = null;
                    try {
                        if (!"".equals(elem.getAttribute("class"))) {
                            Object cls = elem.createExecutableExtension("class");
                            if (cls instanceof IContextOpenSourceProvider) {
                                contextOpenSourceProvider = (IContextOpenSourceProvider)cls;
                            } else {
                                HyadesUIPlugin.logError("Class in extension point org.eclipse.hyades.uicontextOpenSourceProviders must implement IContextOpenSourceProvider");
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    String excludeContext = elem.getAttribute("excludeContext");
                    IConfigurationElement[] contextsElems = elem.getChildren("contexts");
                    Vector<String> contextsV1 = new Vector<String>();
                    int k = 0;
                    while (k < contextsElems.length) {
                        contextsV1.addElement(contextsElems[k].getChildren()[0].getAttribute("refID"));
                        ++k;
                    }
                    String[] contextsA = new String[contextsV1.size()];
                    contextsV1.toArray(contextsA);
                    if (id != null && contextOpenSourceProvider != null) {
                        ContextOpenSourceHandler ch = new ContextOpenSourceHandler(id, contextOpenSourceProvider, "true".equals(excludeContext), contextsA.length == 0 ? null : contextsA);
                        int j = 0;
                        while (j < contexts.length) {
                            Vector<ContextOpenSourceHandler> contextsV = (Vector<ContextOpenSourceHandler>)this.contextOpenSourceHandlers.get(contexts[j].contextKey());
                            if (contextsV == null) {
                                contextsV = new Vector<ContextOpenSourceHandler>();
                                this.contextOpenSourceHandlers.put(contexts[j].contextKey(), contextsV);
                            }
                            if (this.keyInContextHandler(contexts[j].contextKey(), ch)) {
                                contextsV.addElement(ch);
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
    }

    private boolean keyInContextHandler(String key, IContextOpenSourceHandler ch) {
        if (ch.contexts() == null) {
            return !ch.excludeContexts();
        }
        int i = 0;
        while (i < ch.contexts().length) {
            if (key.equals(ch.contexts()[i])) {
                return !ch.excludeContexts();
            }
            ++i;
        }
        return ch.excludeContexts();
    }

    private IContextOpenSourceProvider internalGetContextOpenSourceProvider(String contextKey) {
        IContextOpenSourceHandler handler;
        if (contextKey == null) {
            return null;
        }
        if (this.contextOpenSourceHandlers == null) {
            this.initialize();
        }
        if (this.contextMappingPreference.changed()) {
            this.contextMappingPreference.populateMappingByContext();
        }
        if ((handler = this.getContextOpenSourceHandlerById(contextKey, this.contextMappingPreference.getContextOpenSourceProviderId(contextKey))) != null) {
            return handler.getContextOpenSourceProvider();
        }
        return null;
    }

    public static IContextOpenSourceProvider getContextOpenSourceProvider(String contextKey) {
        return ContextOpenSourceHandlerManager.instance().internalGetContextOpenSourceProvider(contextKey);
    }

    private IContextOpenSourceHandler getContextOpenSourceHandlerById(String contextKey, String id) {
        IContextOpenSourceHandler[] ch = ContextOpenSourceHandlerManager.getContextOpenSourceHandlers(contextKey);
        int i = 0;
        while (i < ch.length) {
            if (ch[i].id().equals(id)) {
                return ch[i];
            }
            ++i;
        }
        return null;
    }

    private Vector getContextOpenSourceHandlersByKey(String key) {
        Vector v = (Vector)this.contextOpenSourceHandlers.get(key);
        if (v != null) {
            return v;
        }
        return new Vector();
    }

    private IContextOpenSourceHandler[] internalGetContextOpenSourceHandlers(String contextKey) {
        Vector v;
        if (this.contextOpenSourceHandlers == null) {
            this.initialize();
        }
        if (contextKey != null) {
            v = this.getContextOpenSourceHandlersByKey(contextKey);
        } else {
            v = new Vector();
            Iterator i = this.contextOpenSourceHandlers.keySet().iterator();
            while (i.hasNext()) {
                v.addAll(this.getContextOpenSourceHandlersByKey((String)i.next()));
            }
        }
        IContextOpenSourceHandler[] contextOpenSourceHandlersResult = new IContextOpenSourceHandler[v.size()];
        v.toArray(contextOpenSourceHandlersResult);
        return contextOpenSourceHandlersResult;
    }

    public static IContextOpenSourceHandler[] getContextOpenSourceHandlers(String contextKey) {
        return ContextOpenSourceHandlerManager.instance().internalGetContextOpenSourceHandlers(contextKey);
    }
}

