/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.widgets.grapher;

import java.util.ArrayList;
import org.eclipse.hyades.ui.widgets.grapher.BasicGraph;
import org.eclipse.hyades.ui.widgets.grapher.Graph;
import org.eclipse.hyades.ui.widgets.grapher.GraphHighlighter;
import org.eclipse.hyades.ui.widgets.grapher.GraphSelectionSource;
import org.eclipse.hyades.ui.widgets.grapher.TextGraph;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class GraphCanvas
extends Canvas
implements PaintListener {
    private ArrayList graphs = new ArrayList();
    private ArrayList postGraphs = new ArrayList();
    private ArrayList preGraphs = new ArrayList();
    private static final boolean PAINT_BUFFERED = true;
    private int buffer_w = -1;
    private int buffer_h = -1;
    private Image buffer = null;
    private GC buffer_gc = null;
    private int xoffset;
    private int yoffset;
    private Color bgcol;
    private GraphHighlighter highlighter = null;
    private GraphSelectionSource selection_source = null;

    public GraphCanvas(Composite parent, int style) {
        super(parent, style | 0x40000);
        this.addPaintListener(this);
        this.setBackground(this.getDisplay().getSystemColor(25));
    }

    public void addGraph(Graph graph) {
        if (graph instanceof BasicGraph) {
            ((BasicGraph)((Object)graph)).setShown(true);
        }
        this.graphs.add(graph);
        graph.setGraphCanvas(this);
    }

    public void addPostGraph(Graph graph) {
        if (graph instanceof BasicGraph) {
            ((BasicGraph)((Object)graph)).setShown(true);
        }
        this.postGraphs.add(graph);
        graph.setGraphCanvas(this);
    }

    public void addPreGraph(Graph graph) {
        if (graph instanceof BasicGraph) {
            ((BasicGraph)((Object)graph)).setShown(true);
        }
        this.preGraphs.add(graph);
        graph.setGraphCanvas(this);
    }

    public void removePostGraph(Graph graph) {
        if (graph instanceof BasicGraph) {
            ((BasicGraph)((Object)graph)).setShown(true);
        }
        this.postGraphs.remove(graph);
    }

    public void removePreGraph(Graph graph) {
        if (graph instanceof BasicGraph) {
            ((BasicGraph)((Object)graph)).setShown(true);
        }
        this.preGraphs.remove(graph);
    }

    public void removeGraph(Graph graph) {
        if (graph instanceof BasicGraph) {
            ((BasicGraph)((Object)graph)).setShown(false);
        }
        this.graphs.remove(graph);
    }

    public void removeAllGraphs() {
        Graph g;
        int i = 0;
        while (i < this.graphs.size()) {
            g = (Graph)this.graphs.get(i);
            if (g instanceof BasicGraph) {
                ((BasicGraph)((Object)g)).setShown(false);
            }
            ++i;
        }
        i = 0;
        while (i < this.preGraphs.size()) {
            g = (Graph)this.preGraphs.get(i);
            if (g instanceof BasicGraph) {
                ((BasicGraph)((Object)g)).setShown(false);
            }
            ++i;
        }
        i = 0;
        while (i < this.postGraphs.size()) {
            g = (Graph)this.postGraphs.get(i);
            if (g instanceof BasicGraph) {
                ((BasicGraph)((Object)g)).setShown(false);
            }
            ++i;
        }
        this.postGraphs.clear();
        this.graphs.clear();
        this.preGraphs.clear();
    }

    public void dispose() {
        super.dispose();
        if (this.buffer != null) {
            this.buffer.dispose();
            this.buffer_gc.dispose();
            if (this.bgcol != null) {
                this.bgcol.dispose();
            }
        }
    }

    public void setBackground(RGB rgb) {
        if (this.bgcol != null) {
            this.bgcol.dispose();
        }
        this.bgcol = new Color((Device)this.getDisplay(), rgb);
        super.setBackground(this.bgcol);
    }

    public void setGraphHighlighter(GraphHighlighter highlighter) {
        this.highlighter = highlighter;
    }

    public void setGraphSelectionSource(GraphSelectionSource source) {
        this.selection_source = source;
    }

    public Point getOffsets() {
        return new Point(this.xoffset, this.yoffset);
    }

    public void setOffsets(Point newOffsets) {
        this.xoffset = newOffsets.x;
        this.yoffset = newOffsets.y;
    }

    public void paintControl(PaintEvent e) {
        GC gc = e.gc;
        int cfr_ignored_0 = e.x;
        int cfr_ignored_1 = e.y;
        int w = e.width;
        int h = e.height;
        if (w < 1 || h < 1) {
            return;
        }
        if ((this.buffer_w < w || this.buffer_h < h) && this.buffer != null) {
            this.buffer.dispose();
            this.buffer_gc.dispose();
            this.buffer = null;
            this.buffer_gc = null;
        }
        if (this.buffer == null) {
            if (this.getDisplay() == null) {
                return;
            }
            this.buffer_w = Math.max(this.buffer_w, w);
            this.buffer_h = Math.max(this.buffer_h, h);
            this.buffer = new Image((Device)this.getDisplay(), this.buffer_w, this.buffer_h);
            this.buffer_gc = new GC((Drawable)this.buffer);
        }
        this.paintUnbuffered(this.buffer_gc, 0, 0, w, h);
        gc.drawImage(this.buffer, 0, 0);
    }

    public void paintUnbuffered(GC gc, int x, int y, int w, int h) {
        Graph g;
        Graph highlighted = null;
        if (this.highlighter != null && this.selection_source != null) {
            highlighted = this.selection_source.getSelectedGraph();
        }
        Color c = this.getBackground();
        gc.setBackground(c);
        gc.fillRectangle(x, y, w + this.xoffset, h + this.yoffset);
        gc.fillRectangle(0, 0, 10000, 10000);
        int textoffset = 0;
        int i = 0;
        while (i < this.preGraphs.size()) {
            g = (Graph)this.preGraphs.get(i);
            g.paintGraph(gc, x + this.xoffset, y + this.yoffset, w, h);
            ++i;
        }
        i = 0;
        while (i < this.graphs.size()) {
            g = (Graph)this.graphs.get(i);
            if (g == highlighted) {
                this.highlighter.setHighlight(g);
            }
            if (g instanceof TextGraph) {
                textoffset = ((TextGraph)g).paintGraph(gc, x + this.xoffset, y + this.yoffset, w, h, textoffset);
            } else {
                g.paintGraph(gc, x + this.xoffset, y + this.yoffset, w, h);
            }
            if (g == highlighted) {
                this.highlighter.unsetHighlight(g);
            }
            ++i;
        }
        i = 0;
        while (i < this.postGraphs.size()) {
            g = (Graph)this.postGraphs.get(i);
            g.paintGraph(gc, x + this.xoffset, y + this.yoffset, w, h);
            ++i;
        }
    }

    public ArrayList getGraphs() {
        return this.graphs;
    }

    public ArrayList getPreGraphs() {
        return this.preGraphs;
    }

    public ArrayList getPostGraphs() {
        return this.postGraphs;
    }
}

