/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.widgets.zoomslider;

import java.util.Date;
import java.util.GregorianCalendar;
import org.eclipse.hyades.ui.widgets.zoomslider.TimeZoomSliderTick;
import org.eclipse.hyades.ui.widgets.zoomslider.ZoomSlider;
import org.eclipse.hyades.ui.widgets.zoomslider.ZoomSliderUtilities;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;

public class TimeZoomSlider
extends ZoomSlider {
    private static final double[] LINEAR_PROGRESSION = new double[]{1.0, 2.0, 5.0};
    private static final double[] OOM4 = new double[]{1.0, 2.0, 3.0, 6.0};
    private static final double[] OOM5 = new double[]{1.2, 3.0, 6.0};
    private static final double[] OOM6 = new double[]{1.2, 1.8, 3.6, 7.2};
    private static final double[] OOM7 = new double[]{1.44, 2.16, 4.32, 8.64};
    private static final double[] GTOOM7 = new double[]{0.864, 1.728, 5.184};
    private GregorianCalendar calendar = new GregorianCalendar();
    private boolean wallTime = true;

    public TimeZoomSlider(Composite parent) {
        super(parent);
    }

    public GregorianCalendar getGregorianCalendar() {
        return this.calendar;
    }

    protected void createTicks() {
        this.calculateIncrement();
        this.tickVector.removeAllElements();
        double tickValue = ZoomSliderUtilities.round(this.visible[0] - this.increment, this.increment);
        while (tickValue <= this.visible[1] + this.increment) {
            this.tickVector.addElement(new TimeZoomSliderTick(this, tickValue));
            tickValue += this.increment;
            tickValue = ZoomSliderUtilities.round(tickValue, this.increment);
        }
        int selectablePoints = 10;
        int tickSpacing = (int)((double)this.getPixelRange() / (this.getVisibleValueRange() / this.increment));
        if (tickSpacing < 20) {
            selectablePoints = 5;
        }
        this.unitIncrement = this.increment / (double)selectablePoints;
        if (this.unitIncrement < this.resolution) {
            this.unitIncrement = this.resolution;
        }
    }

    public void setWallTime(boolean wall) {
        this.wallTime = wall;
    }

    public boolean isWallTime() {
        return this.wallTime;
    }

    public void findDecimalPointPosition() {
        GC gcTemp = new GC((Drawable)this);
        this.decimalPointPosition = this.getBounds().width - 10;
        gcTemp.dispose();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point standard = super.computeSize(wHint, hHint, changed);
        Point size = new Point(standard.x, standard.y);
        if (this.orientation == 0) {
            if (wHint == -1) {
                GC gcTemp = new GC((Drawable)this);
                size.x = gcTemp.stringExtent((String)"99:99:99").x + 20;
                gcTemp.dispose();
            } else {
                size.x = wHint;
            }
            if (hHint != -1) {
                size.y = hHint;
            }
        } else {
            size.y = hHint == -1 ? this.getFontHeight() + 20 : hHint;
            if (wHint != -1) {
                size.x = wHint;
            }
        }
        return size;
    }

    protected void calculateIncrement() {
        ZoomSlider.TickValueRange tvr = new ZoomSlider.TickValueRange(this);
        if (tvr.outside()) {
            int maxTickCount = this.getPixelRange() / 10;
            this.increment = this.getVisibleValueRange() / (double)maxTickCount;
            int orderOfMagnitude = ZoomSliderUtilities.calculateOOM(this.increment);
            double[] progression = this.getProgression(orderOfMagnitude);
            this.increment = progression[0] * Math.pow(10.0, orderOfMagnitude);
            while (this.increment < tvr.min) {
                int i = 0;
                while (i < progression.length) {
                    this.increment = progression[i] * Math.pow(10.0, orderOfMagnitude);
                    if (this.increment >= tvr.min) {
                        this.increment = (long)this.increment;
                        break;
                    }
                    ++i;
                }
                progression = this.getProgression(++orderOfMagnitude);
            }
            this.incrementOOM = ZoomSliderUtilities.calculateOOM(this.increment);
        }
    }

    protected double[] getProgression(int oom) {
        switch (oom) {
            case 1: 
            case 2: 
            case 3: {
                return LINEAR_PROGRESSION;
            }
            case 4: {
                return OOM4;
            }
            case 5: {
                return OOM5;
            }
            case 6: {
                return OOM6;
            }
            case 7: {
                return OOM7;
            }
        }
        return GTOOM7;
    }

    protected double getZero() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(new Date());
        double hrs = 1.0 + (double)calendar.get(11);
        double mins = calendar.get(12);
        double secs = calendar.get(13);
        return hrs * 60.0 * 60.0 + mins * 60.0 + secs;
    }
}

