/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.widgets.zoomslider;

import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.text.NumberFormat;
import java.util.TimeZone;
import java.util.Vector;
import org.eclipse.hyades.ui.HyadesUIImages;
import org.eclipse.hyades.ui.internal.util.UIMessages;
import org.eclipse.hyades.ui.widgets.zoomslider.ZoomControlBar;
import org.eclipse.hyades.ui.widgets.zoomslider.ZoomControlBarsCollection;
import org.eclipse.hyades.ui.widgets.zoomslider.ZoomIndicator;
import org.eclipse.hyades.ui.widgets.zoomslider.ZoomIndicatorsCollection;
import org.eclipse.hyades.ui.widgets.zoomslider.ZoomSliderConfigurationException;
import org.eclipse.hyades.ui.widgets.zoomslider.ZoomSliderEvent;
import org.eclipse.hyades.ui.widgets.zoomslider.ZoomSliderListener;
import org.eclipse.hyades.ui.widgets.zoomslider.ZoomSliderTick;
import org.eclipse.hyades.ui.widgets.zoomslider.ZoomSliderUtilities;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class ZoomSlider
extends Canvas {
    public static final int MIN = 0;
    public static final int MAX = 1;
    public static final int TOP = 0;
    public static final int BOTTOM = 1;
    public static final int MIN_TICKWIDTH = 10;
    public static final int MAX_TICKWIDTH = 25;
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    public static final int INCREASING = 1;
    public static final int DECREASING = -1;
    private static final double[] LINEAR_PROGRESSION = new double[]{1.0, 2.0, 5.0};
    protected Vector tickVector = new Vector();
    private Vector listeners = new Vector();
    private ZoomControlBarsCollection barsCollection = new ZoomControlBarsCollection(this);
    private ZoomIndicatorsCollection indicatorsCollection = new ZoomIndicatorsCollection(this);
    transient ZoomSliderTick lastVisible;
    protected double[] limit = new double[]{0.0, 100.0};
    protected double[] visible = new double[]{0.0, 50.0};
    protected boolean[] locked = new boolean[2];
    protected int orientation = 0;
    protected int direction = 1;
    protected double resolution = 1.0;
    protected int indent = 10;
    protected static final int MINIMIZED_WIDTH = 15;
    protected Image image;
    protected GC gImage;
    protected Image plainScale;
    protected GC gPlain;
    protected Image titleImage;
    protected GC gTitle;
    private int titWidth;
    private int titHeight;
    private Color backgroundColor;
    private Color foregroundColor;
    private Color titleColor;
    private Font titleFont;
    protected boolean zoomable = true;
    protected boolean transposable = true;
    transient double increment = 1.0;
    transient int incrementOOM;
    transient double unitIncrement;
    transient int decimalPointPosition;
    transient boolean scaleChanged = true;
    transient boolean indicatorsChanged;
    transient boolean zoomPrimed;
    transient boolean zoomConfigured;
    transient int zoomStart;
    transient double zoomValue;
    transient int zoomFixed;
    transient boolean zoomed;
    transient int startZoomRange;
    transient boolean transposePrimed;
    transient boolean transposeConfigured;
    transient int transposeStart;
    transient double transposeValue;
    transient double transposeRange;
    transient boolean transposed;
    protected String title;
    protected int rawOffset;
    private int fontHeight;
    private Cursor cursor_zoom_vertical;
    private Cursor cursor_zoom_horizontal;
    private Cursor cursor_transpose;
    private Cursor cursor_normal;
    private static DecimalFormatSymbols dfs = new DecimalFormatSymbols();
    private static NumberFormat nf = NumberFormat.getIntegerInstance();
    Image lockImage;
    boolean minimized = false;
    Rectangle oldBounds = null;

    public ZoomSlider(Composite parent) {
        super(parent, 262144);
        FontData fd = this.getFont().getFontData()[0];
        this.indent = (fd.getHeight() + 4) / 2;
        this.fontHeight = fd.getHeight();
        this.backgroundColor = parent.getBackground();
        this.foregroundColor = parent.getForeground();
        if (this.backgroundColor == null) {
            this.backgroundColor = this.getDisplay().getSystemColor(25);
        }
        if (this.foregroundColor == null) {
            this.foregroundColor = this.getDisplay().getSystemColor(24);
        }
        this.titleColor = this.foregroundColor;
        this.rawOffset = TimeZone.getDefault().getRawOffset();
        if (this.rawOffset < 0) {
            this.rawOffset += 86400000;
        }
        SliderMouseListener sliderMouseListener = new SliderMouseListener();
        this.addMouseListener(sliderMouseListener);
        SliderMouseMoveListener sliderMouseMoveListener = new SliderMouseMoveListener();
        this.addMouseMoveListener(sliderMouseMoveListener);
        SliderPaintListener sliderPaintListener = new SliderPaintListener();
        this.addPaintListener(sliderPaintListener);
        SliderControlListener sliderControlListener = new SliderControlListener();
        this.addControlListener((ControlListener)sliderControlListener);
        SliderDisposeListener sliderDisposeListener = new SliderDisposeListener();
        this.addDisposeListener(sliderDisposeListener);
        this.cursor_zoom_vertical = new Cursor((Device)this.getDisplay(), 7);
        this.cursor_zoom_horizontal = new Cursor((Device)this.getDisplay(), 9);
        this.cursor_transpose = new Cursor((Device)this.getDisplay(), 21);
        this.cursor_normal = new Cursor((Device)this.getDisplay(), 0);
    }

    public ZoomSlider(Composite parent, double minLimit, double maxLimit, double minVisible, double maxVisible, double resolution) throws ZoomSliderConfigurationException {
        this(parent);
        this.configure(minLimit, maxLimit, minVisible, maxVisible, resolution);
    }

    public void addZoomControlBar(double value) {
        new ZoomControlBar(this, value);
        this.updateScale();
    }

    public void addZoomControlBar(ZoomControlBar bar) {
        this.barsCollection.add(bar);
        this.updateScale();
    }

    public void removeZoomControlBar(ZoomControlBar bar) {
        this.barsCollection.remove(bar);
        this.updateScale();
    }

    public boolean hasBars() {
        return this.barsCollection.hasBars();
    }

    public ZoomControlBarsCollection getZoomControlBarsCollection() {
        return this.barsCollection;
    }

    public void addZoomIndicator(ZoomIndicator indicator) {
        this.indicatorsCollection.add(indicator);
        this.updateScale();
    }

    public void removeIndicator(ZoomIndicator indicator) {
        this.indicatorsCollection.remove(indicator);
        this.updateScale();
    }

    public ZoomIndicatorsCollection getZoomIndicatorsCollection() {
        return this.indicatorsCollection;
    }

    public Vector getTickVector() {
        return this.tickVector;
    }

    public ZoomSliderTick getFirstTick() {
        if (this.tickVector.size() == 0) {
            return null;
        }
        return (ZoomSliderTick)this.tickVector.get(0);
    }

    public ZoomSliderTick getLastTick() {
        if (this.tickVector.size() == 0) {
            return null;
        }
        return (ZoomSliderTick)this.tickVector.get(this.tickVector.size() - 1);
    }

    private void reinitialiseGraphics() {
        if (this.image != null) {
            this.image.dispose();
        }
        if (this.gImage != null) {
            this.gImage.dispose();
        }
        if (this.plainScale != null) {
            this.plainScale.dispose();
        }
        if (this.gPlain != null) {
            this.gPlain.dispose();
        }
        if (this.getDisplay() == null) {
            return;
        }
        if (this.getBounds().width < 1) {
            return;
        }
        if (this.getBounds().height < 1) {
            return;
        }
        this.image = new Image((Device)this.getDisplay(), this.getBounds().width, this.getBounds().height);
        this.gImage = new GC((Drawable)this.image);
        this.plainScale = new Image((Device)this.getDisplay(), this.getBounds().width, this.getBounds().height);
        this.gPlain = new GC((Drawable)this.plainScale);
        this.findDecimalPointPosition();
        this.createTicks();
    }

    public void paint(PaintEvent e) {
        if (this.isDisposed()) {
            return;
        }
        if (!this.minimized) {
            if (this.gImage == null) {
                this.reinitialiseGraphics();
            }
            if (this.scaleChanged) {
                this.paintTicks(this.gImage);
                this.paintTicks(this.gPlain);
                this.scaleChanged = false;
                this.indicatorsCollection.paint(this.gImage, null);
            }
            if (this.indicatorsChanged) {
                this.indicatorsCollection.paint(this.gImage, this.plainScale);
            }
            this.barsCollection.paint(this.image, this.gImage, e.gc, this.indicatorsChanged);
            this.indicatorsChanged = false;
        } else {
            if (this.gImage == null) {
                this.reinitialiseGraphics();
            }
            this.paintMinimized(this.gImage);
            this.paintMinimized(this.gPlain);
            this.paintMinimizedTitle(this.gImage);
            this.paintMinimizedTitle(this.gPlain);
            e.gc.drawImage(this.image, 0, 0);
        }
    }

    public void updateScale() {
        this.scaleChanged = true;
        this.redraw();
    }

    public void recreateScale() {
        this.createTicks();
        this.updateScale();
    }

    public void updateIndicators() {
        this.indicatorsChanged = true;
        this.redraw();
    }

    public void externalRepaint() {
        this.scaleChanged = true;
        this.redraw();
    }

    public void resizeScale() {
        this.reinitialiseGraphics();
        this.indicatorsCollection.calculatePositions();
        this.recreateScale();
    }

    public void layout() {
        super.layout();
        this.indicatorsCollection.calculatePositions();
        if (this.isMaxTickWidthExceeded()) {
            this.visible[1] = this.visible[0] + (double)(this.getPixelRange() / 25) * this.resolution;
            if (this.visible[1] > this.limit[1]) {
                this.visible[1] = this.limit[1];
                this.visible[0] = this.visible[1] - (double)(this.getPixelRange() / 25) * this.resolution;
            }
            this.updateScale();
        }
    }

    public void setFont(Font font) {
        FontData fd = font.getFontData()[0];
        this.indent = (fd.getHeight() + 4) / 2;
        this.fontHeight = fd.getHeight();
        super.setFont(font);
    }

    protected int getPixelRange() {
        if (this.orientation == 1) {
            return this.getBounds().width - this.indent * 2;
        }
        return this.getBounds().height - this.indent * 2;
    }

    protected double getZeroPixelValue() {
        if (this.direction == -1) {
            return this.visible[0];
        }
        return this.visible[1];
    }

    protected double getVisibleValueRange() {
        return Math.abs(this.visible[1] - this.visible[0]);
    }

    protected double getSinglePixelRange() {
        return this.getVisibleValueRange() / (double)this.getPixelRange();
    }

    public double pixel2Value(double pixelPos) {
        return this.getZeroPixelValue() - (double)this.direction * ((pixelPos - (double)this.indent) * this.getSinglePixelRange());
    }

    public double value2Pixel(double value) {
        return (this.getZeroPixelValue() - value) / (double)this.direction / this.getSinglePixelRange() + (double)this.indent;
    }

    public double getIncrement() {
        return this.increment;
    }

    public int getIncrementOOM() {
        return this.incrementOOM;
    }

    public double getUnitIncrement() {
        return this.unitIncrement;
    }

    public int getDecimalPointPosition() {
        return this.decimalPointPosition;
    }

    public int getIndent() {
        return this.indent;
    }

    public int getFontHeight() {
        return this.fontHeight;
    }

    public boolean isChanging() {
        if (this.zoomConfigured) {
            return true;
        }
        return this.transposeConfigured;
    }

    protected void findDecimalPointPosition() {
        if (this.orientation == 0) {
            int tail = 0;
            if (this.increment < 1.0) {
                GC gcTemp = new GC((Drawable)this);
                String zeroString = nf.format(0L);
                tail = Math.abs(this.incrementOOM) * gcTemp.stringExtent((String)zeroString).x + gcTemp.stringExtent((String)new StringBuffer().append((char)ZoomSlider.dfs.getDecimalSeparator()).toString()).x;
            }
            this.decimalPointPosition = this.getBounds().width - tail - 5;
        }
    }

    protected void calculateIncrement() {
        TickValueRange tvr = new TickValueRange();
        if (tvr.outside()) {
            int maxTickCount = this.getPixelRange() / 10;
            this.increment = this.getVisibleValueRange() / (double)maxTickCount;
            int orderOfMagnitude = ZoomSliderUtilities.calculateOOM(this.increment);
            this.increment = LINEAR_PROGRESSION[0] * Math.pow(10.0, orderOfMagnitude);
            while (this.increment < tvr.min) {
                int i = 0;
                while (i < 3) {
                    this.increment = LINEAR_PROGRESSION[i] * Math.pow(10.0, orderOfMagnitude);
                    if (this.increment >= tvr.min) break;
                    ++i;
                }
                ++orderOfMagnitude;
            }
            this.incrementOOM = ZoomSliderUtilities.calculateOOM(this.increment);
            this.findDecimalPointPosition();
        }
    }

    protected void createTicks() {
        this.calculateIncrement();
        this.tickVector.removeAllElements();
        double tickValue = ZoomSliderUtilities.round(this.visible[0] - this.increment, this.increment);
        int loop = 0;
        while (tickValue <= this.visible[1] + this.increment) {
            this.tickVector.addElement(new ZoomSliderTick(this, tickValue));
            tickValue += this.increment;
            tickValue = ZoomSliderUtilities.round(tickValue, this.increment);
            if (++loop > 500) break;
        }
        int selectablePoints = 10;
        int tickSpacing = (int)((double)this.getPixelRange() / (this.getVisibleValueRange() / this.increment));
        if (tickSpacing < 20) {
            selectablePoints = 5;
        }
        this.unitIncrement = this.increment / (double)selectablePoints;
        if (this.unitIncrement < this.resolution) {
            this.unitIncrement = this.resolution;
        }
    }

    private void paintMinimized(GC g) {
        g.setBackground(this.backgroundColor);
        g.fillRectangle(0, 0, this.getBounds().width, this.getBounds().height);
        g.setForeground(this.foregroundColor);
        g.drawRectangle(0, 0, this.getBounds().width - 1, this.getBounds().height - 1);
    }

    private void paintTicks(GC g) {
        g.setBackground(this.backgroundColor);
        g.fillRectangle(0, 0, this.getBounds().width, this.getBounds().height);
        g.setForeground(this.foregroundColor);
        this.lastVisible = null;
        this.paintTitle(g);
        try {
            int i = 0;
            while (i < this.tickVector.size()) {
                ((ZoomSliderTick)this.tickVector.elementAt(i)).paintLine(g);
                ++i;
            }
            i = 0;
            while (i < this.tickVector.size()) {
                ((ZoomSliderTick)this.tickVector.elementAt(i)).paintText(g);
                ++i;
            }
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
        g.setForeground(this.foregroundColor);
        g.drawRectangle(0, 0, this.getBounds().width - 1, this.getBounds().height - 1);
        if (this.isLocked(1)) {
            this.paintMaxLock(g);
        }
        if (this.isLocked(0)) {
            this.paintMinLock(g);
        }
    }

    private void paintMinimizedTitle(GC g) {
        if (this.titleImage == null) {
            this.createTitle(g);
        }
        if (this.titleImage != null) {
            if (this.orientation == 1) {
                g.drawImage(this.titleImage, this.getBounds().width - this.titWidth - (this.indent + 15), this.getBounds().height - this.titHeight - 1);
            } else {
                g.drawImage(this.titleImage, 1, this.indent + 15);
            }
        }
    }

    private void paintTitle(GC g) {
        if (this.titleImage == null) {
            this.createTitle(g);
        }
        if (this.titleImage != null) {
            if (this.orientation == 1) {
                g.drawImage(this.titleImage, this.getBounds().width - this.titWidth - (this.indent + 15), this.getBounds().height - (this.titHeight + 2));
            } else {
                g.drawImage(this.titleImage, 4, this.indent + 15);
            }
        }
    }

    private void createLock(GC g) {
        this.lockImage = HyadesUIImages.INSTANCE.getImage("zoomslider_lock.gif");
    }

    private void paintMaxLock(GC g) {
        if (this.lockImage == null) {
            this.createLock(g);
        }
        if (this.lockImage != null) {
            if (this.orientation == 1) {
                g.drawImage(this.lockImage, this.getBounds().width - (this.indent + 6), this.getBounds().height - 11);
            } else {
                g.drawImage(this.lockImage, 2, 2);
            }
        }
    }

    private void paintMinLock(GC g) {
        if (this.lockImage == null) {
            this.createLock(g);
        }
        if (this.lockImage != null) {
            if (this.orientation == 1) {
                g.drawImage(this.lockImage, 2, this.getBounds().height - 11);
            } else {
                g.drawImage(this.lockImage, 2, this.getBounds().height - 11);
            }
        }
    }

    private void createTitle(GC g) {
        if (this.title != null && !this.title.equals("")) {
            g.setFont(this.titleFont);
            this.titWidth = g.stringExtent((String)this.title).x;
            this.titHeight = g.stringExtent((String)this.title).y;
            g.setFont(this.getFont());
            this.titleImage = new Image((Device)this.getDisplay(), this.titWidth, this.titHeight);
            this.gTitle = new GC((Drawable)this.titleImage);
            this.gTitle.setBackground(this.backgroundColor);
            this.gTitle.fillRectangle(0, 0, this.titWidth, this.titHeight);
            this.gTitle.setForeground(this.titleColor);
            this.gTitle.setFont(this.titleFont);
            this.gTitle.drawString(this.title, 0, 0);
            g.setForeground(this.foregroundColor);
            if (this.orientation == 0) {
                this.titleImage = this.rotateImage();
            }
        }
    }

    private Image rotateImage() {
        ImageData titleData = this.titleImage.getImageData();
        Image temp = new Image((Device)this.getDisplay(), titleData.height, titleData.width);
        ImageData tempData = temp.getImageData();
        int h = 0;
        while (h < titleData.height) {
            int w = 0;
            while (w < titleData.width) {
                tempData.setPixel(h, tempData.height - 1 - w, titleData.getPixel(w, h));
                ++w;
            }
            ++h;
        }
        return new Image((Device)this.getDisplay(), tempData);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point standard = super.computeSize(wHint, hHint, changed);
        Point size = new Point(standard.x, standard.y);
        GC gcTemp = new GC((Drawable)this);
        if (this.orientation == 0) {
            if (this.minimized) {
                size.x = 15;
            } else {
                if (wHint == -1) {
                    String maxTick = new ZoomSliderTick((ZoomSlider)this, (double)(this.limit[1] + this.resolution)).representation;
                    String minTick = new ZoomSliderTick((ZoomSlider)this, (double)(this.limit[0] - this.resolution)).representation;
                    int biggestMin = gcTemp.stringExtent((String)minTick).x;
                    int biggestMax = gcTemp.stringExtent((String)maxTick).x;
                    int biggest = biggestMax;
                    if (biggestMin > biggest) {
                        biggest = biggestMin;
                    }
                    size.x = biggest + 20;
                } else {
                    size.x = wHint;
                }
                if (hHint != -1) {
                    size.y = hHint;
                }
            }
        } else {
            size.y = !this.minimized ? (hHint == -1 ? gcTemp.getFontMetrics().getAscent() + 20 : hHint) : 15;
            if (wHint != -1) {
                size.x = wHint;
            }
        }
        gcTemp.dispose();
        return size;
    }

    public void configure(double minLimit, double maxLimit, double minVisible, double maxVisible, double resolution) throws ZoomSliderConfigurationException {
        this.checkConfiguration(minLimit, maxLimit, minVisible, maxVisible, resolution);
        this.limit[0] = minLimit;
        this.limit[1] = maxLimit;
        this.visible[0] = minVisible;
        this.visible[1] = maxVisible;
        this.resolution = resolution;
        try {
            this.recreateScale();
        }
        catch (NullPointerException nullPointerException) {}
    }

    private void checkConfiguration(double minLimit, double maxLimit, double minVisible, double maxVisible, double resolution) throws ZoomSliderConfigurationException {
        if (minLimit >= maxLimit) {
            throw new ZoomSliderConfigurationException(UIMessages._70);
        }
        if (minVisible >= maxVisible) {
            throw new ZoomSliderConfigurationException(UIMessages._71);
        }
        if (minVisible < minLimit) {
            throw new ZoomSliderConfigurationException(UIMessages._72);
        }
        if (maxVisible > maxLimit) {
            throw new ZoomSliderConfigurationException(UIMessages._73);
        }
        if (resolution > maxLimit - minLimit) {
            throw new ZoomSliderConfigurationException(UIMessages._74);
        }
        if (resolution <= 0.0) {
            throw new ZoomSliderConfigurationException(UIMessages._75);
        }
        double oomZeroVersion = resolution * Math.pow(10.0, -1 * ZoomSliderUtilities.calculateOOM(resolution));
        if (oomZeroVersion != 1.0 && oomZeroVersion != 2.0 && oomZeroVersion != 5.0) {
            throw new ZoomSliderConfigurationException(UIMessages._76);
        }
    }

    public void setTitle(String title) {
        this.title = title;
        this.titleImage = null;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitleColor(Color color) {
        this.titleColor = color;
        this.titleImage = null;
    }

    public Color getTitleColor() {
        return this.titleColor;
    }

    public void setTitleFont(Font font) {
        this.titleFont = font;
        this.titleImage = null;
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (color != null) {
            this.foregroundColor = color;
        }
        this.titleImage = null;
    }

    public Color getForeground() {
        return this.foregroundColor;
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (color != null) {
            this.backgroundColor = color;
            this.indicatorsCollection.setXORColors();
        }
        this.titleImage = null;
    }

    public Color getBackground() {
        if (this.backgroundColor != null) {
            return this.backgroundColor;
        }
        return this.getDisplay().getSystemColor(25);
    }

    public void setMaxVisible(double d) throws ZoomSliderConfigurationException {
        this.checkConfiguration(this.limit[0], this.limit[1], this.visible[0], d, this.resolution);
        this.visible[1] = d;
        this.recreateScale();
    }

    public double getMaxVisible() {
        return this.visible[1];
    }

    public void setMinVisible(double d) throws ZoomSliderConfigurationException {
        this.checkConfiguration(this.limit[0], this.limit[1], d, this.visible[1], this.resolution);
        this.visible[0] = d;
        this.recreateScale();
    }

    public double getMinVisible() {
        return this.visible[0];
    }

    public void setMaxLimit(double d) throws ZoomSliderConfigurationException {
        this.checkConfiguration(this.limit[0], d, this.visible[0], this.visible[1], this.resolution);
        this.limit[1] = d;
        this.recreateScale();
    }

    public double getMaxLimit() {
        return this.limit[1];
    }

    public void setMinLimit(double d) throws ZoomSliderConfigurationException {
        this.checkConfiguration(d, this.limit[1], this.visible[0], this.visible[1], this.resolution);
        this.limit[0] = d;
        this.recreateScale();
    }

    public double getMinLimit() {
        return this.limit[0];
    }

    public void setResolution(double d) throws ZoomSliderConfigurationException {
        this.checkConfiguration(this.limit[0], this.limit[1], this.visible[0], this.visible[1], d);
        this.resolution = d;
        this.scaleChanged = true;
        this.findDecimalPointPosition();
        this.redraw();
    }

    public double getResolution() {
        return this.resolution;
    }

    public void setDirection(int direction) throws ZoomSliderConfigurationException {
        if (direction != 1 && direction != -1) {
            throw new ZoomSliderConfigurationException(UIMessages._77);
        }
        this.direction = direction;
        this.recreateScale();
    }

    public int getDirection() {
        return this.direction;
    }

    public void setOrientation(int orientation) throws ZoomSliderConfigurationException {
        if (orientation != 1 && orientation != 0) {
            throw new ZoomSliderConfigurationException(UIMessages._78);
        }
        this.orientation = orientation;
        this.recreateScale();
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void lock(int end, boolean lock) {
        this.locked[end] = lock;
        this.scaleChanged = true;
    }

    public boolean isLocked(int end) {
        return this.locked[end];
    }

    public void setZoomable(boolean b) {
        this.zoomable = b;
    }

    public boolean isZoomable() {
        return this.zoomable;
    }

    public void setTransposable(boolean b) {
        this.transposable = b;
    }

    public boolean isTransposable() {
        return this.transposable;
    }

    public void setLastVisible(ZoomSliderTick tick) {
        this.lastVisible = tick;
    }

    public ZoomSliderTick getLastVisible() {
        return this.lastVisible;
    }

    private boolean isMaxTickWidthExceeded() {
        return this.getVisibleValueRange() / this.resolution < (double)(this.getPixelRange() / 25);
    }

    public double getMinRange() {
        return (double)(this.getPixelRange() / 25) * this.resolution;
    }

    private int complement(int i) {
        if (i == 0) {
            return 1;
        }
        return 0;
    }

    private void primeZoom(MouseEvent event) {
        this.zoomStart = this.orientation == 0 ? event.y : event.x;
        this.zoomValue = this.pixel2Value(this.zoomStart);
        this.zoomPrimed = true;
    }

    private void configureZoom(MouseEvent event) {
        int zoomPosition = 0;
        zoomPosition = this.orientation == 0 ? event.y : event.x;
        if (Math.abs(zoomPosition - this.zoomStart) > 2) {
            if (!this.locked[0] && !this.locked[1]) {
                this.zoomFixed = zoomPosition > this.zoomStart ? (this.direction == 1 ? 1 : 0) : (this.direction == 1 ? 0 : 1);
                this.zoomPrimed = false;
                this.zoomConfigured = true;
            } else if (this.locked[1] && this.locked[0]) {
                this.zoomPrimed = false;
                this.zoomConfigured = false;
            } else {
                this.zoomFixed = this.locked[1] ? 1 : 0;
                this.zoomPrimed = false;
                this.zoomConfigured = true;
            }
            this.startZoomRange = Math.abs(this.zoomStart - (int)this.value2Pixel(this.visible[this.zoomFixed]));
        }
    }

    private void zoom(MouseEvent event) {
        double diff;
        int pixel = event.y;
        if (this.orientation == 1) {
            pixel = event.x;
        }
        if ((diff = Math.abs((double)pixel - this.value2Pixel(this.visible[this.zoomFixed]))) > 0.0) {
            double percentage = (double)this.getPixelRange() / diff;
            double temp = this.visible[this.complement(this.zoomFixed)];
            if (this.zoomFixed == 0) {
                this.visible[this.complement((int)this.zoomFixed)] = this.visible[this.zoomFixed] + percentage * Math.abs(this.visible[this.zoomFixed] - this.zoomValue);
                if (this.visible[this.complement(this.zoomFixed)] > this.limit[this.complement(this.zoomFixed)]) {
                    this.visible[this.complement((int)this.zoomFixed)] = this.limit[this.complement(this.zoomFixed)];
                }
            } else {
                this.visible[this.complement((int)this.zoomFixed)] = this.visible[this.zoomFixed] - percentage * Math.abs(this.visible[this.zoomFixed] - this.zoomValue);
                if (this.visible[this.complement(this.zoomFixed)] < this.limit[this.complement(this.zoomFixed)]) {
                    this.visible[this.complement((int)this.zoomFixed)] = this.limit[this.complement(this.zoomFixed)];
                }
            }
            if (this.isMaxTickWidthExceeded() && !this.isContracting(pixel)) {
                this.visible[this.complement((int)this.zoomFixed)] = temp;
            }
            if (this.visible[this.complement(this.zoomFixed)] != temp) {
                this.zoomed = true;
                this.recreateScale();
                int i = 0;
                while (i < this.listeners.size()) {
                    ((ZoomSliderListener)this.listeners.elementAt(i)).zoomSliderChanged(new ZoomSliderEvent(event.getSource(), ZoomSliderEvent.ZOOMED, false));
                    ++i;
                }
            }
        }
    }

    private boolean isContracting(int pixel) {
        double newZoomRange = Math.abs(pixel - (int)this.value2Pixel(this.visible[this.zoomFixed]));
        return newZoomRange <= (double)this.startZoomRange;
    }

    private void primeTranspose(MouseEvent event) {
        if (!this.locked[0] && !this.locked[1]) {
            this.transposeStart = this.orientation == 0 ? event.y : event.x;
            this.transposePrimed = true;
        }
    }

    private void configureTranspose(MouseEvent event) {
        int transposePosition = 0;
        transposePosition = this.orientation == 0 ? event.y : event.x;
        if (Math.abs(transposePosition - this.transposeStart) > 2) {
            this.transposeValue = this.pixel2Value(transposePosition);
            this.transposeRange = this.getVisibleValueRange();
            this.transposePrimed = false;
            this.transposeConfigured = true;
        }
    }

    private void transpose(MouseEvent event) {
        double oldVisibleMin = this.visible[0];
        int pixel = event.y;
        if (this.orientation == 1) {
            pixel = event.x;
        }
        double diff = Math.abs((double)pixel - this.value2Pixel(this.visible[0]));
        this.visible[0] = this.transposeValue - diff * this.getSinglePixelRange();
        if (this.visible[0] < this.limit[0]) {
            this.visible[0] = this.limit[0];
        }
        this.visible[1] = this.visible[0] + this.transposeRange;
        if (this.visible[1] > this.limit[1]) {
            this.visible[1] = this.limit[1];
            this.visible[0] = this.visible[1] - this.transposeRange;
        }
        if (this.visible[0] != oldVisibleMin) {
            this.transposed = true;
            this.recreateScale();
            int i = 0;
            while (i < this.listeners.size()) {
                ((ZoomSliderListener)this.listeners.elementAt(i)).zoomSliderChanged(new ZoomSliderEvent(event.getSource(), ZoomSliderEvent.TRANSPOSED, false));
                ++i;
            }
        }
    }

    public void addZoomSliderListener(ZoomSliderListener listener) {
        this.listeners.add(listener);
    }

    public void removeZoomSliderListener(ZoomSliderListener listener) {
        this.listeners.remove(listener);
    }

    private void Slider_MouseDown(MouseEvent event) {
        if (!this.barsCollection.mouseDown(event)) {
            if (event.button > 1) {
                this.setCursor(this.cursor_transpose);
                if (this.transposable) {
                    this.primeTranspose(event);
                }
            } else {
                if (this.orientation == 0) {
                    this.setCursor(this.cursor_zoom_vertical);
                } else {
                    this.setCursor(this.cursor_zoom_horizontal);
                }
                if (this.zoomable) {
                    this.primeZoom(event);
                }
            }
        }
    }

    private void Slider_MouseUp(MouseEvent event) {
        if (!this.barsCollection.mouseUp(event)) {
            int i;
            this.setCursor(this.cursor_normal);
            if (this.zoomPrimed) {
                this.zoomPrimed = false;
            }
            if (this.zoomConfigured) {
                this.zoomConfigured = false;
            }
            if (this.transposePrimed) {
                this.transposePrimed = false;
            }
            if (this.transposeConfigured) {
                this.transposeConfigured = false;
            }
            if (this.zoomed) {
                i = 0;
                while (i < this.listeners.size()) {
                    ((ZoomSliderListener)this.listeners.elementAt(i)).zoomSliderChanged(new ZoomSliderEvent(event.getSource(), ZoomSliderEvent.ZOOMED, true));
                    ++i;
                }
                this.zoomed = false;
            }
            if (this.transposed) {
                i = 0;
                while (i < this.listeners.size()) {
                    ((ZoomSliderListener)this.listeners.elementAt(i)).zoomSliderChanged(new ZoomSliderEvent(event.getSource(), ZoomSliderEvent.TRANSPOSED, true));
                    ++i;
                }
                this.transposed = false;
            }
        }
    }

    private void Slider_MouseMove(MouseEvent event) {
        ZoomControlBar bar = this.barsCollection.getZoomControlBarContaining(event.x, event.y);
        if (bar != null) {
            String ntooltip = bar.getToolTipText();
            if (this.getToolTipText() == null || !this.getToolTipText().equals(ntooltip)) {
                this.setToolTipText(ntooltip);
            }
        } else {
            String ntooltip = null;
            if (this.getToolTipText() != null) {
                this.setToolTipText(ntooltip);
            }
        }
        if (!this.barsCollection.mouseMove(event)) {
            if (this.zoomPrimed) {
                this.configureZoom(event);
            }
            if (this.zoomConfigured) {
                this.zoom(event);
            }
            if (this.transposePrimed) {
                this.configureTranspose(event);
            }
            if (this.transposeConfigured) {
                this.transpose(event);
            }
        }
    }

    public boolean isMinimized() {
        return this.minimized;
    }

    public void setMinimized(boolean minimized) {
        this.minimized = minimized;
    }

    class TickValueRange {
        public double min;
        public double max;

        public TickValueRange() {
            this.min = ZoomSlider.this.getSinglePixelRange() * 10.0;
            if (this.min < ZoomSlider.this.resolution) {
                this.min = ZoomSlider.this.resolution;
            }
            this.max = ZoomSlider.this.getSinglePixelRange() * 25.0;
            if (this.max < ZoomSlider.this.resolution) {
                this.max = ZoomSlider.this.resolution;
            }
        }

        public boolean outside() {
            return ZoomSlider.this.increment < this.min || ZoomSlider.this.increment > this.max;
        }
    }

    class SliderPaintListener
    implements PaintListener {
        SliderPaintListener() {
        }

        public void paintControl(PaintEvent e) {
            ZoomSlider.this.paint(e);
        }
    }

    class SliderMouseListener
    implements MouseListener {
        SliderMouseListener() {
        }

        public void mouseDown(MouseEvent e) {
            ZoomSlider.this.Slider_MouseDown(e);
        }

        public void mouseUp(MouseEvent e) {
            ZoomSlider.this.Slider_MouseUp(e);
        }

        public void mouseDoubleClick(MouseEvent e) {
        }
    }

    class SliderMouseMoveListener
    implements MouseMoveListener {
        SliderMouseMoveListener() {
        }

        public void mouseMove(MouseEvent event) {
            ZoomSlider.this.Slider_MouseMove(event);
        }
    }

    class SliderControlListener
    extends ControlAdapter {
        SliderControlListener() {
        }

        public void controlResized(ControlEvent e) {
            ZoomSlider.this.resizeScale();
        }
    }

    class SliderDisposeListener
    implements DisposeListener {
        SliderDisposeListener() {
        }

        public void widgetDisposed(DisposeEvent e) {
            if (ZoomSlider.this.image != null) {
                ZoomSlider.this.image.dispose();
            }
            if (ZoomSlider.this.gImage != null) {
                ZoomSlider.this.gImage.dispose();
            }
            if (ZoomSlider.this.plainScale != null) {
                ZoomSlider.this.plainScale.dispose();
            }
            if (ZoomSlider.this.gPlain != null) {
                ZoomSlider.this.gPlain.dispose();
            }
            if (ZoomSlider.this.titleImage != null) {
                ZoomSlider.this.titleImage.dispose();
            }
            if (ZoomSlider.this.gTitle != null) {
                ZoomSlider.this.gTitle.dispose();
            }
            if (ZoomSlider.this.titleFont != null) {
                ZoomSlider.this.titleFont.dispose();
            }
            ZoomSlider.this.barsCollection.dispose();
            ZoomSlider.this.indicatorsCollection.dispose();
            ZoomSlider.this.cursor_zoom_vertical.dispose();
            ZoomSlider.this.cursor_zoom_horizontal.dispose();
            ZoomSlider.this.cursor_transpose.dispose();
            ZoomSlider.this.cursor_normal.dispose();
        }
    }
}

