/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.widgets.zoomslider;

import com.ibm.icu.text.DecimalFormatSymbols;
import org.eclipse.hyades.ui.widgets.zoomslider.ZoomSlider;
import org.eclipse.hyades.ui.widgets.zoomslider.ZoomSliderUtilities;
import org.eclipse.swt.graphics.GC;

public class ZoomSliderTick {
    protected static DecimalFormatSymbols dfs = new DecimalFormatSymbols();
    protected ZoomSlider slider;
    protected boolean textVisible;
    protected double sliderValue;
    protected int sliderPixel;
    protected String representation;

    public ZoomSliderTick() {
    }

    public ZoomSliderTick(ZoomSlider slider, double sliderValue) {
        this.slider = slider;
        this.sliderValue = sliderValue;
        this.sliderPixel = (int)slider.value2Pixel(sliderValue);
        this.representation = ZoomSliderUtilities.double2String(sliderValue);
        this.textVisible = this.isTextVisible();
    }

    public int getPixel() {
        return this.sliderPixel;
    }

    public double getValue() {
        return this.sliderValue;
    }

    public boolean getTextVisibleBoolean() {
        return this.textVisible;
    }

    public void paintLine(GC g) {
        g.setForeground(this.slider.getForeground());
        if (this.slider.getOrientation() == 0) {
            if (this.textVisible) {
                g.drawLine(0, this.sliderPixel, this.slider.getBounds().width, this.sliderPixel);
            } else {
                g.drawLine(0, this.sliderPixel, 5, this.sliderPixel);
                g.drawLine(this.slider.getBounds().width - 5, this.sliderPixel, this.slider.getBounds().width - 1, this.sliderPixel);
            }
        } else if (this.textVisible) {
            g.drawLine(this.sliderPixel, 0, this.sliderPixel, this.slider.getBounds().height);
        } else {
            g.drawLine(this.sliderPixel, 0, this.sliderPixel, 5);
            g.drawLine(this.sliderPixel, this.slider.getBounds().height - 5, this.sliderPixel, this.slider.getBounds().height - 1);
        }
    }

    public void paintText(GC g) {
        if (this.textVisible) {
            int width;
            int ascent = g.getFontMetrics().getAscent();
            int head = width = g.stringExtent((String)this.representation).x;
            int dotIndex = this.representation.indexOf(dfs.getDecimalSeparator());
            if (dotIndex != -1) {
                head = g.stringExtent((String)this.representation.substring((int)0, (int)dotIndex)).x;
            }
            int xPos = 0;
            int yPos = 0;
            g.setBackground(this.slider.getBackground());
            if (this.slider.getOrientation() == 0) {
                xPos = this.slider.getDecimalPointPosition() - head;
                yPos = this.sliderPixel - g.stringExtent((String)this.representation).y / 2;
                g.fillRectangle(xPos - 2, yPos, width + 4, g.stringExtent((String)this.representation).y);
            } else {
                xPos = this.sliderPixel - width / 2;
                if (this.overlaps(this.slider.getLastVisible(), g)) {
                    return;
                }
                this.slider.setLastVisible(this);
                yPos = this.slider.getBounds().height / 2 - this.slider.getFontHeight() / 2 - 1;
                g.fillRectangle(xPos, yPos, width, ascent + 2);
            }
            g.setForeground(this.slider.getForeground());
            g.drawString(this.representation, xPos, yPos - 1, true);
        }
    }

    protected boolean isTextVisible() {
        long digit;
        double tempValue;
        int oom = this.slider.getIncrementOOM();
        if (Math.abs(tempValue = ++oom > 0 ? this.sliderValue / Math.pow(10.0, oom) : this.sliderValue * Math.pow(10.0, -1 * oom)) >= 1.0) {
            long maj = (long)(tempValue * 10.0);
            long min = (long)tempValue * 10L;
            digit = maj - min;
        } else {
            digit = (long)(tempValue * 10.0);
        }
        digit = Math.abs(digit);
        if (digit == 0L) {
            return true;
        }
        if (digit == 5L) {
            return this.slider.getIncrement() != 5.0 * Math.pow(10.0, this.slider.getIncrementOOM());
        }
        return false;
    }

    public boolean overlaps(ZoomSliderTick tick, GC g) {
        if (tick == null) {
            return false;
        }
        return tick.getPixel() > this.sliderPixel ? tick.getPixel() < this.sliderPixel + g.stringExtent((String)this.representation).x + 5 : tick.getPixel() > this.sliderPixel - g.stringExtent((String)this.representation).x - 5;
    }
}

