/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.hyades.uml2sd.ui.core.Frame;
import org.eclipse.hyades.uml2sd.ui.core.Metrics;
import org.eclipse.hyades.uml2sd.ui.drawings.IGC;
import org.eclipse.hyades.uml2sd.util.DebugUtil;

public abstract class GraphNode {
    protected int startEventOccurrence = 0;
    protected int endEventOccurrence = 0;
    public String prefId = "PREF_SYNC_MESS";
    private boolean selected = false;
    private boolean focused = false;
    protected boolean hasChilds = false;
    private String name = "";
    protected HashMap nodes;
    protected HashMap fnodes;
    protected HashMap bnodes;
    protected HashMap indexes;
    protected HashMap fSort;
    protected HashMap bSort;

    public void resetIndex() {
        if (!this.hasChilds) {
            return;
        }
        Iterator it = this.indexes.keySet().iterator();
        while (it.hasNext()) {
            Object nodeType = it.next();
            this.indexes.put(nodeType, new Integer(0));
        }
    }

    public void addNode(GraphNode nodeToAdd) {
        if (!this.hasChilds) {
            this.nodes = new HashMap(2);
            this.fnodes = new HashMap(2);
            this.bnodes = new HashMap(2);
            this.indexes = new HashMap(2);
            this.bSort = new HashMap(2);
            this.fSort = new HashMap(2);
            this.hasChilds = true;
        }
        if (nodeToAdd == null) {
            return;
        }
        if (this.nodes.get(nodeToAdd.getArrayId()) == null) {
            this.nodes.put(nodeToAdd.getArrayId(), new ArrayList(1));
            this.indexes.put(nodeToAdd.getArrayId(), new Integer(0));
            this.fnodes.put(nodeToAdd.getArrayId(), new ArrayList(1));
            this.fSort.put(nodeToAdd.getArrayId(), new Boolean(false));
            if (nodeToAdd.getBackComparator() != null) {
                this.bnodes.put(nodeToAdd.getArrayId(), new ArrayList(1));
                this.bSort.put(nodeToAdd.getArrayId(), new Boolean(false));
            }
        }
        List fNodeList = (List)this.fnodes.get(nodeToAdd.getArrayId());
        List bNodeList = null;
        if (this.bnodes != null) {
            bNodeList = (List)this.bnodes.get(nodeToAdd.getArrayId());
        }
        if (fNodeList != null && fNodeList.size() > 0) {
            GraphNode node = (GraphNode)fNodeList.get(fNodeList.size() - 1);
            Comparator fcomp = nodeToAdd.getComparator();
            Comparator bcomp = nodeToAdd.getBackComparator();
            if (fcomp != null && fcomp.compare(node, nodeToAdd) == 1) {
                this.fSort.put(nodeToAdd.getArrayId(), new Boolean(true));
            }
            if (bcomp != null && bcomp.compare(node, nodeToAdd) == 1) {
                this.bSort.put(nodeToAdd.getArrayId(), new Boolean(true));
            }
        }
        fNodeList.add(nodeToAdd);
        this.nodes.put(nodeToAdd.getArrayId(), fNodeList);
        this.fnodes.put(nodeToAdd.getArrayId(), fNodeList);
        if (nodeToAdd.getBackComparator() != null) {
            bNodeList.add(nodeToAdd);
            this.bnodes.put(nodeToAdd.getArrayId(), bNodeList);
        }
    }

    public void setName(String nodeName) {
        this.name = nodeName;
    }

    public String getName() {
        return this.name;
    }

    public void setSelected(boolean selection) {
        this.selected = selection;
    }

    public void setFocused(boolean focus) {
        this.focused = focus;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean hasFocus() {
        return this.focused;
    }

    public abstract boolean contains(int var1, int var2);

    public abstract int getX();

    public abstract int getY();

    public abstract int getHeight();

    public abstract int getWidth();

    protected abstract void draw(IGC var1);

    public boolean isVisible(int x, int y, int width, int height) {
        return true;
    }

    public Comparator getComparator() {
        return null;
    }

    public Comparator getBackComparator() {
        return null;
    }

    public boolean isSameAs(GraphNode node) {
        return false;
    }

    public abstract String getArrayId();

    public boolean positiveDistanceToPoint(int x, int y) {
        return false;
    }

    public GraphNode getNodeAt(int x, int y) {
        GraphNode toReturn = null;
        if (!this.hasChilds) {
            return null;
        }
        Iterator it = this.nodes.keySet().iterator();
        GraphNode node = null;
        while (it.hasNext()) {
            Object nodeType = it.next();
            List list = (List)this.nodes.get(nodeType);
            int index = (Integer)this.indexes.get(nodeType);
            node = this.getNodeFromListAt(x, y, list, index);
            if (toReturn == null) {
                toReturn = node;
            }
            if (node == null) continue;
            GraphNode internalNode = node.getNodeAt(x, y);
            if (internalNode != null) {
                return internalNode;
            }
            if (Math.abs(node.getWidth()) >= Math.abs(toReturn.getWidth()) && Math.abs(node.getHeight()) >= Math.abs(toReturn.getHeight())) continue;
            toReturn = node;
        }
        return toReturn;
    }

    public ArrayList getNodeList(GraphNode from, GraphNode to) {
        ArrayList<GraphNode> result = new ArrayList<GraphNode>();
        if (from != null) {
            result.add(from);
        } else if (to != null) {
            result.add(to);
        }
        if (from == null || to == null) {
            return result;
        }
        if (from == to) {
            return result;
        }
        int startX = Math.min(from.getX(), Math.min(to.getX(), Math.min(from.getX() + from.getWidth(), to.getX() + to.getWidth())));
        int endX = Math.max(from.getX(), Math.max(to.getX(), Math.max(from.getX() + from.getWidth(), to.getX() + to.getWidth())));
        int startY = Math.min(from.getY(), Math.min(to.getY(), Math.min(from.getY() + from.getHeight(), to.getY() + to.getHeight())));
        int endY = Math.max(from.getY(), Math.max(to.getY(), Math.max(from.getY() + from.getHeight(), to.getY() + to.getHeight())));
        if (!this.hasChilds) {
            return result;
        }
        Iterator it = this.nodes.keySet().iterator();
        while (it.hasNext()) {
            Object nodeType = it.next();
            List nodesList = (List)this.nodes.get(nodeType);
            if (nodesList == null || nodesList.isEmpty()) {
                return null;
            }
            int i = 0;
            while (i < nodesList.size()) {
                int ny;
                GraphNode node = (GraphNode)nodesList.get(i);
                int nw = node.getWidth();
                int nh = node.getHeight();
                int nx = node.getX();
                if (GraphNode.contains(startX, startY, endX - startX, endY - startY, nx + 1, (ny = node.getY()) + 1) && GraphNode.contains(startX, startY, endX - startX, endY - startY, nx + nw - 2, ny + nh - 2)) {
                    result.add(node);
                }
                result.addAll(node.getNodeList(from, to));
                ++i;
            }
        }
        if (to != null && !result.contains(to)) {
            result.add(to);
        }
        return result;
    }

    protected GraphNode getNodeFromListAt(int x, int y, List list, int fromIndex) {
        if (list == null) {
            return null;
        }
        int i = fromIndex;
        while (i < list.size()) {
            GraphNode node = (GraphNode)list.get(i);
            if (node.contains(x, y)) {
                return node;
            }
            ++i;
        }
        return null;
    }

    public int getStartOccurrence() {
        return this.startEventOccurrence;
    }

    public int getEndOccurrence() {
        return this.endEventOccurrence;
    }

    public void updateIndex(int x, int y, int width, int height) {
        if (!this.hasChilds) {
            return;
        }
        if (DebugUtil.debugIndex()) {
            System.out.print("*****************************\n");
            System.out.print("Visible area position in virtual screen (x,y)= " + x + " " + y + "\n\n");
        }
        Iterator it = this.nodes.keySet().iterator();
        while (it.hasNext()) {
            Object nodeType = it.next();
            int direction = 1;
            int drawIndex = (Integer)this.indexes.get(nodeType);
            if (this.nodes.get(nodeType) != null && ((List)this.nodes.get(nodeType)).size() > 1) {
                if (((GraphNode)((List)this.nodes.get(nodeType)).get(drawIndex)).positiveDistanceToPoint(x, y)) {
                    direction = -1;
                }
                if (drawIndex == 0) {
                    direction = 1;
                }
                if (direction == -1 && this.bnodes.get(nodeType) != null) {
                    GraphNode currentNode = (GraphNode)((List)this.nodes.get(nodeType)).get(drawIndex);
                    drawIndex = Arrays.binarySearch(((List)this.bnodes.get(nodeType)).toArray(), ((List)this.nodes.get(nodeType)).get(drawIndex), currentNode.getBackComparator());
                    this.nodes.put(nodeType, this.bnodes.get(nodeType));
                    if (drawIndex < 0) {
                        drawIndex = 0;
                        direction = 1;
                    } else {
                        this.nodes.put(nodeType, this.bnodes.get(nodeType));
                    }
                }
                GraphNode prev = null;
                int i = drawIndex;
                while (i < ((List)this.nodes.get(nodeType)).size() && i >= 0) {
                    drawIndex = i;
                    this.indexes.put(nodeType, new Integer(i));
                    GraphNode currentNode = (GraphNode)((List)this.nodes.get(nodeType)).get(i);
                    if (prev == null) {
                        prev = currentNode;
                    }
                    Comparator comp = currentNode.getComparator();
                    HashMap sort = this.fSort;
                    if (direction == -1 && currentNode.getBackComparator() != null) {
                        comp = currentNode.getBackComparator();
                        sort = this.bSort;
                    }
                    if (i < ((List)this.nodes.get(nodeType)).size() - 1) {
                        GraphNode next = (GraphNode)((List)this.nodes.get(nodeType)).get(i + 1);
                        if (comp != null && comp.compare(currentNode, next) == 1) {
                            sort.put(nodeType, new Boolean(true));
                        }
                    }
                    if (direction == 1) {
                        if (((GraphNode)((List)this.nodes.get(nodeType)).get(i)).positiveDistanceToPoint(x, y)) {
                            break;
                        }
                    } else if (currentNode.getBackComparator() == null) {
                        if (!currentNode.positiveDistanceToPoint(x, y)) {
                            break;
                        }
                    } else if (currentNode.isVisible(x, y, width, height) && !currentNode.positiveDistanceToPoint(x, y)) {
                        if (comp != null && comp.compare(currentNode, prev) <= 0) {
                            break;
                        }
                    } else if (comp != null && comp.compare(currentNode, prev) <= 0) {
                        prev = currentNode;
                    }
                    i += direction;
                }
                this.nodes.put(nodeType, this.fnodes.get(nodeType));
                if (this.bnodes.get(nodeType) != null && direction == -1) {
                    int index = (Integer)this.indexes.get(nodeType);
                    List list = (List)this.nodes.get(nodeType);
                    List backList = (List)this.bnodes.get(nodeType);
                    GraphNode currentNode = (GraphNode)backList.get(index);
                    if (index > 0) {
                        index = Arrays.binarySearch(list.toArray(), backList.get(index), currentNode.getComparator());
                        if (index < 0) {
                            index = 0;
                        }
                        this.indexes.put(nodeType, new Integer(index));
                    }
                }
                i = drawIndex;
                while (i < ((List)this.nodes.get(nodeType)).size() && i >= 0) {
                    GraphNode toDraw = (GraphNode)((List)this.nodes.get(nodeType)).get(i);
                    toDraw.updateIndex(x, y, width, height);
                    if (!toDraw.isVisible(x, y, width, height)) break;
                    ++i;
                }
            }
            if (!DebugUtil.debugIndex()) continue;
            System.out.print("First drawn " + nodeType + " index = " + drawIndex + "\n");
            System.out.print(nodeType + " found in " + 0 + " iterations\n");
        }
        if (DebugUtil.debugIndex()) {
            System.out.print("*****************************\n");
        }
    }

    protected void drawChildsNodes(IGC context) {
        if (!this.hasChilds) {
            return;
        }
        Iterator it = this.fSort.keySet().iterator();
        while (it.hasNext()) {
            Object nodeType = it.next();
            boolean sort = (Boolean)this.fSort.get(nodeType);
            if (!sort) continue;
            Object[] temp = ((List)this.fnodes.get(nodeType)).toArray();
            GraphNode node = (GraphNode)((List)this.nodes.get(nodeType)).get(0);
            Arrays.sort(temp, node.getComparator());
            this.fSort.put(nodeType, new Boolean(false));
            this.nodes.put(nodeType, Arrays.asList(temp));
            this.fnodes.put(nodeType, Arrays.asList(temp));
            if (!DebugUtil.debugSorting()) continue;
            System.out.print(nodeType + " array sorted\n");
        }
        Iterator it2 = this.bSort.keySet().iterator();
        while (it2.hasNext()) {
            Object nodeType = it2.next();
            boolean sort = (Boolean)this.bSort.get(nodeType);
            if (!sort) continue;
            Object[] temp = ((List)this.bnodes.get(nodeType)).toArray();
            GraphNode node = (GraphNode)((List)this.nodes.get(nodeType)).get(0);
            Arrays.sort(temp, node.getBackComparator());
            this.bSort.put(nodeType, new Boolean(false));
            this.bnodes.put(nodeType, Arrays.asList(temp));
            if (!DebugUtil.debugSorting()) continue;
            System.out.print(nodeType + " back array sorted\n");
        }
        if (DebugUtil.debugDisplay()) {
            System.out.print("*****************************\n");
        }
        int arrayStep = 1;
        if ((float)(Metrics.getMessageFontHeigth() + 20) * context.getZoom() < 1.0f) {
            arrayStep = Math.round(1.0f / ((float)(Metrics.getMessageFontHeigth() + 20) * context.getZoom()));
        }
        int count = 0;
        Iterator it3 = this.fSort.keySet().iterator();
        while (it3.hasNext()) {
            count = 0;
            Object nodeType = it3.next();
            GraphNode node = (GraphNode)((List)this.nodes.get(nodeType)).get(0);
            context.setFont(Frame.getUserPref().getFont(node.prefId));
            int index = (Integer)this.indexes.get(nodeType);
            count = this.drawNodes(context, (List)this.nodes.get(nodeType), index, arrayStep);
            if (!DebugUtil.debugDisplay()) continue;
            System.out.print(String.valueOf(count) + " " + nodeType + " drawn, starting from index " + index + "\r\n");
        }
        if (DebugUtil.debugDisplay()) {
            System.out.print("*****************************\n");
        }
    }

    private int drawNodes(IGC context, List list, int startIndex, int step) {
        if (!this.hasChilds) {
            return 0;
        }
        GraphNode last = null;
        int nodesCount = 0;
        if (list.size() < 0) {
            return 0;
        }
        GraphNode node = (GraphNode)list.get(0);
        context.setFont(Frame.getUserPref().getFont(node.prefId));
        Comparator comparator = node.getComparator();
        int i = startIndex;
        while (i < list.size()) {
            int ch;
            int cw;
            int cy;
            int cx;
            GraphNode toDraw = (GraphNode)list.get(i);
            if (i < list.size() - 1) {
                GraphNode next = (GraphNode)list.get(i + 1);
                if (comparator != null && comparator.compare(toDraw, next) == 1) {
                    this.fSort.put(next.getArrayId(), new Boolean(true));
                }
            }
            if (!toDraw.isVisible(cx = context.getContentsX(), cy = context.getContentsY(), cw = context.getVisibleWidth(), ch = context.getVisibleHeight()) && toDraw.positiveDistanceToPoint(cx + cw, cy + ch)) break;
            if ((!toDraw.isSameAs(last) || toDraw.isSelected()) && toDraw.isVisible(context.getContentsX(), context.getContentsY(), context.getVisibleWidth(), context.getVisibleHeight())) {
                ++nodesCount;
                toDraw.draw(context);
                if (this.hasFocus()) {
                    toDraw.drawFocus(context);
                }
            }
            last = toDraw;
            i += step;
        }
        return nodesCount;
    }

    public void drawFocus(IGC context) {
        context.drawFocus(this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    public static boolean contains(int x, int y, int width, int height, int px, int py) {
        int locX = x;
        int locY = y;
        int locWidth = width;
        int locHeight = height;
        if (width < 0) {
            locX += width;
            locWidth = -locWidth;
        }
        if (height < 0) {
            locY += height;
            locHeight = -locHeight;
        }
        return px >= locX && py >= locY && px - locX <= locWidth && py - locY <= locHeight;
    }
}

