/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui.core.internal;

import org.eclipse.hyades.uml2sd.ui.core.AsyncMessage;
import org.eclipse.hyades.uml2sd.ui.core.Frame;
import org.eclipse.hyades.uml2sd.ui.core.ITimeRange;
import org.eclipse.hyades.uml2sd.ui.core.Metrics;
import org.eclipse.hyades.uml2sd.ui.drawings.IColor;
import org.eclipse.hyades.uml2sd.ui.drawings.IGC;

public class EllipsisisMessage
extends AsyncMessage
implements ITimeRange {
    public int getX() {
        if (this.startLifeline == null) {
            return super.getX() + super.getWidth() - 16;
        }
        return super.getX();
    }

    public int getY() {
        return super.getY() + 3;
    }

    public int getWidth() {
        return 16;
    }

    private void drawMessage(IGC context) {
        int x = super.getX();
        int y = this.getY();
        int width = super.getWidth();
        int height = this.getHeight();
        if (this.startLifeline == null && this.endLifeline != null) {
            context.drawTextTruncatedCentred(this.getName(), x, y - Metrics.getMessageFontHeigth() - 20, width, 20 + Metrics.getMessageFontHeigth(), !this.isSelected());
            int currentStyle = context.getLineStyle();
            context.setLineStyle(context.getLineSolidStyle());
            context.drawRectangle(x + width - 5, y, x + width - 6, y + height);
            context.drawRectangle(x + width - 10, y, x + width - 11, y + height);
            context.drawRectangle(x + width - 15, y, x + width - 16, y + height);
            context.setLineStyle(currentStyle);
            IColor storedColor = context.getBackground();
            context.setBackground(context.getForeground());
            context.fillRectangle(x + width - 5, y, x + width - 6, y + height);
            context.fillRectangle(x + width - 10, y, x + width - 11, y + height);
            context.fillRectangle(x + width - 15, y, x + width - 16, y + height);
            context.setBackground(storedColor);
        } else if (this.endLifeline == null && this.startLifeline != null) {
            context.drawTextTruncatedCentred(this.getName(), x, y - Metrics.getMessageFontHeigth() - 20, width, 20 + Metrics.getMessageFontHeigth(), !this.isSelected());
            int currentStyle = context.getLineStyle();
            context.setLineStyle(context.getLineSolidStyle());
            context.drawRectangle(x + 5, y, 1, 1);
            context.drawRectangle(x + 10, y, 1, 1);
            context.drawRectangle(x + 15, y, 1, 1);
            context.setLineStyle(currentStyle);
            IColor storedColor = context.getBackground();
            context.setBackground(context.getForeground());
            context.fillRectangle(x + 5, y, 1, 1);
            context.fillRectangle(x + 10, y, 1, 1);
            context.fillRectangle(x + 15, y, 1, 1);
            context.setBackground(storedColor);
        } else {
            super.draw(context);
        }
    }

    public void draw(IGC context) {
        if (!this.isVisible()) {
            return;
        }
        if (this.isSelected()) {
            context.setForeground(Frame.getUserPref().getBackGroundColorSelection());
            context.setLineWidth(5);
            this.drawMessage(context);
            context.setBackground(Frame.getUserPref().getBackGroundColorSelection());
            context.setForeground(Frame.getUserPref().getForeGroundColorSelection());
        } else {
            context.setBackground(Frame.getUserPref().getBackGroundColor("PREF_ASYNC_MESS"));
            context.setForeground(Frame.getUserPref().getForeGroundColor("PREF_ASYNC_MESS"));
        }
        if (this.hasFocus()) {
            context.setDrawTextWithFocusStyle(true);
        }
        context.setLineWidth(1);
        this.drawMessage(context);
        context.setLineWidth(1);
        if (this.hasFocus()) {
            context.setDrawTextWithFocusStyle(false);
        }
    }
}

