/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui.load;

import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.uml2sd.util.SDUtil;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.part.ViewPart;

public class BackgroundLoader {
    private static ViewPart view;
    private boolean debug = false;
    private static BackgroundLoader instance;
    private Thread thread;
    private IProgressMonitor monitor;
    private List taskList = new LinkedList();
    private static Image image;

    static {
        image = SDUtil.getResourceImage("full/clcl16/sequencediagram_obj.gif").createImage();
    }

    private void addTask(IRunnableWithProgress task) {
        this.taskList.add(task);
    }

    private IRunnableWithProgress getNextTask() {
        if (!this.taskList.isEmpty()) {
            return (IRunnableWithProgress)this.taskList.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRunnableWithProgress consumeTask() {
        List list = this.taskList;
        synchronized (list) {
            IRunnableWithProgress task = this.getNextTask();
            if (task != null) {
                this.taskList.remove(0);
            }
            return task;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearTasks() {
        List list = this.taskList;
        synchronized (list) {
            this.taskList.clear();
        }
    }

    public static synchronized BackgroundLoader getInstance() {
        if (instance == null) {
            instance = new BackgroundLoader();
        }
        return instance;
    }

    public synchronized void newTask(IRunnableWithProgress task) {
        this.addTask(task);
        if (this.debug) {
            System.err.println("newTask(): Adding " + task);
        }
        if (this.thread == null || !this.thread.isAlive()) {
            this.thread = new Thread(new Runnable(){

                public void run() {
                    IRunnableWithProgress task = BackgroundLoader.this.getNextTask();
                    if (BackgroundLoader.this.debug) {
                        System.err.println("newTask(): Testing next task #1 = " + task);
                    }
                    while (task != null) {
                        block4: {
                            try {
                                BackgroundLoader.this.cancelIt(false);
                                this.runIt(task);
                                BackgroundLoader.this.consumeTask();
                                BackgroundLoader.this.cancelIt(false);
                            }
                            catch (Exception e) {
                                BackgroundLoader.this.clearTasks();
                                BackgroundLoader.this.cancelIt(true);
                                if (!BackgroundLoader.this.debug) break block4;
                                e.printStackTrace();
                            }
                        }
                        task = BackgroundLoader.this.getNextTask();
                        if (!BackgroundLoader.this.debug) continue;
                        System.err.println("newTask(): Testing next task #2 = " + task);
                    }
                }

                private void runIt(IRunnableWithProgress task) throws InvocationTargetException, InterruptedException {
                    task.run(BackgroundLoader.this.monitor);
                }
            });
            this.thread.setName("Sequence Diagram Background Loader");
            this.thread.start();
        } else {
            this.cancelIt(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelIt(boolean b) {
        IProgressMonitor iProgressMonitor = this.monitor;
        synchronized (iProgressMonitor) {
            this.monitor.setCanceled(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newSubsequentTask(IRunnableWithProgress task) {
        this.addTask(task);
        if (this.getNextTask() == task) {
            if (this.debug) {
                System.err.println("newSubsequentTask(): Calling newTask because no current task is executed");
            }
            this.newTask(task);
        } else {
            BackgroundLoader backgroundLoader = this;
            synchronized (backgroundLoader) {
                if (this.debug) {
                    System.err.println("newSubsequentTask(): Adding " + task);
                }
            }
        }
    }

    public synchronized void cancelTask() {
        this.cancelIt(true);
        if (this.thread.isAlive()) {
            this.thread.destroy();
        }
        this.clearTasks();
    }

    public static void shutdown() {
        if (instance != null && BackgroundLoader.instance.monitor != null && !BackgroundLoader.instance.monitor.isCanceled()) {
            BackgroundLoader.instance.monitor.setCanceled(true);
        }
        instance = null;
        image.dispose();
    }

    private BackgroundLoader() {
        this.monitor = new CancelProgressMonitor();
    }

    public static void setView(ViewPart view_) {
        view = view_;
    }

    static /* synthetic */ Image access$2() {
        return image;
    }

    public class CancelProgressMonitor
    implements IProgressMonitor {
        private volatile boolean canceled = false;
        private volatile String taskName;

        public boolean isCanceled() {
            return this.canceled;
        }

        public void setCanceled(boolean canceled_) {
            this.canceled = canceled_;
            if (canceled_ && this.taskName != null && BackgroundLoader.this.debug) {
                System.err.println("Canceled task \"" + this.taskName + "\"");
            }
        }

        public void beginTask(String name, int totalWork) {
            this.setTaskName(name);
            if (BackgroundLoader.this.debug) {
                System.err.println("Starting task \"" + this.taskName + "\"...");
            }
        }

        public void done() {
            if (BackgroundLoader.this.debug) {
                System.err.println(String.valueOf(this.canceled ? "Done normally " : "Done with canceled ") + "task \"" + this.taskName + "\"");
            }
            this.setTaskName(null);
        }

        public void internalWorked(double work) {
        }

        public void setTaskName(String name) {
            this.taskName = name;
            if (view == null) {
                return;
            }
            Display.getDefault().syncExec(new Runnable(this){
                final /* synthetic */ CancelProgressMonitor this$1;
                {
                    this.this$1 = cancelProgressMonitor;
                }

                public void run() {
                    block2: {
                        try {
                            IStatusLineManager lineManager = BackgroundLoader.access$1().getViewSite().getActionBars().getStatusLineManager();
                            lineManager.setMessage((Image)(CancelProgressMonitor.access$0(this.this$1) != null ? BackgroundLoader.access$2() : null), CancelProgressMonitor.access$0(this.this$1));
                        }
                        catch (Exception e) {
                            if (!BackgroundLoader.access$0(CancelProgressMonitor.access$1(this.this$1))) break block2;
                            e.printStackTrace();
                        }
                    }
                }
            });
        }

        public void subTask(String name) {
        }

        public void worked(int work) {
        }

        static /* synthetic */ String access$0(CancelProgressMonitor cancelProgressMonitor) {
            return cancelProgressMonitor.taskName;
        }

        static /* synthetic */ BackgroundLoader access$1(CancelProgressMonitor cancelProgressMonitor) {
            return cancelProgressMonitor.BackgroundLoader.this;
        }
    }
}

