/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui.preferences;

import java.util.Hashtable;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.uml2sd.ui.drawings.IColor;
import org.eclipse.hyades.uml2sd.ui.drawings.IFont;
import org.eclipse.hyades.uml2sd.ui.drawings.ISDPreferences;
import org.eclipse.hyades.uml2sd.ui.drawings.impl.ColorImpl;
import org.eclipse.hyades.uml2sd.ui.drawings.impl.FontImpl;
import org.eclipse.hyades.uml2sd.util.SDMessages;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class SDViewPref
implements ISDPreferences,
IPropertyChangeListener {
    public static final String BACK_COLOR_POSTFIX = "_BACK_COLOR";
    public static final String FORE_COLOR_POSTFIX = "_FORE_COLOR";
    public static final String TEXT_COLOR_POSTFIX = "_TEXT_COLOR";
    public static final String[] fontList = new String[]{"PREF_LIFELINE", "PREF_EXEC", "PREF_SYNC_MESS", "PREF_SYNC_MESS_RET", "PREF_ASYNC_MESS", "PREF_ASYNC_MESS_RET", "PREF_FRAME", "PREF_LIFELINE_HEADER", "PREF_FRAME_NAME"};
    public static final String[] fontList2 = new String[]{SDMessages._88, SDMessages._89, SDMessages._90, SDMessages._91, SDMessages._92, SDMessages._93, SDMessages._94, SDMessages._95, SDMessages._96};
    public static final String[] prefBackColorList = new String[]{"PREF_LIFELINE", "PREF_EXEC", "PREF_FRAME", "PREF_LIFELINE_HEADER", "PREF_FRAME_NAME"};
    public static final String[] prefForeColorList = new String[]{"PREF_LIFELINE", "PREF_EXEC", "PREF_SYNC_MESS", "PREF_SYNC_MESS_RET", "PREF_ASYNC_MESS", "PREF_ASYNC_MESS_RET", "PREF_FRAME", "PREF_LIFELINE_HEADER", "PREF_FRAME_NAME"};
    public static final String[] prefTextColorList = new String[]{"PREF_LIFELINE", "PREF_SYNC_MESS", "PREF_SYNC_MESS_RET", "PREF_ASYNC_MESS", "PREF_ASYNC_MESS_RET", "PREF_LIFELINE_HEADER", "PREF_FRAME_NAME"};
    protected Hashtable fontPref;
    protected Hashtable foreColorPref;
    protected Hashtable backColorPref;
    protected Hashtable textColorPref;
    private static SDViewPref handle = null;
    private IPreferenceStore prefStore = HyadesUIPlugin.getInstance().getPreferenceStore();
    private IColor timeCompressionSelectionColor = null;
    private boolean noFocusSelection = false;
    protected static final String TEMP_TAG = "_TEMP";

    private SDViewPref() {
        ColorImpl color;
        this.prefStore.setDefault("PREF_LINK_FONT", true);
        this.prefStore.setDefault("PREF_EXCLUDE_EXTERNAL_TIME", true);
        this.prefStore.setDefault("PREF_LIFELINE_WIDTH", 120);
        this.prefStore.setDefault("PREF_USE_GRADIENT", true);
        this.prefStore.setDefault("PREF_TOOLTIP", true);
        this.fontPref = new Hashtable();
        this.foreColorPref = new Hashtable();
        this.backColorPref = new Hashtable();
        this.textColorPref = new Hashtable();
        int i = 0;
        while (i < fontList.length) {
            if (fontList[i].equals("PREF_FRAME_NAME")) {
                FontData[] data = Display.getDefault().getSystemFont().getFontData();
                data[0].setStyle(1);
                PreferenceConverter.setDefault((IPreferenceStore)this.prefStore, (String)fontList[i], (FontData)data[0]);
                PreferenceConverter.setDefault((IPreferenceStore)this.prefStore, (String)(String.valueOf(fontList[i]) + TEMP_TAG), (FontData)data[0]);
            } else {
                PreferenceConverter.setDefault((IPreferenceStore)this.prefStore, (String)fontList[i], (FontData[])Display.getDefault().getSystemFont().getFontData());
                PreferenceConverter.setDefault((IPreferenceStore)this.prefStore, (String)(String.valueOf(fontList[i]) + TEMP_TAG), (FontData[])Display.getDefault().getSystemFont().getFontData());
            }
            ++i;
        }
        i = 0;
        while (i < prefBackColorList.length) {
            color = prefBackColorList[i].equals("PREF_EXEC") || prefBackColorList[i].equals("PREF_FRAME_NAME") ? new ColorImpl(Display.getDefault(), 201, 222, 233) : (prefBackColorList[i].equals("PREF_LIFELINE") ? new ColorImpl(Display.getDefault(), 220, 220, 220) : (prefBackColorList[i].equals("PREF_LIFELINE_HEADER") ? new ColorImpl(Display.getDefault(), 245, 244, 244) : new ColorImpl(Display.getDefault(), 255, 255, 255)));
            PreferenceConverter.setDefault((IPreferenceStore)this.prefStore, (String)(String.valueOf(prefBackColorList[i]) + BACK_COLOR_POSTFIX), (RGB)((Color)color.getColor()).getRGB());
            PreferenceConverter.setDefault((IPreferenceStore)this.prefStore, (String)(String.valueOf(prefBackColorList[i]) + BACK_COLOR_POSTFIX + TEMP_TAG), (RGB)((Color)color.getColor()).getRGB());
            color.dispose();
            ++i;
        }
        i = 0;
        while (i < prefForeColorList.length) {
            color = prefForeColorList[i].equals("PREF_LIFELINE") ? new ColorImpl(Display.getDefault(), 129, 129, 129) : (prefForeColorList[i].equals("PREF_FRAME_NAME") ? new ColorImpl(Display.getDefault(), 81, 153, 200) : (prefForeColorList[i].equals("PREF_LIFELINE_HEADER") ? new ColorImpl(Display.getDefault(), 129, 127, 137) : new ColorImpl(Display.getDefault(), 134, 176, 212)));
            PreferenceConverter.setDefault((IPreferenceStore)this.prefStore, (String)(String.valueOf(prefForeColorList[i]) + FORE_COLOR_POSTFIX), (RGB)((Color)color.getColor()).getRGB());
            PreferenceConverter.setDefault((IPreferenceStore)this.prefStore, (String)(String.valueOf(prefForeColorList[i]) + FORE_COLOR_POSTFIX + TEMP_TAG), (RGB)((Color)color.getColor()).getRGB());
            color.dispose();
            ++i;
        }
        i = 0;
        while (i < prefTextColorList.length) {
            color = prefTextColorList[i].equals("PREF_LIFELINE") ? new ColorImpl(Display.getDefault(), 129, 129, 129) : (prefTextColorList[i].equals("PREF_FRAME_NAME") ? new ColorImpl(Display.getDefault(), 0, 0, 0) : (prefTextColorList[i].equals("PREF_LIFELINE_HEADER") ? new ColorImpl(Display.getDefault(), 129, 127, 137) : new ColorImpl(Display.getDefault(), 134, 176, 212)));
            PreferenceConverter.setDefault((IPreferenceStore)this.prefStore, (String)(String.valueOf(prefTextColorList[i]) + TEXT_COLOR_POSTFIX), (RGB)((Color)color.getColor()).getRGB());
            PreferenceConverter.setDefault((IPreferenceStore)this.prefStore, (String)(String.valueOf(prefTextColorList[i]) + TEXT_COLOR_POSTFIX + TEMP_TAG), (RGB)((Color)color.getColor()).getRGB());
            color.dispose();
            ++i;
        }
        ColorImpl color2 = new ColorImpl(Display.getDefault(), 218, 232, 238);
        PreferenceConverter.setDefault((IPreferenceStore)this.prefStore, (String)"PREF_TIME_COMP", (RGB)((Color)color2.getColor()).getRGB());
        color2.dispose();
        this.buildFontsAndColors();
        this.prefStore.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public IPreferenceStore getPreferenceStore() {
        return this.prefStore;
    }

    public void apply() {
        this.buildFontsAndColors();
        this.prefStore.firePropertyChangeEvent("PREFOK", null, null);
    }

    public static SDViewPref getInstance() {
        if (handle == null) {
            handle = new SDViewPref();
        }
        return handle;
    }

    public IColor getForeGroundColor(String prefName) {
        if (this.foreColorPref.get(String.valueOf(prefName) + FORE_COLOR_POSTFIX) != null && this.foreColorPref.get(String.valueOf(prefName) + FORE_COLOR_POSTFIX) instanceof ColorImpl) {
            return (IColor)this.foreColorPref.get(String.valueOf(prefName) + FORE_COLOR_POSTFIX);
        }
        return ColorImpl.getSystemColor(2);
    }

    public IColor getBackGroundColor(String prefName) {
        if (this.backColorPref.get(String.valueOf(prefName) + BACK_COLOR_POSTFIX) != null && this.backColorPref.get(String.valueOf(prefName) + BACK_COLOR_POSTFIX) instanceof ColorImpl) {
            return (IColor)this.backColorPref.get(String.valueOf(prefName) + BACK_COLOR_POSTFIX);
        }
        return ColorImpl.getSystemColor(1);
    }

    public IColor getFontColor(String prefName) {
        if (this.textColorPref.get(String.valueOf(prefName) + TEXT_COLOR_POSTFIX) != null && this.textColorPref.get(String.valueOf(prefName) + TEXT_COLOR_POSTFIX) instanceof ColorImpl) {
            return (IColor)this.textColorPref.get(String.valueOf(prefName) + TEXT_COLOR_POSTFIX);
        }
        return ColorImpl.getSystemColor(2);
    }

    public IColor getForeGroundColorSelection() {
        if (this.noFocusSelection) {
            return ColorImpl.getSystemColor(33);
        }
        return ColorImpl.getSystemColor(27);
    }

    public IColor getBackGroundColorSelection() {
        if (this.noFocusSelection) {
            return ColorImpl.getSystemColor(22);
        }
        return ColorImpl.getSystemColor(26);
    }

    public IFont getFont(String prefName) {
        if (this.fontPref.get(prefName) != null && this.fontPref.get(prefName) instanceof IFont) {
            return (IFont)this.fontPref.get(prefName);
        }
        return FontImpl.getSystemFont();
    }

    public int getLifelineWidth() {
        return this.prefStore.getInt("PREF_LIFELINE_WIDTH");
    }

    public boolean fontLinked() {
        return this.prefStore.getBoolean("PREF_LINK_FONT");
    }

    public boolean tooltipEnabled() {
        return this.prefStore.getBoolean("PREF_TOOLTIP");
    }

    public boolean excludeExternalTime() {
        return this.prefStore.getBoolean("PREF_EXCLUDE_EXTERNAL_TIME");
    }

    public boolean useGradienColor() {
        return this.prefStore.getBoolean("PREF_USE_GRADIENT");
    }

    public IColor getTimeCompressionSelectionColor() {
        return this.timeCompressionSelectionColor;
    }

    private void buildFontsAndColors() {
        RGB rgb;
        Display display = Display.getDefault();
        int i = 0;
        while (i < fontList.length) {
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)this.prefStore, (String)fontList[i]);
            if (this.fontPref.get(fontList[i]) != null && this.fontPref.get(fontList[i]) instanceof IFont) {
                ((IFont)this.fontPref.get(fontList[i])).dispose();
            }
            this.fontPref.put(fontList[i], new FontImpl(display, fontData));
            ++i;
        }
        i = 0;
        while (i < prefBackColorList.length) {
            rgb = PreferenceConverter.getColor((IPreferenceStore)this.prefStore, (String)(String.valueOf(prefBackColorList[i]) + BACK_COLOR_POSTFIX));
            if (this.backColorPref.get(String.valueOf(prefBackColorList[i]) + BACK_COLOR_POSTFIX) != null && this.backColorPref.get(String.valueOf(prefBackColorList[i]) + BACK_COLOR_POSTFIX) instanceof IColor) {
                ((IColor)this.backColorPref.get(String.valueOf(prefBackColorList[i]) + BACK_COLOR_POSTFIX)).dispose();
            }
            this.backColorPref.put(String.valueOf(prefBackColorList[i]) + BACK_COLOR_POSTFIX, new ColorImpl(display, rgb.red, rgb.green, rgb.blue));
            ++i;
        }
        i = 0;
        while (i < prefForeColorList.length) {
            rgb = PreferenceConverter.getColor((IPreferenceStore)this.prefStore, (String)(String.valueOf(prefForeColorList[i]) + FORE_COLOR_POSTFIX));
            if (this.foreColorPref.get(String.valueOf(prefForeColorList[i]) + FORE_COLOR_POSTFIX) != null && this.foreColorPref.get(String.valueOf(prefForeColorList[i]) + FORE_COLOR_POSTFIX) instanceof IColor) {
                ((IColor)this.foreColorPref.get(String.valueOf(prefForeColorList[i]) + FORE_COLOR_POSTFIX)).dispose();
            }
            this.foreColorPref.put(String.valueOf(prefForeColorList[i]) + FORE_COLOR_POSTFIX, new ColorImpl(display, rgb.red, rgb.green, rgb.blue));
            ++i;
        }
        i = 0;
        while (i < prefTextColorList.length) {
            rgb = PreferenceConverter.getColor((IPreferenceStore)this.prefStore, (String)(String.valueOf(prefTextColorList[i]) + TEXT_COLOR_POSTFIX));
            if (this.textColorPref.get(String.valueOf(prefTextColorList[i]) + TEXT_COLOR_POSTFIX) != null && this.textColorPref.get(String.valueOf(prefTextColorList[i]) + TEXT_COLOR_POSTFIX) instanceof IColor) {
                ((IColor)this.textColorPref.get(String.valueOf(prefTextColorList[i]) + TEXT_COLOR_POSTFIX)).dispose();
            }
            this.textColorPref.put(String.valueOf(prefTextColorList[i]) + TEXT_COLOR_POSTFIX, new ColorImpl(display, rgb.red, rgb.green, rgb.blue));
            ++i;
        }
        RGB rgb2 = PreferenceConverter.getColor((IPreferenceStore)this.prefStore, (String)"PREF_TIME_COMP");
        if (this.timeCompressionSelectionColor != null) {
            this.timeCompressionSelectionColor.dispose();
        }
        this.timeCompressionSelectionColor = new ColorImpl(display, rgb2.red, rgb2.green, rgb2.blue);
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.prefStore.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.prefStore.removePropertyChangeListener(listener);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (!event.getProperty().equals("PREFOK")) {
            this.buildFontsAndColors();
            this.prefStore.firePropertyChangeEvent("PREFOK", null, null);
        }
    }

    public void setNoFocusSelection(boolean v) {
        this.noFocusSelection = v;
    }
}

