/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui.view;

import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.hyades.uml2sd.util.SDMessages;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;

public class ScrollView
extends Composite {
    public static final int AUTO = 0;
    public static final int ALWAYS_OFF = 2;
    public static final int ALWAYS_ON = 1;
    private int contents_height_ = 0;
    private int contents_width_ = 0;
    private int contents_x_ = 0;
    private int contents_y_ = 0;
    private int h_scrollbar_mode_ = 0;
    private int v_scrollbar_mode_ = 0;
    private int h_scrollbar_increment_ = 10;
    private int v_scrollbar_increment_ = 10;
    private boolean auto_scroll_enabled_ = true;
    private int auto_scroll_period_ = 75;
    private PaintListener localPaintListener = null;
    private MouseMoveListener localMouseMoveListener = null;
    private MouseListener localMouseListener = null;
    private ControlListener localControlListener = null;
    private KeyListener localKeyListener = null;
    private Canvas vertsb_;
    private Canvas horzsb_ = new Canvas((Composite)this, 256);
    private Canvas viewcontrol_;
    protected Control corner_control_;
    private int overview_size_ = 100;
    private int mouse_down_x_ = -1;
    private int mouse_down_y_ = -1;
    private AutoScroll auto_scroll_ = null;
    private Timer auto_scroll_timer_ = null;
    public static final int VBAR = 1;
    public static final int HBAR = 2;
    private static Cursor overview_cursor_;

    public ScrollView(Composite c, int style) {
        this(c, style, true);
    }

    public ScrollView(Composite c, int style, boolean mouseWheel) {
        super(c, 0);
        this.viewcontrol_ = mouseWheel ? new Canvas((Composite)this, style | 0x100 | 0x200) : new Canvas((Composite)this, style);
        this.viewcontrol_.setBackground(this.getBackground());
        if (mouseWheel) {
            this.viewcontrol_.getVerticalBar().setVisible(false);
            this.viewcontrol_.getHorizontalBar().setVisible(false);
        }
        this.vertsb_ = new Canvas((Composite)this, 512);
        this.setLayout(new SVLayout());
        this.localPaintListener = new PaintListener(){

            public void paintControl(PaintEvent event) {
                Rectangle r = event.gc.getClipping();
                int cx = ScrollView.this.viewToContentsX(r.x);
                int cy = ScrollView.this.viewToContentsY(r.y);
                ScrollView.this.drawContents(event.gc, cx, cy, r.width, r.height);
            }
        };
        this.viewcontrol_.addPaintListener(this.localPaintListener);
        this.localMouseMoveListener = new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                int ox = e.x;
                int oy = e.y;
                e.x = ScrollView.this.viewToContentsX(e.x);
                e.y = ScrollView.this.viewToContentsY(e.y);
                ScrollView.this.contentsMouseMoveEvent(e);
                e.x = ox;
                e.y = oy;
            }
        };
        this.viewcontrol_.addMouseMoveListener(this.localMouseMoveListener);
        MouseTrackListener localMouseTrackListener = new MouseTrackListener(){

            public void mouseEnter(MouseEvent e) {
                int ox = e.x;
                int oy = e.y;
                e.x = ScrollView.this.viewToContentsX(e.x);
                e.y = ScrollView.this.viewToContentsY(e.y);
                ScrollView.this.contentsMouseEnter(e);
                e.x = ox;
                e.y = oy;
            }

            public void mouseHover(MouseEvent e) {
                int ox = e.x;
                int oy = e.y;
                e.x = ScrollView.this.viewToContentsX(e.x);
                e.y = ScrollView.this.viewToContentsY(e.y);
                ScrollView.this.contentsMouseHover(e);
                e.x = ox;
                e.y = oy;
            }

            public void mouseExit(MouseEvent e) {
                int ox = e.x;
                int oy = e.y;
                e.x = ScrollView.this.viewToContentsX(e.x);
                e.y = ScrollView.this.viewToContentsY(e.y);
                ScrollView.this.contentsMouseExit(e);
                e.x = ox;
                e.y = oy;
            }
        };
        this.viewcontrol_.addMouseTrackListener(localMouseTrackListener);
        this.localMouseListener = new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                int ox = e.x;
                int oy = e.y;
                e.x = ScrollView.this.viewToContentsX(e.x);
                e.y = ScrollView.this.viewToContentsY(e.y);
                ScrollView.this.contentsMouseDoubleClickEvent(e);
                e.x = ox;
                e.y = oy;
            }

            public void mouseDown(MouseEvent e) {
                int ox = e.x;
                int oy = e.y;
                int n = ScrollView.this.viewToContentsX(e.x);
                ScrollView.this.mouse_down_x_ = n;
                e.x = n;
                int n2 = ScrollView.this.viewToContentsY(e.y);
                ScrollView.this.mouse_down_y_ = n2;
                e.y = n2;
                ScrollView.this.contentsMouseDownEvent(e);
                e.x = ox;
                e.y = oy;
            }

            public void mouseUp(MouseEvent e) {
                int ox = e.x;
                int oy = e.y;
                e.x = ScrollView.this.viewToContentsX(e.x);
                e.y = ScrollView.this.viewToContentsY(e.y);
                ScrollView.this.contentsMouseUpEvent(e);
                e.x = ox;
                e.y = oy;
                ScrollView.this.mouse_down_y_ = -1;
                ScrollView.this.mouse_down_x_ = -1;
            }
        };
        this.viewcontrol_.addMouseListener(this.localMouseListener);
        this.localKeyListener = new KeyListener(){

            public void keyPressed(KeyEvent e) {
                ScrollView.this.keyPressedEvent(e);
            }

            public void keyReleased(KeyEvent e) {
                ScrollView.this.keyReleasedEvent(e);
            }
        };
        this.viewcontrol_.addKeyListener(this.localKeyListener);
        this.getVerticalBar().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ScrollView.this.setContentsPos(ScrollView.this.contents_x_, ScrollView.this.getVerticalBar().getSelection());
                if (!ScrollView.this.viewcontrol_.isFocusControl()) {
                    ScrollView.this.viewcontrol_.setFocus();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (this.viewcontrol_.getVerticalBar() != null) {
            this.viewcontrol_.getVerticalBar().addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ScrollBar b = ScrollView.this.viewcontrol_.getVerticalBar();
                    ScrollView.this.setContentsPos(ScrollView.this.contents_x_, b.getSelection());
                    ScrollView.this.getVerticalBar().setSelection(b.getSelection());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        this.getHorizontalBar().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ScrollView.this.setContentsPos(ScrollView.this.getHorizontalBar().getSelection(), ScrollView.this.contents_y_);
                if (!ScrollView.this.viewcontrol_.isFocusControl()) {
                    ScrollView.this.viewcontrol_.setFocus();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (this.viewcontrol_.getHorizontalBar() != null) {
            this.viewcontrol_.getHorizontalBar().addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ScrollBar b = ScrollView.this.viewcontrol_.getHorizontalBar();
                    ScrollView.this.setContentsPos(b.getSelection(), ScrollView.this.contents_y_);
                    ScrollView.this.getHorizontalBar().setSelection(b.getSelection());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
    }

    public boolean setFocus() {
        return this.viewcontrol_.forceFocus();
    }

    public void setCursor(Cursor cursor) {
        this.viewcontrol_.setCursor(cursor);
    }

    public void dispose() {
        if (this.auto_scroll_ != null) {
            this.auto_scroll_.cancel();
            this.auto_scroll_ = null;
        }
        if (this.viewcontrol_ != null) {
            this.viewcontrol_.dispose();
        }
        this.viewcontrol_ = null;
        if (this.vertsb_ != null) {
            this.vertsb_.dispose();
        }
        this.vertsb_ = null;
        if (this.horzsb_ != null) {
            this.horzsb_.dispose();
        }
        this.horzsb_ = null;
        if (this.corner_control_ != null) {
            Object data = this.corner_control_.getData();
            if (data instanceof Overview) {
                ((Overview)data).dispose();
            }
            this.corner_control_.dispose();
            this.corner_control_ = null;
        }
        super.dispose();
    }

    public Rectangle getClientArea() {
        return this.viewcontrol_.getClientArea();
    }

    public void setBackground(Color c) {
        super.setBackground(c);
        this.viewcontrol_.setBackground(c);
    }

    public void setToolTipText(String text) {
        this.viewcontrol_.setToolTipText(text);
    }

    protected void drawOverview(GC gc, Rectangle r) {
        int x = (int)((float)(r.width * this.contents_x_) / (float)this.contents_width_);
        int y = (int)((float)(r.height * this.contents_y_) / (float)this.contents_height_);
        int vw = this.getVisibleWidth();
        int vh = this.getVisibleHeight();
        int w = r.width - 1;
        if (this.contents_width_ > vw) {
            w = (int)((float)(r.width * vw) / (float)this.contents_width_);
        }
        int h = r.height - 1;
        if (this.contents_height_ > vh) {
            h = (int)((float)(r.height * vh) / (float)this.contents_height_);
        }
        gc.setForeground(this.getForeground());
        if (w < 5 || h < 5) {
            gc.drawLine(x, 0, x, r.height);
            gc.drawLine(0, y, r.width, y);
        } else {
            gc.drawRectangle(x, y, w, h);
        }
    }

    public void replaceControlListener(ControlListener nlistener) {
        if (this.localControlListener != null) {
            this.removeControlListener(this.localControlListener);
            this.localControlListener = null;
        }
        this.addControlListener(nlistener);
    }

    public void replaceKeyListener(KeyListener nlistener) {
        if (this.localKeyListener != null) {
            this.removeKeyListener(this.localKeyListener);
            this.localKeyListener = null;
        }
        this.addKeyListener(nlistener);
    }

    public void replaceMouseListener(MouseListener nlistener) {
        if (this.localMouseListener != null) {
            this.removeMouseListener(this.localMouseListener);
            this.localMouseListener = null;
        }
        this.viewcontrol_.addMouseListener(nlistener);
    }

    public void replaceMouseMoveListener(MouseMoveListener nlistener) {
        if (this.localMouseMoveListener != null) {
            this.removeMouseMoveListener(this.localMouseMoveListener);
            this.localMouseMoveListener = null;
        }
        this.viewcontrol_.addMouseMoveListener(nlistener);
    }

    public void replacePaintListener(PaintListener nlistener) {
        if (this.localPaintListener != null) {
            this.removePaintListener(this.localPaintListener);
            this.localPaintListener = null;
        }
        this.viewcontrol_.addPaintListener(nlistener);
    }

    public int getContentsHeight() {
        return this.contents_height_;
    }

    public int getContentsWidth() {
        return this.contents_width_;
    }

    public int getContentsX() {
        return this.contents_x_;
    }

    public int getContentsY() {
        return this.contents_y_;
    }

    public boolean getDragAutoScroll() {
        return this.auto_scroll_enabled_;
    }

    public void setDragAutoScroll(boolean aDragAutoScroll) {
        this.auto_scroll_enabled_ = aDragAutoScroll;
        if (!this.auto_scroll_enabled_ && this.auto_scroll_ != null) {
            this.auto_scroll_.cancel();
            this.auto_scroll_ = null;
        }
    }

    public void setDragAutoScrollPeriod(int _period) {
        this.auto_scroll_period_ = Math.max(0, _period);
    }

    public int getDragAutoScrollPeriod() {
        return this.auto_scroll_period_;
    }

    public int getHScrollBarMode() {
        return this.h_scrollbar_mode_;
    }

    public void setHScrollBarMode(int aHScrollBarMode) {
        this.h_scrollbar_mode_ = aHScrollBarMode;
    }

    public int getVScrollBarMode() {
        return this.v_scrollbar_mode_;
    }

    public void setVScrollBarMode(int aVScrollBarMode) {
        this.v_scrollbar_mode_ = aVScrollBarMode;
    }

    public int getHScrollBarIncrement() {
        return this.h_scrollbar_increment_;
    }

    public int getVScrollBarIncrement() {
        return this.v_scrollbar_increment_;
    }

    public void setHScrollBarIncrement(int _inc) {
        this.h_scrollbar_increment_ = Math.max(1, _inc);
    }

    public void setVScrollBarIncrement(int _inc) {
        this.v_scrollbar_increment_ = Math.max(1, _inc);
    }

    public void setOverviewEnabled(boolean _b) {
        if (this.getOverviewEnabled() == _b) {
            return;
        }
        Button cc = null;
        if (_b) {
            Button b = new Button((Composite)this, 0);
            b.setText("+");
            Overview ovr = new Overview();
            ovr.useControl((Control)b);
            b.setData((Object)ovr);
            cc = b;
            b.setToolTipText(SDMessages._78);
        }
        this.setCornerControl((Control)cc);
    }

    public void setOverviewSize(int _size) {
        this.overview_size_ = Math.abs(_size);
    }

    public boolean getOverviewEnabled() {
        Object data;
        return this.corner_control_ instanceof Button && (data = ((Button)this.corner_control_).getData()) instanceof Overview;
    }

    public int getOverviewSize() {
        return this.overview_size_;
    }

    public Control getViewControl() {
        return this.viewcontrol_;
    }

    protected void contentsMouseExit(MouseEvent e) {
    }

    protected void contentsMouseHover(MouseEvent e) {
    }

    protected void contentsMouseEnter(MouseEvent e) {
    }

    protected void contentsMouseDoubleClickEvent(MouseEvent e) {
    }

    protected void contentsMouseDownEvent(MouseEvent e) {
        this.mouse_down_x_ = e.x;
        this.mouse_down_y_ = e.y;
    }

    protected void contentsMouseMoveEvent(MouseEvent _event) {
        if ((_event.stateMask & SWT.BUTTON_MASK) != 0) {
            if (!this.auto_scroll_enabled_) {
                this.scrollBy(-(_event.x - this.mouse_down_x_), -(_event.y - this.mouse_down_y_));
                return;
            }
            int sx = 0;
            int sy = 0;
            int v_right = this.getContentsX() + this.getVisibleWidth();
            int v_bottom = this.getContentsY() + this.getVisibleHeight();
            if (_event.x < this.getContentsX()) {
                sx = this.getContentsX() - _event.x;
                this.mouse_down_x_ = this.getContentsX();
            } else if (_event.x > v_right) {
                sx = -_event.x + v_right;
                this.mouse_down_x_ = v_right;
            }
            if (_event.y < this.getContentsY()) {
                sy = this.getContentsY() - _event.y;
                this.mouse_down_y_ = this.getContentsY();
            } else if (_event.y > v_bottom) {
                sy = -_event.y + v_bottom;
                this.mouse_down_y_ = v_bottom;
            }
            if (sx != 0 || sy != 0) {
                if (this.auto_scroll_ == null) {
                    if (this.auto_scroll_timer_ == null) {
                        this.auto_scroll_timer_ = new Timer(true);
                    }
                    this.auto_scroll_ = new AutoScroll(this, sx, sy);
                    this.auto_scroll_timer_.schedule((TimerTask)this.auto_scroll_, 0L, (long)this.auto_scroll_period_);
                } else {
                    this.auto_scroll_.dx_ = sx;
                    this.auto_scroll_.dy_ = sy;
                }
            } else {
                if (this.auto_scroll_ != null) {
                    this.auto_scroll_.cancel();
                    this.auto_scroll_ = null;
                }
                this.scrollBy(-(_event.x - this.mouse_down_x_), -(_event.y - this.mouse_down_y_));
            }
        }
    }

    protected void contentsMouseUpEvent(MouseEvent _event) {
        if (this.auto_scroll_ != null) {
            this.auto_scroll_.cancel();
            this.auto_scroll_ = null;
        }
    }

    protected void drawContents(GC gc, int clipx, int clipy, int clipw, int cliph) {
    }

    public void resizeContents(int _w, int _h) {
        if (_w < 0) {
            _w = 0;
        }
        if (_h < 0) {
            _h = 0;
        }
        int oldW = this.contents_width_;
        int oldH = this.contents_height_;
        if (_w == oldW && _h == oldH) {
            return;
        }
        this.contents_width_ = _w;
        this.contents_height_ = _h;
        if (oldW > _w) {
            int s = _w;
            _w = oldW;
            oldW = s;
        }
        int vis_width = this.getVisibleWidth();
        int vis_height = this.getVisibleHeight();
        if (oldW < vis_width) {
            if (_w > vis_width) {
                _w = vis_width;
            }
            this.viewcontrol_.redraw(this.getContentsX() + oldW, 0, _w - oldW, vis_height, true);
        }
        if (oldH > _h) {
            int s = _h;
            _h = oldH;
            oldH = s;
        }
        if (oldH < vis_height) {
            if (_h > vis_height) {
                _h = vis_height;
            }
            this.viewcontrol_.redraw(0, this.getContentsY() + oldH, vis_width, _h - oldH, true);
        }
        if (this.updateScrollBarVisiblity()) {
            this.layout();
        } else {
            this.updateScrollBarsValues();
        }
    }

    public void redraw() {
        super.redraw();
        this.viewcontrol_.redraw();
    }

    public void scrollBy(int _dx, int _dy) {
        this.setContentsPos(this.getContentsX() + _dx, this.getContentsY() + _dy);
    }

    public void ensureVisible(int _px, int _py) {
        int cx = this.getContentsX();
        int cy = this.getContentsY();
        int right = this.getContentsX() + this.getVisibleWidth();
        int bottom = this.getContentsY() + this.getVisibleHeight();
        if (_px < this.getContentsX()) {
            cx = _px;
        } else if (_px > right) {
            cx = _px - this.getVisibleWidth();
        }
        if (_py < this.getContentsY()) {
            cy = _py;
        } else if (_py > bottom) {
            cy = _py - this.getVisibleHeight();
        }
        this.setContentsPos(cx, cy);
    }

    public void ensureVisible(int _x, int _y, int _w, int _h, int _align) {
        this.ensureVisible(_x, _y, _w, _h, _align, false);
    }

    protected void ensureVisible(int _x, int _y, int _w, int _h, int _align, boolean forceAlign) {
        if (_w < 0) {
            _x += _w;
            _w = -_w;
        }
        if (_h < 0) {
            _y += _h;
            _h = -_h;
        }
        int hbar = this.getHorizontalBarHeight();
        int vbar = this.getVerticalBarWidth();
        int cx = this.getContentsX();
        int cy = this.getContentsY();
        int right = this.getContentsX() + this.getVisibleWidth() - vbar;
        int bottom = this.getContentsY() + this.getVisibleHeight() - hbar;
        boolean align_h = false;
        boolean align_v = false;
        if (_x < this.getContentsX()) {
            cx = _x;
        } else if (_x + _w > right) {
            cx = _x - _w;
        }
        if (_y < this.getContentsY()) {
            cy = _y;
        } else if (_y + _h > bottom) {
            cy = _y - _h;
        }
        if (_w > this.getVisibleWidth()) {
            align_h = true;
        }
        if (_h > this.getVisibleHeight()) {
            align_v = true;
        }
        if (align_h || forceAlign && _x + _w > right) {
            cx = (_align & 0x4000) != 0 ? _x : ((_align & 0x20000) != 0 ? right - _w : _x + (_w - this.getVisibleWidth()) / 2);
        }
        if (align_v || forceAlign && _y + _h > bottom) {
            cy = (_align & 0x80) != 0 ? _y : ((_align & 0x400) != 0 ? bottom - _h : _y + (_h - this.getVisibleHeight()) / 2);
        }
        this.setContentsPos(cx, cy);
    }

    public boolean isVisible(int _px, int _py) {
        if (_px < this.getContentsX()) {
            return false;
        }
        if (_py < this.getContentsY()) {
            return false;
        }
        if (_px > this.getContentsX() + this.getVisibleWidth()) {
            return false;
        }
        return _py <= this.getContentsY() + this.getVisibleHeight();
    }

    public boolean isVisible(int _x, int _y, int _w, int _h) {
        if (_x + _w < this.getContentsX()) {
            return false;
        }
        if (_y + _h < this.getContentsY()) {
            return false;
        }
        int vr = this.getContentsX() + this.getVisibleWidth();
        int vb = this.getContentsY() + this.getVisibleHeight();
        if (_x > vr) {
            return false;
        }
        return _y <= vb;
    }

    public Rectangle getVisiblePart(int _x, int _y, int _w, int _h) {
        if (_x + _w < this.getContentsX()) {
            return null;
        }
        if (_y + _h < this.getContentsY()) {
            return null;
        }
        int vr = this.getContentsX() + this.getVisibleWidth();
        int vb = this.getContentsY() + this.getVisibleHeight();
        if (_x > vr) {
            return null;
        }
        if (_y > vb) {
            return null;
        }
        int rr = _x + _w;
        int rb = _y + _h;
        int nl = Math.max(_x, this.getContentsX());
        int nt = Math.max(_y, this.getContentsY());
        int nr = Math.min(rr, vr);
        int nb = Math.min(rb, vb);
        Rectangle c = new Rectangle(nl, nt, nr - nl, nb - nt);
        return c;
    }

    public final Rectangle getVisiblePart(Rectangle _r) {
        if (_r == null) {
            return null;
        }
        return this.getVisiblePart(_r.x, _r.y, _r.width, _r.height);
    }

    public boolean setContentsPos(int _x, int _y) {
        int nx = _x;
        int ny = _y;
        if (this.getVisibleWidth() >= this.getContentsWidth()) {
            nx = 0;
        } else if (_x < 0) {
            nx = 0;
        } else if (_x + this.getVisibleWidth() > this.getContentsWidth()) {
            nx = this.getContentsWidth() - this.getVisibleWidth();
        }
        if (this.getVisibleHeight() >= this.getContentsHeight()) {
            ny = 0;
        } else if (_y <= 0) {
            ny = 0;
        } else if (_y + this.getVisibleHeight() > this.getContentsHeight()) {
            ny = this.getContentsHeight() - this.getVisibleHeight();
        }
        if (nx == this.contents_x_ && ny == this.contents_y_) {
            return false;
        }
        this.contents_x_ = nx;
        this.contents_y_ = ny;
        this.updateScrollBarsValues();
        this.viewcontrol_.redraw();
        return true;
    }

    public ScrollBar getVerticalBar() {
        return this.vertsb_.getVerticalBar();
    }

    public ScrollBar getHorizontalBar() {
        return this.horzsb_.getHorizontalBar();
    }

    public int computeBarVisibility(int for_width, int for_height, boolean curr_h_vis, boolean curr_v_vis) {
        int vis = 0;
        switch (this.v_scrollbar_mode_) {
            case 2: {
                break;
            }
            case 1: {
                vis |= 1;
                break;
            }
            case 0: {
                if (this.getContentsHeight() <= for_height) break;
                vis = 1;
                if (curr_v_vis) break;
                for_width -= this.getVerticalBarWidth();
            }
        }
        switch (this.h_scrollbar_mode_) {
            case 2: {
                break;
            }
            case 1: {
                vis |= 2;
                break;
            }
            case 0: {
                if (this.getContentsWidth() <= for_width) break;
                vis |= 2;
                if (curr_h_vis || this.getContentsHeight() <= for_height - this.getHorizontalBarHeight()) break;
                vis |= 1;
            }
        }
        return vis;
    }

    private boolean updateScrollBarVisiblity() {
        boolean new_h_vis;
        boolean change = false;
        boolean curr_v_vis = this.vertsb_.getVisible();
        boolean curr_h_vis = this.horzsb_.getVisible();
        int bar_new_vis = this.computeBarVisibility(this.getVisibleWidth(), this.getVisibleHeight(), curr_h_vis, curr_v_vis);
        boolean new_v_vis = (bar_new_vis & 1) != 0;
        boolean bl = new_h_vis = (bar_new_vis & 2) != 0;
        if (curr_v_vis ^ new_v_vis) {
            this.vertsb_.setVisible(new_v_vis);
            change = true;
        }
        if (curr_h_vis ^ new_h_vis) {
            this.horzsb_.setVisible(new_h_vis);
            change = true;
        }
        if (this.corner_control_ != null && change) {
            boolean vis;
            boolean bl2 = vis = new_v_vis || new_h_vis;
            if (vis ^ this.corner_control_.getVisible()) {
                this.corner_control_.setVisible(vis);
                change = true;
            }
        }
        return change;
    }

    private void updateScrollBarsValues() {
        ScrollBar b = this.getVerticalBar();
        if (b != null) {
            b.setMinimum(0);
            b.setMaximum(this.getContentsHeight());
            b.setThumb(this.getVisibleHeight());
            b.setPageIncrement(this.getVisibleHeight());
            b.setIncrement(this.v_scrollbar_increment_);
            b.setSelection(this.getContentsY());
        }
        if ((b = this.viewcontrol_.getVerticalBar()) != null) {
            b.setMinimum(0);
            b.setMaximum(this.getContentsHeight());
            b.setThumb(this.getVisibleHeight());
            b.setPageIncrement(this.getVisibleHeight());
            b.setIncrement(this.v_scrollbar_increment_);
            b.setSelection(this.getContentsY());
        }
        if ((b = this.getHorizontalBar()) != null) {
            b.setMinimum(0);
            b.setMaximum(this.getContentsWidth());
            b.setThumb(this.getVisibleWidth());
            b.setSelection(this.getContentsX());
            b.setPageIncrement(this.getVisibleWidth());
            b.setIncrement(this.h_scrollbar_increment_);
        }
        if ((b = this.viewcontrol_.getHorizontalBar()) != null) {
            b.setMinimum(0);
            b.setMaximum(this.getContentsWidth());
            b.setThumb(this.getVisibleWidth());
            b.setSelection(this.getContentsX());
            b.setPageIncrement(this.getVisibleWidth());
            b.setIncrement(this.h_scrollbar_increment_);
        }
    }

    public void setCornerControl(Control _w) {
        if (this.corner_control_ != null) {
            this.corner_control_.dispose();
        }
        this.corner_control_ = _w;
        if (this.corner_control_ != null) {
            ScrollBar vb = this.getVerticalBar();
            ScrollBar hb = this.getHorizontalBar();
            boolean vis = vb.getVisible() || hb.getVisible();
            this.corner_control_.setVisible(vis);
        }
    }

    public final Point viewToContents(int _x, int _y) {
        Point p = new Point(this.viewToContentsX(_x), this.viewToContentsY(_y));
        return p;
    }

    public int viewToContentsX(int _x) {
        return this.contents_x_ + _x;
    }

    public int viewToContentsY(int _y) {
        return this.contents_y_ + _y;
    }

    public final Point contentsToView(int _x, int _y) {
        Point p = new Point(this.contentsToViewX(_x), this.contentsToViewY(_y));
        return p;
    }

    public int contentsToViewX(int _x) {
        return _x - this.contents_x_;
    }

    public int contentsToViewY(int _y) {
        return _y - this.contents_y_;
    }

    public int getVisibleHeight() {
        Rectangle r = this.viewcontrol_.getClientArea();
        return r.height;
    }

    public int getVisibleWidth() {
        Rectangle r = this.viewcontrol_.getClientArea();
        return r.width;
    }

    protected void keyPressedEvent(KeyEvent _e) {
        switch (_e.keyCode) {
            case 0x1000001: {
                this.scrollBy(0, -this.getVisibleHeight());
                break;
            }
            case 0x1000002: {
                this.scrollBy(0, this.getVisibleHeight());
                break;
            }
            case 0x1000003: {
                this.scrollBy(-this.getVisibleWidth(), 0);
                break;
            }
            case 0x1000004: {
                this.scrollBy(this.getVisibleWidth(), 0);
            }
        }
    }

    protected void keyReleasedEvent(KeyEvent _e) {
    }

    protected void viewResized() {
        this.setContentsPos(this.getContentsX(), this.getContentsY());
    }

    public int getVerticalBarWidth() {
        int bw = this.vertsb_.computeTrim((int)0, (int)0, (int)0, (int)0).width;
        return bw + 1;
    }

    public int getHorizontalBarHeight() {
        int bh = this.horzsb_.computeTrim((int)0, (int)0, (int)0, (int)0).height;
        return bh + 1;
    }

    public Rectangle computeTrim(int x, int y, int w, int h) {
        Rectangle r = new Rectangle(x, y, w, h);
        int bar_vis = this.computeBarVisibility(w, h, false, false);
        if ((bar_vis & 1) != 0) {
            r.width += this.getVerticalBarWidth();
        }
        if ((bar_vis & 2) != 0) {
            r.height += this.getHorizontalBarHeight();
        }
        return r;
    }

    private static class AutoScroll
    extends TimerTask {
        public int dx_;
        public int dy_;
        public ScrollView sv_;

        public AutoScroll(ScrollView _sv, int _dx, int _dy) {
            this.sv_ = _sv;
            this.dx_ = _dx;
            this.dy_ = _dy;
        }

        public void run() {
            Display.getDefault().asyncExec(new Runnable(this){
                final /* synthetic */ AutoScroll this$1;
                {
                    this.this$1 = autoScroll;
                }

                public void run() {
                    this.this$1.sv_.scrollBy(this.this$1.dx_, this.this$1.dy_);
                }
            });
        }
    }

    private class SVLayout
    extends Layout {
        int seek = 0;
        boolean dont_layout = false;

        SVLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            Point p = new Point(250, 250);
            if (ScrollView.this.contents_width_ < p.x) {
                p.x = ScrollView.this.contents_width_;
            }
            if (ScrollView.this.contents_height_ < p.y) {
                p.y = ScrollView.this.contents_height_;
            }
            return p;
        }

        protected void layout(Composite composite, boolean flushCache) {
            if (this.dont_layout) {
                return;
            }
            ++this.seek;
            if (this.seek > 10) {
                this.dont_layout = true;
            }
            Point cs = composite.getSize();
            int bar_vis = ScrollView.this.computeBarVisibility(cs.x, cs.y, false, false);
            boolean vb_vis = (bar_vis & 1) != 0;
            boolean hb_vis = (bar_vis & 2) != 0;
            ScrollView.this.vertsb_.setVisible(vb_vis);
            ScrollView.this.horzsb_.setVisible(hb_vis);
            int vbw = ScrollView.this.getVerticalBarWidth();
            int hbh = ScrollView.this.getHorizontalBarHeight();
            int wb = vb_vis ? vbw : 0;
            int hb = hb_vis ? hbh : 0;
            int cww = 0;
            int cwh = 0;
            if (ScrollView.this.corner_control_ != null && (vb_vis || hb_vis)) {
                ScrollView.this.corner_control_.setVisible(true);
                cww = vbw;
                cwh = hbh;
                if (wb == 0) {
                    wb = vbw;
                }
                if (hb == 0) {
                    hb = hbh;
                }
            } else if (vb_vis && hb_vis) {
                if (ScrollView.this.corner_control_ != null) {
                    ScrollView.this.corner_control_.setVisible(false);
                }
                cww = vbw;
                cwh = hbh;
            }
            if (vb_vis || hb_vis) {
                ScrollView.this.updateScrollBarsValues();
            }
            int vw = cs.x - (vb_vis ? vbw : 0);
            int vh = cs.y - (hb_vis ? hbh : 0);
            int vbx = cs.x - wb;
            int hby = cs.y - hb;
            Rectangle rc = ScrollView.this.viewcontrol_.getClientArea();
            int old_width = rc.width;
            int old_height = rc.height;
            ScrollView.this.viewcontrol_.setBounds(0, 0, vw, vh);
            boolean do_view_resize = false;
            rc = ScrollView.this.viewcontrol_.getClientArea();
            if (old_width != rc.width || old_height != rc.height) {
                do_view_resize = true;
            }
            if (vb_vis) {
                ScrollView.this.vertsb_.setBounds(vbx, 0, wb, cs.y - cwh);
            }
            if (hb_vis) {
                ScrollView.this.horzsb_.setBounds(0, hby, cs.x - cww, hb);
            }
            if (ScrollView.this.corner_control_ != null && ScrollView.this.corner_control_.getVisible()) {
                ScrollView.this.corner_control_.setBounds(vbx, hby, vbw, hbh);
            }
            ScrollView.this.updateScrollBarsValues();
            if (do_view_resize) {
                ScrollView.this.viewResized();
            }
            --this.seek;
            if (this.seek == 0) {
                this.dont_layout = false;
            }
        }
    }

    private class Overview {
        private float overview_factor_x_;
        private float overview_factor_y_;
        private Shell overview;
        private int save_cursor_x;
        private int save_cursor_y;

        Overview() {
        }

        public void useControl(Control _c) {
            Point pos = _c.getLocation();
            _c.addMouseListener(new MouseListener(this){
                final /* synthetic */ Overview this$1;
                {
                    this.this$1 = overview;
                }

                public void mouseDoubleClick(MouseEvent e) {
                }

                public void mouseDown(MouseEvent e) {
                    Overview.access$0(this.this$1, e.x, e.y);
                }

                public void mouseUp(MouseEvent e) {
                    Overview.access$1(this.this$1);
                }
            });
            _c.addFocusListener(new FocusListener(this){
                final /* synthetic */ Overview this$1;
                {
                    this.this$1 = overview;
                }

                public void focusGained(FocusEvent e) {
                }

                public void focusLost(FocusEvent e) {
                    if (Overview.access$2(this.this$1)) {
                        Overview.access$3(this.this$1, false);
                    }
                }
            });
            _c.addKeyListener(new KeyListener(this, pos){
                final /* synthetic */ Overview this$1;
                private final /* synthetic */ Point val$pos;
                {
                    this.this$1 = overview;
                    this.val$pos = point;
                }

                public void keyPressed(KeyEvent e) {
                    if (e.keyCode == 32 && !Overview.access$2(this.this$1)) {
                        Overview.access$0(this.this$1, this.val$pos.x, this.val$pos.y);
                    } else if (e.keyCode == 32) {
                        Overview.access$1(this.this$1);
                    }
                    if (e.keyCode == 0x1000002) {
                        Overview.access$4(this.this$1, 0, 1, (TypedEvent)e);
                    }
                    if (e.keyCode == 0x1000001) {
                        Overview.access$4(this.this$1, 0, -1, (TypedEvent)e);
                    }
                    if (e.keyCode == 0x1000004) {
                        Overview.access$4(this.this$1, 1, 0, (TypedEvent)e);
                    }
                    if (e.keyCode == 0x1000003) {
                        Overview.access$4(this.this$1, -1, 0, (TypedEvent)e);
                    }
                }

                public void keyReleased(KeyEvent e) {
                }
            });
            _c.addMouseMoveListener(new MouseMoveListener(this){
                final /* synthetic */ Overview this$1;
                {
                    this.this$1 = overview;
                }

                public void mouseMove(MouseEvent e) {
                    if (Overview.access$2(this.this$1)) {
                        Overview.access$5(this.this$1, e);
                    }
                }
            });
        }

        public void dispose() {
            if (this.overview != null) {
                this.overview.dispose();
            }
        }

        private boolean overviewing() {
            return this.overview != null && this.overview.isVisible();
        }

        private void overviewAppear(int mx, int my) {
            int h;
            if (this.overview == null) {
                this.overview = new Shell(ScrollView.this.getShell(), 278528);
                this.overview.addPaintListener(new PaintListener(this){
                    final /* synthetic */ Overview this$1;
                    {
                        this.this$1 = overview;
                    }

                    public void paintControl(PaintEvent e) {
                        Overview.access$7(this.this$1).drawOverview(e.gc, Overview.access$6(this.this$1).getClientArea());
                    }
                });
            }
            this.overview.setForeground(ScrollView.this.viewcontrol_.getForeground());
            Point p = this.toGlobalCoordinates(ScrollView.this.corner_control_, 0, 0);
            int x = p.x;
            int y = p.y;
            int w = h = ScrollView.this.overview_size_;
            Rectangle scr = ScrollView.this.getDisplay().getBounds();
            Point ccs = ScrollView.this.corner_control_.getSize();
            try {
                float ratio;
                if (ScrollView.this.contents_width_ > ScrollView.this.contents_height_) {
                    ratio = (float)ScrollView.this.contents_height_ / (float)ScrollView.this.contents_width_;
                    h = (int)((float)w * ratio);
                    if (h < ccs.y) {
                        h = ccs.y;
                    } else if (h >= scr.height / 2) {
                        h = scr.height / 2;
                    }
                } else {
                    ratio = (float)ScrollView.this.contents_width_ / (float)ScrollView.this.contents_height_;
                    w = (int)((float)h * ratio);
                    if (w < ccs.x) {
                        w = ccs.x;
                    } else if (w >= scr.width / 2) {
                        w = scr.width / 2;
                    }
                }
                this.overview_factor_x_ = (float)ScrollView.this.contents_width_ / (float)w;
                this.overview_factor_y_ = (float)ScrollView.this.contents_height_ / (float)h;
            }
            catch (ArithmeticException arithmeticException) {}
            if (x <= 0) {
                x = 1;
            }
            if (y <= 0) {
                y = 1;
            }
            x = x - w + ccs.x;
            y = y - h + ccs.y;
            this.overview.setBounds(x, y, w, h);
            this.overview.setVisible(true);
            this.overview.redraw();
            if (overview_cursor_ == null) {
                RGB[] rgb = new RGB[]{new RGB(0, 0, 0), new RGB(255, 0, 0)};
                PaletteData pal_ = new PaletteData(rgb);
                int s = 1;
                byte[] src = new byte[s * s];
                byte[] msk = new byte[s * s];
                int i = 0;
                while (i < s * s) {
                    src[i] = -1;
                    ++i;
                }
                ImageData i_src = new ImageData(s, s, 1, pal_, 1, src);
                ImageData i_msk = new ImageData(s, s, 1, pal_, 1, msk);
                overview_cursor_ = new Cursor(null, i_src, i_msk, 0, 0);
            }
            ScrollView.this.corner_control_.setCursor(overview_cursor_);
            p = this.toGlobalCoordinates(ScrollView.this.corner_control_, mx, my);
            this.save_cursor_x = p.x;
            this.save_cursor_y = p.y;
            Rectangle r = this.overview.getClientArea();
            int cx = (int)((float)(r.width * ScrollView.this.contents_x_) / (float)ScrollView.this.contents_width_);
            int cy = (int)((float)(r.height * ScrollView.this.contents_y_) / (float)ScrollView.this.contents_height_);
            p = this.toGlobalCoordinates((Control)this.overview.getParent(), cx, cy);
            cx = p.x;
            cy = p.y;
        }

        private void overviewDisappear() {
            this.overviewDisappear(true);
        }

        private void overviewDisappear(boolean restoreCursorLoc) {
            if (this.overview == null) {
                return;
            }
            this.overview.setVisible(false);
            ScrollView.this.corner_control_.setCursor(null);
            if (restoreCursorLoc) {
                ScrollView.this.getDisplay().setCursorLocation(this.save_cursor_x, this.save_cursor_y);
            }
            this.overview.dispose();
            this.overview = null;
        }

        private void overviewMove(MouseEvent event) {
            Point p = this.toGlobalCoordinates(ScrollView.this.corner_control_, event.x, event.y);
            int dx = p.x - this.save_cursor_x;
            int dy = p.y - this.save_cursor_y;
            this.overviewMove(dx, dy, (TypedEvent)event);
        }

        private void overviewMove(int dx, int dy, TypedEvent event) {
            MouseEvent e;
            boolean ctrl = false;
            boolean shift = false;
            if (event instanceof MouseEvent) {
                e = (MouseEvent)event;
                ScrollView.this.getDisplay().setCursorLocation(this.save_cursor_x, this.save_cursor_y);
                ctrl = (e.stateMask & 0x40000) != 0;
                shift = (e.stateMask & 0x20000) != 0;
            } else if (event instanceof KeyEvent) {
                e = (KeyEvent)event;
                ctrl = (e.stateMask & 0x40000) != 0;
                shift = (e.stateMask & 0x20000) != 0;
            }
            int cx = ScrollView.this.contents_x_;
            int cy = ScrollView.this.contents_y_;
            float fx = this.overview_factor_x_;
            float fy = this.overview_factor_y_;
            if (ctrl && shift) {
                if (fx * 0.25f > 1.0f && (double)fy * 0.25 > 1.0) {
                    fy = 1.0f;
                    fx = 1.0f;
                } else {
                    fx *= 0.1f;
                    fy *= 0.1f;
                }
            } else if (ctrl) {
                fx *= 0.5f;
                fy *= 0.5f;
            } else if (shift) {
                fx *= 0.5f;
                fy *= 0.5f;
            }
            ScrollView.this.scrollBy((int)(fx * (float)dx), (int)(fy * (float)dy));
            if (cx != ScrollView.this.contents_x_ || cy != ScrollView.this.contents_y_) {
                this.overview.redraw();
                this.overview.update();
            }
        }

        protected Point toGlobalCoordinates(Control _loc, int _x, int _y) {
            Point p = new Point(_x, _y);
            Control c = _loc;
            while (c != null) {
                int trim_x = 0;
                int trim_y = 0;
                if (c instanceof Scrollable) {
                    Scrollable s = (Scrollable)c;
                    Rectangle rr = s.getClientArea();
                    Rectangle tr = s.computeTrim(rr.x, rr.y, rr.width, rr.height);
                    trim_x = rr.x - tr.x;
                    trim_y = rr.y - tr.y;
                }
                p.x += c.getLocation().x + trim_x;
                p.y += c.getLocation().y + trim_y;
                c = c.getParent();
            }
            return p;
        }

        static /* synthetic */ void access$0(Overview overview, int n, int n2) {
            overview.overviewAppear(n, n2);
        }

        static /* synthetic */ void access$1(Overview overview) {
            overview.overviewDisappear();
        }

        static /* synthetic */ boolean access$2(Overview overview) {
            return overview.overviewing();
        }

        static /* synthetic */ void access$3(Overview overview, boolean bl) {
            overview.overviewDisappear(bl);
        }

        static /* synthetic */ void access$4(Overview overview, int n, int n2, TypedEvent typedEvent) {
            overview.overviewMove(n, n2, typedEvent);
        }

        static /* synthetic */ void access$5(Overview overview, MouseEvent mouseEvent) {
            overview.overviewMove(mouseEvent);
        }

        static /* synthetic */ Shell access$6(Overview overview) {
            return overview.overview;
        }

        static /* synthetic */ ScrollView access$7(Overview overview) {
            return overview.ScrollView.this;
        }
    }
}

