/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.util;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.hyades.uml2sd.util.SDMessages;

public class TimeUtil {
    private static String[] normalStrings = new String[]{SDMessages._8, SDMessages._6, SDMessages._10, SDMessages._12, SDMessages._14, SDMessages._16, SDMessages._18};
    private static String[] accessibleStrings = new String[]{SDMessages._9, SDMessages._7, SDMessages._11, SDMessages._13, SDMessages._15, SDMessages._17, SDMessages._19};
    public static String[] deltaNormalString = new String[]{SDMessages._128, SDMessages._129, SDMessages._130, SDMessages._131, SDMessages._132, SDMessages._133};

    public static String timeToString(double time) {
        return TimeUtil.timeToString(time, normalStrings);
    }

    public static String accessibleTimeToString(double time) {
        return TimeUtil.timeToString(time, accessibleStrings);
    }

    private static String timeToString(double time, String[] ress) {
        String ret;
        if (Math.abs(time) >= 86400.0) {
            int days = (int)(time / 86400.0);
            int hours = Math.abs((int)(time % 86400.0) / 3600);
            ret = days != 1 && days != -1 ? MessageFormat.format((String)ress[0], (Object[])new Object[]{new Integer(days), new Integer(hours)}) : MessageFormat.format((String)ress[1], (Object[])new Object[]{new Integer(days), new Integer(hours)});
        } else if (Math.abs(time) >= 3600.0) {
            int hours = (int)(time / 3600.0);
            int mins = Math.abs((int)(time % 3600.0) / 60);
            ret = MessageFormat.format((String)ress[2], (Object[])new Object[]{new Integer(hours), new Integer(mins)});
        } else if (Math.abs(time) >= 60.0) {
            int mins = (int)(time / 60.0);
            int s = Math.abs((int)(time % 60.0));
            ret = MessageFormat.format((String)ress[3], (Object[])new Object[]{new Integer(mins), new Integer(s)});
        } else {
            ret = Math.abs(time) >= 1.0 ? MessageFormat.format((String)ress[4], (Object[])new Object[]{new Double(time)}) : (Math.abs(time * 1000.0) >= 1.0 ? MessageFormat.format((String)ress[5], (Object[])new Object[]{new Double(time * 1000.0)}) : MessageFormat.format((String)ress[6], (Object[])new Object[]{new Double(time * 1000000.0)}));
        }
        return ret;
    }

    public static String deltaToString(double time) {
        if (Math.abs(time) >= 86400.0) {
            int days = (int)(time / 86400.0);
            return MessageFormat.format((String)SDMessages._127, (Object[])new Object[]{new Integer(days)});
        }
        if (Math.abs(time) >= 3600.0) {
            int hours = (int)(time / 3600.0);
            return MessageFormat.format((String)SDMessages._127, (Object[])new Object[]{new Integer(hours)});
        }
        if (Math.abs(time) >= 60.0) {
            int mins = (int)(time / 60.0);
            return MessageFormat.format((String)SDMessages._127, (Object[])new Object[]{new Integer(mins)});
        }
        if (Math.abs(time) >= 1.0) {
            return MessageFormat.format((String)SDMessages._127, (Object[])new Object[]{new Double(time)});
        }
        if (Math.abs(time * 1000.0) >= 1.0) {
            return MessageFormat.format((String)SDMessages._127, (Object[])new Object[]{new Double(time * 1000.0)});
        }
        return MessageFormat.format((String)SDMessages._127, (Object[])new Object[]{new Double(time * 1000000.0)});
    }

    public static int deltaUnit(double time) {
        if (Math.abs(time) >= 86400.0) {
            return 0;
        }
        if (Math.abs(time) >= 3600.0) {
            return 1;
        }
        if (Math.abs(time) >= 60.0) {
            return 2;
        }
        if (Math.abs(time) >= 1.0) {
            return 3;
        }
        if (Math.abs(time * 1000.0) >= 1.0) {
            return 4;
        }
        return 5;
    }
}

