/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ztest;

import org.eclipse.hyades.uml2sd.ui.core.AsyncMessage;
import org.eclipse.hyades.uml2sd.ui.core.AsyncMessageReturn;
import org.eclipse.hyades.uml2sd.ui.core.BaseMessage;
import org.eclipse.hyades.uml2sd.ui.core.ExecutionOccurrence;
import org.eclipse.hyades.uml2sd.ui.core.Frame;
import org.eclipse.hyades.uml2sd.ui.core.GraphNode;
import org.eclipse.hyades.uml2sd.ui.core.Lifeline;
import org.eclipse.hyades.uml2sd.ui.core.SyncMessage;
import org.eclipse.hyades.uml2sd.ui.core.SyncMessageReturn;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class ToolBox
extends Window
implements ISelectionListener {
    private Button changeName;
    private SDView view;
    private Text nodeName;
    private Button createEvent;
    private Text startEvent;
    private Text endEvent;
    private Combo comb;
    private Button createMessage;
    private Text startExecEvent;
    private Text endExecEvent;
    private Button createExec;

    public ToolBox(Shell parent, SDView v) {
        super(parent);
        this.view = v;
    }

    private GridData newGridData(int span) {
        GridData data = new GridData(1808);
        data.horizontalSpan = span;
        return data;
    }

    public GraphNode getFirstSelectedObject() {
        StructuredSelection stSel;
        ISelection sel = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (sel != null && sel instanceof StructuredSelection && (stSel = (StructuredSelection)sel).getFirstElement() instanceof GraphNode) {
            return (GraphNode)stSel.getFirstElement();
        }
        return null;
    }

    public GraphNode getSecondSelectedObject() {
        Object[] arr;
        StructuredSelection stSel;
        ISelection sel = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (sel != null && sel instanceof StructuredSelection && (stSel = (StructuredSelection)sel).getFirstElement() instanceof GraphNode && (arr = stSel.toArray()).length > 1 && arr[1] instanceof GraphNode) {
            return (GraphNode)arr[1];
        }
        return null;
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().addPostSelectionListener((ISelectionListener)this);
        GridLayout parentLayout = new GridLayout();
        parentLayout.numColumns = 2;
        parent.setLayout((Layout)parentLayout);
        Group g1 = new Group(parent, 32);
        g1.setLayoutData((Object)this.newGridData(2));
        GridLayout kindSelectionLayout = new GridLayout();
        kindSelectionLayout.numColumns = 2;
        g1.setLayout((Layout)kindSelectionLayout);
        this.changeName = new Button((Composite)g1, 8);
        this.changeName.setText("Change graph node name");
        this.changeName.setLayoutData((Object)this.newGridData(1));
        this.changeName.setEnabled(false);
        this.changeName.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GraphNode node = ToolBox.this.getFirstSelectedObject();
                if (node != null) {
                    node.setName(ToolBox.this.nodeName.getText());
                    ToolBox.this.view.getSDWidget().redraw();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.nodeName = new Text((Composite)g1, 2052);
        this.nodeName.setLayoutData((Object)this.newGridData(1));
        Button createLifeline = new Button((Composite)g1, 8);
        createLifeline.setText("Create lifeline");
        createLifeline.setLayoutData((Object)this.newGridData(2));
        createLifeline.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Frame frame;
                if (ToolBox.this.view.getFrame() == null) {
                    frame = new Frame();
                    ToolBox.this.view.setFrame(frame);
                }
                frame = ToolBox.this.view.getFrame();
                Lifeline l = new Lifeline();
                frame.addLifeLine(l);
                ToolBox.this.view.getSDWidget().redraw();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.createEvent = new Button((Composite)g1, 8);
        this.createEvent.setText("Create event occurrence");
        this.createEvent.setLayoutData((Object)this.newGridData(2));
        this.createEvent.setEnabled(false);
        this.createEvent.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GraphNode node = ToolBox.this.getFirstSelectedObject();
                if (node != null && node instanceof Lifeline) {
                    int event = ((Lifeline)node).getNewEventOccurrence();
                    ToolBox.this.startEvent.setText(new Integer(event).toString());
                    ToolBox.this.view.getSDWidget().redraw();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label label = new Label(parent, 0x1000102);
        label.setLayoutData((Object)this.newGridData(2));
        Group g2 = new Group(parent, 32);
        g2.setLayoutData((Object)this.newGridData(2));
        GridLayout kindSelectionLayout2 = new GridLayout();
        kindSelectionLayout2.numColumns = 2;
        g2.setLayout((Layout)kindSelectionLayout2);
        Text startLifeline = new Text((Composite)g2, 12);
        startLifeline.setText("Start lifeline");
        GridData data = this.newGridData(1);
        data.horizontalAlignment = 0x1000000;
        startLifeline.setLayoutData((Object)data);
        Text endLifeline = new Text((Composite)g2, 12);
        endLifeline.setText("End lifeline");
        GridData data2 = this.newGridData(1);
        data2.horizontalAlignment = 0x1000000;
        endLifeline.setLayoutData((Object)data2);
        this.startEvent = new Text((Composite)g2, 2052);
        GridData data5 = this.newGridData(1);
        data5.horizontalAlignment = 0x1000000;
        this.startEvent.setLayoutData((Object)data5);
        this.endEvent = new Text((Composite)g2, 2052);
        GridData data6 = this.newGridData(1);
        data6.horizontalAlignment = 0x1000000;
        this.endEvent.setLayoutData((Object)data6);
        this.createMessage = new Button((Composite)g2, 8);
        this.createMessage.setText("Create message");
        this.createMessage.setLayoutData((Object)this.newGridData(1));
        this.createMessage.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Lifeline l1 = (Lifeline)ToolBox.this.getFirstSelectedObject();
                Lifeline l2 = (Lifeline)ToolBox.this.getSecondSelectedObject();
                int event1 = Integer.parseInt(ToolBox.this.startEvent.getText());
                int event2 = Integer.parseInt(ToolBox.this.endEvent.getText());
                Frame frame = ToolBox.this.view.getFrame();
                switch (ToolBox.this.comb.getSelectionIndex()) {
                    case 0: {
                        SyncMessage m = new SyncMessage();
                        m.setStartLifeline(l1);
                        m.setEndLifeline(l2);
                        frame.addMessage(m);
                        break;
                    }
                    case 1: {
                        SyncMessageReturn m = new SyncMessageReturn();
                        m.setStartLifeline(l1);
                        m.setEndLifeline(l2);
                        frame.addMessage(m);
                        break;
                    }
                    case 2: {
                        AsyncMessage m = new AsyncMessage();
                        m.setStartLifeline(l1);
                        m.setEndLifeline(l2);
                        m.setStartOccurrence(event1);
                        m.setEndOccurrence(event2);
                        frame.addMessage(m);
                        break;
                    }
                    case 3: {
                        AsyncMessageReturn m = new AsyncMessageReturn();
                        m.setStartLifeline(l1);
                        m.setEndLifeline(l2);
                        m.setStartOccurrence(event1);
                        m.setEndOccurrence(event2);
                        frame.addMessage(m);
                        break;
                    }
                }
                ToolBox.this.view.getSDWidget().redraw();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.comb = new Combo((Composite)g2, 4);
        this.comb.add("Sync Mess");
        this.comb.add("Sync Mess Ret");
        this.comb.add("ASync Mess");
        this.comb.add("ASync Mess Ret");
        this.comb.select(0);
        Label label2 = new Label(parent, 0x1000102);
        label2.setLayoutData((Object)this.newGridData(2));
        Group g3 = new Group(parent, 32);
        g3.setLayoutData((Object)this.newGridData(2));
        GridLayout kindSelectionLayout3 = new GridLayout();
        kindSelectionLayout3.numColumns = 2;
        g3.setLayout((Layout)kindSelectionLayout3);
        Text lifeline = new Text((Composite)g3, 12);
        lifeline.setText("Lifeline events occurrences");
        GridData data7 = this.newGridData(2);
        data7.horizontalAlignment = 0x1000000;
        lifeline.setLayoutData((Object)data7);
        this.startExecEvent = new Text((Composite)g3, 2052);
        GridData data8 = this.newGridData(1);
        data8.horizontalAlignment = 0x1000000;
        this.startExecEvent.setLayoutData((Object)data8);
        this.endExecEvent = new Text((Composite)g3, 2052);
        GridData data9 = this.newGridData(1);
        data9.horizontalAlignment = 0x1000000;
        this.endExecEvent.setLayoutData((Object)data9);
        this.createExec = new Button((Composite)g3, 8);
        this.createExec.setText("Create execution");
        this.createExec.setLayoutData((Object)this.newGridData(2));
        this.createExec.setEnabled(false);
        this.createExec.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Lifeline l1 = (Lifeline)ToolBox.this.getFirstSelectedObject();
                int Event1 = Integer.parseInt(ToolBox.this.startExecEvent.getText());
                int Event2 = Integer.parseInt(ToolBox.this.endExecEvent.getText());
                ExecutionOccurrence occ = new ExecutionOccurrence();
                occ.setLifeline(l1);
                occ.setStartOccurrence(Event1);
                occ.setEndOccurrence(Event2);
                l1.addExecution(occ);
                ToolBox.this.view.getSDWidget().redraw();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return parent;
    }

    public boolean close() {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().removePostSelectionListener((ISelectionListener)this);
        return super.close();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        GraphNode node2;
        this.changeName.setEnabled(false);
        this.createEvent.setEnabled(false);
        this.createMessage.setEnabled(false);
        this.createExec.setEnabled(false);
        this.startEvent.setText("");
        this.endEvent.setText("");
        int lifelineCount = 0;
        GraphNode node = this.getFirstSelectedObject();
        if (node != null) {
            this.changeName.setEnabled(true);
            if (node instanceof Lifeline) {
                this.createEvent.setEnabled(true);
                this.createExec.setEnabled(true);
                this.startEvent.setText(new Integer(((Lifeline)node).getEventOccurrence()).toString());
                ++lifelineCount;
            } else if (node instanceof BaseMessage) {
                int start;
                BaseMessage m = (BaseMessage)node;
                int end = start = m.getEventOccurrence();
                if (m instanceof AsyncMessage) {
                    start = ((AsyncMessage)m).getStartOccurrence();
                    end = ((AsyncMessage)m).getEndOccurrence();
                }
                if (m.getStartLifeline() != null) {
                    this.startEvent.setText(new Integer(start).toString());
                }
                if (m.getEndLifeline() != null) {
                    this.endEvent.setText(new Integer(end).toString());
                }
            } else {
                this.createEvent.setEnabled(false);
                this.startEvent.setText("");
            }
        }
        if ((node2 = this.getSecondSelectedObject()) != null) {
            this.createEvent.setEnabled(false);
            this.changeName.setEnabled(false);
            this.createExec.setEnabled(false);
            if (node2 instanceof Lifeline) {
                this.endEvent.setText(new Integer(((Lifeline)node2).getEventOccurrence()).toString());
                ++lifelineCount;
            } else {
                this.endEvent.setText("");
            }
        }
        if (lifelineCount == 2) {
            this.createMessage.setEnabled(true);
        }
    }
}

