/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.internal.annotations.controller;

import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.WeakHashMap;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jem.util.RegistryReader;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.common.internal.annotations.controller.AnnotationsController;
import org.eclipse.jst.common.internal.annotations.registry.AnnotationsControllerResources;
import org.eclipse.wst.common.frameworks.internal.enablement.EnablementIdentifier;
import org.eclipse.wst.common.frameworks.internal.enablement.EnablementIdentifierEvent;
import org.eclipse.wst.common.frameworks.internal.enablement.EnablementManager;
import org.eclipse.wst.common.frameworks.internal.enablement.IEnablementIdentifier;
import org.eclipse.wst.common.frameworks.internal.enablement.IEnablementIdentifierListener;
import org.eclipse.wst.common.frameworks.internal.enablement.Identifiable;
import org.eclipse.wst.common.frameworks.internal.enablement.IdentifiableComparator;
import org.eclipse.wst.common.internal.emf.utilities.Assert;

public class AnnotationsControllerManager
extends RegistryReader
implements IEnablementIdentifierListener {
    public static final AnnotationsControllerManager INSTANCE = new AnnotationsControllerManager();
    private SortedSet descriptors;
    private Map annotationsControllers;

    static {
        INSTANCE.readRegistry();
    }

    public AnnotationsControllerManager() {
        super("org.eclipse.jst.common.annotations.controller", "annotationsController");
    }

    public boolean readElement(IConfigurationElement element) {
        if (!element.getName().equals("annotationsController")) {
            return false;
        }
        this.addAnnotationController(new Descriptor(element));
        return true;
    }

    protected void addAnnotationController(Descriptor descriptor) {
        EnablementManager.INSTANCE.getIdentifier(descriptor.getID(), null).addIdentifierListener((IEnablementIdentifierListener)this);
        this.getDescriptors().add(descriptor);
    }

    protected SortedSet getDescriptors() {
        if (this.descriptors == null) {
            this.descriptors = new TreeSet(IdentifiableComparator.getInstance());
        }
        return this.descriptors;
    }

    public Descriptor getDescriptor(IProject project) {
        Iterator iter = this.getDescriptors().iterator();
        while (iter.hasNext()) {
            Descriptor descriptor = (Descriptor)iter.next();
            IEnablementIdentifier identifier = EnablementManager.INSTANCE.getIdentifier(descriptor.getID(), project);
            if (!identifier.isEnabled()) continue;
            return descriptor;
        }
        return null;
    }

    public boolean isAnyAnnotationsSupported() {
        return this.getDescriptors().size() > 0;
    }

    public void identifierChanged(EnablementIdentifierEvent identifierEvent) {
        IProject project = ((EnablementIdentifier)identifierEvent.getIdentifier()).getProject();
        this.getAnnotationsControllers().remove(project);
    }

    public AnnotationsController getAnnotationsController(IProject project) {
        AnnotationsController controller = (AnnotationsController)this.getAnnotationsControllers().get(project);
        if (controller == null) {
            if (!this.hasAnnotationsBuilder(project)) {
                return null;
            }
            Descriptor descriptor = this.getDescriptor(project);
            if (descriptor != null) {
                controller = descriptor.createInstance();
                this.getAnnotationsControllers().put(project, controller);
            }
        }
        return controller;
    }

    public Map getAnnotationsControllers() {
        if (this.annotationsControllers == null) {
            this.annotationsControllers = new WeakHashMap();
        }
        return this.annotationsControllers;
    }

    public boolean hasAnnotationsBuilder(IProject project) {
        Descriptor annotationsDescriptor = this.getDescriptor(project);
        if (annotationsDescriptor == null) {
            return false;
        }
        return this.hasBuilder(project, annotationsDescriptor.getBuilderID());
    }

    public boolean hasBuilder(IProject project, String builderName) {
        try {
            ICommand[] builders = project.getDescription().getBuildSpec();
            int i = 0;
            while (i < builders.length) {
                ICommand builder = builders[i];
                if (builder != null && builder.getBuilderName().equals(builderName)) {
                    return true;
                }
                ++i;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public static class Descriptor
    implements Identifiable {
        public static final String ANNOTATIONS_CONTROLLER = "annotationsController";
        public static final String ATT_ID = "id";
        public static final String CLASS = "class";
        public static final String BUILDER_ID = "builderID";
        private final IConfigurationElement configElement;
        private final String ID;
        private String builderID;
        private final int loadOrder;
        private static int loadOrderCounter = 0;

        public Descriptor(IConfigurationElement aConfigElement) {
            Assert.isLegal((boolean)ANNOTATIONS_CONTROLLER.equals(aConfigElement.getName()), (String)AnnotationsControllerResources.AnnotationsControllerManager_ERROR_0);
            this.configElement = aConfigElement;
            this.ID = this.configElement.getAttribute(ATT_ID);
            this.builderID = this.configElement.getAttribute(BUILDER_ID);
            this.loadOrder = loadOrderCounter++;
        }

        public String getID() {
            return this.ID;
        }

        public String getBuilderID() {
            return this.builderID;
        }

        public int getLoadOrder() {
            return this.loadOrder;
        }

        public AnnotationsController createInstance() {
            AnnotationsController instance = null;
            try {
                instance = (AnnotationsController)this.configElement.createExecutableExtension(CLASS);
            }
            catch (CoreException e) {
                Logger.getLogger().logError((Throwable)e);
            }
            return instance;
        }
    }
}

