/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ejb.ui.internal.actions;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jst.ejb.ui.internal.actions.AbstractClientJARAction;
import org.eclipse.jst.j2ee.internal.ejb.archiveoperations.EjbClientProjectRemovalDataModelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.ui.UIOperationHandler;
import org.eclipse.wst.common.frameworks.internal.ui.WorkspaceModifyComposedOperation;
import org.eclipse.wst.validation.internal.operations.ValidationOperation;
import org.eclipse.wst.validation.internal.operations.ValidatorManager;
import org.eclipse.wst.validation.internal.operations.ValidatorSubsetOperation;
import org.eclipse.wst.validation.internal.ui.plugin.ValidationUIPlugin;
import org.osgi.framework.Bundle;

public class EJBClientRemovalAction
extends AbstractClientJARAction {
    public static String LABEL = Platform.getResourceString((Bundle)Platform.getBundle((String)"org.eclipse.jst.ejb.ui"), (String)"%ejb.client.jar.remove.action.description_ui_");

    public EJBClientRemovalAction() {
        this.setText(LABEL);
    }

    protected void primRun(final Shell shell) {
        final IProject ejbProject = this.getProject();
        if (!this.checkClientExists(shell)) {
            return;
        }
        if (!this.checkBinaryProject(shell)) {
            return;
        }
        if (!this.confirmProceed(shell)) {
            return;
        }
        final IProject clientProject = this.getClientProject();
        ValidatorManager.getManager();
        Job clientRemoveJob = new Job("Removing EJB Client Project"){

            protected IStatus run(IProgressMonitor monitor) {
                UIOperationHandler opHandler = new UIOperationHandler(shell);
                IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new EjbClientProjectRemovalDataModelProvider());
                model.setProperty("IEjbClientProjectRemovalDataModelProperties.EJB_PROJECT", (Object)ejbProject);
                model.setProperty("IEjbClientProjectRemovalDataModelProperties.EJB_CLIENT_VIEW_PROJECT", (Object)clientProject);
                model.setProperty("IEjbClientProjectRemovalDataModelProperties.OP_HANDLER", (Object)opHandler);
                IStatus status = Status.OK_STATUS;
                try {
                    status = model.getDefaultOperation().execute(monitor, null);
                }
                catch (ExecutionException e) {
                    Logger.getLogger().logError((Throwable)e);
                }
                return status;
            }
        };
        clientRemoveJob.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        clientRemoveJob.setUser(true);
        clientRemoveJob.schedule();
    }

    protected void runValidationOperation(ProgressMonitorDialog dlg) {
        WorkspaceModifyComposedOperation runnable = new WorkspaceModifyComposedOperation();
        ValidatorSubsetOperation sop = new ValidatorSubsetOperation(this.getProject(), true, false);
        sop.setValidators(new String[]{"org.eclipse.jst.j2ee.core.internal.validation.EJBValidator"});
        runnable.addRunnable(ValidationUIPlugin.getRunnableWithProgress((ValidationOperation)sop));
        try {
            dlg.run(true, false, (IRunnableWithProgress)runnable);
        }
        catch (InvocationTargetException e) {
            Logger.getLogger((String)"org.eclipse.jst.j2ee.ui").logError((Throwable)e);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void handleException(Shell shell, Exception e) {
        Logger.getLogger().logError((Throwable)e);
        MessageDialog.openError((Shell)shell, (String)REMOVE_ERROR_TITLE, (String)ERROR_REMOVING_CLIENT);
    }

    private boolean checkClientExists(Shell shell) {
        if (this.getClientProject() == null) {
            MessageDialog.openError((Shell)shell, (String)NO_CLIENT_JAR_TITLE, (String)NO_CLIENT_JAR_MSG);
            return false;
        }
        return true;
    }

    private boolean confirmProceed(Shell shell) {
        String message = MessageFormat.format(REMOVE_MESSAGE, this.getClientProject().getName());
        return MessageDialog.openQuestion((Shell)shell, (String)REMOVE_TITLE, (String)message);
    }

    /*
     * Exception decompiling
     */
    private IProject getClientProject() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 80->83)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean checkBinaryProject(Shell shell) {
        if (JemProjectUtilities.isBinaryProject((IProject)this.getProject())) {
            MessageDialog.openError((Shell)shell, (String)REMOVE_ERROR_TITLE, (String)BINARY_EJB_PROJECT);
            return false;
        }
        if (JemProjectUtilities.isBinaryProject((IProject)this.getClientProject())) {
            MessageDialog.openError((Shell)shell, (String)REMOVE_ERROR_TITLE, (String)BINARY_CLIENT_PROJECT);
            return false;
        }
        return true;
    }
}

