/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.webservice;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.internal.webservice.WebServiceUIResourceHandler;
import org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef;
import org.eclipse.ui.IActionFilter;

public class WebServiceNavigatorGroupType
implements IActionFilter {
    public static final int SERVICES = 0;
    public static final int CLIENTS = 2;
    public static final int HANDLERS = 3;
    public static final String SERVICES_UI = WebServiceUIResourceHandler.WebServiceNavigatorGroupType_UI_0;
    public static final String CLIENTS_UI = WebServiceUIResourceHandler.WebServiceNavigatorGroupType_UI_1;
    public static final String HANDLERS_UI = WebServiceUIResourceHandler.WebServiceNavigatorGroupType_UI_2;
    private int TYPE;
    private EObject wsdlService = null;
    private ServiceRef serviceRef = null;

    public WebServiceNavigatorGroupType(int groupType) {
        this.TYPE = groupType;
    }

    public WebServiceNavigatorGroupType(int groupType, EObject wsdlService) {
        this.TYPE = groupType;
        this.wsdlService = wsdlService;
    }

    public WebServiceNavigatorGroupType(int groupType, ServiceRef serviceRef) {
        this.TYPE = groupType;
        this.serviceRef = serviceRef;
    }

    public int getGroupType() {
        return this.TYPE;
    }

    public boolean isServices() {
        return this.getGroupType() == 0;
    }

    public boolean isClients() {
        return this.getGroupType() == 2;
    }

    public boolean isHandlers() {
        return this.getGroupType() == 3;
    }

    public EObject getWsdlService() {
        return this.wsdlService;
    }

    public String toString() {
        if (this.isServices()) {
            return SERVICES_UI;
        }
        if (this.isClients()) {
            return CLIENTS_UI;
        }
        if (this.isHandlers()) {
            return HANDLERS_UI;
        }
        return super.toString();
    }

    public boolean testAttribute(Object target, String name, String value) {
        if (target != null && target instanceof WebServiceNavigatorGroupType && value != null) {
            WebServiceNavigatorGroupType group = (WebServiceNavigatorGroupType)target;
            if (group.isClients() && value.equals(CLIENTS_UI)) {
                return true;
            }
            if (group.isServices() && value.equals(SERVICES_UI)) {
                return true;
            }
            if (group.isHandlers() && value.equals(HANDLERS_UI)) {
                return true;
            }
        }
        return false;
    }

    public ServiceRef getServiceRef() {
        return this.serviceRef;
    }
}

