/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.deployables;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.internal.deployables.J2EEFlexProjDeployable;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.ModuleDelegate;
import org.eclipse.wst.server.core.util.ProjectModuleFactoryDelegate;

public class J2EEDeployableFactory
extends ProjectModuleFactoryDelegate {
    protected Map moduleDelegates = new HashMap(5);

    protected IModule createModule(IProject project) {
        try {
            ModuleCoreNature nature = (ModuleCoreNature)project.getNature("org.eclipse.wst.common.modulecore.ModuleCoreNature");
            if (nature != null) {
                return this.createModule(nature);
            }
        }
        catch (CoreException e) {
            Logger.getLogger().write((Throwable)e);
        }
        return null;
    }

    protected IModule createModule(ModuleCoreNature nature) {
        IProject project = nature.getProject();
        try {
            IVirtualComponent comp = ComponentCore.createComponent((IProject)project);
            return this.createModuleDelegates(comp);
        }
        catch (Exception e) {
            Logger.getLogger().write((Throwable)e);
            return null;
        }
    }

    public ModuleDelegate getModuleDelegate(IModule module) {
        return (ModuleDelegate)this.moduleDelegates.get(module);
    }

    protected IModule createModuleDelegates(IVirtualComponent component) {
        try {
            String type = J2EEProjectUtilities.getJ2EEProjectType(component.getProject());
            if (type != null && !type.equals("")) {
                String version = J2EEProjectUtilities.getJ2EEProjectVersion(component.getProject());
                IModule module = this.createModule(component.getDeployedName(), component.getDeployedName(), type, version, component.getProject());
                J2EEFlexProjDeployable moduleDelegate = new J2EEFlexProjDeployable(component.getProject(), component);
                this.moduleDelegates.put(module, moduleDelegate);
                return module;
            }
        }
        catch (Exception e) {
            Logger.getLogger().write((Throwable)e);
        }
        return null;
    }

    protected IPath[] getListenerPaths() {
        return new IPath[]{new Path(".project"), new Path(".settings/.component"), new Path(".settings/org.eclipse.wst.common.project.facet.core.xml")};
    }

    protected void clearCache() {
        this.moduleDelegates = new HashMap(5);
    }
}

