/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.validation;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.application.internal.impl.ApplicationImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.componentcore.util.EARArtifactEdit;
import org.eclipse.jst.j2ee.internal.validation.J2EEValidationHelper;
import org.eclipse.wst.common.componentcore.ArtifactEdit;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.validation.internal.operations.WorkbenchReporter;

public class EarHelper
extends J2EEValidationHelper {
    protected EARFile earFile;
    protected ArtifactEdit edit = null;

    public EarHelper() {
        this.registerModel("EAR_VALIDATION", "loadEarFile");
    }

    public String getApplicationXMLFile() {
        return "Application_ID";
    }

    public String getPortableName(IResource resource) {
        if (!(resource instanceof IFile)) {
            return null;
        }
        return "application.xml";
    }

    public String getTargetObjectName(Object obj) {
        super.getTargetObjectName(obj);
        if (obj != null && obj instanceof EARFile) {
            return this.getApplicationXMLFile();
        }
        if (obj != null && obj instanceof ApplicationImpl) {
            return "application.xml";
        }
        return null;
    }

    public EObject loadEarFile() {
        IVirtualComponent comp = ComponentCore.createComponent((IProject)this.getProject());
        this.edit = ComponentUtilities.getArtifactEditForRead((IVirtualComponent)comp);
        try {
            Archive archive = ((EARArtifactEdit)this.edit).asArchive(false);
            return archive;
        }
        catch (OpenFailureException e1) {
            Logger.getLogger().log((Throwable)e1);
            return null;
        }
    }

    public void closeEARFile() {
        if (this.earFile != null) {
            this.earFile.close();
            this.earFile = null;
        }
    }

    public void cleanup(WorkbenchReporter reporter) {
        if (this.edit != null) {
            this.edit.dispose();
        }
    }
}

