/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.contentassist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.ui.text.java.CompletionProposalCollector;
import org.eclipse.jdt.ui.text.java.CompletionProposalComparator;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslation;
import org.eclipse.jst.jsp.ui.internal.contentassist.AutoImportProposal;
import org.eclipse.jst.jsp.ui.internal.contentassist.JSPCompletionProposal;
import org.eclipse.swt.graphics.Image;

public class JSPProposalCollector
extends CompletionProposalCollector {
    private JSPTranslation fTranslation;
    private Comparator fComparator;

    public JSPProposalCollector(ICompilationUnit cu, JSPTranslation translation) {
        super(cu);
        if (translation == null) {
            throw new IllegalArgumentException("JSPTranslation cannot be null");
        }
        this.fTranslation = translation;
    }

    public JSPCompletionProposal[] getJSPCompletionProposals() {
        ArrayList<IJavaCompletionProposal> results = new ArrayList<IJavaCompletionProposal>();
        IJavaCompletionProposal[] javaProposals = this.getJavaCompletionProposals();
        int i = 0;
        while (i < javaProposals.length) {
            if (javaProposals[i] instanceof JSPCompletionProposal) {
                results.add(javaProposals[i]);
            }
            ++i;
        }
        Collections.sort(results, this.getComparator());
        return results.toArray(new JSPCompletionProposal[results.size()]);
    }

    private Comparator getComparator() {
        if (this.fComparator == null) {
            this.fComparator = new CompletionProposalComparator();
        }
        return this.fComparator;
    }

    protected IJavaCompletionProposal createJavaCompletionProposal(CompletionProposal proposal) {
        JSPCompletionProposal jspProposal = null;
        if (!proposal.isConstructor()) {
            if (proposal.getKind() == 9) {
                String signature = String.valueOf(proposal.getDeclarationSignature());
                String completion = String.valueOf(proposal.getCompletion());
                if (completion.indexOf(signature) != -1) {
                    jspProposal = this.createAutoImportProposal(proposal);
                }
            }
            if (jspProposal == null) {
                jspProposal = this.createJspProposal(proposal);
            }
        }
        return jspProposal;
    }

    private JSPCompletionProposal createAutoImportProposal(CompletionProposal proposal) {
        AutoImportProposal jspProposal = null;
        String signature = new String(proposal.getDeclarationSignature());
        String completion = new String(proposal.getCompletion());
        String newCompletion = completion.replaceAll(String.valueOf(signature) + ".", "");
        int offset = proposal.getReplaceStart();
        int length = proposal.getReplaceEnd() - offset;
        offset = this.fTranslation.getJspOffset(offset);
        int positionAfter = this.calculatePositionAfter(proposal, newCompletion, offset);
        IJavaCompletionProposal javaProposal = super.createJavaCompletionProposal(proposal);
        proposal.getDeclarationSignature();
        Image image = javaProposal.getImage();
        String displayString = javaProposal.getDisplayString();
        displayString = this.getTranslation().fixupMangledName(displayString);
        IContextInformation contextInformation = javaProposal.getContextInformation();
        String additionalInfo = javaProposal.getAdditionalProposalInfo();
        int relevance = javaProposal.getRelevance();
        boolean updateLengthOnValidate = true;
        jspProposal = new AutoImportProposal(completion, newCompletion, offset, length, positionAfter, image, displayString, contextInformation, additionalInfo, relevance, updateLengthOnValidate);
        return jspProposal;
    }

    private JSPCompletionProposal createJspProposal(CompletionProposal proposal) {
        String completion = String.valueOf(proposal.getCompletion());
        int offset = proposal.getReplaceStart();
        int length = proposal.getReplaceEnd() - offset;
        offset = this.fTranslation.getJspOffset(offset);
        int positionAfter = this.calculatePositionAfter(proposal, completion, offset);
        IJavaCompletionProposal javaProposal = super.createJavaCompletionProposal(proposal);
        proposal.getDeclarationSignature();
        Image image = javaProposal.getImage();
        String displayString = javaProposal.getDisplayString();
        displayString = this.getTranslation().fixupMangledName(displayString);
        IContextInformation contextInformation = javaProposal.getContextInformation();
        String additionalInfo = javaProposal.getAdditionalProposalInfo();
        int relevance = javaProposal.getRelevance();
        boolean updateLengthOnValidate = true;
        JSPCompletionProposal jspProposal = new JSPCompletionProposal(completion, offset, length, positionAfter, image, displayString, contextInformation, additionalInfo, relevance, updateLengthOnValidate);
        return jspProposal;
    }

    private int calculatePositionAfter(CompletionProposal proposal, String completion, int currentCursorOffset) {
        int positionAfter = completion.length();
        int kind = proposal.getKind();
        if (kind == 1 || kind == 7 || kind == 11 || kind == 6) {
            String[] params = Signature.getParameterTypes((String)String.valueOf(proposal.getSignature()));
            if (completion.length() > 0 && params.length > 0) {
                --positionAfter;
            }
        }
        return positionAfter;
    }

    static char[] getTypeTriggers() {
        return TYPE_TRIGGERS;
    }

    public JSPTranslation getTranslation() {
        return this.fTranslation;
    }
}

