/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.generic.core.internal;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.apache.tools.ant.taskdefs.Execute;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.RuntimeProcess;
import org.eclipse.jdt.internal.launching.JavaRemoteApplicationLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jst.server.generic.core.internal.CorePlugin;
import org.eclipse.jst.server.generic.core.internal.ExternalServerBehaviour;
import org.eclipse.jst.server.generic.core.internal.GenericServerCoreMessages;
import org.eclipse.jst.server.generic.core.internal.Trace;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;

public class ExternalLaunchConfigurationDelegate
extends AbstractJavaLaunchConfigurationDelegate {
    public static final String ID_EXTERNAL_LAUNCH_TYPE = "org.eclipse.jst.server.generic.core.ExternalLaunchConfigurationType";
    public static final String COMMANDLINE = "org.eclipse.jst.server.generic.core.COMMANDLINE";
    public static final String EXECUTABLE_NAME = "org.eclipse.jst.server.generic.core.EXECUTABLE_NAME";
    public static final String DEBUG_PORT = "org.eclipse.jst.server.generic.core.DEBUG_PORT";
    public static final String DEFAULT_EXECUTABLE_NAME = "External Generic Server";
    private static JavaRemoteApplicationLaunchConfigurationDelegate debuggingDelegate = new JavaRemoteApplicationLaunchConfigurationDelegate();
    static /* synthetic */ Class class$0;

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        Class<?> clazz;
        IServer server = ServerUtil.getServer((ILaunchConfiguration)configuration);
        if (server == null) {
            this.abort(GenericServerCoreMessages.missingServer, null, 150);
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.server.core.model.ServerBehaviourDelegate");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ExternalServerBehaviour serverBehavior = (ExternalServerBehaviour)((Object)server.loadAdapter((Class)clazz, null));
        serverBehavior.setupLaunch(launch, mode, monitor);
        String commandline = configuration.getAttribute(COMMANDLINE, null);
        if (commandline == null || commandline.length() == 0) {
            this.abort(GenericServerCoreMessages.commandlineUnspecified, null, 150);
        }
        String[] cmdArgs = DebugPlugin.parseArguments((String)commandline);
        String[] pgmArgs = DebugPlugin.parseArguments((String)this.getProgramArguments(configuration));
        String[] cmds = new String[cmdArgs.length + pgmArgs.length];
        System.arraycopy(cmdArgs, 0, cmds, 0, cmdArgs.length);
        System.arraycopy(pgmArgs, 0, cmds, cmdArgs.length, pgmArgs.length);
        String executableName = configuration.getAttribute(EXECUTABLE_NAME, DEFAULT_EXECUTABLE_NAME);
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        String[] env = manager.getEnvironment(configuration);
        File workingDir = this.verifyWorkingDirectory(configuration);
        if (workingDir == null) {
            this.abort(GenericServerCoreMessages.workingdirUnspecified, null, 150);
        }
        try {
            Process process = Execute.launch(null, (String[])cmds, (String[])env, (File)workingDir, (boolean)true);
            RuntimeProcess runtimeProcess = new RuntimeProcess(launch, process, executableName, null);
            launch.addProcess((IProcess)runtimeProcess);
            serverBehavior.setProcess((IProcess)runtimeProcess);
        }
        catch (IOException ioe) {
            this.abort(GenericServerCoreMessages.errorLaunchingExecutable, ioe, 150);
        }
        if (mode.equals("debug")) {
            ILaunchConfigurationWorkingCopy wc = this.createDebuggingConfig(configuration);
            serverBehavior.setDebuggingConfig(wc, mode, launch, monitor);
        }
    }

    private ILaunchConfigurationWorkingCopy createDebuggingConfig(ILaunchConfiguration configuration) throws CoreException {
        ILaunchConfigurationWorkingCopy wc = configuration.getWorkingCopy();
        this.setDebugArgument(wc, IJavaLaunchConfigurationConstants.ATTR_CONNECT_MAP, "hostname", "localhost");
        String port = configuration.getAttribute(DEBUG_PORT, null);
        if (port == null || port.length() == 0) {
            this.abort(GenericServerCoreMessages.debugPortUnspecified, null, 150);
        }
        this.setDebugArgument(wc, IJavaLaunchConfigurationConstants.ATTR_CONNECT_MAP, "port", port);
        return wc;
    }

    protected static void startDebugging(ILaunchConfigurationWorkingCopy wc, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        Trace.trace(Trace.FINEST, "Starting debugging");
        debuggingDelegate.launch((ILaunchConfiguration)wc, mode, launch, monitor);
    }

    private void setDebugArgument(ILaunchConfigurationWorkingCopy config, String attribKey, String key, String arg) {
        try {
            HashMap<String, String> args = config.getAttribute(attribKey, null);
            args = args != null ? new HashMap(args) : new HashMap<String, String>();
            args.put(key, String.valueOf(arg));
            config.setAttribute(attribKey, args);
        }
        catch (CoreException coreException) {}
    }

    protected void abort(String message, Throwable exception, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(4, CorePlugin.getDefault().getBundle().getSymbolicName(), code, message, exception));
    }
}

