/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.core.internal;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.server.tomcat.core.internal.IMimeMapping;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatWebModule;
import org.eclipse.jst.server.tomcat.core.internal.Messages;
import org.eclipse.jst.server.tomcat.core.internal.ProgressUtil;
import org.eclipse.jst.server.tomcat.core.internal.TomcatConfiguration;
import org.eclipse.jst.server.tomcat.core.internal.TomcatServer;
import org.eclipse.jst.server.tomcat.core.internal.Trace;
import org.eclipse.jst.server.tomcat.core.internal.WebAppDocument;
import org.eclipse.jst.server.tomcat.core.internal.WebModule;
import org.eclipse.jst.server.tomcat.core.internal.xml.Factory;
import org.eclipse.jst.server.tomcat.core.internal.xml.XMLUtil;
import org.eclipse.jst.server.tomcat.core.internal.xml.server32.Connector;
import org.eclipse.jst.server.tomcat.core.internal.xml.server32.Context;
import org.eclipse.jst.server.tomcat.core.internal.xml.server32.ContextManager;
import org.eclipse.jst.server.tomcat.core.internal.xml.server32.Parameter;
import org.eclipse.jst.server.tomcat.core.internal.xml.server32.Server;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.ServerPort;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class Tomcat32Configuration
extends TomcatConfiguration {
    public static final String ID = "org.eclipse.tomcat.configuration.32";
    protected static final String HTTP_HANDLER = "org.apache.tomcat.service.http.HttpConnectionHandler";
    protected static final String APACHE_HANDLER = "org.apache.tomcat.service.connector.Ajp12ConnectionHandler";
    protected static final String SSL_SOCKET_FACTORY = "org.apache.tomcat.net.SSLSocketFactory";
    protected Server server;
    protected Factory serverFactory;
    protected boolean isServerDirty;
    protected WebAppDocument webAppDocument;
    protected Document tomcatUsersDocument;
    protected String policyFile;

    public Tomcat32Configuration(IFolder path) {
        super(path);
    }

    public ServerPort getMainPort() {
        Iterator iterator = this.getServerPorts().iterator();
        while (iterator.hasNext()) {
            ServerPort port = (ServerPort)iterator.next();
            if (!port.getName().equals("HTTP Connector")) continue;
            return port;
        }
        return null;
    }

    public String getDocBasePrefix() {
        return "webapps/";
    }

    public List getMimeMappings() {
        if (this.webAppDocument == null) {
            return new ArrayList(0);
        }
        return this.webAppDocument.getMimeMappings();
    }

    public Server getServer() {
        return this.server;
    }

    public List getServerPorts() {
        ArrayList<ServerPort> ports = new ArrayList<ServerPort>();
        try {
            int count = this.server.getContextManager().getConnectorCount();
            int i = 0;
            while (i < count) {
                Connector connector = this.server.getContextManager().getConnector(i);
                int paramCount = connector.getParameterCount();
                String handler = null;
                String name = Messages.portUnknown;
                String socketFactory = null;
                String protocol = "TCPIP";
                boolean advanced = true;
                String[] contentTypes = null;
                int port = -1;
                int j = 0;
                while (j < paramCount) {
                    Parameter p = connector.getParameter(j);
                    if ("port".equals(p.getName())) {
                        try {
                            port = Integer.parseInt(p.getValue());
                        }
                        catch (Exception exception) {}
                    } else if ("handler".equals(p.getName())) {
                        handler = p.getValue();
                    } else if ("socketFactory".equals(p.getName())) {
                        socketFactory = p.getValue();
                    }
                    ++j;
                }
                if (HTTP_HANDLER.equals(handler)) {
                    protocol = "HTTP";
                    contentTypes = new String[]{"web", "webservices"};
                    if (SSL_SOCKET_FACTORY.equals(socketFactory)) {
                        protocol = "SSL";
                        name = "SSL Connector";
                    } else {
                        name = "HTTP Connector";
                        advanced = false;
                    }
                } else if (APACHE_HANDLER.equals(handler)) {
                    name = "Apache Connector";
                }
                if (handler != null) {
                    ports.add(new ServerPort(String.valueOf(i), name, port, protocol, contentTypes, advanced));
                }
                ++i;
            }
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error getting server ports", e);
        }
        return ports;
    }

    public Document getTomcatUsersDocument() {
        return this.tomcatUsersDocument;
    }

    public List getWebModules() {
        ArrayList<WebModule> list = new ArrayList<WebModule>();
        try {
            ContextManager contextManager = this.server.getContextManager();
            int size = contextManager.getContextCount();
            int i = 0;
            while (i < size) {
                Context context = contextManager.getContext(i);
                String reload = context.getReloadable();
                if (reload == null) {
                    reload = "false";
                }
                WebModule module = new WebModule(context.getPath(), context.getDocBase(), context.getSource(), reload.equalsIgnoreCase("true"));
                list.add(module);
                ++i;
            }
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error getting project refs", e);
        }
        return list;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load(IPath path, IProgressMonitor monitor) throws CoreException {
        try {
            block10: {
                monitor = ProgressUtil.getMonitorFor(monitor);
                monitor.beginTask(Messages.loadingTask, 5);
                FileInputStream in = new FileInputStream(path.append("tomcat.policy").toFile());
                ((InputStream)in).read();
                ((InputStream)in).close();
                monitor.worked(1);
                this.serverFactory = new Factory();
                this.serverFactory.setPackageName("org.eclipse.jst.server.tomcat.core.internal.xml.server32");
                this.server = (Server)this.serverFactory.loadDocument(new FileInputStream(path.append("server.xml").toFile()));
                monitor.worked(1);
                this.webAppDocument = new WebAppDocument(path.append("web.xml"));
                monitor.worked(1);
                this.tomcatUsersDocument = XMLUtil.getDocumentBuilder().parse(new InputSource(new FileInputStream(path.append("tomcat-users.xml").toFile())));
                monitor.worked(1);
                BufferedReader br = null;
                try {
                    try {
                        br = new BufferedReader(new InputStreamReader(new FileInputStream(path.append("tomcat.policy").toFile())));
                        String temp = br.readLine();
                        this.policyFile = "";
                        while (true) {
                            if (temp == null) {
                                br.close();
                            }
                            this.policyFile = String.valueOf(this.policyFile) + temp + "\n";
                            temp = br.readLine();
                        }
                    }
                    catch (Exception e) {
                        Trace.trace(Trace.SEVERE, "Could not load policy file", e);
                    }
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    if (br == null) throw throwable;
                    br.close();
                    throw throwable;
                }
                {
                    Object var6_10 = null;
                    if (br == null) break block10;
                }
                br.close();
            }
            monitor.worked(1);
            if (monitor.isCanceled()) {
                return;
            }
            monitor.done();
            return;
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Could not load Tomcat v3.2 configuration from " + path.toOSString() + ": " + e.getMessage());
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorCouldNotLoadConfiguration, (Object)path.toOSString()), (Throwable)e));
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load(IFolder folder, IProgressMonitor monitor) throws CoreException {
        try {
            block11: {
                monitor = ProgressUtil.getMonitorFor(monitor);
                monitor.beginTask(Messages.loadingTask, 800);
                IFile file = folder.getFile("tomcat.policy");
                if (!file.exists()) {
                    throw new CoreException((IStatus)new Status(2, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorCouldNotLoadConfiguration, (Object)folder.getFullPath().toOSString()), null));
                }
                file = folder.getFile("server.xml");
                InputStream in = file.getContents();
                this.serverFactory = new Factory();
                this.serverFactory.setPackageName("org.eclipse.jst.server.tomcat.core.internal.xml.server32");
                this.server = (Server)this.serverFactory.loadDocument(in);
                monitor.worked(200);
                file = folder.getFile("web.xml");
                this.webAppDocument = new WebAppDocument(file);
                monitor.worked(200);
                file = folder.getFile("tomcat-users.xml");
                in = file.getContents();
                this.tomcatUsersDocument = XMLUtil.getDocumentBuilder().parse(new InputSource(in));
                monitor.worked(200);
                file = folder.getFile("tomcat.policy");
                in = file.getContents();
                BufferedReader br = null;
                try {
                    try {
                        br = new BufferedReader(new InputStreamReader(in));
                        String temp = br.readLine();
                        this.policyFile = "";
                        while (true) {
                            if (temp == null) {
                                br.close();
                            }
                            this.policyFile = String.valueOf(this.policyFile) + temp + "\n";
                            temp = br.readLine();
                        }
                    }
                    catch (Exception e) {
                        Trace.trace(Trace.SEVERE, "Could not load policy file", e);
                    }
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    if (br == null) throw throwable;
                    br.close();
                    throw throwable;
                }
                {
                    Object var7_11 = null;
                    if (br == null) break block11;
                }
                br.close();
            }
            monitor.worked(200);
            if (monitor.isCanceled()) {
                throw new Exception("Cancelled");
            }
            monitor.done();
            return;
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Could not load Tomcat v3.2 configuration from: " + folder.getFullPath() + ": " + e.getMessage());
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorCouldNotLoadConfiguration, (Object)folder.getFullPath().toOSString()), (Throwable)e));
        }
    }

    protected void save(IPath path, boolean forceDirty, IProgressMonitor monitor) throws CoreException {
        try {
            monitor = ProgressUtil.getMonitorFor(monitor);
            monitor.beginTask(Messages.savingTask, 5);
            if (!path.toFile().exists()) {
                forceDirty = true;
                path.toFile().mkdir();
            }
            monitor.worked(1);
            if (forceDirty || this.isServerDirty) {
                this.serverFactory.save(path.append("server.xml").toOSString());
            }
            monitor.worked(1);
            this.webAppDocument.save(path.append("web.xml").toOSString(), forceDirty);
            monitor.worked(1);
            if (forceDirty) {
                XMLUtil.save(path.append("tomcat-users.xml").toOSString(), this.tomcatUsersDocument);
            }
            monitor.worked(1);
            if (forceDirty) {
                BufferedWriter bw = new BufferedWriter(new FileWriter(path.append("tomcat.policy").toFile()));
                bw.write(this.policyFile);
                bw.close();
            }
            monitor.worked(1);
            this.isServerDirty = false;
            if (monitor.isCanceled()) {
                return;
            }
            monitor.done();
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Could not save Tomcat v3.2 configuration to " + path, e);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorCouldNotSaveConfiguration, (Object[])new String[]{e.getLocalizedMessage()}), (Throwable)e));
        }
    }

    public void save(IPath path, IProgressMonitor monitor) throws CoreException {
        this.save(path, true, monitor);
    }

    public void save(IFolder folder, IProgressMonitor monitor) throws CoreException {
        try {
            monitor = ProgressUtil.getMonitorFor(monitor);
            monitor.beginTask(Messages.savingTask, 900);
            if (!folder.exists()) {
                folder.create(true, true, ProgressUtil.getSubMonitorFor(monitor, 100));
            } else {
                monitor.worked(100);
            }
            byte[] data = this.serverFactory.getContents();
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            IFile file = folder.getFile("server.xml");
            if (file.exists()) {
                if (this.isServerDirty) {
                    file.setContents((InputStream)in, true, true, ProgressUtil.getSubMonitorFor(monitor, 200));
                } else {
                    monitor.worked(200);
                }
            } else {
                file.create((InputStream)in, true, ProgressUtil.getSubMonitorFor(monitor, 200));
            }
            file = folder.getFile("web.xml");
            this.webAppDocument.save(file, ProgressUtil.getSubMonitorFor(monitor, 200));
            data = XMLUtil.getContents(this.tomcatUsersDocument);
            in = new ByteArrayInputStream(data);
            file = folder.getFile("tomcat-users.xml");
            if (file.exists()) {
                monitor.worked(200);
            } else {
                file.create((InputStream)in, true, ProgressUtil.getSubMonitorFor(monitor, 200));
            }
            in = new ByteArrayInputStream(this.policyFile.getBytes());
            file = folder.getFile("tomcat.policy");
            if (file.exists()) {
                monitor.worked(200);
            } else {
                file.create((InputStream)in, true, ProgressUtil.getSubMonitorFor(monitor, 200));
            }
            if (monitor.isCanceled()) {
                return;
            }
            monitor.done();
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Could not save Tomcat v3.2 configuration to " + folder.getFullPath(), e);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorCouldNotSaveConfiguration, (Object[])new String[]{e.getLocalizedMessage()}), (Throwable)e));
        }
    }

    public void addMimeMapping(int index, IMimeMapping map) {
        this.webAppDocument.addMimeMapping(index, map);
        this.firePropertyChangeEvent("addMapping", new Integer(index), map);
    }

    public void addWebModule(int index, ITomcatWebModule module) {
        try {
            ContextManager contextManager = this.server.getContextManager();
            Context context = (Context)contextManager.createElement(index, "Context");
            context.setPath(module.getPath());
            context.setDocBase(module.getDocumentBase());
            context.setReloadable(module.isReloadable() ? "true" : "false");
            if (module.getMemento() != null && module.getMemento().length() > 0) {
                context.setSource(module.getMemento());
            }
            this.isServerDirty = true;
            this.firePropertyChangeEvent("addWebModule", null, module);
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error adding web module", e);
        }
    }

    public void localizeConfiguration(IPath path, TomcatServer server2, IProgressMonitor monitor) {
        try {
            monitor = ProgressUtil.getMonitorFor(monitor);
            monitor.beginTask(Messages.updatingConfigurationTask, 100);
            Tomcat32Configuration config = new Tomcat32Configuration(null);
            config.load(path, ProgressUtil.getSubMonitorFor(monitor, 30));
            if (monitor.isCanceled()) {
                return;
            }
            if (server2.isTestEnvironment()) {
                IPath tomcatPath = path.removeLastSegments(1);
                config.server.getContextManager().setHome(tomcatPath.toOSString());
                config.isServerDirty = true;
            }
            monitor.worked(40);
            if (monitor.isCanceled()) {
                return;
            }
            config.save(path, false, ProgressUtil.getSubMonitorFor(monitor, 30));
            if (!monitor.isCanceled()) {
                monitor.done();
            }
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error localizing configuration", e);
        }
    }

    public void modifyMimeMapping(int index, IMimeMapping map) {
        this.webAppDocument.modifyMimeMapping(index, map);
        this.firePropertyChangeEvent("modifyMapping", new Integer(index), map);
    }

    public void modifyServerPort(String id, int port) {
        try {
            int con = Integer.parseInt(id);
            Connector connector = this.server.getContextManager().getConnector(con);
            int size = connector.getParameterCount();
            int i = 0;
            while (i < size) {
                Parameter p = connector.getParameter(i);
                if ("port".equals(p.getName())) {
                    p.setValue(String.valueOf(port));
                    this.isServerDirty = true;
                    this.firePropertyChangeEvent("modifyPort", id, new Integer(port));
                    return;
                }
                ++i;
            }
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error modifying server port " + id, e);
        }
    }

    public void modifyWebModule(int index, String docBase, String path, boolean reloadable) {
        try {
            ContextManager contextManager = this.server.getContextManager();
            Context context = contextManager.getContext(index);
            context.setPath(path);
            context.setDocBase(docBase);
            context.setReloadable(reloadable ? "true" : "false");
            this.isServerDirty = true;
            WebModule module = new WebModule(path, docBase, null, reloadable);
            this.firePropertyChangeEvent("modifyWebModule", new Integer(index), module);
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error modifying web module " + index, e);
        }
    }

    public void removeMimeMapping(int index) {
        this.webAppDocument.removeMimeMapping(index);
        this.firePropertyChangeEvent("removeMapping", null, new Integer(index));
    }

    public void removeWebModule(int index) {
        try {
            ContextManager contextManager = this.server.getContextManager();
            contextManager.removeElement("Context", index);
            this.isServerDirty = true;
            this.firePropertyChangeEvent("removeWebModule", null, new Integer(index));
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error removing web module " + index, e);
        }
    }
}

