/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.core.internal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatVersionHandler;
import org.eclipse.jst.server.tomcat.core.internal.Tomcat32Handler;
import org.eclipse.jst.server.tomcat.core.internal.Tomcat40Handler;
import org.eclipse.jst.server.tomcat.core.internal.Tomcat41Handler;
import org.eclipse.jst.server.tomcat.core.internal.Tomcat50Handler;
import org.eclipse.jst.server.tomcat.core.internal.Tomcat55Handler;
import org.eclipse.jst.server.tomcat.core.internal.Trace;

public class TomcatPlugin
extends Plugin {
    protected static TomcatPlugin singleton;
    public static final String PLUGIN_ID = "org.eclipse.jst.server.tomcat.core";
    public static final String TOMCAT_32 = "org.eclipse.jst.server.tomcat.32";
    public static final String TOMCAT_40 = "org.eclipse.jst.server.tomcat.40";
    public static final String TOMCAT_41 = "org.eclipse.jst.server.tomcat.41";
    public static final String TOMCAT_50 = "org.eclipse.jst.server.tomcat.50";
    public static final String TOMCAT_55 = "org.eclipse.jst.server.tomcat.55";
    protected static final String VERIFY_INSTALL_FILE = "verifyInstall.properties";
    protected static String[] verify32;
    protected static String[] verify40;
    protected static String[] verify41;
    protected static String[] verify50;
    protected static String[] verify55;

    public TomcatPlugin() {
        singleton = this;
    }

    public static TomcatPlugin getInstance() {
        return singleton;
    }

    public static String getPreference(String id) {
        return TomcatPlugin.getInstance().getPluginPreferences().getString(id);
    }

    public static void setPreference(String id, String value) {
        TomcatPlugin.getInstance().getPluginPreferences().setValue(id, value);
        TomcatPlugin.getInstance().savePluginPreferences();
    }

    public static void log(IStatus status) {
        TomcatPlugin.getInstance().getLog().log(status);
    }

    protected static String getTomcatStateLocation() {
        try {
            return TomcatPlugin.getInstance().getStateLocation().toOSString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static ITomcatVersionHandler getTomcatVersionHandler(String id) {
        if (id.indexOf("runtime") > 0) {
            id = String.valueOf(id.substring(0, 30)) + id.substring(38);
        }
        if (TOMCAT_32.equals(id)) {
            return new Tomcat32Handler();
        }
        if (TOMCAT_40.equals(id)) {
            return new Tomcat40Handler();
        }
        if (TOMCAT_41.equals(id)) {
            return new Tomcat41Handler();
        }
        if (TOMCAT_50.equals(id)) {
            return new Tomcat50Handler();
        }
        if (TOMCAT_55.equals(id)) {
            return new Tomcat55Handler();
        }
        return null;
    }

    public static void loadVerifyFiles() {
        if (verify32 != null) {
            return;
        }
        verify32 = new String[0];
        verify40 = new String[0];
        verify41 = new String[0];
        verify50 = new String[0];
        verify55 = new String[0];
        try {
            URL url = TomcatPlugin.getInstance().getBundle().getEntry(VERIFY_INSTALL_FILE);
            url = Platform.resolve((URL)url);
            Properties p = new Properties();
            p.load(url.openStream());
            String verify = p.getProperty("verify32install");
            verify.replace('/', File.separatorChar);
            StringTokenizer st = new StringTokenizer(verify, ",");
            ArrayList<String> list = new ArrayList<String>();
            while (st.hasMoreTokens()) {
                list.add(st.nextToken());
            }
            Trace.trace(Trace.FINEST, "Verify32: " + ((Object)list).toString());
            verify32 = new String[list.size()];
            list.toArray(verify32);
            verify = p.getProperty("verify40install");
            verify.replace('/', File.separatorChar);
            st = new StringTokenizer(verify, ",");
            list = new ArrayList();
            while (st.hasMoreTokens()) {
                list.add(st.nextToken());
            }
            Trace.trace(Trace.FINEST, "Verify40: " + ((Object)list).toString());
            verify40 = new String[list.size()];
            list.toArray(verify40);
            verify = p.getProperty("verify41install");
            verify.replace('/', File.separatorChar);
            st = new StringTokenizer(verify, ",");
            list = new ArrayList();
            while (st.hasMoreTokens()) {
                list.add(st.nextToken());
            }
            Trace.trace(Trace.FINEST, "Verify41: " + ((Object)list).toString());
            verify41 = new String[list.size()];
            list.toArray(verify41);
            verify = p.getProperty("verify50install");
            verify.replace('/', File.separatorChar);
            st = new StringTokenizer(verify, ",");
            list = new ArrayList();
            while (st.hasMoreTokens()) {
                list.add(st.nextToken());
            }
            Trace.trace(Trace.FINEST, "Verify50: " + ((Object)list).toString());
            verify50 = new String[list.size()];
            list.toArray(verify50);
            verify = p.getProperty("verify55install");
            verify.replace('/', File.separatorChar);
            st = new StringTokenizer(verify, ",");
            list = new ArrayList();
            while (st.hasMoreTokens()) {
                list.add(st.nextToken());
            }
            Trace.trace(Trace.FINEST, "Verify55: " + ((Object)list).toString());
            verify55 = new String[list.size()];
            list.toArray(verify55);
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Could not load installation verification properties", e);
        }
    }

    public static boolean verifyInstallPath(IPath installPath, String id) {
        if (installPath == null) {
            return false;
        }
        String dir = installPath.toOSString();
        if (!dir.endsWith(File.separator)) {
            dir = String.valueOf(dir) + File.separator;
        }
        TomcatPlugin.loadVerifyFiles();
        String[] paths = null;
        if (TOMCAT_32.equals(id)) {
            paths = verify32;
        } else if (TOMCAT_40.equals(id)) {
            paths = verify40;
        } else if (TOMCAT_41.equals(id)) {
            paths = verify41;
        } else if (TOMCAT_50.equals(id)) {
            paths = verify50;
        } else if (TOMCAT_55.equals(id)) {
            paths = verify55;
        } else {
            return false;
        }
        int i = 0;
        while (i < paths.length) {
            File temp = new File(String.valueOf(dir) + paths[i]);
            if (!temp.exists()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean verifyTomcatVersionFromPath(IPath installPath, String version) {
        if (installPath == null || version == null) {
            return false;
        }
        String s = installPath.lastSegment();
        if (s == null) {
            return false;
        }
        if (s.indexOf("-3.2") > 0 || s.indexOf(" 3.2") > 0) {
            return TOMCAT_32.equals(version);
        }
        if (s.indexOf("-4.0") > 0 || s.indexOf(" 4.0") > 0) {
            return TOMCAT_40.equals(version);
        }
        if (s.indexOf("-4.1") > 0 || s.indexOf(" 4.1") > 0) {
            return TOMCAT_41.equals(version);
        }
        if (s.indexOf("-5.0") > 0 || s.indexOf(" 5.0") > 0) {
            return TOMCAT_50.equals(version);
        }
        if (s.indexOf("-5.5") > 0 || s.indexOf(" 5.5") > 0) {
            return TOMCAT_55.equals(version);
        }
        return true;
    }

    protected static File getPlugin() {
        try {
            URL installURL = TomcatPlugin.getInstance().getBundle().getEntry("/");
            URL localURL = Platform.asLocalURL((URL)installURL);
            return new File(localURL.getFile());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static void log(String message) {
        TomcatPlugin.log((IStatus)new Status(4, PLUGIN_ID, 4, message, null));
    }

    public static void log(Throwable e) {
        TomcatPlugin.log((IStatus)new Status(4, PLUGIN_ID, 4, e.getMessage(), e));
    }
}

