/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.ui.internal.cactus;

import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.junit.wizards.NewTestCaseWizardPageOne;
import org.eclipse.jdt.junit.wizards.NewTestCaseWizardPageTwo;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jst.server.ui.internal.ImageResource;
import org.eclipse.jst.server.ui.internal.JavaServerUIPlugin;
import org.eclipse.jst.server.ui.internal.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class NewServletTestCaseWizard
extends Wizard
implements INewWizard {
    private static final String SUPERCLASS_NAME = "org.apache.cactus.ServletTestCase";
    protected static final String[] CLASSES_TO_CHECK = new String[]{"org.apache.cactus.ServletTestCase", "junit.framework.TestCase", "org.apache.commons.logging.Log", "org.aspectj.lang.JoinPoint", "org.apache.commons.httpclient.HttpClient"};
    protected static final String[] REQUIRED_LIBRARIES = new String[]{"cactus-1.7.jar", "junit-3.8.1.jar", "aspectjrt-1.2.1.jar", "commons-logging-1.0.4.jar", "commons-httpclient-2.0.2.jar"};
    private IWorkbench fWorkbench;
    private IStructuredSelection fSelection;
    private NewTestCaseWizardPageTwo fPage2;
    private NewTestCaseWizardPageOne fPage1;

    public NewServletTestCaseWizard() {
        this.setWindowTitle(Messages.NewServletTestCaseWizard_WindowTitle);
        this.setDefaultPageImageDescriptor(ImageResource.getImageDescriptor("wiz_cactus_test"));
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.fWorkbench = workbench;
        this.fSelection = selection;
    }

    public void addPages() {
        super.addPages();
        this.fPage2 = new NewTestCaseWizardPageTwo();
        this.fPage1 = new NewTestCaseWizardPageOne(this.fPage2){

            public void createControl(Composite parent) {
                super.createControl(parent);
                this.setSuperClass(NewServletTestCaseWizard.SUPERCLASS_NAME, true);
            }

            protected IStatus validateIfJUnitProject() {
                IPackageFragmentRoot root = this.getPackageFragmentRoot();
                if (root == null) {
                    return Status.OK_STATUS;
                }
                IJavaProject project = root.getJavaProject();
                try {
                    int i = 0;
                    while (i < CLASSES_TO_CHECK.length) {
                        IType type = project.findType(CLASSES_TO_CHECK[i]);
                        if (type == null) {
                            MessageDialog.openError((Shell)this.getShell(), (String)Messages.NewServletTestCaseWizard_ErrorMessageTitleMissingLibrary, (String)NLS.bind((String)Messages.NewServletTestCaseWizard_ErrorMessageMissingLibrary, (Object[])REQUIRED_LIBRARIES));
                            return Status.OK_STATUS;
                        }
                        ++i;
                    }
                }
                catch (JavaModelException e) {
                    JavaServerUIPlugin.log(e);
                }
                return Status.OK_STATUS;
            }
        };
        this.addPage((IWizardPage)this.fPage1);
        this.fPage1.init(this.getSelection());
        this.addPage((IWizardPage)this.fPage2);
    }

    private IStructuredSelection getSelection() {
        return this.fSelection;
    }

    public boolean performFinish() {
        if (this.finishPage(this.fPage1.getRunnable())) {
            IType newClass = this.fPage1.getCreatedType();
            IResource resource = newClass.getCompilationUnit().getResource();
            if (resource != null) {
                BasicNewResourceWizard.selectAndReveal((IResource)resource, (IWorkbenchWindow)this.fWorkbench.getActiveWorkbenchWindow());
                this.openResource(resource);
            }
            return true;
        }
        return false;
    }

    protected boolean finishPage(IRunnableWithProgress runnable) {
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(runnable);
        try {
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)this.getContainer(), (IRunnableWithProgress)op, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        }
        catch (InvocationTargetException e) {
            String title = Messages.NewServletTestCaseWizard_ErrorTitleNew;
            String message = Messages.NewServletTestCaseWizard_ErrorTitleCreateOfElementFailed;
            NewServletTestCaseWizard.displayMessageDialog(e, e.getMessage(), this.getShell(), title, message);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    public static void displayMessageDialog(Throwable t, String exceptionMessage, Shell shell, String title, String message) {
        StringWriter msg = new StringWriter();
        if (message != null) {
            msg.write(message);
            msg.write("\n\n");
        }
        if (exceptionMessage == null || exceptionMessage.length() == 0) {
            msg.write(Messages.NewServletTestCaseWizard_ErrorMessageSeeErrorLog);
        } else {
            msg.write(exceptionMessage);
        }
        MessageDialog.openError((Shell)shell, (String)title, (String)msg.toString());
    }

    protected void openResource(final IResource resource) {
        Display display;
        IWorkbenchPage activePage;
        if (resource.getType() == 1 && (activePage = NewServletTestCaseWizard.getActivePage()) != null && (display = Display.getDefault()) != null) {
            display.asyncExec(new Runnable(){

                public void run() {
                    try {
                        IDE.openEditor((IWorkbenchPage)activePage, (IFile)((IFile)resource), (boolean)true);
                    }
                    catch (PartInitException e) {
                        JavaServerUIPlugin.log(e);
                    }
                }
            });
        }
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow activeWorkbenchWindow = NewServletTestCaseWizard.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return null;
        }
        return activeWorkbenchWindow.getActivePage();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        IWorkbench workbench = JavaServerUIPlugin.getInstance().getWorkbench();
        if (workbench != null) {
            return workbench.getActiveWorkbenchWindow();
        }
        return null;
    }
}

