/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis.consumption.ui.command;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.ws.internal.axis.consumption.core.AxisConsumptionCoreMessages;
import org.eclipse.jst.ws.internal.axis.consumption.core.common.JavaWSDLParameter;
import org.eclipse.jst.ws.internal.axis.consumption.ui.AxisConsumptionUIMessages;
import org.eclipse.jst.ws.internal.axis.consumption.ui.util.PlatformUtils;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class DefaultsForClientJavaWSDLCommand
extends AbstractDataModelOperation {
    private JavaWSDLParameter javaWSDLParam_;
    private IProject proxyProject_;
    private String WSDLServiceURL_;
    private String WSDLServicePathname_;
    private String outputFolder_;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment environment = this.getEnvironment();
        if (this.outputFolder_ == null) {
            IPath[] paths = ResourceUtils.getAllJavaSourceLocations((IProject)this.proxyProject_);
            this.outputFolder_ = paths[0].toString();
        }
        if (this.javaWSDLParam_ == null) {
            IStatus status = StatusUtils.errorStatus((String)AxisConsumptionCoreMessages.MSG_ERROR_JAVA_WSDL_PARAM_NOT_SET);
            environment.getStatusHandler().reportError(status);
            return status;
        }
        this.javaWSDLParam_.setMetaInfOnly(false);
        this.javaWSDLParam_.setServerSide((byte)0);
        ModuleCoreNature mn = ModuleCoreNature.getModuleCoreNature((IProject)this.proxyProject_);
        if (mn != null) {
            IPath webModuleServerRoot = ResourceUtils.getJavaSourceLocation((IProject)this.proxyProject_);
            String output = ResourceUtils.findResource((IPath)webModuleServerRoot).getLocation().toString();
            IPath javaOutput = ResourceUtils.findResource((IPath)new Path(this.outputFolder_)).getLocation();
            this.javaWSDLParam_.setJavaOutput(javaOutput.toString());
            IFolder webModuleContainer = ResourceUtils.getWebComponentServerRoot((IProject)this.proxyProject_);
            if (webModuleContainer != null) {
                IPath webModulePath = webModuleContainer.getFullPath();
                IResource res = ResourceUtils.findResource((IPath)webModulePath);
                if (res != null) {
                    output = res.getLocation().toString();
                }
                this.javaWSDLParam_.setOutput(output);
            }
        } else {
            IJavaProject javaProject = null;
            javaProject = JavaCore.create((IProject)this.proxyProject_);
            if (javaProject != null) {
                IPath output = ResourceUtils.findResource((IPath)new Path(this.outputFolder_)).getLocation();
                this.javaWSDLParam_.setJavaOutput(output.toString());
                this.javaWSDLParam_.setOutput(output.toString());
            } else {
                IStatus status = StatusUtils.errorStatus((String)AxisConsumptionUIMessages.MSG_WARN_NO_JAVA_NATURE);
                environment.getStatusHandler().reportError(status);
                return status;
            }
        }
        if (this.WSDLServicePathname_ == null) {
            if (this.WSDLServiceURL_ == null) {
                IStatus status = StatusUtils.errorStatus((String)AxisConsumptionUIMessages.MSG_ERROR_WSDL_LOCATION_NOT_SET);
                environment.getStatusHandler().reportError(status);
                return status;
            }
        } else {
            this.WSDLServiceURL_ = PlatformUtils.getFileFromPlatform(this.WSDLServicePathname_);
        }
        this.javaWSDLParam_.setInputWsdlLocation(this.WSDLServiceURL_);
        return Status.OK_STATUS;
    }

    public JavaWSDLParameter getJavaWSDLParam() {
        return this.javaWSDLParam_;
    }

    public void setJavaWSDLParam(JavaWSDLParameter javaWSDLParam) {
        this.javaWSDLParam_ = javaWSDLParam;
    }

    public void setProxyProject(IProject proxyProject) {
        this.proxyProject_ = proxyProject;
    }

    public void setWSDLServiceURL(String serviceURL) {
        this.WSDLServiceURL_ = serviceURL;
    }

    public void setWSDLServicePathname(String servicePathname) {
        this.WSDLServicePathname_ = servicePathname;
    }

    public String getOutputFolder() {
        return this.outputFolder_;
    }

    public void setOutputFolder(String outputFolder) {
        this.outputFolder_ = outputFolder;
    }
}

