/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis.creation.ui.task;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.soap.SOAPAddress;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.axis.consumption.core.AxisConsumptionCoreMessages;
import org.eclipse.jst.ws.internal.axis.consumption.core.common.JavaWSDLParameter;
import org.eclipse.jst.ws.internal.axis.consumption.ui.AxisConsumptionUIMessages;
import org.eclipse.jst.ws.internal.axis.consumption.ui.util.FileUtil;
import org.eclipse.jst.ws.internal.axis.consumption.ui.util.PlatformUtils;
import org.eclipse.jst.ws.internal.axis.consumption.ui.util.WSDLUtils;
import org.eclipse.jst.ws.internal.axis.creation.ui.AxisCreationUIMessages;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.common.ServerUtils;
import org.eclipse.jst.ws.internal.consumption.command.common.CopyWSDLCommand;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;

public class Skeleton2WSDLCommand
extends AbstractDataModelOperation {
    private static final String SERVICE_EXT = "/services/";
    private static final String WSDL_EXT = "wsdl";
    private final String WSDL_FOLDER = "wsdl";
    private WebServicesParser webServicesParser;
    private JavaWSDLParameter javaWSDLParam;
    private IProject serverProject;
    private String serviceServerTypeID_;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment environment = this.getEnvironment();
        if (this.javaWSDLParam == null) {
            IStatus status = StatusUtils.errorStatus((String)AxisConsumptionCoreMessages.MSG_ERROR_JAVA_WSDL_PARAM_NOT_SET);
            environment.getStatusHandler().reportError(status);
            return status;
        }
        Definition definition = null;
        String wsdlURL = this.javaWSDLParam.getInputWsdlLocation();
        try {
            URL url = new URL(wsdlURL);
            definition = this.webServicesParser.getWSDLDefinition(url.toString());
        }
        catch (MalformedURLException malformedURLException) {
            wsdlURL = PlatformUtils.getFileURLFromPath((IPath)new Path(wsdlURL));
            definition = this.webServicesParser.getWSDLDefinition(wsdlURL);
        }
        Service service = null;
        Port port = null;
        if (definition == null) {
            IStatus status = StatusUtils.errorStatus((String)NLS.bind((String)AxisConsumptionUIMessages.MSG_ERROR_WSDL_NO_DEFINITION, (Object[])new String[]{wsdlURL}));
            environment.getStatusHandler().reportError(status);
            return status;
        }
        service = (Service)definition.getServices().values().iterator().next();
        port = (Port)service.getPorts().values().iterator().next();
        this.javaWSDLParam.setPortTypeName(WSDLUtils.getPortTypeName((Definition)definition));
        this.javaWSDLParam.setServiceName(WSDLUtils.getServiceElementName((Definition)definition));
        if (port == null) {
            IStatus status = StatusUtils.errorStatus((String)NLS.bind((String)AxisConsumptionUIMessages.MSG_ERROR_WSDL_NO_PORT, (Object[])new String[]{wsdlURL}));
            environment.getStatusHandler().reportError(status);
            return status;
        }
        Map services = definition.getServices();
        Iterator servicesIt = services.values().iterator();
        while (servicesIt.hasNext()) {
            Service s = (Service)servicesIt.next();
            Map ports = s.getPorts();
            Iterator portsIt = ports.values().iterator();
            while (portsIt.hasNext()) {
                Port p = (Port)portsIt.next();
                this.modifyEndpoint(p);
            }
        }
        IWorkspaceRoot workspace = ResourcesPlugin.getWorkspace().getRoot();
        String wsdlLocation = this.javaWSDLParam.getOutputWsdlLocation();
        IPath wsdlPath = null;
        IFile outputFile = null;
        try {
            if (wsdlLocation != null) {
                outputFile = workspace.getFileForLocation((IPath)new Path(wsdlLocation));
            } else {
                wsdlPath = J2EEUtils.getWebContentPath((IProject)this.serverProject);
                IPath wsdlFilePath = wsdlPath.append(WSDL_EXT).append(port.getName()).addFileExtension(WSDL_EXT);
                IFolder folder = ResourceUtils.getWorkspaceRoot().getFolder(wsdlPath.append(WSDL_EXT));
                FileUtil.createFolder((IFolder)folder, (boolean)true, (boolean)true);
                outputFile = workspace.getFile(wsdlFilePath);
                wsdlLocation = outputFile.getLocation().toString();
                this.javaWSDLParam.setOutputWsdlLocation(wsdlLocation);
            }
            CopyWSDLCommand copyWSDLCommand = new CopyWSDLCommand();
            copyWSDLCommand.setWebServicesParser(this.webServicesParser);
            copyWSDLCommand.setWsdlURI(wsdlURL);
            copyWSDLCommand.setDestinationURI(outputFile.getLocation().toFile().toURL().toString());
            copyWSDLCommand.setDefinition(definition);
            copyWSDLCommand.setEnvironment(environment);
            IStatus status = copyWSDLCommand.execute(null, null);
            if (status != null && status.getSeverity() == 4) {
                return status;
            }
        }
        catch (Exception e) {
            IStatus status = StatusUtils.errorStatus((String)NLS.bind((String)AxisConsumptionUIMessages.MSG_ERROR_WRITE_WSDL, (Object[])new String[]{wsdlLocation}), (Throwable)e);
            environment.getStatusHandler().reportError(status);
            return status;
        }
        return Status.OK_STATUS;
    }

    private IStatus modifyEndpoint(Port port) {
        Iterator it = port.getExtensibilityElements().iterator();
        SOAPAddress soapAddress = null;
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof SOAPAddress)) continue;
            soapAddress = (SOAPAddress)obj;
            break;
        }
        if (soapAddress != null) {
            String projectURL = null;
            projectURL = this.serviceServerTypeID_ != null && this.serviceServerTypeID_.length() > 0 ? ServerUtils.getEncodedWebComponentURL((IProject)this.serverProject, (String)this.serviceServerTypeID_) : "http://tempuri.org/";
            if (projectURL == null) {
                return StatusUtils.errorStatus((String)NLS.bind((String)AxisCreationUIMessages.MSG_ERROR_PROJECT_URL, (Object[])new String[]{this.serverProject.toString()}));
            }
            StringBuffer serviceURL = new StringBuffer(projectURL);
            serviceURL.append(SERVICE_EXT).append(port.getName());
            this.javaWSDLParam.setUrlLocation(serviceURL.toString());
            soapAddress.setLocationURI(serviceURL.toString());
        }
        return Status.OK_STATUS;
    }

    public JavaWSDLParameter getJavaWSDLParam() {
        return this.javaWSDLParam;
    }

    public void setJavaWSDLParam(JavaWSDLParameter javaWSDLParam) {
        this.javaWSDLParam = javaWSDLParam;
    }

    public void setServerProject(IProject serverProject) {
        this.serverProject = serverProject;
    }

    public WebServicesParser getWebServicesParser() {
        return this.webServicesParser;
    }

    public void setWebServicesParser(WebServicesParser webServicesParser) {
        this.webServicesParser = webServicesParser;
    }

    public String getWsdlURI() {
        File file = new File(this.getJavaWSDLParam().getOutputWsdlLocation());
        String url = "";
        try {
            url = file.toURL().toString();
        }
        catch (MalformedURLException malformedURLException) {}
        return url;
    }

    public void setServiceServerTypeID(String id) {
        this.serviceServerTypeID_ = id;
    }
}

