/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.creation.ui.extension;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.ws.internal.consumption.command.common.CreateFacetedProjectCommand;
import org.eclipse.jst.ws.internal.consumption.common.FacetUtils;
import org.eclipse.jst.ws.internal.consumption.common.RequiredFacetVersion;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceRuntimeExtensionUtils2;
import org.eclipse.jst.ws.internal.data.TypeRuntimeServer;
import org.eclipse.wst.command.internal.env.core.context.ResourceContext;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.wsrt.IContext;
import org.eclipse.wst.ws.internal.wsrt.ISelection;
import org.eclipse.wst.ws.internal.wsrt.IWebService;
import org.eclipse.wst.ws.internal.wsrt.IWebServiceRuntime;
import org.eclipse.wst.ws.internal.wsrt.SimpleContext;
import org.eclipse.wst.ws.internal.wsrt.WebServiceInfo;
import org.eclipse.wst.ws.internal.wsrt.WebServiceScenario;
import org.eclipse.wst.ws.internal.wsrt.WebServiceState;

public class PreServiceDevelopCommand
extends AbstractDataModelOperation {
    private TypeRuntimeServer typeRuntimeServer_;
    private String serviceRuntimeId_;
    private IContext context_;
    private ISelection selection_;
    private String project_;
    private String module_;
    private String moduleType_;
    private String earProject_;
    private String ear_;
    private IWebService webService_;
    private String j2eeLevel_;
    private ResourceContext resourceContext_;
    private boolean deploy_;
    private boolean install_;
    private boolean run_;
    private boolean client_;
    private boolean test_;
    private boolean publish_;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        RequiredFacetVersion[] rfvs;
        boolean matches;
        int earIndex;
        IEnvironment environment = this.getEnvironment();
        int index = this.module_.indexOf("/");
        if (index != -1) {
            this.project_ = this.module_.substring(0, index);
            this.module_ = this.module_.substring(index + 1);
        }
        if (this.ear_ != null && this.ear_.length() > 0 && (earIndex = this.ear_.indexOf("/")) != -1) {
            this.earProject_ = this.ear_.substring(0, earIndex);
            this.ear_ = this.ear_.substring(earIndex + 1);
        }
        IWebServiceRuntime wsrt = WebServiceRuntimeExtensionUtils2.getServiceRuntime((String)this.serviceRuntimeId_);
        WebServiceInfo wsInfo = new WebServiceInfo();
        wsInfo.setServerFactoryId(this.typeRuntimeServer_.getServerId());
        wsInfo.setServerInstanceId(this.typeRuntimeServer_.getServerInstanceId());
        wsInfo.setState(WebServiceState.UNKNOWN_LITERAL);
        wsInfo.setWebServiceRuntimeId(this.typeRuntimeServer_.getRuntimeId());
        this.webService_ = wsrt.getWebService(wsInfo);
        WebServiceScenario scenario = null;
        int scenarioInt = WebServiceRuntimeExtensionUtils2.getScenarioFromTypeId((String)this.typeRuntimeServer_.getTypeId());
        if (scenarioInt == 0) {
            scenario = WebServiceScenario.BOTTOMUP_LITERAL;
            String impl = (String)this.selection_.getSelection()[0];
            wsInfo.setImplURL(impl);
        } else if (scenarioInt == 1) {
            scenario = WebServiceScenario.TOPDOWN_LITERAL;
            String wsdlURL = (String)this.selection_.getSelection()[0];
            wsInfo.setWsdlURL(wsdlURL);
        }
        this.context_ = new SimpleContext(true, true, this.deploy_, this.install_, this.run_, this.client_, this.test_, this.publish_, scenario, this.resourceContext_.isOverwriteFilesEnabled(), this.resourceContext_.isCreateFoldersEnabled(), this.resourceContext_.isCheckoutFilesEnabled());
        IStatus status = Status.OK_STATUS;
        IProject project = ProjectUtilities.getProject((String)this.project_);
        if (!project.exists() && (matches = WebServiceRuntimeExtensionUtils2.doesServiceRuntimeSupportTemplate((String)this.serviceRuntimeId_, (String)this.moduleType_))) {
            RequiredFacetVersion[] rfv = WebServiceRuntimeExtensionUtils2.getServiceRuntimeDescriptorById((String)this.serviceRuntimeId_).getRequiredFacetVersions();
            CreateFacetedProjectCommand command = new CreateFacetedProjectCommand();
            command.setProjectName(this.project_);
            command.setTemplateId(this.moduleType_);
            command.setRequiredFacetVersions(rfv);
            command.setServerFactoryId(this.typeRuntimeServer_.getServerId());
            command.setServerInstanceId(this.typeRuntimeServer_.getServerInstanceId());
            status = command.execute(monitor, adaptable);
            if (status.getSeverity() == 4) {
                environment.getStatusHandler().reportError(status);
                return status;
            }
        }
        if ((status = FacetUtils.addRequiredFacetsToProject((IProject)project, (RequiredFacetVersion[])(rfvs = WebServiceRuntimeExtensionUtils2.getServiceRuntimeDescriptorById((String)this.serviceRuntimeId_).getRequiredFacetVersions()), (IProgressMonitor)monitor)).getSeverity() == 4) {
            environment.getStatusHandler().reportError(status);
            return status;
        }
        return status;
    }

    public void setServiceTypeRuntimeServer(TypeRuntimeServer typeRuntimeServer) {
        this.typeRuntimeServer_ = typeRuntimeServer;
    }

    public void setServiceRuntimeId(String id) {
        this.serviceRuntimeId_ = id;
    }

    public void setServiceJ2EEVersion(String j2eeLevel) {
        this.j2eeLevel_ = j2eeLevel;
    }

    public String getJ2eeLevel() {
        return this.j2eeLevel_;
    }

    public IWebService getWebService() {
        return this.webService_;
    }

    public IContext getContext() {
        return this.context_;
    }

    public void setResourceContext(ResourceContext resourceContext) {
        this.resourceContext_ = resourceContext;
    }

    public ISelection getSelection() {
        return this.selection_;
    }

    public void setSelection(ISelection selection) {
        this.selection_ = selection;
    }

    public String getProject() {
        return this.project_;
    }

    public String getModule() {
        return this.module_;
    }

    public void setModule(String module) {
        this.module_ = module;
    }

    public void setModuleType(String type) {
        this.moduleType_ = type;
    }

    public String getEarProject() {
        return this.earProject_;
    }

    public String getEar() {
        return this.ear_;
    }

    public void setEar(String ear) {
        this.ear_ = ear;
    }

    public void setInstallService(boolean installService) {
        this.install_ = installService;
    }

    public void setDeployService(boolean deployService) {
        this.deploy_ = deployService;
    }

    public void setStartService(boolean startService) {
        this.run_ = startService;
    }

    public void setTestService(boolean testService) {
        this.test_ = testService;
    }

    public void setPublishService(boolean publishService) {
        this.publish_ = publishService;
    }

    public void setGenerateProxy(boolean genProxy) {
        this.client_ = genProxy;
    }
}

