/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.product;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.TreeMap;
import org.eclipse.pde.internal.core.iproduct.IAboutInfo;
import org.eclipse.pde.internal.core.iproduct.IArgumentsInfo;
import org.eclipse.pde.internal.core.iproduct.IConfigurationFileInfo;
import org.eclipse.pde.internal.core.iproduct.IIntroInfo;
import org.eclipse.pde.internal.core.iproduct.ILauncherInfo;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductFeature;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.core.iproduct.IProductModelFactory;
import org.eclipse.pde.internal.core.iproduct.IProductPlugin;
import org.eclipse.pde.internal.core.iproduct.ISplashInfo;
import org.eclipse.pde.internal.core.iproduct.IWindowImages;
import org.eclipse.pde.internal.core.product.ProductObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Product
extends ProductObject
implements IProduct {
    private static final long serialVersionUID = 1L;
    private String fId;
    private String fName;
    private String fApplication;
    private IAboutInfo fAboutInfo;
    private TreeMap fPlugins = new TreeMap();
    private TreeMap fFeatures = new TreeMap();
    private IConfigurationFileInfo fConfigIniInfo;
    private boolean fUseFeatures;
    private IWindowImages fWindowImages;
    private ISplashInfo fSplashInfo;
    private ILauncherInfo fLauncherInfo;
    private IArgumentsInfo fLauncherArgs;
    private IIntroInfo fIntroInfo;

    public Product(IProductModel model) {
        super(model);
    }

    public String getId() {
        return this.fId;
    }

    public String getName() {
        return this.fName;
    }

    public String getApplication() {
        return this.fApplication;
    }

    public String getDefiningPluginId() {
        if (this.fId == null) {
            return null;
        }
        int dot = this.fId.lastIndexOf(46);
        return dot != -1 ? this.fId.substring(0, dot) : null;
    }

    public void setId(String id) {
        String old = this.fId;
        this.fId = id;
        if (this.isEditable()) {
            this.firePropertyChanged("id", old, this.fId);
        }
    }

    public void setName(String name) {
        String old = this.fName;
        this.fName = name;
        if (this.isEditable()) {
            this.firePropertyChanged("name", old, this.fName);
        }
    }

    public void setAboutInfo(IAboutInfo info) {
        this.fAboutInfo = info;
    }

    public void setApplication(String application) {
        String old = this.fApplication;
        this.fApplication = application;
        if (this.isEditable()) {
            this.firePropertyChanged("application", old, this.fApplication);
        }
    }

    public void write(String indent, PrintWriter writer) {
        writer.print(String.valueOf(indent) + "<product");
        if (this.fName != null && this.fName.length() > 0) {
            writer.print(" name=\"" + this.getWritableString(this.fName) + "\"");
        }
        if (this.fId != null && this.fId.length() > 0) {
            writer.print(" id=\"" + this.fId + "\"");
        }
        if (this.fApplication != null && this.fApplication.length() > 0) {
            writer.print(" application=\"" + this.fApplication + "\"");
        }
        writer.print(" useFeatures=\"" + Boolean.toString(this.fUseFeatures) + "\"");
        writer.println(">");
        if (this.fAboutInfo != null) {
            writer.println();
            this.fAboutInfo.write(String.valueOf(indent) + "   ", writer);
        }
        if (this.fConfigIniInfo != null) {
            writer.println();
            this.fConfigIniInfo.write(String.valueOf(indent) + "   ", writer);
        }
        if (this.fLauncherArgs != null) {
            writer.println();
            this.fLauncherArgs.write(String.valueOf(indent) + "   ", writer);
        }
        if (this.fWindowImages != null) {
            writer.println();
            this.fWindowImages.write(String.valueOf(indent) + "   ", writer);
        }
        if (this.fSplashInfo != null) {
            writer.println();
            this.fSplashInfo.write(String.valueOf(indent) + "   ", writer);
        }
        if (this.fLauncherInfo != null) {
            writer.println();
            this.fLauncherInfo.write(String.valueOf(indent) + "   ", writer);
        }
        if (this.fIntroInfo != null) {
            writer.println();
            this.fIntroInfo.write(String.valueOf(indent) + "   ", writer);
        }
        writer.println();
        writer.println(String.valueOf(indent) + "   <plugins>");
        Iterator iter = this.fPlugins.values().iterator();
        while (iter.hasNext()) {
            IProductPlugin plugin = (IProductPlugin)iter.next();
            plugin.write(String.valueOf(indent) + "      ", writer);
        }
        writer.println(String.valueOf(indent) + "   </plugins>");
        if (this.fFeatures.size() > 0) {
            writer.println();
            writer.println(String.valueOf(indent) + "   <features>");
            iter = this.fFeatures.values().iterator();
            while (iter.hasNext()) {
                IProductFeature feature = (IProductFeature)iter.next();
                feature.write(String.valueOf(indent) + "      ", writer);
            }
            writer.println(String.valueOf(indent) + "   </features>");
        }
        writer.println();
        writer.println("</product>");
    }

    public IAboutInfo getAboutInfo() {
        return this.fAboutInfo;
    }

    public void reset() {
        this.fAboutInfo = null;
        this.fApplication = null;
        this.fId = null;
        this.fName = null;
        this.fIntroInfo = null;
        this.fPlugins.clear();
    }

    public void parse(Node node) {
        if (node.getNodeType() == 1 && node.getNodeName().equals("product")) {
            Element element = (Element)node;
            this.fApplication = element.getAttribute("application");
            this.fId = element.getAttribute("id");
            this.fName = element.getAttribute("name");
            this.fUseFeatures = "true".equals(element.getAttribute("useFeatures"));
            NodeList children = node.getChildNodes();
            IProductModelFactory factory = this.getModel().getFactory();
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                if (child.getNodeType() == 1) {
                    String name = child.getNodeName();
                    if (name.equals("aboutInfo")) {
                        this.fAboutInfo = factory.createAboutInfo();
                        this.fAboutInfo.parse(child);
                    } else if (name.equals("plugins")) {
                        this.parsePlugins(child.getChildNodes());
                    } else if (name.equals("features")) {
                        this.parseFeatures(child.getChildNodes());
                    } else if (name.equals("configIni")) {
                        this.fConfigIniInfo = factory.createConfigFileInfo();
                        this.fConfigIniInfo.parse(child);
                    } else if (name.equals("windowImages")) {
                        this.fWindowImages = factory.createWindowImages();
                        this.fWindowImages.parse(child);
                    } else if (name.equals("splash")) {
                        this.fSplashInfo = factory.createSplashInfo();
                        this.fSplashInfo.parse(child);
                    } else if (name.equals("launcher")) {
                        this.fLauncherInfo = factory.createLauncherInfo();
                        this.fLauncherInfo.parse(child);
                    } else if (name.equals("launcherArgs")) {
                        this.fLauncherArgs = factory.createLauncherArguments();
                        this.fLauncherArgs.parse(child);
                    } else if (name.equals("intro")) {
                        this.fIntroInfo = factory.createIntroInfo();
                        this.fIntroInfo.parse(child);
                    }
                }
                ++i;
            }
        }
    }

    private void parsePlugins(NodeList children) {
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1 && child.getNodeName().equals("plugin")) {
                IProductPlugin plugin = this.getModel().getFactory().createPlugin();
                plugin.parse(child);
                this.fPlugins.put(plugin.getId(), plugin);
            }
            ++i;
        }
    }

    private void parseFeatures(NodeList children) {
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1 && child.getNodeName().equals("feature")) {
                IProductFeature feature = this.getModel().getFactory().createFeature();
                feature.parse(child);
                this.fFeatures.put(feature.getId(), feature);
            }
            ++i;
        }
    }

    public void addPlugin(IProductPlugin plugin) {
        String id = plugin.getId();
        if (this.fPlugins.containsKey(id)) {
            return;
        }
        plugin.setModel(this.getModel());
        this.fPlugins.put(id, plugin);
        if (this.isEditable()) {
            this.fireStructureChanged(plugin, 1);
        }
    }

    public void removePlugin(IProductPlugin plugin) {
        this.fPlugins.remove(plugin.getId());
        if (this.isEditable()) {
            this.fireStructureChanged(plugin, 2);
        }
    }

    public IProductPlugin[] getPlugins() {
        return this.fPlugins.values().toArray(new IProductPlugin[this.fPlugins.size()]);
    }

    public IConfigurationFileInfo getConfigurationFileInfo() {
        return this.fConfigIniInfo;
    }

    public void setConfigurationFileInfo(IConfigurationFileInfo info) {
        this.fConfigIniInfo = info;
    }

    public boolean useFeatures() {
        return this.fUseFeatures;
    }

    public void setUseFeatures(boolean use) {
        boolean old = this.fUseFeatures;
        this.fUseFeatures = use;
        if (this.isEditable()) {
            this.firePropertyChanged("useFeatures", Boolean.toString(old), Boolean.toString(this.fUseFeatures));
        }
    }

    public boolean containsPlugin(String id) {
        return this.fPlugins.containsKey(id);
    }

    public boolean containsFeature(String id) {
        return this.fFeatures.containsKey(id);
    }

    public IWindowImages getWindowImages() {
        return this.fWindowImages;
    }

    public void setWindowImages(IWindowImages images) {
        this.fWindowImages = images;
    }

    public ISplashInfo getSplashInfo() {
        return this.fSplashInfo;
    }

    public void setSplashInfo(ISplashInfo info) {
        this.fSplashInfo = info;
    }

    public ILauncherInfo getLauncherInfo() {
        return this.fLauncherInfo;
    }

    public void setLauncherInfo(ILauncherInfo info) {
        this.fLauncherInfo = info;
    }

    public void addFeature(IProductFeature feature) {
        String id = feature.getId();
        if (this.fFeatures.containsKey(id)) {
            return;
        }
        feature.setModel(this.getModel());
        this.fFeatures.put(id, feature);
        if (this.isEditable()) {
            this.fireStructureChanged(feature, 1);
        }
    }

    public void removeFeature(IProductFeature feature) {
        this.fFeatures.remove(feature.getId());
        if (this.isEditable()) {
            this.fireStructureChanged(feature, 2);
        }
    }

    public IProductFeature[] getFeatures() {
        return this.fFeatures.values().toArray(new IProductFeature[this.fFeatures.size()]);
    }

    public IArgumentsInfo getLauncherArguments() {
        return this.fLauncherArgs;
    }

    public void setLauncherArguments(IArgumentsInfo info) {
        this.fLauncherArgs = info;
    }

    public IIntroInfo getIntroInfo() {
        return this.fIntroInfo;
    }

    public void setIntroInfo(IIntroInfo introInfo) {
        this.fIntroInfo = introInfo;
    }
}

