/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.sample.loganalyzer;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.hyades.monitoring.sample.SampleMessages;
import org.eclipse.hyades.trace.sample.loganalyzer.LogAnalyzerCreationWizard;
import org.eclipse.hyades.trace.sample.loganalyzer.LogAnalyzerSamplePage;
import org.eclipse.hyades.ui.internal.wizard.exampleproject.CreationWizard;
import org.eclipse.hyades.ui.internal.wizard.exampleproject.CreationWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class LogAnalyzerCreationPage
extends CreationWizardPage {
    public LogAnalyzerCreationPage(CreationWizard creationWizard, String pageName, IConfigurationElement configurationElement) {
        super(creationWizard, pageName, configurationElement);
    }

    public Text getProjectText() {
        if (!(this.getControl() instanceof Composite)) {
            return null;
        }
        if (this.getProjectName() == null) {
            return null;
        }
        Composite parent = (Composite)this.getControl();
        Control[] children = parent.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof Composite) {
                Control[] grandChildren = ((Composite)children[i]).getChildren();
                int j = 0;
                while (j < grandChildren.length) {
                    if (grandChildren[j] instanceof Text) {
                        Text text = (Text)grandChildren[j];
                        if (this.getProjectName().equals(text.getText())) {
                            return text;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    protected boolean validatePage() {
        LogAnalyzerCreationWizard wizard;
        LogAnalyzerSamplePage samplePage;
        String projectName = this.getProjectName();
        if (projectName == null) {
            return false;
        }
        if (!this.projectValidatePage()) {
            return false;
        }
        if (this.getWizard() instanceof LogAnalyzerCreationWizard && (samplePage = (wizard = (LogAnalyzerCreationWizard)this.getWizard()).getPageTwo()) != null) {
            samplePage.setAccessLog(this.getLocationPath().toString());
            samplePage.setErrorLog(this.getLocationPath().toString());
        }
        return true;
    }

    protected boolean projectValidatePage() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String projectFieldContents = super.getProjectName();
        if (projectFieldContents.equals("")) {
            this.setErrorMessage(null);
            this.setMessage(SampleMessages._16);
            return false;
        }
        IStatus nameStatus = workspace.validateName(projectFieldContents, 4);
        if (!nameStatus.isOK()) {
            this.setErrorMessage(nameStatus.getMessage());
            return false;
        }
        if (this.getProjectHandle().exists()) {
            this.setErrorMessage(SampleMessages._17);
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }
}

