/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.sample.loganalyzer;

import java.lang.reflect.InvocationTargetException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.logging.parsers.importer.ILogParser;
import org.eclipse.hyades.logging.parsers.importer.ParserWrapper;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.monitoring.sample.HyadesSamplePlugin;
import org.eclipse.hyades.monitoring.sample.SampleMessages;
import org.eclipse.hyades.trace.sample.loganalyzer.AnalyzeCorrelateOperation;
import org.eclipse.hyades.trace.sample.loganalyzer.AnalyzeLogAction;
import org.eclipse.hyades.trace.sample.loganalyzer.CorrelateLogAction;
import org.eclipse.hyades.trace.sample.loganalyzer.LogAnalyzerCreationPage;
import org.eclipse.hyades.trace.sample.loganalyzer.LogAnalyzerSamplePage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.ui.internal.util.CoreUtil;
import org.eclipse.hyades.ui.internal.util.StringUtil;
import org.eclipse.hyades.ui.internal.wizard.exampleproject.CreationWizard;
import org.eclipse.hyades.ui.internal.wizard.exampleproject.CreationWizardPage;
import org.eclipse.hyades.ui.internal.wizard.exampleproject.ZipAdjusterCreationWizard;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;

public class LogAnalyzerCreationWizard
extends ZipAdjusterCreationWizard {
    LogAnalyzerCreationPage pageOne = null;
    LogAnalyzerSamplePage pageTwo = null;
    private ResourceBundle resourceBundle;

    protected void addZipExtensions() {
        this.addZipExtension("trcpxmi");
        this.addZipExtension("trcaxmi");
        this.addZipExtension("trcdbxmi");
        this.setResourceBundle(HyadesSamplePlugin.getInstance().getResourceBundle());
    }

    protected void logError(String error) {
        HyadesSamplePlugin.logError(error);
    }

    protected CreationWizardPage createWizardPage(String suggestedName, IConfigurationElement configurationElement) {
        if (suggestedName.equals("newProject1")) {
            this.pageTwo = new LogAnalyzerSamplePage((CreationWizard)this, suggestedName, configurationElement, this.pageOne);
            return this.pageTwo;
        }
        this.pageOne = new LogAnalyzerCreationPage((CreationWizard)this, suggestedName, configurationElement);
        return this.pageOne;
    }

    public boolean correlateAccessLog(AnalyzeCorrelateOperation aco) {
        CorrelateLogAction runnable = null;
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(runnable);
        TRCMonitor monitor = aco.getTRCMonitor();
        runnable = new CorrelateLogAction();
        runnable.setMofObject((EObject)monitor);
        op = new WorkspaceModifyDelegatingOperation((IRunnableWithProgress)runnable);
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            this.handleException(e.getTargetException());
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        runnable.dispose();
        return true;
    }

    public boolean analyzeErrorLog(String projectName, String fileName, String symptomDBPath, AnalyzeCorrelateOperation aco) {
        AnalyzeLogAction runnable = null;
        TRCAgentProxy emfObject = aco.getAgent().getAgentProxy();
        runnable = new AnalyzeLogAction();
        runnable.setSymptomDBPath(symptomDBPath);
        runnable.setProjectName(projectName);
        runnable.setSDBFileName(fileName);
        runnable.setMofObject((EObject)emfObject);
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation((IRunnableWithProgress)runnable);
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            this.handleException(e.getTargetException());
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    public AnalyzeCorrelateOperation importLogFile(String logFile, ILogParser parser, String name, String adapter) {
        INavigator fViewer = null;
        AnalyzeCorrelateOperation runnable = null;
        try {
            IWorkbenchPage page = UIPlugin.getActivePage();
            fViewer = (INavigator)page.showView("org.eclipse.hyades.log.ui.internal.navigator.LogNavigator");
        }
        catch (Exception exception) {
            return null;
        }
        runnable = new AnalyzeCorrelateOperation(parser, name);
        runnable.setFViewer(fViewer);
        runnable.setLogFilePath(logFile);
        runnable.setAdapterFilePath(adapter);
        runnable.setProjectName(this.pageOne.getProjectName());
        runnable.setTcMonitor("LogCorrelationAnalyzerSample_TCMonitor");
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation((IRunnableWithProgress)runnable);
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            this.handleException(e.getTargetException());
            return null;
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        runnable.dispose();
        return runnable;
    }

    protected boolean finishWork() {
        AnalyzeCorrelateOperation acoLog = this.importLogFile(this.pageTwo.getLogPath(), (ILogParser)new ParserWrapper(), SampleMessages._2, this.getAccessLogAdapter());
        AnalyzeCorrelateOperation acoErrorLog = this.importLogFile(this.pageTwo.getErrorLogPath(), (ILogParser)new ParserWrapper(), SampleMessages._3, this.getErrorLogAdapter());
        if (this.pageTwo.getAnalyzeLogButton().getSelection()) {
            this.analyzeErrorLog(this.pageTwo.getProjectName(), this.pageTwo.getSDBFileName(), this.pageTwo.getSymptomDBFilePath(), acoErrorLog);
        }
        if (this.pageTwo.getCorrelateLogButton().getSelection()) {
            this.correlateAccessLog(acoLog);
        }
        return true;
    }

    private void handleException(Throwable throwable) {
        this.logError(CoreUtil.getStackTrace((Throwable)throwable));
    }

    protected String getString(String key) {
        if (this.resourceBundle != null) {
            try {
                return this.resourceBundle.getString(key);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return key;
    }

    protected String getString(String key, String[] args) {
        String ret = this.getString(key);
        int i = args.length;
        while (i > 0) {
            ret = StringUtil.replace((String)ret, (String)("%" + i), (String)args[i - 1]);
            --i;
        }
        return ret;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void setResourceBundle(ResourceBundle bundle) {
        this.resourceBundle = bundle;
    }

    public LogAnalyzerSamplePage getPageTwo() {
        return this.pageTwo;
    }

    private String getAccessLogAdapter() {
        if (System.getProperty("os.name", "Windows").startsWith("Windows")) {
            return ".\\config\\Apache\\access\\v1.3.26\\static.adapter";
        }
        return "./config/Apache/access/v1.3.26/static.adapter";
    }

    private String getErrorLogAdapter() {
        if (System.getProperty("os.name", "Windows").startsWith("Windows")) {
            return ".\\config\\Apache\\error\\v1.3.26\\static.adapter";
        }
        return "./config/Apache/error/v1.3.26/static.adapter";
    }
}

