/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.monitoring.logui.internal.util;

import com.ibm.icu.text.SimpleDateFormat;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.execution.core.file.IFileManagerExtended;
import org.eclipse.hyades.execution.local.file.FileManagerFactory;
import org.eclipse.hyades.internal.execution.core.file.ServerNotAvailableException;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.logging.adapter.model.internal.adapter.AdapterType;
import org.eclipse.hyades.logging.adapter.model.internal.adapter.DocumentRoot;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType;
import org.eclipse.hyades.logging.adapter.model.internal.context.Component;
import org.eclipse.hyades.logging.adapter.model.internal.context.ContextFactory;
import org.eclipse.hyades.logging.adapter.model.internal.context.ContextType;
import org.eclipse.hyades.logging.adapter.model.internal.context.ContextsType;
import org.eclipse.hyades.logging.adapter.model.internal.context.RoleNames;
import org.eclipse.hyades.logging.adapter.model.internal.filter.AbstractFilterRuleType;
import org.eclipse.hyades.logging.adapter.model.internal.filter.FilterConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.filter.FilterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.filter.FilterRuleBlockType;
import org.eclipse.hyades.logging.adapter.model.internal.filter.LogicalOperatorType;
import org.eclipse.hyades.logging.adapter.model.internal.filter.NumericalFilterRuleType;
import org.eclipse.hyades.logging.adapter.model.internal.filter.NumericalRelationalOperatorType;
import org.eclipse.hyades.logging.adapter.model.internal.filter.PathExpressionType;
import org.eclipse.hyades.logging.adapter.model.internal.filter.RangeFilterRuleType;
import org.eclipse.hyades.logging.adapter.model.internal.filter.RangeRelationalOperatorType;
import org.eclipse.hyades.logging.adapter.model.internal.filter.StringFilterRuleType;
import org.eclipse.hyades.logging.adapter.model.internal.filter.StringRelationalOperatorType;
import org.eclipse.hyades.logging.parsers.internal.importer.GLAHelper;
import org.eclipse.hyades.models.cbe.CBEPackage;
import org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleOperand;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.extensions.WhereExpression;
import org.eclipse.hyades.ui.internal.util.StringUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tptp.monitoring.logui.internal.LogUIMessages;
import org.eclipse.tptp.monitoring.logui.internal.MonitoringLogUIPlugin;

public class GLAFilterHelper
extends GLAHelper {
    protected static final String WindowsAdapterRootDir = "C:\\";
    protected static final String UnixAdapterRootDir = "/tmp/";
    protected static final String GLARangeFilterAttributeNamePathRoot = "RangeFilter";
    protected static final String GLARangeFilterByEventsAttributeName = "events";
    protected static final String GLARangeFilterBySecondsAttributeName = "seconds";
    protected static final String dateTimeFormat = "yyyy-MM-dd'T'HH:mm:ss.S Z";

    public static FilterConfigType createGLAFilter(SimpleSearchQuery query) {
        FilterConfigType filter = null;
        if (query.getWhereExpression() != null) {
            WhereExpression expression = query.getWhereExpression();
            EObject filterRule = GLAFilterHelper.createFilterElement(expression);
            if (filterRule == null) {
                return null;
            }
            if (filterRule instanceof AbstractFilterRuleType) {
                filter = FilterFactory.eINSTANCE.createFilterConfigType();
                filter.setAbstractFilterRule((AbstractFilterRuleType)filterRule);
            } else if (filterRule instanceof FilterRuleBlockType) {
                filter = FilterFactory.eINSTANCE.createFilterConfigType();
                filter.setFilterRuleBlock((FilterRuleBlockType)filterRule);
            }
        }
        return filter;
    }

    protected static AdapterType getAdapter(Resource resource, SimpleSearchQuery query) {
        DocumentRoot rootObject;
        AdapterType object;
        if (resource.getContents().size() > 0 && (object = (rootObject = (DocumentRoot)resource.getContents().get(0)).getAdapter()) instanceof AdapterType) {
            EList contexts;
            ContextsType contextsType;
            Object element;
            FilterConfigType filter = GLAFilterHelper.createGLAFilter(query);
            if (filter == null) {
                return null;
            }
            AdapterType adapter = object;
            EList contextInstance = adapter.getConfiguration().getContextInstance();
            ContextInstanceType contextType = null;
            if (contextInstance != null && contextInstance.size() > 0 && (element = contextInstance.get(0)) != null && element instanceof ContextInstanceType) {
                contextType = (ContextInstanceType)element;
                contextType.getFilter().add((Object)filter);
            }
            if ((contextsType = adapter.getContexts()) != null && (contexts = contextsType.getContext()) != null && contexts.size() > 0) {
                ContextType context = (ContextType)contexts.get(0);
                filter.setDescription("CBE Filter Component");
                context.getComponent().add(context.getComponent().size() - 1, (Object)GLAFilterHelper.createFilterComponent(filter));
            }
            return adapter;
        }
        return null;
    }

    public static String addFilterToAdapter(Node node, ResourceSet resourceSet, Map table, SimpleSearchQuery query, String nameSpace) throws Exception {
        String tempFilePath;
        Resource resource;
        block13: {
            String adapterFilePath = GLAFilterHelper.getAdapterPath((Map)table, (String)nameSpace, (boolean)false);
            String key = GLAFilterHelper.getAdapterPathKey((Map)table);
            table.put("originalAdapter", (String)table.get(key));
            resource = null;
            try {
                resource = resourceSet.getResource(URI.createURI((String)adapterFilePath), true);
            }
            catch (Exception e1) {
                if (e1 instanceof WrappedException && ((WrappedException)e1).exception() instanceof FileNotFoundException) {
                    String message = NLS.bind((String)LogUIMessages._81, (Object)adapterFilePath);
                    throw new Exception(message);
                }
                throw e1;
            }
            AdapterType adapter = GLAFilterHelper.getAdapter(resource, query);
            if (adapter == null) {
                return "";
            }
            File destination_file = null;
            tempFilePath = "";
            try {
                IPath dirPath = MonitoringLogUIPlugin.getDefault().getStateLocation();
                String destPath = dirPath.toString();
                destPath = StringUtil.replace((String)destPath, (String)"org.eclipse.tptp.monitoring.logui", (String)"org.eclipse.hyades.logging.parsers");
                File destinationDir = new File(destPath);
                try {
                    destination_file = File.createTempFile("GLA", ".adapter", destinationDir);
                }
                catch (Exception exception) {
                    String tmpFileName = new String("GLA" + System.currentTimeMillis() + ".adapter");
                    destination_file = new File(destinationDir, tmpFileName);
                }
                resource.setURI(URI.createFileURI((String)destination_file.getAbsolutePath()));
                HashMap<String, Boolean> options = new HashMap<String, Boolean>();
                options.put("SCHEMA_LOCATION", Boolean.FALSE);
                resource.save(options);
                table.put(key, destination_file.getName());
                table.put("ConfigFileRoot", destination_file.getParent());
                destination_file.deleteOnExit();
                tempFilePath = destination_file.getAbsolutePath();
                if (node != null) {
                    tempFilePath = GLAFilterHelper.sendAdapter(node, table, destination_file.getAbsolutePath(), destination_file.getName());
                }
            }
            catch (FileTransferException e) {
                throw e;
            }
            catch (Exception exception) {
                try {
                    destination_file = File.createTempFile("GLA" + System.currentTimeMillis(), ".adapter");
                    resource.setURI(URI.createFileURI((String)destination_file.getAbsolutePath()));
                    HashMap<String, Boolean> options = new HashMap<String, Boolean>();
                    options.put("SCHEMA_LOCATION", Boolean.FALSE);
                    resource.save(options);
                    table.put(key, destination_file.getName());
                    table.put("ConfigFileRoot", destination_file.getParent());
                    destination_file.deleteOnExit();
                    tempFilePath = destination_file.getAbsolutePath();
                    if (node != null) {
                        tempFilePath = GLAFilterHelper.sendAdapter(node, table, destination_file.getAbsolutePath(), destination_file.getName());
                    }
                }
                catch (Exception exception2) {
                    File oldFile = new File(adapterFilePath);
                    String tmpFileName = new String("GLA" + System.currentTimeMillis() + ".adapter");
                    destination_file = new File(oldFile.getParent(), tmpFileName);
                    resource.setURI(URI.createFileURI((String)destination_file.getAbsolutePath()));
                    HashMap<String, Boolean> options = new HashMap<String, Boolean>();
                    options.put("SCHEMA_LOCATION", Boolean.FALSE);
                    resource.save(options);
                    table.put(key, destination_file.getName());
                    table.put("ConfigFileRoot", destination_file.getParent());
                    tempFilePath = destination_file.getAbsolutePath();
                    if (node == null) break block13;
                    tempFilePath = GLAFilterHelper.sendAdapter(node, table, destination_file.getAbsolutePath(), destination_file.getName());
                }
            }
        }
        resource.unload();
        return tempFilePath;
    }

    private static EObject createFilterElement(WhereExpression expression) {
        if (expression instanceof LogicalExpression) {
            LogicalExpression logicalExpression = (LogicalExpression)expression;
            int s = logicalExpression.getArguments().size();
            if (s == 0) {
                return null;
            }
            if (logicalExpression.getArguments().size() == 1) {
                Object argument = logicalExpression.getArguments().get(0);
                if (argument instanceof BinaryExpression) {
                    EObject filterRule = GLAFilterHelper.createFilterRule((BinaryExpression)argument);
                    if (logicalExpression.getOperator().getValue() == 0) {
                        if (filterRule instanceof AbstractFilterRuleType) {
                            ((AbstractFilterRuleType)filterRule).setNegation(true);
                        } else if (filterRule instanceof FilterRuleBlockType) {
                            ((FilterRuleBlockType)filterRule).setNegation(true);
                        }
                    }
                    return filterRule;
                }
                if (argument instanceof LogicalExpression) {
                    return GLAFilterHelper.createFilterElement((WhereExpression)((LogicalExpression)argument));
                }
            } else {
                WhereExpression argument = null;
                Object element = null;
                EObject rule = null;
                ArrayList<EObject> rules = new ArrayList<EObject>();
                int i = 0;
                while (i < s) {
                    element = logicalExpression.getArguments().get(i);
                    if (element instanceof WhereExpression) {
                        argument = (WhereExpression)element;
                        if (argument != null) {
                            if (argument instanceof BinaryExpression) {
                                rule = GLAFilterHelper.createFilterRule((BinaryExpression)argument);
                            } else if (argument instanceof LogicalExpression) {
                                rule = GLAFilterHelper.createFilterElement((WhereExpression)((LogicalExpression)argument));
                            }
                        }
                        if (rule != null) {
                            rules.add(rule);
                        }
                    }
                    ++i;
                }
                int sr = rules.size();
                if (sr > 1) {
                    FilterRuleBlockType parentBlock = FilterFactory.eINSTANCE.createFilterRuleBlockType();
                    parentBlock.setName(logicalExpression.getName() != null ? logicalExpression.getName() : "filterBlock");
                    parentBlock.setOperator(LogicalOperatorType.get((String)logicalExpression.getOperator().getName()));
                    int i2 = 0;
                    while (i2 < sr) {
                        if (rules.get(i2) instanceof AbstractFilterRuleType) {
                            parentBlock.getAbstractFilterRule().add(rules.get(i2));
                        } else if (rules.get(i2) instanceof FilterRuleBlockType) {
                            parentBlock.getFilterRuleBlock().add(rules.get(i2));
                        }
                        ++i2;
                    }
                    return parentBlock;
                }
                if (sr == 1 && rules.get(0) != null && rules.get(0) instanceof EObject) {
                    return (EObject)rules.get(0);
                }
            }
        } else if (expression instanceof BinaryExpression) {
            return GLAFilterHelper.createFilterRule((BinaryExpression)expression);
        }
        return null;
    }

    private static EObject createFilterRule(BinaryExpression binaryExpression) {
        EStructuralFeature feature = ((SimpleOperand)binaryExpression.getLeftOperand()).getFeature();
        Object attributeValue = ((SimpleOperand)binaryExpression.getRightOperands().get(0)).getValue();
        if (binaryExpression.getName() != null && binaryExpression.getName().equals("internal.rangeByEventCountOrSecondsCount")) {
            return GLAFilterHelper.createRangeFilterRuleType(binaryExpression);
        }
        if (feature.getEType() == EcorePackage.eINSTANCE.getEString()) {
            return GLAFilterHelper.createStringFilterRuleType(binaryExpression);
        }
        if (feature == CBEPackage.eINSTANCE.getCBECommonBaseEvent_CreationTime() || feature == CBEPackage.eINSTANCE.getCBECommonBaseEvent_ElapsedTime()) {
            return GLAFilterHelper.createTimeFilterRuleType(binaryExpression);
        }
        if (attributeValue instanceof Number) {
            return GLAFilterHelper.createNumericFilterRule(binaryExpression);
        }
        return null;
    }

    public static String sendAdapter(Node node, Map table, String sourceFile, String destinationFile) throws Exception {
        int lastSeparatorIndex;
        String returnValue;
        block17: {
            IFileManagerExtended fileManager = null;
            String targetDirectory = WindowsAdapterRootDir;
            String targetFile = String.valueOf(targetDirectory) + destinationFile;
            returnValue = "";
            try {
                try {
                    fileManager = FileManagerFactory.getInstance().create(node.getConnection());
                }
                catch (Exception e) {
                    throw new FileTransferException(e);
                }
                if (fileManager == null) {
                    throw new FileTransferException(LogUIMessages._100);
                }
                if (fileManager instanceof IFileManagerExtended) {
                    IFileManagerExtended fManager = fileManager;
                    IFileManagerExtended.FileIdentifierList srcList = IFileManagerExtended.FileIdentifierList.create((String)sourceFile);
                    IFileManagerExtended.FileIdentifierList tarList = IFileManagerExtended.FileIdentifierList.create((String)destinationFile);
                    try {
                        fManager.putFile(srcList, tarList);
                        returnValue = tarList.get(0);
                        break block17;
                    }
                    catch (ServerNotAvailableException e0) {
                        throw e0;
                    }
                    catch (Exception exception) {
                        fileManager.putFile(sourceFile, targetFile);
                        returnValue = targetFile;
                        break block17;
                    }
                }
                fileManager.putFile(sourceFile, targetFile);
                returnValue = targetFile;
            }
            catch (ServerNotAvailableException e0) {
                MonitoringLogUIPlugin.log(e0);
                throw new FileTransferException(e0);
            }
            catch (FileTransferException fte) {
                MonitoringLogUIPlugin.log(fte);
                throw fte;
            }
            catch (Exception exception) {
                targetDirectory = UnixAdapterRootDir;
                targetFile = String.valueOf(targetDirectory) + destinationFile;
                try {
                    fileManager.putFile(sourceFile, targetFile);
                    returnValue = targetFile;
                }
                catch (Exception e2) {
                    MonitoringLogUIPlugin.log(e2);
                    throw new FileTransferException(e2);
                }
            }
        }
        if (returnValue != null && returnValue.length() > 0) {
            lastSeparatorIndex = returnValue.lastIndexOf(47);
            if (lastSeparatorIndex == -1) {
                lastSeparatorIndex = returnValue.lastIndexOf(92);
            }
            if (lastSeparatorIndex <= -1) {
                FileTransferException fte = new FileTransferException(LogUIMessages._101);
                MonitoringLogUIPlugin.log(fte);
                throw fte;
            }
        } else {
            FileTransferException fte = new FileTransferException(LogUIMessages._102);
            MonitoringLogUIPlugin.log(fte);
            throw fte;
        }
        table.put("ConfigFileRoot", returnValue.substring(0, lastSeparatorIndex + 1));
        return returnValue;
    }

    public static void deleteTempAdapter(Node node, String file) {
        if (file.indexOf("GLA") <= -1 || !file.endsWith("adapter")) {
            return;
        }
        try {
            IFileManagerExtended fileManager = FileManagerFactory.getInstance().create(node.getConnection());
            fileManager.deleteFile(file);
        }
        catch (Exception e) {
            MonitoringLogUIPlugin.log(e);
        }
    }

    private static String createDateTime() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        Date today = new Date();
        String result = formatter.format(today);
        return result;
    }

    private static Component createFilterComponent(FilterConfigType filter) {
        String date = GLAFilterHelper.createDateTime();
        Component mcontext = ContextFactory.eINSTANCE.createComponent();
        mcontext.setDescription(filter.getDescription());
        mcontext.setUniqueID(filter.getUniqueID());
        mcontext.setExecutableClass("org.eclipse.hyades.logging.adapter.internal.filters.Filter");
        mcontext.setImplementationCreationDate((Object)date);
        mcontext.setLoggingLevel("50");
        mcontext.setRole(RoleNames.CBE_FILTER_LITERAL);
        mcontext.setRoleCreationDate((Object)date);
        mcontext.setName(mcontext.getDescription());
        mcontext.setImplementationVersion("1.0");
        mcontext.setRoleVersion("1.0");
        return mcontext;
    }

    private static EObject createNumericFilterRule(BinaryExpression binaryExpression) {
        NumericalFilterRuleType filterRule = null;
        EStructuralFeature feature = ((SimpleOperand)binaryExpression.getLeftOperand()).getFeature();
        Object attributeValue = ((SimpleOperand)binaryExpression.getRightOperands().get(0)).getValue();
        String value = attributeValue.toString();
        int operatorIndex = binaryExpression.getOperator().getValue();
        switch (operatorIndex) {
            case 2: {
                filterRule = GLAFilterHelper.createNumericalFilterRuleType(binaryExpression);
                filterRule.setOperator(NumericalRelationalOperatorType.get((int)0));
                break;
            }
            case 0: {
                filterRule = GLAFilterHelper.createNumericalFilterRuleType(binaryExpression);
                filterRule.setOperator(NumericalRelationalOperatorType.get((int)2));
                break;
            }
            case 1: {
                filterRule = GLAFilterHelper.createNumericalFilterRuleType(binaryExpression);
                filterRule.setOperator(NumericalRelationalOperatorType.get((int)1));
                break;
            }
            case 3: {
                filterRule = GLAFilterHelper.createNumericalFilterRuleType(binaryExpression);
                filterRule.setOperator(NumericalRelationalOperatorType.get((int)4));
                break;
            }
            case 4: {
                filterRule = GLAFilterHelper.createNumericalFilterRuleType(binaryExpression);
                filterRule.setOperator(NumericalRelationalOperatorType.get((int)3));
                break;
            }
            case 8: {
                FilterRuleBlockType block = FilterFactory.eINSTANCE.createFilterRuleBlockType();
                block.setName("BetweenFilterBlock");
                block.setOperator(LogicalOperatorType.get((int)0));
                NumericalFilterRuleType leftBoundRule = GLAFilterHelper.createRule(feature, 4, value);
                block.getAbstractFilterRule().add((Object)leftBoundRule);
                Object attributeValue1 = ((SimpleOperand)binaryExpression.getRightOperands().get(1)).getValue();
                String value2 = attributeValue1.toString();
                NumericalFilterRuleType rightBoundRule = GLAFilterHelper.createRule(feature, 3, value2);
                block.getAbstractFilterRule().add((Object)rightBoundRule);
                return block;
            }
            case 5: {
                FilterRuleBlockType block = FilterFactory.eINSTANCE.createFilterRuleBlockType();
                block.setName("NotEqualFilterBlock");
                block.setOperator(LogicalOperatorType.get((int)1));
                NumericalFilterRuleType lessThenRule = GLAFilterHelper.createRule(feature, 0, value);
                block.getAbstractFilterRule().add((Object)lessThenRule);
                NumericalFilterRuleType greaterThenRule = GLAFilterHelper.createRule(feature, 1, value);
                block.getAbstractFilterRule().add((Object)greaterThenRule);
                return block;
            }
        }
        if (filterRule != null) {
            filterRule.setImplementationClass("org.eclipse.hyades.logging.adapter.internal.filters.NumericalFilterType");
        }
        return filterRule;
    }

    private static EObject createTimeFilterRuleType(BinaryExpression binaryExpression) {
        EObject filterRule = GLAFilterHelper.createNumericFilterRule(binaryExpression);
        if (filterRule != null) {
            if (filterRule instanceof NumericalFilterRuleType) {
                ((NumericalFilterRuleType)filterRule).setImplementationClass("org.eclipse.hyades.logging.adapter.internal.filters.TimeFilterType");
                Object attributeValue = ((SimpleOperand)binaryExpression.getRightOperands().get(0)).getValue();
                if (attributeValue instanceof Number) {
                    SimpleDateFormat format = new SimpleDateFormat(dateTimeFormat);
                    String value = format.format(new Date(((Number)attributeValue).longValue() / 1000L));
                    ((NumericalFilterRuleType)filterRule).setAttributeValue(value);
                }
            } else if (filterRule instanceof FilterRuleBlockType) {
                EList containedRules = ((FilterRuleBlockType)filterRule).getAbstractFilterRule();
                int s = containedRules.size();
                Object element = null;
                int i = 0;
                while (i < s) {
                    element = containedRules.get(i);
                    if (element != null && element instanceof NumericalFilterRuleType) {
                        ((NumericalFilterRuleType)element).setImplementationClass("org.eclipse.hyades.logging.adapter.internal.filters.TimeFilterType");
                        Double attributeValue = new Double(((NumericalFilterRuleType)element).getAttributeValue());
                        SimpleDateFormat format = new SimpleDateFormat(dateTimeFormat);
                        String value = format.format(new Date(((Number)attributeValue).longValue() / 1000L));
                        ((NumericalFilterRuleType)element).setAttributeValue(value);
                    }
                    ++i;
                }
            }
        }
        return filterRule;
    }

    private static StringFilterRuleType createStringFilterRuleType(BinaryExpression binaryExpression) {
        StringFilterRuleType filterRule = FilterFactory.eINSTANCE.createStringFilterRuleType();
        EStructuralFeature feature = ((SimpleOperand)binaryExpression.getLeftOperand()).getFeature();
        Object attributeValue = ((SimpleOperand)binaryExpression.getRightOperands().get(0)).getValue();
        String value = attributeValue.toString();
        PathExpressionType path = FilterFactory.eINSTANCE.createPathExpressionType();
        path.getNode().add((Object)feature.getEContainingClass().getName().substring(3));
        path.getNode().add((Object)feature.getName());
        filterRule.setAttributeNamePath(path);
        filterRule.setAttributeValue(value);
        if (binaryExpression.getOperator() == RelationalOperators.get((int)2)) {
            filterRule.setOperator(StringRelationalOperatorType.get((int)0));
        } else if (binaryExpression.getOperator() == RelationalOperators.get((int)6)) {
            int i = value.indexOf("*");
            if (i > 0) {
                filterRule.setOperator(StringRelationalOperatorType.get((int)1));
                value = value.substring(0, i);
                filterRule.setAttributeValue(value);
            } else if (i == 0) {
                int j = value.indexOf("*", 1);
                if (j >= 0) {
                    filterRule.setOperator(StringRelationalOperatorType.get((int)3));
                    value = value.substring(1, j);
                    filterRule.setAttributeValue(value);
                } else {
                    filterRule.setOperator(StringRelationalOperatorType.get((int)2));
                    value = value.substring(1);
                    filterRule.setAttributeValue(value);
                }
            }
        } else if (binaryExpression.getOperator() == RelationalOperators.get((int)0) || binaryExpression.getOperator() == RelationalOperators.get((int)3)) {
            filterRule.setOperator(StringRelationalOperatorType.get((int)2));
        } else if (binaryExpression.getOperator() == RelationalOperators.get((int)1) || binaryExpression.getOperator() == RelationalOperators.get((int)4)) {
            filterRule.setOperator(StringRelationalOperatorType.get((int)1));
        }
        filterRule.setImplementationClass("org.eclipse.hyades.logging.adapter.internal.filters.StringFilterType");
        return filterRule;
    }

    private static NumericalFilterRuleType createRule(EStructuralFeature feature, int operator, String value) {
        NumericalFilterRuleType filterRule = FilterFactory.eINSTANCE.createNumericalFilterRuleType();
        PathExpressionType path = FilterFactory.eINSTANCE.createPathExpressionType();
        path.getNode().add((Object)feature.getEContainingClass().getName().substring(3));
        path.getNode().add((Object)feature.getName());
        filterRule.setAttributeNamePath(path);
        filterRule.setAttributeValue(value);
        if (operator == 3) {
            filterRule.setOperator(NumericalRelationalOperatorType.get((int)4));
        } else if (operator == 4) {
            filterRule.setOperator(NumericalRelationalOperatorType.get((int)3));
        } else if (operator == 0) {
            filterRule.setOperator(NumericalRelationalOperatorType.get((int)2));
        } else if (operator == 1) {
            filterRule.setOperator(NumericalRelationalOperatorType.get((int)1));
        }
        filterRule.setImplementationClass("org.eclipse.hyades.logging.adapter.internal.filters.NumericalFilterType");
        return filterRule;
    }

    private static NumericalFilterRuleType createNumericalFilterRuleType(BinaryExpression binaryExpression) {
        NumericalFilterRuleType filterRule = FilterFactory.eINSTANCE.createNumericalFilterRuleType();
        EStructuralFeature feature = ((SimpleOperand)binaryExpression.getLeftOperand()).getFeature();
        Object attributeValue = ((SimpleOperand)binaryExpression.getRightOperands().get(0)).getValue();
        String value = attributeValue.toString();
        PathExpressionType path = FilterFactory.eINSTANCE.createPathExpressionType();
        path.getNode().add((Object)feature.getEContainingClass().getName().substring(3));
        path.getNode().add((Object)feature.getName());
        filterRule.setAttributeNamePath(path);
        filterRule.setAttributeValue(value);
        return filterRule;
    }

    private static RangeFilterRuleType createRangeFilterRuleType(BinaryExpression binaryExpression) {
        RangeFilterRuleType filterRule = FilterFactory.eINSTANCE.createRangeFilterRuleType();
        Object value = null;
        if (binaryExpression.getRightOperands().size() > 0 && (value = ((SimpleOperand)binaryExpression.getRightOperands().get(0)).getValue()) != null) {
            filterRule.setAttributeValue(value.toString());
        }
        if (value == null) {
            filterRule.setAttributeValue("0");
        }
        if (binaryExpression.getOperator() == RelationalOperators.get((int)1)) {
            filterRule.setOperator(RangeRelationalOperatorType.get((int)1));
        } else if (binaryExpression.getOperator() == RelationalOperators.get((int)0)) {
            filterRule.setOperator(RangeRelationalOperatorType.get((int)0));
        }
        PathExpressionType path = FilterFactory.eINSTANCE.createPathExpressionType();
        if (((SimpleOperand)binaryExpression.getLeftOperand()).getName().equals("internal.events")) {
            path.getNode().add((Object)GLARangeFilterAttributeNamePathRoot);
            path.getNode().add((Object)GLARangeFilterByEventsAttributeName);
            filterRule.setAttributeNamePath(path);
        } else if (((SimpleOperand)binaryExpression.getLeftOperand()).getName().equals("internal.seconds")) {
            path.getNode().add((Object)GLARangeFilterAttributeNamePathRoot);
            path.getNode().add((Object)GLARangeFilterBySecondsAttributeName);
            filterRule.setAttributeNamePath(path);
        }
        filterRule.setImplementationClass("org.eclipse.hyades.logging.adapter.internal.filters.NumericalRangeFilterType");
        return filterRule;
    }

    static class FileTransferException
    extends Exception {
        private static final long serialVersionUID = 3375583192773987380L;

        public FileTransferException() {
        }

        public FileTransferException(String message) {
            super(message);
        }

        public FileTransferException(String message, Throwable cause) {
            super(message, cause);
        }

        public FileTransferException(Throwable cause) {
            super(cause);
        }
    }
}

