/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.monitoring.logui.internal.wizards;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.execution.local.CommunicationDebug;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.DataProcessor;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.AgentFactory;
import org.eclipse.hyades.internal.execution.local.control.AgentListener;
import org.eclipse.hyades.internal.execution.local.control.InactiveProcessException;
import org.eclipse.hyades.internal.execution.local.control.NoSuchApplicationException;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NodeFactory;
import org.eclipse.hyades.internal.execution.local.control.NotConnectedException;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.internal.execution.local.control.ProcessFactory;
import org.eclipse.hyades.internal.execution.local.control.ProcessListener;
import org.eclipse.hyades.loaders.util.HyadesResourceExtensions;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.XMLLoader;
import org.eclipse.hyades.log.ui.internal.navigator.LogNavigator;
import org.eclipse.hyades.logging.adapter.model.internal.adapter.util.AdapterResourceFactoryImpl;
import org.eclipse.hyades.logging.parsers.importer.ILogParser;
import org.eclipse.hyades.logging.parsers.internal.importer.GLAHelper;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.util.IHyadesExtendedResource;
import org.eclipse.hyades.models.hierarchy.util.IHyadesResourceExtension;
import org.eclipse.hyades.models.hierarchy.util.PerfUtil;
import org.eclipse.hyades.models.plugin.ModelsPlugin;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceAssociationManager;
import org.eclipse.hyades.trace.ui.internal.piclient.XMLTraceDataProcessor;
import org.eclipse.hyades.trace.ui.internal.util.DeleteUtil;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.IAssociationMapping;
import org.eclipse.hyades.ui.extension.IAssociationMappingRegistry;
import org.eclipse.hyades.ui.internal.util.PreferencesUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tptp.monitoring.logui.internal.LogUIMessages;
import org.eclipse.tptp.monitoring.logui.internal.MonitoringLogUIPlugin;
import org.eclipse.tptp.monitoring.logui.internal.util.GLAFilterHelper;
import org.eclipse.tptp.monitoring.logui.internal.util.ImportLogPasswordAuthentication;
import org.eclipse.tptp.monitoring.logui.internal.util.PasswordDialog;
import org.eclipse.tptp.monitoring.logui.internal.util.TraceMergeUIDialog;
import org.eclipse.tptp.monitoring.logui.internal.wizards.BasicParserField;
import org.eclipse.tptp.monitoring.logui.internal.wizards.ImportLogWizard;
import org.eclipse.tptp.monitoring.logui.internal.wizards.ImportLogWizardPage;
import org.eclipse.tptp.monitoring.logui.internal.wizards.LocalGLALogger;
import org.eclipse.tptp.monitoring.logui.internal.wizards.LocalLogParserLoader;
import org.eclipse.tptp.monitoring.logui.internal.wizards.LogFileElement;
import org.eclipse.tptp.monitoring.logui.internal.wizards.LogParserItem;
import org.eclipse.tptp.monitoring.logui.internal.wizards.ParserField;
import org.eclipse.tptp.monitoring.logui.internal.wizards.ParserParameter;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ImportLogWizard
extends Wizard
implements IImportWizard,
Runnable {
    protected IStructuredSelection selection;
    protected IWorkbench workbench;
    protected LogParserItem _parser;
    protected LogNavigator fViewer;
    protected Shell fShell;
    protected String errorMessage = null;
    protected String logParserId;
    protected String reasonAction = null;
    private boolean bAppend = false;
    private boolean bNoSelected = false;
    private boolean bCancel = false;
    private final String SKIP_LOG = "skip_log";
    private ImportLogWizardPage wizardPage;
    private boolean shouldOpenLogView = false;
    private String detailMsg = null;
    private StatusListener monitorThread = null;
    private TRCAgent displayAgent;
    private LogImportJobListener jobListener = new LogImportJobListener();
    private List jobList = null;

    public ImportLogWizard() {
        IDialogSettings workbenchSettings = MonitoringLogUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection("org.eclipse.tptp.monitoring.logui.internal.wizards.ImportLogFile");
        if (section == null) {
            section = workbenchSettings.addNewSection("org.eclipse.tptp.monitoring.logui.internal.wizards.ImportLogFile");
        }
        this.setDialogSettings(section);
        this.fShell = HyadesUIPlugin.getInstance().getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    public ImportLogWizardPage getImportLogWizardPage() {
        return this.wizardPage;
    }

    public LogParserItem getSelectedParser() {
        return this._parser;
    }

    public List getLogFileElements() {
        return this.wizardPage.getLogFileElements();
    }

    public void addPages() {
        super.addPages();
        this.setWindowTitle(LogUIMessages._1);
        this.wizardPage = new ImportLogWizardPage();
        this.addPage((IWizardPage)this.wizardPage);
    }

    public void init(IWorkbench wb, IStructuredSelection currentSelection) {
        this.workbench = wb;
        this.selection = currentSelection;
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        this.bCancel = false;
        if (!this.performPageFinish()) {
            return false;
        }
        this.errorMessage = null;
        BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)this);
        return !this.bCancel;
    }

    public boolean performCancel() {
        this.performPageFinish();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ImportLogWizard importLogWizard = this;
        synchronized (importLogWizard) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    try {
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        boolean shouldSwitch = HyadesUIPlugin.getInstance().openPerspectiveSwitchDialog(window.getShell(), "org.eclipse.hyades.trace.internal.ui.tracePerspective", UIPlugin.getDefault().getPreferenceStore(), "switch_to_perspective", MonitoringLogUIPlugin.getResourceString(LogUIMessages._55));
                        if (shouldSwitch) {
                            UIPlugin.getActivePage();
                        }
                        if ("org.eclipse.hyades.trace.internal.ui.tracePerspective".equals(window.getActivePage().getPerspective().getId())) {
                            ImportLogWizard.this.fViewer = (LogNavigator)UIPlugin.getActivePage().showView("org.eclipse.hyades.log.ui.internal.navigator.LogNavigator");
                            ImportLogWizard.this.shouldOpenLogView = true;
                        } else {
                            ImportLogWizard.this.shouldOpenLogView = false;
                        }
                    }
                    catch (Exception e) {
                        HyadesUIPlugin.logError((Throwable)e);
                    }
                }
            });
        }
        List elements = this.getLogFileElements();
        if (elements.size() > 0) {
            this.jobList = new ArrayList(elements.size());
        }
        IStatus status = null;
        String errMsg = "";
        int i = 0;
        while (i < elements.size()) {
            status = this.importLog((LogFileElement)elements.get(i));
            if (status.getSeverity() == 4 || status.getChildren().length > 0 && status.getChildren()[0].getSeverity() == 4) {
                Hashtable input = this.getUserInput((LogFileElement)elements.get(i), false);
                String param = (String)input.get("file_path");
                if (param == null) {
                    param = ((LogFileElement)elements.get(i)).getParser().getName();
                }
                errMsg = NLS.bind((String)LogUIMessages._9, (Object)param);
                ErrorDialog.openError((Shell)this.getShell(), (String)LogUIMessages._42, (String)errMsg, (IStatus)status);
            } else if (status.getSeverity() == 8 && this.bCancel) {
                return;
            }
            ++i;
        }
        LogImportJob job = null;
        int nrOfLocalImports = this.getLocalImportsCount();
        if (nrOfLocalImports > 0) {
            this.monitorThread = new StatusListener(nrOfLocalImports);
        }
        int i2 = 0;
        while (i2 < this.jobList.size()) {
            job = (LogImportJob)((Object)this.jobList.get(i2));
            if (job instanceof LocalLogImportJob) {
                ++nrOfLocalImports;
            }
            if (job != null) {
                job.schedule();
            }
            ++i2;
        }
        if (this.monitorThread != null) {
            this.monitorThread.start();
        }
    }

    private void refreshView(final Object object) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
                event.setSource(object);
                event.setType(64);
                UIPlugin.getDefault().notifyProfileEventListener(event);
            }
        });
    }

    protected boolean performPageFinish() {
        return this.wizardPage.finish();
    }

    private String getParserCommand(LogFileElement element, Hashtable input) {
        String cmd = element.getParser().getParserClass().concat(" ");
        Locale defaultLocale = Locale.getDefault();
        String localeProperty = defaultLocale.getLanguage().trim();
        if (localeProperty.length() > 0) {
            input.put("client_locale_language", localeProperty);
            localeProperty = defaultLocale.getCountry().trim();
            if (localeProperty.length() > 0) {
                input.put("client_locale_country", localeProperty);
            }
            if ((localeProperty = defaultLocale.getVariant().trim()).length() > 0) {
                input.put("client_locale_variant", localeProperty);
            }
        }
        Enumeration enums = input.keys();
        while (enums.hasMoreElements()) {
            Object key = enums.nextElement();
            String value = input.get(key).toString();
            cmd = cmd.concat("\"").concat(key.toString()).concat("=");
            cmd = value.endsWith("\\") || value.endsWith("/") ? cmd.concat(value.substring(0, value.length() - 1)).concat("\" ") : cmd.concat(value).concat("\" ");
        }
        return cmd.trim();
    }

    private Hashtable getUserInput(LogFileElement element, boolean parserParam) {
        Hashtable table = new Hashtable();
        BasicParserField[] fields = element.getParser().getFields();
        Map values = element.getValues();
        int s = fields.length;
        BasicParserField field = null;
        int i = 0;
        while (i < s) {
            field = fields[i];
            if (field != null && field.getId() != null) {
                StringTokenizer tokenizer;
                String value;
                if (field instanceof ParserField) {
                    if (((ParserField)field).getCustomFieldClass() != null && ((ParserField)field).getCustomFieldClass().trim().length() > 0) {
                        Iterator iter = values.entrySet().iterator();
                        while (iter.hasNext()) {
                            Map.Entry entry = iter.next();
                            String prefix = String.valueOf(field.getId()) + ".";
                            String key = (String)entry.getKey();
                            if (key != null && key.startsWith(prefix)) {
                                table.put(key.substring(prefix.length()), values.get(key));
                                continue;
                            }
                            table.put(key, values.get(key));
                        }
                    } else {
                        table.put(field.getId(), values.get(field.getId()));
                    }
                } else if (field.getId().equals("characterEncodingField")) {
                    if (!values.get(field.getId()).equals(LogUIMessages._94)) {
                        table.put("charset", values.get(field.getId()));
                    }
                } else if (field.getId().equals("localeField")) {
                    if (!values.get(field.getId()).equals(LogUIMessages._94)) {
                        value = (String)values.get(field.getId());
                        int idx = value.indexOf("_");
                        String countryCode = "";
                        String languageCode = "";
                        if (idx < 0) {
                            languageCode = value;
                        } else {
                            languageCode = value.substring(0, idx);
                            int idx1 = value.indexOf("_", idx + 1);
                            countryCode = idx1 < 0 ? value.substring(idx + 1) : value.substring(idx + 1, idx1);
                        }
                        table.put("isoLanguageCode", languageCode);
                        if (countryCode.trim().length() > 0) {
                            table.put("isoCountryCode", countryCode);
                        }
                    }
                } else if (field.getId().equals("timeZoneField")) {
                    if (!values.get(field.getId()).equals(LogUIMessages._94)) {
                        int colIdx;
                        String timeZoneID = (String)values.get(field.getId());
                        int index = -1;
                        int k = 0;
                        while (k < PreferencesUtil.TIME_ZONE_IDS.length) {
                            if (PreferencesUtil.TIME_ZONE_IDS[k].equals(timeZoneID)) {
                                index = k;
                                break;
                            }
                            ++k;
                        }
                        String offset = "";
                        offset = index >= 0 ? ((colIdx = (offset = PreferencesUtil.TIME_ZONE_LIST_OFFSET[index]).indexOf(":")) >= 0 ? String.valueOf(offset.substring(3, colIdx)) + offset.substring(colIdx + 1) : "+0000") : "+0000";
                        table.put("timezone", offset);
                    }
                } else if (field.getId().equals("defaultDateField") && (tokenizer = new StringTokenizer(value = (String)values.get(field.getId()), "-")).hasMoreTokens()) {
                    table.put("year", tokenizer.nextToken());
                    if (tokenizer.hasMoreTokens()) {
                        table.put("month", tokenizer.nextToken());
                        if (tokenizer.hasMoreTokens()) {
                            table.put("day", tokenizer.nextToken());
                        }
                    }
                }
            }
            ++i;
        }
        if (parserParam) {
            ArrayList params = element.getParser().getParserParameters();
            int ps = params.size();
            int m = 0;
            while (m < ps) {
                ParserParameter param = (ParserParameter)params.get(m);
                table.put(param.getName(), param.getValue());
                ++m;
            }
        }
        return table;
    }

    private TRCAgent createAgent(TRCProcessProxy process, LogFileElement element, TRCAgentProxy mergeAgentProxy) {
        TRCAgentProxy agent = null;
        final String name = this.getAgentName(element);
        String type = "Logging";
        if (mergeAgentProxy != null) {
            if (this.bAppend) {
                return mergeAgentProxy.getAgent();
            }
            ((IHyadesExtendedResource)mergeAgentProxy.getAgent().eResource()).delete();
            mergeAgentProxy.setAgent(null);
            mergeAgentProxy.getProcessProxy().eResource().setModified(true);
            mergeAgentProxy.setProcessProxy(null);
        } else {
            EList agents = process.getAgentProxies();
            Object[] agentProxys = agents.toArray();
            int i = 0;
            while (i < agents.size()) {
                agent = (TRCAgentProxy)agentProxys[i];
                TRCAgent ag = (TRCAgent)agent.eGet((EStructuralFeature)HierarchyPackage.eINSTANCE.getTRCAgentProxy_Agent(), false);
                String postfix = LoadersUtils.getPostfix((URI)EcoreUtil.getURI((EObject)ag));
                if (postfix.endsWith("#/")) {
                    int l = postfix.length();
                    postfix = postfix.substring(0, l - 2);
                }
                if (agent.getName().equals(name) && postfix.equals(this.getAgentNamePostfix(element))) {
                    this.errorMessage = null;
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            TraceMergeUIDialog dialog = new TraceMergeUIDialog(ImportLogWizard.this.getShell(), NLS.bind((String)LogUIMessages._51, (Object)name));
                            int ret = dialog.open();
                            if (ret == 3) {
                                ImportLogWizard.this.errorMessage = "skip_log";
                                ImportLogWizard.this.bNoSelected = true;
                            } else if (ret == 1025) {
                                ImportLogWizard.this.bAppend = true;
                            } else if (ret == 1026) {
                                ImportLogWizard.this.bAppend = false;
                            } else if (ret == 1) {
                                ImportLogWizard.this.bCancel = true;
                            }
                        }
                    });
                    if (this.bNoSelected) {
                        this.bNoSelected = false;
                        return null;
                    }
                    if (this.bCancel) {
                        return null;
                    }
                    if (this.bAppend) {
                        return agent.getAgent();
                    }
                    Path path = new Path(TString.resourcePath((URI)agent.getAgent().eResource().getURI()));
                    IResource res = UIPlugin.getPluginWorkbench().getRoot().findMember((IPath)path);
                    DeleteUtil.setDeleteInProgress((boolean)true);
                    DeleteUtil.deleteResource((IResource)res, (boolean)true, (boolean)true, (String)"org.eclipse.hyades.log.ui.logNavigator");
                    ((IHyadesExtendedResource)agent.getAgent().eResource()).delete();
                    agent.setAgent(null);
                    agent.getProcessProxy().eResource().setModified(true);
                    agent.setProcessProxy(null);
                    DeleteUtil.setDeleteInProgress((boolean)false);
                }
                ++i;
            }
        }
        Date currentDate = new Date();
        String timestamp = DateFormat.getDateTimeInstance((int)0, (int)0).format(currentDate);
        String rID = this.normalize(timestamp);
        rID = String.valueOf(rID) + "-" + currentDate.getTime();
        String agentName = process.getNode().getMonitor().getName() + "_" + process.getNode().getName() + "_" + process.getPid() + "_" + rID + "_" + HyadesUtil.change((String)element.getParser().getDescription(), (String)"/", (String)"");
        agentName = HyadesUtil.change((String)agentName, (String)" ", (String)"");
        String pPath = process.eResource().getURI().toString();
        Path path = new Path(pPath);
        if (path.segmentCount() > 1) {
            pPath = path.removeLastSegments(1).toString();
        }
        String fileName = String.valueOf(agentName) + this.getAgentNamePostfix(element);
        IPath filePath = new Path(pPath).append(fileName);
        URI uri = URI.createURI((String)filePath.toString());
        Resource agDoc = Resource.Factory.Registry.INSTANCE.getFactory(uri).createResource(uri);
        agDoc.setModified(true);
        EList agExt = agDoc.getContents();
        UIPlugin.getDefault().getResourceSet().getResources().add((Object)agDoc);
        HierarchyFactory factory = UIPlugin.getDefault().getPerftraceFactory();
        agent = factory.createTRCAgentProxy();
        agent.setName(name);
        agent.setType(type);
        agent.setProcessProxy(process);
        process.getAgentProxies().add((Object)agent);
        TRCAgent ag = factory.createTRCAgent();
        ag.setAgentProxy(agent);
        ag.setType(type);
        agExt.add((Object)ag);
        return ag;
    }

    private String normalize(String input) {
        int l = input.length();
        StringBuffer normalizedString = new StringBuffer();
        int i = 0;
        while (i < l) {
            if (input.charAt(i) != ' ' && input.charAt(i) != ':' && input.charAt(i) != '\'') {
                normalizedString.append(input.charAt(i));
            }
            ++i;
        }
        return normalizedString.toString();
    }

    private String getAgentName(LogFileElement element) {
        String fPath = (String)this.getUserInput(element, false).get("file_path");
        String name = String.valueOf(element.getParser().getName()) + (fPath != null ? " " + fPath : "");
        return name;
    }

    private String getAgentNamePostfix(LogFileElement element) {
        String res = null;
        Preferences store = ModelsPlugin.getPlugin().getPluginPreferences();
        if (store.contains("largeResourceSupportCurrentDBType")) {
            String activeDBType = store.getString("largeResourceSupportCurrentDBType");
            Iterator iter = HyadesResourceExtensions.getInstance().entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                if (!(entry.getKey() instanceof String)) continue;
                IHyadesResourceExtension hyadesResourceFactory = (IHyadesResourceExtension)entry.getValue();
                String postfix = (String)entry.getKey();
                if (!postfix.endsWith(".trcadb") || !hyadesResourceFactory.getStoreType(postfix).equals(activeDBType)) continue;
                return postfix;
            }
        }
        if (res == null) {
            res = ".trcaxmi";
        }
        return res;
    }

    private TRCProcessProxy createProcess(IContainer container, TRCNode node, LogFileElement element) {
        int pID = 0;
        String logPath = "";
        Hashtable elems = this.getUserInput(element, false);
        Iterator iterator = elems.keySet().iterator();
        if (iterator.hasNext()) {
            logPath = String.valueOf(logPath) + elems.get(iterator.next()).toString();
        }
        while (iterator.hasNext()) {
            logPath = String.valueOf(logPath) + " " + elems.get(iterator.next()).toString();
        }
        TRCProcessProxy process = null;
        EList processes = node.getProcessProxies();
        Iterator i = processes.iterator();
        int counter = 0;
        while (i.hasNext()) {
            process = (TRCProcessProxy)i.next();
            ++counter;
            if (process.getName() == null || !process.getName().equals(logPath)) continue;
            process.eResource().setModified(true);
            return process;
        }
        String rID = new Date().toString();
        rID = HyadesUtil.change((String)rID, (String)" ", (String)"");
        rID = HyadesUtil.change((String)rID, (String)":", (String)"");
        String processName = String.valueOf(node.getMonitor().getName()) + "_" + node.getName() + "_" + counter + "_" + pID;
        String fileName = String.valueOf(processName) + "." + "trcpxmi";
        IPath path = container.getFullPath().append(fileName);
        URI uri = URI.createURI((String)("platform:/resource" + path.toString()));
        Resource pDoc = Resource.Factory.Registry.INSTANCE.getFactory(uri).createResource(uri);
        pDoc.setModified(true);
        EList pExt = pDoc.getContents();
        UIPlugin.getDefault().getResourceSet().getResources().add((Object)pDoc);
        HierarchyFactory factory = UIPlugin.getDefault().getPerftraceFactory();
        process = factory.createTRCProcessProxy();
        process.setPid(pID);
        process.setRuntimeId(String.valueOf(pID));
        process.setName(logPath);
        process.setLaunchMode(0);
        process.setNode(node);
        node.eResource().setModified(true);
        pExt.add((Object)process);
        TRCProcessProxy fProcess = process;
        this.refreshView(fProcess);
        return process;
    }

    private void openLogView(TRCAgent agent) {
        System.out.println("ImportWizard agentProxy=" + agent.getAgentProxy() + "/" + agent.getDefaultEvents().size());
        IAssociationMappingRegistry registry = TraceAssociationManager.getTraceViewMappingRegistry();
        IAssociationMapping mapping = registry.getAssociationMapping("analyzerExtensions");
        if (mapping == null) {
            return;
        }
        IAssociationDescriptor[] array = mapping.getAssociationDescriptors(agent.getType());
        if (array.length > 0) {
            IAssociationDescriptor desc = array[0];
            try {
                IAction action = (IAction)desc.createImplementationClassInstance();
                if (action != null) {
                    action.run();
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
        IWorkbenchPage page = UIPlugin.getActivePage();
        try {
            this.fViewer = (LogNavigator)page.showView("org.eclipse.hyades.log.ui.internal.navigator.LogNavigator");
            StructuredViewer viewer = this.fViewer.getViewer();
            if (viewer != null) {
                viewer.refresh();
            }
        }
        catch (Exception e) {
            HyadesUIPlugin.logError((Throwable)e);
        }
    }

    protected IStatus importLog(LogFileElement element) {
        TRCProcessProxy process;
        TRCAgent agent;
        Node node;
        boolean localHost = true;
        PerfUtil p = PerfUtil.createInstance((String)("LogImportWizard.run " + this.getUserInput(element, false).get("file_path")), (boolean)true);
        this.bAppend = true;
        if (element.getMergedAgent() != null) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    TraceMergeUIDialog dialog = new TraceMergeUIDialog(ImportLogWizard.this.getShell(), MonitoringLogUIPlugin.getResourceString(LogUIMessages._52));
                    int ret = dialog.open();
                    if (ret == 3) {
                        ImportLogWizard.this.bNoSelected = true;
                        return;
                    }
                    if (ret == 1025) {
                        ImportLogWizard.this.bAppend = true;
                    } else if (ret == 1026) {
                        ImportLogWizard.this.bAppend = false;
                    } else if (ret == 1) {
                        ImportLogWizard.this.bCancel = true;
                    }
                }
            });
        }
        if (this.bNoSelected || this.bCancel) {
            this.bNoSelected = false;
            return new Status(8, MonitoringLogUIPlugin.getPluginId(), 0, "", null);
        }
        String project = element.getProject();
        String monitor = element.getMonitor();
        String host = element.getHost();
        try {
            node = NodeFactory.createNode((String)host);
            Node lnode = NodeFactory.createNode((String)"localhost");
            localHost = node.getName().equals(lnode.getName());
        }
        catch (Exception e) {
            this.reasonAction = NLS.bind((String)LogUIMessages._10, (Object)host);
            Status result = new Status(4, MonitoringLogUIPlugin.getPluginId(), 0, this.reasonAction, (Throwable)e);
            return result;
        }
        TRCAgent tRCAgent = agent = element.getMergedAgent() != null ? element.getMergedAgent().getAgent() : null;
        if (agent == null) {
            TRCNode trcNode;
            IContainer container = PDCoreUtil.createContainer((IPath)new Path(project));
            TRCMonitor trcMonitor = PDCoreUtil.createMonitor((IContainer)container, (String)monitor);
            IContainer fContainer = container;
            this.refreshView(fContainer);
            String portNb = UIPlugin.getDefault().getPreferenceStore().getString("localhost_port");
            TRCNode fNode = trcNode = PDCoreUtil.createNode((TRCMonitor)trcMonitor, (String)node.getName(), (String)portNb);
            TRCMonitor fMonitor = trcMonitor;
            this.refreshView(fMonitor);
            process = this.createProcess(container, trcNode, element);
            this.refreshView(fNode);
            try {
                agent = this.createAgent(process, element, null);
                if (agent == null && this.bCancel) {
                    return new Status(8, MonitoringLogUIPlugin.getPluginId(), 0, "", null);
                }
            }
            catch (Exception e) {
                this.errorMessage = LogUIMessages._11;
                return new Status(4, MonitoringLogUIPlugin.getPluginId(), 0, this.errorMessage, (Throwable)e);
            }
            if (this.errorMessage != null && this.errorMessage.startsWith("skip_log")) {
                return new Status(8, MonitoringLogUIPlugin.getPluginId(), 0, "", null);
            }
            TRCProcessProxy fProcess = process;
            this.refreshView(fProcess);
        } else {
            process = agent.getAgentProxy().getProcessProxy();
            if (!this.bAppend) {
                agent = this.createAgent(process, element, element.getMergedAgent());
            }
        }
        this.displayAgent = agent;
        TRCAgent trcAgent = agent;
        TRCProcessProxy trcProcess = process;
        if (this.fViewer != null) {
            this.fViewer.getViewer().refresh((Object)trcAgent.getAgentProxy());
        }
        try {
            if (localHost) {
                this.importFromLocalHost(element, trcAgent);
            } else {
                this.importFromRemoteHost(element, trcProcess, trcAgent);
            }
        }
        catch (OperationCanceledException e) {
            trcAgent.getAgentProxy().setActive(false);
            return new Status(8, MonitoringLogUIPlugin.getPluginId(), 0, "", (Throwable)e);
        }
        catch (Exception e) {
            HyadesUIPlugin.logError((Throwable)e);
            MultiStatus result = null;
            if (this.errorMessage == null) {
                this.errorMessage = MonitoringLogUIPlugin.getResourceString(LogUIMessages._11);
            }
            if (this.reasonAction == null && e.getLocalizedMessage() != null) {
                this.reasonAction = e.getLocalizedMessage();
            }
            if (this.reasonAction != null) {
                if (this.detailMsg != null) {
                    result = new MultiStatus(MonitoringLogUIPlugin.getPluginId(), 0, this.reasonAction, (Throwable)e);
                    result.add((IStatus)new Status(4, MonitoringLogUIPlugin.getPluginId(), 0, this.detailMsg, (Throwable)e));
                } else {
                    result = new Status(4, MonitoringLogUIPlugin.getPluginId(), 0, this.reasonAction, (Throwable)e);
                }
            } else {
                result = this.detailMsg != null ? new Status(4, MonitoringLogUIPlugin.getPluginId(), 0, this.detailMsg, (Throwable)e) : (e.getLocalizedMessage() != null ? new Status(4, MonitoringLogUIPlugin.getPluginId(), 0, e.getLocalizedMessage(), (Throwable)e) : new Status(4, MonitoringLogUIPlugin.getPluginId(), 0, e.toString(), (Throwable)e));
            }
            trcAgent.getAgentProxy().setActive(false);
            if (this.fViewer != null) {
                this.fViewer.getViewer().refresh((Object)trcAgent.getAgentProxy());
            }
            return result;
        }
        p.stopAndPrintStatus();
        return new Status(0, MonitoringLogUIPlugin.getPluginId(), 0, "", null);
    }

    protected void importFromLocalHost(LogFileElement element, TRCAgent trcAgent) throws Exception {
        XMLTraceDataProcessor xmlLoader = new XMLTraceDataProcessor(trcAgent);
        Hashtable input = this.getUserInput(element, true);
        ILogParser parser = element.getParser().getParserInstance();
        String nameSpace = "org.eclipse.hyades.logging.adapter.config";
        if (element.getParser() != null && element.getParser().getNamespace() != null && element.getParser().getNamespace().length() > 0) {
            nameSpace = element.getParser().getNamespace();
        }
        input.put("parserPluginName", nameSpace);
        if (element.getFilter() != null && element.getFilter().getQuery() != null) {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("adapter", new AdapterResourceFactoryImpl());
            GLAFilterHelper.addFilterToAdapter(null, (ResourceSet)resourceSet, input, element.getFilter().getQuery(), nameSpace);
        }
        LocalLogParserLoader parserLoader = new LocalLogParserLoader(parser, input);
        parserLoader.setXMLLoader((XMLLoader)xmlLoader);
        String filePath = (String)element.getValues().get("file_path");
        LocalLogImportJob job = filePath != null && (filePath.startsWith("ftp://") || filePath.startsWith("http://")) ? new LocalDownloadJob(LogUIMessages._7, input, element, parser, (XMLLoader)xmlLoader, parserLoader, trcAgent) : new LocalLogImportJob(LogUIMessages._7, element, parser, (XMLLoader)xmlLoader, parserLoader, trcAgent);
        job.addJobChangeListener((IJobChangeListener)this.jobListener);
        this.jobList.add(job);
    }

    protected void importFromRemoteHost(LogFileElement element, TRCProcessProxy trcProcess, TRCAgent trcAgent) throws Exception {
        Node node = PDCoreUtil.profileConnect((String)element.getHost(), (String)String.valueOf(element.getPort()));
        if (node == null) {
            trcAgent.getAgentProxy().setActive(false);
            if (this.fViewer != null) {
                this.fViewer.getViewer().refresh((Object)trcAgent.getAgentProxy());
            }
            return;
        }
        Hashtable userInput = this.getUserInput(element, true);
        if (element.getFilter() != null && element.getFilter().getQuery() != null) {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("adapter", new AdapterResourceFactoryImpl());
            String nameSpace = "org.eclipse.hyades.logging.adapter.config";
            if (element.getParser() != null && element.getParser().getNamespace() != null && element.getParser().getNamespace().length() > 0) {
                nameSpace = element.getParser().getNamespace();
            }
            String tempAdapterPath = GLAFilterHelper.addFilterToAdapter(node, (ResourceSet)resourceSet, userInput, element.getFilter().getQuery(), nameSpace);
            element.setTempAdapterPath(tempAdapterPath);
        }
        Process process = ProcessFactory.createProcess((Node)node, (String)"RemoteLogParserLoader", (String)this.getParserCommand(element, userInput));
        process.addProcessListener((ProcessListener)new ProcessListenerImpl(trcProcess, trcAgent.getAgentProxy()));
        Agent agent = AgentFactory.createAgent((Process)process, (String)"Remote Log Loader IRemoteEntity", (String)"Logging");
        TRCAgentProxy aproxy = trcAgent.getAgentProxy();
        agent.setAutoAttach(true);
        Agent errorAgent = AgentFactory.createAgent((Process)process, (String)"Remote Log Loader Error IRemoteEntity", (String)"Logging");
        errorAgent.setAutoAttach(true);
        Agent statusAgent = AgentFactory.createAgent((Process)process, (String)"Remote Log Loader Status IRemoteEntity", (String)"Logging");
        statusAgent.setAutoAttach(true);
        RemoteLogImportJob job = new RemoteLogImportJob(LogUIMessages._7, element, node, process, trcAgent);
        agent.addAgentListener((AgentListener)new LogAgentListener(job, aproxy, trcProcess));
        ErrorAgentListener errorListener = new ErrorAgentListener();
        errorAgent.addAgentListener((AgentListener)errorListener);
        job.setErrorListener(errorListener);
        statusAgent.addAgentListener((AgentListener)job);
        job.addJobChangeListener((IJobChangeListener)this.jobListener);
        this.jobList.add(job);
    }

    private int getLocalImportsCount() {
        int count = 0;
        LogImportJob job = null;
        if (this.jobList.size() == 0) {
            return 0;
        }
        int i = 0;
        while (i < this.jobList.size()) {
            job = (LogImportJob)((Object)this.jobList.get(i));
            if (job != null && job instanceof LocalLogImportJob) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    static /* synthetic */ boolean access$0(ImportLogWizard importLogWizard) {
        return importLogWizard.shouldOpenLogView;
    }

    static /* synthetic */ void access$8(ImportLogWizard importLogWizard, TRCAgent tRCAgent) {
        importLogWizard.openLogView(tRCAgent);
    }

    class ProcessListenerImpl
    implements ProcessListener {
        TRCAgentProxy trcAgent;
        TRCProcessProxy trcProcess;

        public ProcessListenerImpl(TRCProcessProxy process, TRCAgentProxy agent) {
            this.trcProcess = process;
            this.trcAgent = agent;
        }

        public void processExited(Process process) {
            this.trcAgent.setActive(false);
            this.trcAgent.setAttached(false);
            this.trcAgent.setMonitored(false);
            Display.getDefault().asyncExec(new Runnable(this){
                final /* synthetic */ ProcessListenerImpl this$1;
                {
                    this.this$1 = processListenerImpl;
                }

                public void run() {
                    if (ImportLogWizard.access$0(ProcessListenerImpl.access$0(this.this$1))) {
                        ProcessListenerImpl.access$0((ProcessListenerImpl)this.this$1).fViewer.getViewer().refresh((Object)this.this$1.trcAgent);
                    }
                }
            });
        }

        public void processLaunched(Process process) {
            try {
                if (this.trcProcess != null) {
                    this.trcProcess.setPid(Integer.parseInt(process.getProcessId()));
                    this.trcProcess.setRuntimeId(process.getUUID());
                    this.trcProcess.setActive(true);
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }

        static /* synthetic */ ImportLogWizard access$0(ProcessListenerImpl processListenerImpl) {
            return processListenerImpl.ImportLogWizard.this;
        }
    }

    class LogAgentListener
    implements AgentListener {
        private RemoteLogImportJob job;
        private TRCAgentProxy aproxy;
        private TRCProcessProxy trcProcess;

        public LogAgentListener(RemoteLogImportJob job, TRCAgentProxy aproxy, TRCProcessProxy trcProcess) {
            this.job = job;
            this.aproxy = aproxy;
            this.trcProcess = trcProcess;
        }

        public void agentActive(Agent agent) {
            this.aproxy.setActive(true);
            this.job.setLogAgentActive(true);
            this.job.resetTimeOut();
            this.aproxy.setAttached(true);
            this.aproxy.setMonitored(true);
            LoadersUtils.registerAgentInstance((TRCAgentProxy)this.aproxy, (Object)agent);
            if (CommunicationDebug.INSTANCE.debug) {
                System.out.println("Log agent active received agent=" + agent.getName());
            }
            Display.getDefault().asyncExec(new Runnable(this){
                final /* synthetic */ LogAgentListener this$1;
                {
                    this.this$1 = logAgentListener;
                }

                public void run() {
                    ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
                    event.setSource((Object)LogAgentListener.access$0(this.this$1));
                    event.setType(1);
                    UIPlugin.getDefault().notifyProfileEventListener(event);
                }
            });
            try {
                XMLTraceDataProcessor dataProcessor = new XMLTraceDataProcessor(this, this.aproxy){
                    final /* synthetic */ LogAgentListener this$1;
                    {
                        this.this$1 = logAgentListener;
                    }

                    public void dataServerExited() {
                        super.dataServerExited();
                        LoadersUtils.deregisterAgentInstance((TRCAgentProxy)LogAgentListener.access$0(this.this$1));
                        Display.getDefault().asyncExec(new Runnable(this){
                            final /* synthetic */ 3 this$2;
                            {
                                this.this$2 = var1_1;
                            }

                            public void run() {
                                ProfileEvent event = UIPlugin.getDefault().getRefreshViewEvent((Object)LogAgentListener.access$0(3.access$0(this.this$2)));
                                UIPlugin.getDefault().notifyProfileEventListener(event);
                            }
                        });
                    }

                    static /* synthetic */ LogAgentListener access$0(3 var0) {
                        return var0.this$1;
                    }
                };
                agent.startMonitoring((DataProcessor)dataProcessor);
            }
            catch (Exception e) {
                MonitoringLogUIPlugin.log(e);
                ImportLogWizard.this.errorMessage = MonitoringLogUIPlugin.getResourceString(LogUIMessages._11);
                ImportLogWizard.this.reasonAction = e.getLocalizedMessage();
                Status status = new Status(4, MonitoringLogUIPlugin.getPluginId(), 0, ImportLogWizard.this.errorMessage, (Throwable)e);
                this.job.setStatus((IStatus)status);
                this.job.setFinished(true);
            }
        }

        public void agentInactive(Agent agent) {
            this.job.setLogAgentActive(false);
            this.aproxy.setActive(false);
            this.aproxy.setAttached(false);
            this.aproxy.setMonitored(false);
            this.trcProcess.setActive(false);
            if (CommunicationDebug.INSTANCE.debug) {
                System.out.println("Log agent inactive received agent" + agent.getName());
            }
            this.job.setFinished(true);
            Display.getDefault().asyncExec(new Runnable(this){
                final /* synthetic */ LogAgentListener this$1;
                {
                    this.this$1 = logAgentListener;
                }

                public void run() {
                    ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
                    event.setSource((Object)LogAgentListener.access$0(this.this$1));
                    event.setType(16);
                    UIPlugin.getDefault().notifyProfileEventListener(event);
                }
            });
        }

        public void error(Agent agent, String errorId, String message) {
            ImportLogWizard.this.reasonAction = errorId.concat(": ").concat(message);
            ImportLogWizard.this.errorMessage = MonitoringLogUIPlugin.getResourceString(LogUIMessages._11);
            MultiStatus status = new MultiStatus(MonitoringLogUIPlugin.getPluginId(), 0, ImportLogWizard.this.errorMessage, null);
            if (ImportLogWizard.this.reasonAction != null) {
                status.add((IStatus)new Status(4, MonitoringLogUIPlugin.getPluginId(), 0, ImportLogWizard.this.reasonAction, null));
            }
            this.job.setStatus((IStatus)status);
            this.job.setFinished(true);
        }

        public void handleCommand(Agent agent, CommandElement command) {
        }

        static /* synthetic */ TRCAgentProxy access$0(LogAgentListener logAgentListener) {
            return logAgentListener.aproxy;
        }
    }

    class ErrorAgentListener
    implements AgentListener {
        private String errorAgentMessage = null;
        private boolean isActive = false;

        public void agentActive(Agent agent) {
            this.isActive = true;
            if (CommunicationDebug.INSTANCE.debug) {
                System.out.println("ErrorAgent active received agent=" + agent.getName());
            }
            try {
                Agent fAgent = agent;
                agent.startMonitoring(new DataProcessor(this, fAgent){
                    final /* synthetic */ ErrorAgentListener this$1;
                    private final /* synthetic */ Agent val$fAgent;
                    {
                        this.this$1 = errorAgentListener;
                        this.val$fAgent = agent;
                    }

                    public void incommingData(byte[] buffer, int length, InetAddress peer) {
                        try {
                            ErrorAgentListener.access$0(this.this$1, new String(buffer, 0, length, "UTF-8"));
                        }
                        catch (UnsupportedEncodingException e) {
                            MonitoringLogUIPlugin.log(e);
                        }
                        if (CommunicationDebug.INSTANCE.debug) {
                            System.out.println("errorAgentMessage=" + ErrorAgentListener.access$1(this.this$1) + " agent=" + this.val$fAgent.getName());
                        }
                    }

                    public void incommingData(char[] buffer, int length, InetAddress peer) {
                    }

                    public void invalidDataType(byte[] data, int length, InetAddress peer) {
                    }

                    public void waitingForData() {
                    }
                });
            }
            catch (Exception e) {
                this.errorAgentMessage = e.toString();
                Display.getDefault().asyncExec(new Runnable(this){
                    final /* synthetic */ ErrorAgentListener this$1;
                    {
                        this.this$1 = errorAgentListener;
                    }

                    public void run() {
                    }
                });
            }
        }

        public void agentInactive(Agent agent) {
            this.isActive = false;
            if (CommunicationDebug.INSTANCE.debug) {
                System.out.println("ErrorAgent inactive received agent=" + agent.getName());
            }
        }

        public void error(Agent agent, String errorId, String message) {
            this.errorAgentMessage = errorId.concat(": ").concat(message);
            if (CommunicationDebug.INSTANCE.debug) {
                System.out.println("error errorAgentMessage=" + this.errorAgentMessage + " agent" + agent.getName());
            }
        }

        public void handleCommand(Agent agent, CommandElement command) {
        }

        String getErrorMessage() {
            return this.errorAgentMessage;
        }

        boolean isActive() {
            return this.isActive;
        }

        static /* synthetic */ void access$0(ErrorAgentListener errorAgentListener, String string) {
            errorAgentListener.errorAgentMessage = string;
        }

        static /* synthetic */ String access$1(ErrorAgentListener errorAgentListener) {
            return errorAgentListener.errorAgentMessage;
        }
    }

    class LocalLogImportJob
    extends LogImportJob {
        private ILogParser parser = null;
        private XMLLoader xmlLoader = null;
        private LocalLogParserLoader parserLoader;

        LocalLogImportJob(String name, LogFileElement element, ILogParser parser, XMLLoader xmlLoader, LocalLogParserLoader parserLoader, TRCAgent trcAgent) {
            super(name);
            this.element = element;
            this.parser = parser;
            this.xmlLoader = xmlLoader;
            this.parserLoader = parserLoader;
            this.trcAgent = trcAgent;
        }

        ILogParser getParser() {
            return this.parser;
        }

        TRCAgent getTRCAgent() {
            return this.trcAgent;
        }

        IProgressMonitor getMonitor() {
            return this.mon;
        }

        boolean hasFinished() {
            return this.hasFinished;
        }

        void setFinished(boolean newValue) {
            this.hasFinished = newValue;
        }

        int[] getProgressStatus() {
            this.parseStatusString();
            return this.status;
        }

        String getTaskName() {
            return ImportLogWizard.this.getAgentName(this.element);
        }

        IStatus stop() {
            try {
                this.parser.stop();
            }
            catch (Exception e) {
                return new Status(4, MonitoringLogUIPlugin.getPluginId(), 0, MonitoringLogUIPlugin.getResourceString(LogUIMessages._8), (Throwable)e);
            }
            return new Status(0, MonitoringLogUIPlugin.getPluginId(), 0, "", null);
        }

        private void parseStatusString() {
            int startProcessed;
            int endProcessed;
            if (CommunicationDebug.INSTANCE.debug) {
                System.out.println("LocalLogImport ---- getStatus is called, element" + this.getTaskName());
            }
            this.statusString = this.parser.getStatus();
            if (this.statusString == null) {
                return;
            }
            if (CommunicationDebug.INSTANCE.debug) {
                System.out.println("LocalLogImport: STATUS_STRING = " + this.statusString + " element" + this.getTaskName());
            }
            if (!this.statusString.startsWith("total=") || this.statusString.indexOf("processed") < 0) {
                return;
            }
            if (this.status[0] == 0) {
                int stopTotal = this.statusString.indexOf(" ");
                this.status[0] = new Integer(this.statusString.substring(6, stopTotal));
                if (CommunicationDebug.INSTANCE.debug) {
                    System.out.println("LocalLogImport: TOTAL=" + this.status[0] + " element " + this.getTaskName());
                }
            }
            if ((endProcessed = this.statusString.indexOf(" ", startProcessed = this.statusString.indexOf("processed"))) < 0) {
                endProcessed = this.statusString.length();
            }
            this.status[1] = new Integer(this.statusString.substring(startProcessed + 10, endProcessed));
            if (CommunicationDebug.INSTANCE.debug) {
                System.out.println("LocalLogImport: PROCESSED=" + this.status[1] + " element " + this.getTaskName());
            }
        }

        protected IStatus run(IProgressMonitor monitor) {
            this.mon = monitor;
            this.trcAgent.getAgentProxy().setActive(true);
            if (ImportLogWizard.this.monitorThread != null) {
                ImportLogWizard.this.monitorThread.register(this);
            }
            return this.runOnLocalHost(monitor);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected IStatus runOnLocalHost(IProgressMonitor monitor) {
            LocalGLALogger glaLogger = new LocalGLALogger();
            this.parserLoader.setParserLogger(glaLogger);
            try {
                try {
                    this.xmlLoader.loadEvent("<CommonBaseEvents>".getBytes(), "<CommonBaseEvents>".getBytes().length);
                    this.parserLoader.startParsing();
                    this.xmlLoader.loadEvent("</CommonBaseEvents>".getBytes(), "</CommonBaseEvents>".getBytes().length);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    String param = (String)ImportLogWizard.this.getUserInput(this.element, false).get("file_path");
                    if (param == null) {
                        param = this.element.getParser().getName();
                    }
                    ImportLogWizard.this.errorMessage = NLS.bind((String)LogUIMessages._9, (Object)param);
                    MultiStatus mutliStatus = new MultiStatus(MonitoringLogUIPlugin.getPluginId(), 0, ImportLogWizard.this.errorMessage, (Throwable)e);
                    if (glaLogger.getLogDetails() != null) {
                        ImportLogWizard.this.detailMsg = glaLogger.getLogDetails().trim();
                        mutliStatus.add((IStatus)new Status(4, MonitoringLogUIPlugin.getPluginId(), 0, ImportLogWizard.this.detailMsg, null));
                    }
                    this.setStatus((IStatus)mutliStatus);
                    this.stop();
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    this.xmlLoader.cleanUp();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
            {
                Object var6_9 = null;
            }
            try {}
            catch (Exception exception) {}
            this.xmlLoader.cleanUp();
            if (this.jobStatus == null) {
                MultiStatus multiStatus = new MultiStatus(MonitoringLogUIPlugin.getPluginId(), 0, "", null);
                multiStatus.add((IStatus)new Status(0, MonitoringLogUIPlugin.getPluginId(), 0, "", null));
                this.setStatus((IStatus)multiStatus);
            }
            if (!CommunicationDebug.INSTANCE.debug) return this.jobStatus;
            System.out.println("LOCAL JOB " + this.getTaskName() + " FINISHED..." + this.jobStatus);
            return this.jobStatus;
        }
    }

    class RemoteLogImportJob
    extends LogImportJob
    implements AgentListener {
        private Node node = null;
        private Process process = null;
        private boolean monitoringFinished = false;
        private long startTime = 0L;
        private int timeout = 2000;
        private int importTimeOut = 25000;
        private List errorMessages = null;
        private ErrorAgentListener errorListener = null;
        private boolean isLogAgentActive = false;
        private boolean logAgentActiveEventReceived = false;
        private final int MAX_NR_OF_ERRORS_DISPLAYED = 100;

        RemoteLogImportJob(String name, LogFileElement element, Node node, Process process, TRCAgent trcAgent) {
            super(name);
            this.element = element;
            this.node = node;
            this.process = process;
            this.trcAgent = trcAgent;
        }

        Process getProcess() {
            return this.process;
        }

        TRCAgent getTRCAgent() {
            return this.trcAgent;
        }

        IProgressMonitor getMonitor() {
            return this.mon;
        }

        boolean hasFinished() {
            return this.hasFinished;
        }

        boolean isMonitoring() {
            return !this.monitoringFinished;
        }

        void setMonitoringFinished(boolean newValue) {
            this.monitoringFinished = newValue;
        }

        void setFinished(boolean newValue) {
            this.hasFinished = newValue;
        }

        int[] getProgressStatus() {
            this.parseStatusString();
            return this.status;
        }

        String getTaskName() {
            return ImportLogWizard.this.getAgentName(this.element);
        }

        void setErrorListener(ErrorAgentListener listener) {
            this.errorListener = listener;
        }

        List getErrorMessages() {
            return this.errorMessages;
        }

        boolean isLogAgentActive() {
            return this.isLogAgentActive;
        }

        void setLogAgentActive(boolean newValue) {
            this.isLogAgentActive = newValue;
            if (newValue) {
                this.logAgentActiveEventReceived = true;
            }
        }

        IStatus stop() {
            try {
                if (this.process != null && this.process.isActive()) {
                    Node vNode = this.process.getNode();
                    vNode.killProcess(this.process);
                }
            }
            catch (NotConnectedException exc1) {
                exc1.printStackTrace();
            }
            catch (InactiveProcessException exc2) {
                exc2.printStackTrace();
            }
            ProfileEvent pEvent = UIPlugin.getDefault().getProfileEvent();
            pEvent.setSource((Object)this.process);
            pEvent.setType(16);
            ProfileEvent fpEvent = pEvent;
            Display.getDefault().asyncExec(new Runnable(this, fpEvent){
                final /* synthetic */ RemoteLogImportJob this$1;
                private final /* synthetic */ ProfileEvent val$fpEvent;
                {
                    this.this$1 = remoteLogImportJob;
                    this.val$fpEvent = profileEvent;
                }

                public void run() {
                    UIPlugin.getDefault().notifyProfileEventListener(this.val$fpEvent);
                }
            });
            return new Status(0, MonitoringLogUIPlugin.getPluginId(), 0, "", null);
        }

        private void parseStatusString() {
            if (this.statusString == null) {
                return;
            }
            if (this.statusString.startsWith("total=") && this.statusString.indexOf("processed") > 0) {
                int startProcessed;
                int endProcessed;
                if (this.status[0] == 0) {
                    int stopTotal = this.statusString.indexOf(" ");
                    this.status[0] = new Integer(this.statusString.substring(6, stopTotal));
                    if (CommunicationDebug.INSTANCE.debug) {
                        System.out.println("RemoteImport.parseStatusString() TOTAL=" + this.status[0]);
                    }
                }
                if ((endProcessed = this.statusString.indexOf(" ", startProcessed = this.statusString.indexOf("processed"))) < 0) {
                    endProcessed = this.statusString.length();
                }
                this.status[1] = new Integer(this.statusString.substring(startProcessed + 10, endProcessed));
                if (CommunicationDebug.INSTANCE.debug) {
                    System.out.println("RemoteImport.parseStatusString() PROCESSED=" + this.status[1]);
                }
            } else if (this.statusString.startsWith("glalog=")) {
                String errString;
                if (this.errorMessages == null) {
                    this.errorMessages = new ArrayList();
                }
                if (!this.errorMessages.contains(errString = this.statusString.substring(7))) {
                    this.errorMessages.add(errString);
                }
            }
        }

        protected IStatus run(IProgressMonitor monitor) {
            this.mon = monitor;
            this.trcAgent.getAgentProxy().setActive(true);
            IStatus result = this.runOnRemoteHost(monitor);
            String tempAdapterPath = this.element.getTempAdapterPath();
            if (tempAdapterPath != null && tempAdapterPath.length() > 0) {
                GLAFilterHelper.deleteTempAdapter(this.node, tempAdapterPath);
            }
            return result;
        }

        protected IStatus runOnRemoteHost(IProgressMonitor monitor) {
            try {
                this.process.launch();
            }
            catch (NoSuchApplicationException n) {
                String parserClass = this.element.getParser().getId().trim();
                if (!parserClass.equals("com.ibm.etools.logging.parsers.WASActivityLogParser")) {
                    ImportLogWizard.this.errorMessage = LogUIMessages._11;
                    ImportLogWizard.this.reasonAction = LogUIMessages._13;
                    MultiStatus multiStatus = new MultiStatus(MonitoringLogUIPlugin.getPluginId(), 0, ImportLogWizard.this.errorMessage, (Throwable)n);
                    multiStatus.add((IStatus)new Status(4, MonitoringLogUIPlugin.getPluginId(), 0, ImportLogWizard.this.reasonAction, (Throwable)n));
                    return multiStatus;
                }
                Hashtable userInput = ImportLogWizard.this.getUserInput(this.element, true);
                String was_home = (String)userInput.get("was_home");
                String activityPath = (String)userInput.get("file_path");
                this.process = ProcessFactory.createProcess((Node)this.node, (String)"ActivityLogParser", (String)"com.ibm.etools.logging.was.WASActivityLogParser".concat(" \"").concat(activityPath).concat("\" \"").concat(was_home).concat("\""));
                this.process.addProcessListener((ProcessListener)new ProcessListenerImpl(this.trcAgent.getAgentProxy().getProcessProxy(), this.trcAgent.getAgentProxy()));
                Agent preV5ProcessAgent = AgentFactory.createAgent((Process)this.process, (String)"WAS Activity Log Agent", (String)"Logging");
                preV5ProcessAgent.setAutoAttach(true);
                preV5ProcessAgent.addAgentListener((AgentListener)new LogAgentListener(this, this.trcAgent.getAgentProxy(), this.trcAgent.getAgentProxy().getProcessProxy()));
                Agent preV5ErrorAgent = AgentFactory.createAgent((Process)this.process, (String)"WAS Activity Log Error Agent", (String)"Logging");
                preV5ErrorAgent.setAutoAttach(true);
                ErrorAgentListener errorAgentListener = new ErrorAgentListener();
                preV5ErrorAgent.addAgentListener((AgentListener)errorAgentListener);
                this.setErrorListener(errorAgentListener);
                try {
                    this.process.launch();
                }
                catch (Exception e) {
                    ImportLogWizard.this.errorMessage = LogUIMessages._11;
                    ImportLogWizard.this.reasonAction = LogUIMessages._12;
                    MonitoringLogUIPlugin.log(e);
                    MultiStatus multiStatus = new MultiStatus(MonitoringLogUIPlugin.getPluginId(), 0, ImportLogWizard.this.errorMessage, (Throwable)e);
                    multiStatus.add((IStatus)new Status(4, MonitoringLogUIPlugin.getPluginId(), 0, ImportLogWizard.this.reasonAction, (Throwable)e));
                    return multiStatus;
                }
            }
            catch (Exception e) {
                ImportLogWizard.this.errorMessage = LogUIMessages._11;
                ImportLogWizard.this.reasonAction = LogUIMessages._12;
                MonitoringLogUIPlugin.log(e);
                MultiStatus multiStatus = new MultiStatus(MonitoringLogUIPlugin.getPluginId(), 0, ImportLogWizard.this.errorMessage, (Throwable)e);
                multiStatus.add((IStatus)new Status(4, MonitoringLogUIPlugin.getPluginId(), 0, ImportLogWizard.this.reasonAction, (Throwable)e));
                return multiStatus;
            }
            return this.monitorProgress(monitor);
        }

        private IStatus monitorProgress(IProgressMonitor monitor) {
            boolean taskBegan = false;
            int workedUnits = 0;
            while (this.isActive()) {
                try {
                    this.status = this.getProgressStatus();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (!taskBegan && this.status[0] > 0) {
                    monitor.beginTask(this.getTaskName(), this.status[0]);
                    if (CommunicationDebug.INSTANCE.debug) {
                        System.out.println("REMOTE JOB: TOTAL WORK=" + this.status[0] + " element=" + this.getTaskName());
                    }
                    taskBegan = true;
                }
                if (this.status[0] != 0 && this.status[1] != 0 && this.status[0] <= this.status[1]) {
                    this.setFinished(true);
                    monitor.done();
                }
                if (monitor.isCanceled()) {
                    this.stop();
                    this.setFinished(true);
                    this.setStatus((IStatus)new Status(8, MonitoringLogUIPlugin.getPluginId(), 0, "", null));
                    monitor.done();
                }
                if (this.status[1] > 0) {
                    monitor.worked(this.status[1] - workedUnits);
                    if (CommunicationDebug.INSTANCE.debug) {
                        System.out.println("REMOTE JOB: WORKED=" + (this.status[1] - workedUnits) + " element=" + this.getTaskName());
                    }
                    int percent = this.status[1] * 100 / this.status[0];
                    monitor.subTask(String.valueOf(this.getTaskName()) + " " + percent + "%");
                    workedUnits = this.status[1];
                } else {
                    monitor.subTask(this.getTaskName());
                }
                try {
                    Thread.sleep(2000L);
                }
                catch (Exception exception) {}
            }
            if (this.hasErrors()) {
                this.generateErrorMessage();
            }
            if (this.jobStatus == null) {
                this.jobStatus = new Status(0, MonitoringLogUIPlugin.getPluginId(), 0, "", null);
            }
            monitor.done();
            if (CommunicationDebug.INSTANCE.debug) {
                System.out.println("REMOTE JOB FINISHED " + this.jobStatus);
            }
            return this.jobStatus;
        }

        private boolean hasErrors() {
            return this.errorListener != null && this.errorListener.getErrorMessage() != null || this.errorMessages != null && !this.errorMessages.isEmpty();
        }

        private boolean isActive() {
            if (CommunicationDebug.INSTANCE.debug) {
                System.out.println("monitoringFinished=" + this.monitoringFinished + ", isLogAgentActive=" + this.isLogAgentActive + ", logAgentActiveEventReceived=" + this.logAgentActiveEventReceived + ", hasFinished=" + this.hasFinished + ", errorListener.isActive()=" + this.errorListener.isActive());
            }
            if (!this.monitoringFinished) {
                if (!this.isLogAgentActive && !this.logAgentActiveEventReceived) {
                    if (!this.timeOut(this.importTimeOut)) {
                        return true;
                    }
                    String errMsg = LogUIMessages._82;
                    Status result = new Status(4, MonitoringLogUIPlugin.getPluginId(), 0, errMsg, null);
                    this.setStatus((IStatus)result);
                    return false;
                }
                if (!this.hasFinished || this.errorListener.isActive()) {
                    return true;
                }
                return !this.timeOut(this.timeout);
            }
            if (!this.hasFinished || this.errorListener.isActive()) {
                return true;
            }
            return !this.timeOut(this.timeout);
        }

        private boolean timeOut(int delta) {
            long currentTime;
            if (this.startTime == 0L) {
                this.startTime = System.currentTimeMillis();
            }
            return (currentTime = System.currentTimeMillis()) - this.startTime > (long)delta;
        }

        void resetTimeOut() {
            this.startTime = 0L;
        }

        public void agentActive(Agent agent) {
            try {
                DataProcessor dataProcessor = new DataProcessor(this){
                    final /* synthetic */ RemoteLogImportJob this$1;
                    {
                        this.this$1 = remoteLogImportJob;
                    }

                    public void incommingData(byte[] buffer, int length, InetAddress peer) {
                        try {
                            this.this$1.statusString = new String(buffer, 0, length, "UTF-8");
                        }
                        catch (UnsupportedEncodingException e) {
                            MonitoringLogUIPlugin.log(e);
                        }
                        RemoteLogImportJob.access$0(this.this$1);
                    }

                    public void incommingData(char[] buffer, int length, InetAddress peer) {
                    }

                    public void invalidDataType(byte[] data, int length, InetAddress peer) {
                    }

                    public void waitingForData() {
                    }
                };
                agent.startMonitoring(dataProcessor);
            }
            catch (Exception exception) {}
        }

        public void agentInactive(Agent agent) {
            this.setFinished(true);
            this.setMonitoringFinished(true);
        }

        private void generateErrorMessage() {
            if (this.errorMessages != null && this.errorMessages.size() > 0) {
                String mainErrMsg = (String)this.errorMessages.get(0);
                MultiStatus multiStatus = null;
                if (this.errorListener != null && this.errorListener.getErrorMessage() != null && this.errorListener.getErrorMessage().trim().length() > 0) {
                    mainErrMsg = this.errorListener.getErrorMessage();
                    StringTokenizer stringTokenizer = new StringTokenizer(mainErrMsg, "\r\n");
                    while (stringTokenizer.hasMoreTokens()) {
                        String token = stringTokenizer.nextToken();
                        if (token.length() <= 0) continue;
                        if (multiStatus == null) {
                            multiStatus = new MultiStatus(MonitoringLogUIPlugin.getPluginId(), 0, token, null);
                            continue;
                        }
                        multiStatus.add((IStatus)new Status(4, MonitoringLogUIPlugin.getPluginId(), 0, token, null));
                    }
                    if (multiStatus == null) {
                        multiStatus = new MultiStatus(MonitoringLogUIPlugin.getPluginId(), 0, mainErrMsg, null);
                    }
                }
                StringBuffer errMsg = new StringBuffer();
                int min = Math.min(100, this.errorMessages.size());
                int i = 0;
                while (i < min) {
                    errMsg.append(this.errorMessages.get(i));
                    multiStatus.add((IStatus)new Status(4, MonitoringLogUIPlugin.getPluginId(), 0, this.errorMessages.get(i).toString(), null));
                    ++i;
                }
                this.setStatus((IStatus)multiStatus);
            } else if (this.errorListener != null && this.errorListener.getErrorMessage() != null && this.errorListener.getErrorMessage().trim().length() > 0) {
                Status result = null;
                StringTokenizer stringTokenizer = new StringTokenizer(this.errorListener.getErrorMessage(), "\r\n");
                if (stringTokenizer.countTokens() > 1) {
                    while (stringTokenizer.hasMoreTokens()) {
                        String token = stringTokenizer.nextToken();
                        if (token.length() <= 0) continue;
                        if (result == null) {
                            result = new MultiStatus(MonitoringLogUIPlugin.getPluginId(), 0, token, null);
                            continue;
                        }
                        ((MultiStatus)result).add((IStatus)new Status(4, MonitoringLogUIPlugin.getPluginId(), 0, token, null));
                    }
                }
                if (result == null) {
                    result = new Status(4, MonitoringLogUIPlugin.getPluginId(), 0, this.errorListener.getErrorMessage(), null);
                }
                this.setStatus((IStatus)result);
            }
        }

        public void error(Agent agent, String errorId, String message) {
        }

        public void handleCommand(Agent agent, CommandElement command) {
        }

        static /* synthetic */ void access$0(RemoteLogImportJob remoteLogImportJob) {
            remoteLogImportJob.parseStatusString();
        }
    }

    abstract class LogImportJob
    extends Job {
        protected LogFileElement element = null;
        protected TRCAgent trcAgent = null;
        protected boolean hasFinished = false;
        protected int[] status = new int[2];
        protected IProgressMonitor mon = null;
        protected String statusString = null;
        protected IStatus jobStatus = null;

        LogImportJob(String name) {
            super(name);
        }

        abstract int[] getProgressStatus();

        IStatus getStatus() {
            return this.jobStatus;
        }

        public void setStatus(IStatus newStatus) {
            this.jobStatus = newStatus;
        }

        abstract void setFinished(boolean var1);

        abstract boolean hasFinished();

        abstract IStatus stop();

        abstract TRCAgent getTRCAgent();
    }

    class LocalDownloadJob
    extends LocalLogImportJob {
        byte[] buffer = new byte[0x200000];
        Map table;

        LocalDownloadJob(String name, Map input, LogFileElement element, ILogParser parser, XMLLoader xmlLoader, LocalLogParserLoader parserLoader, TRCAgent trcAgent) {
            super(name, element, parser, xmlLoader, parserLoader, trcAgent);
            this.table = input;
        }

        private boolean isZipFile(InputStream inputStream) throws IOException {
            byte[] headerSignature = new byte[4];
            return inputStream.read(headerSignature) > 1 && headerSignature[0] == 80 && headerSignature[1] == 75 && headerSignature[2] == 3 && headerSignature[3] == 4;
        }

        protected IStatus run(IProgressMonitor monitor) {
            String fileURL = (String)this.element.getValues().get("file_path");
            String key = GLAHelper.getAdapterPathKey((Map)this.table);
            try {
                monitor.beginTask(this.getTaskName(), -1);
                monitor.subTask(" " + NLS.bind((String)LogUIMessages._95, (Object)fileURL));
                Authenticator authenticator = new Authenticator(this, fileURL){
                    ImportLogPasswordAuthentication importLogAuthentication;
                    final /* synthetic */ LocalDownloadJob this$1;
                    private final /* synthetic */ String val$fileURL;
                    {
                        this.this$1 = localDownloadJob;
                        this.val$fileURL = string;
                        this.importLogAuthentication = null;
                    }

                    protected PasswordAuthentication getPasswordAuthentication() {
                        this.importLogAuthentication = new ImportLogPasswordAuthentication();
                        Display.getDefault().syncExec(new Runnable(this, this.val$fileURL){
                            final /* synthetic */ 10 this$2;
                            private final /* synthetic */ String val$fileURL;
                            {
                                this.this$2 = var1_1;
                                this.val$fileURL = string;
                            }

                            public void run() {
                                PasswordDialog pwdDialog = new PasswordDialog(LocalDownloadJob.access$0(10.access$0(this.this$2)).getShell(), LogUIMessages._96, null, this.val$fileURL, this.this$2.importLogAuthentication);
                                if (pwdDialog.open() == 1) {
                                    this.this$2.importLogAuthentication = null;
                                }
                            }
                        });
                        return this.importLogAuthentication.getAuthentication();
                    }

                    static /* synthetic */ LocalDownloadJob access$0(10 var0) {
                        return var0.this$1;
                    }
                };
                Authenticator.setDefault(authenticator);
                URLConnection connection = new URL(fileURL).openConnection();
                InputStream inputStream = connection.getInputStream();
                IPath stateLocation = MonitoringLogUIPlugin.getDefault().getStateLocation();
                SimpleDateFormat format = new SimpleDateFormat("yyyymmddhhMMss");
                String prefixDir = String.valueOf(stateLocation.makeAbsolute().toString()) + "/tmp" + format.format(new Date());
                File parent = new File(prefixDir);
                if (parent != null && !parent.exists()) {
                    parent.mkdirs();
                }
                inputStream = new BufferedInputStream(inputStream, 65536);
                inputStream.mark(5);
                if (this.isZipFile(inputStream)) {
                    inputStream.reset();
                    ZipInputStream zipInputStream = new ZipInputStream(inputStream);
                    while (zipInputStream.available() > -1) {
                        ZipEntry entry = zipInputStream.getNextEntry();
                        if (entry == null) {
                            if (!CommunicationDebug.INSTANCE.debug) break;
                            System.out.println("End of zip file " + fileURL);
                            break;
                        }
                        String fileName = entry.getName();
                        int i = fileName.indexOf(".");
                        String namePrefix = i > 0 ? fileName.substring(0, i) : fileName;
                        String nameSuffix = i > 0 ? fileName.substring(i + 1) : "log";
                        File file = File.createTempFile(namePrefix, nameSuffix, parent);
                        if (entry.isDirectory()) {
                            file.mkdir();
                            continue;
                        }
                        file.deleteOnExit();
                        this.copyInputStream(zipInputStream, new BufferedOutputStream(new FileOutputStream(file)));
                        zipInputStream.closeEntry();
                    }
                    zipInputStream.close();
                    if (key != null) {
                        this.table.put("file_path", parent + "/\".*\"");
                    }
                } else {
                    inputStream.reset();
                    int i = fileURL.lastIndexOf(47);
                    int j = fileURL.lastIndexOf(46);
                    String namePrefix = i > 0 && j > 0 ? fileURL.substring(i + 1, j) : "tmp" + format.format(new Date());
                    String nameSuffix = i > 0 && j > 0 ? fileURL.substring(j + 1) : "log";
                    File file = File.createTempFile(namePrefix, nameSuffix, parent);
                    file.deleteOnExit();
                    this.copyInputStream(inputStream, new BufferedOutputStream(new FileOutputStream(file)));
                    if (key != null) {
                        this.table.put("file_path", file.getAbsolutePath());
                    }
                }
                inputStream.close();
            }
            catch (Exception ioe) {
                if (CommunicationDebug.INSTANCE.debug) {
                    System.out.println("Exception caught while downloading the file " + fileURL);
                    ioe.printStackTrace();
                }
                ImportLogWizard.this.reasonAction = NLS.bind((String)LogUIMessages._98, (Object)fileURL);
                this.setStatus((IStatus)new Status(4, MonitoringLogUIPlugin.getPluginId(), 0, ImportLogWizard.this.reasonAction, (Throwable)ioe));
                return this.jobStatus;
            }
            return super.run(monitor);
        }

        public final void copyInputStream(InputStream in, OutputStream out) throws IOException {
            int len;
            while ((len = in.read(this.buffer)) >= 0) {
                out.write(this.buffer, 0, len);
            }
            out.close();
        }

        static /* synthetic */ ImportLogWizard access$0(LocalDownloadJob localDownloadJob) {
            return localDownloadJob.ImportLogWizard.this;
        }
    }

    class LogImportJobListener
    extends JobChangeAdapter {
        LogImportJobListener() {
        }

        public void done(IJobChangeEvent event) {
            if (event.getResult().getSeverity() == 8) {
                ((LogImportJob)event.getJob()).stop();
            }
            ((LogImportJob)event.getJob()).setFinished(true);
            ((LogImportJob)event.getJob()).getTRCAgent().getAgentProxy().setActive(false);
            IJobChangeEvent fEvent = event;
            Display.getDefault().asyncExec(new Runnable(this, fEvent){
                final /* synthetic */ LogImportJobListener this$1;
                private final /* synthetic */ IJobChangeEvent val$fEvent;
                {
                    this.this$1 = logImportJobListener;
                    this.val$fEvent = iJobChangeEvent;
                }

                public void run() {
                    if (LogImportJobListener.access$0((LogImportJobListener)this.this$1).fViewer != null) {
                        LogImportJobListener.access$0((LogImportJobListener)this.this$1).fViewer.getViewer().refresh((Object)((LogImportJob)this.val$fEvent.getJob()).getTRCAgent().getAgentProxy());
                    }
                }
            });
            if (((LogImportJob)event.getJob()).getTRCAgent() == ImportLogWizard.this.displayAgent) {
                ImportLogWizard.this.refreshView(((LogImportJob)event.getJob()).getTRCAgent().getAgentProxy());
                Display.getDefault().asyncExec(new Runnable(this){
                    final /* synthetic */ LogImportJobListener this$1;
                    {
                        this.this$1 = logImportJobListener;
                    }

                    public void run() {
                        if (ImportLogWizard.access$0(LogImportJobListener.access$0(this.this$1))) {
                            ((TreeViewer)LogImportJobListener.access$0((LogImportJobListener)this.this$1).fViewer.getViewer()).setExpandedState((Object)LogImportJobListener.access$0((LogImportJobListener)this.this$1).fViewer.getContentProvider().getLogFolder(), true);
                            LogImportJobListener.access$0((LogImportJobListener)this.this$1).fViewer.getViewer().setSelection((ISelection)new StructuredSelection((Object)ImportLogWizard.access$6(LogImportJobListener.access$0(this.this$1)).getAgentProxy()));
                            ImportLogWizard.access$8(LogImportJobListener.access$0(this.this$1), ImportLogWizard.access$6(LogImportJobListener.access$0(this.this$1)));
                        }
                    }
                });
            }
        }

        static /* synthetic */ ImportLogWizard access$0(LogImportJobListener logImportJobListener) {
            return logImportJobListener.ImportLogWizard.this;
        }
    }

    class StatusListener
    extends Thread {
        private int s;
        private LocalLogImportJob[] jobs;

        public StatusListener(int s) {
            this.s = s;
            this.initialize();
        }

        private void initialize() {
            this.jobs = new LocalLogImportJob[this.s];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            int[] status = null;
            long[] startTime = new long[this.s];
            boolean[] tasksBegan = new boolean[this.s];
            int[] unitsWorked = new int[this.s];
            int k = 0;
            while (k < this.s) {
                tasksBegan[k] = false;
                ++k;
            }
            LocalLogImportJob element = null;
            boolean end = false;
            while (!end) {
                int i = 0;
                while (i < this.s) {
                    LocalLogImportJob[] localLogImportJobArray = this.jobs;
                    // MONITORENTER : this.jobs
                    element = this.jobs[i];
                    if (element != null && !element.hasFinished()) {
                        if (startTime[i] == 0L) {
                            startTime[i] = System.currentTimeMillis();
                        }
                        try {
                            status = element.getProgressStatus();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (!tasksBegan[i] && status[0] > 0) {
                            element.getMonitor().beginTask(element.getTaskName(), status[0]);
                            if (CommunicationDebug.INSTANCE.debug) {
                                System.out.println("MONITORING THREAD: TOTAL WORK=" + status[0] + " element " + element.getTaskName());
                            }
                            tasksBegan[i] = true;
                        }
                        if (status[0] != 0 && status[1] != 0 && status[0] <= status[1]) {
                            element.setFinished(true);
                            element.getMonitor().done();
                        }
                        if (element.getMonitor().isCanceled()) {
                            element.setStatus((IStatus)new Status(8, MonitoringLogUIPlugin.getPluginId(), 0, "", null));
                            element.stop();
                            element.setFinished(true);
                            element.getMonitor().done();
                        }
                        if (status[1] > 0) {
                            element.getMonitor().worked(status[1] - unitsWorked[i]);
                            if (CommunicationDebug.INSTANCE.debug) {
                                System.out.println("MONITORING THREAD: WORKED=" + (status[1] - unitsWorked[i]) + " element " + element.getTaskName());
                            }
                            int percent = status[1] * 100 / status[0];
                            element.getMonitor().subTask(" " + NLS.bind((String)LogUIMessages._99, (Object)Integer.toString(percent)));
                            unitsWorked[i] = status[1];
                        } else {
                            element.getMonitor().subTask(element.getTaskName());
                        }
                    }
                    end = true;
                    boolean jobStatus = false;
                    int j = 0;
                    while (true) {
                        if (j >= this.s) {
                            // MONITOREXIT : localLogImportJobArray
                            break;
                        }
                        boolean bl = jobStatus = this.jobs[j] != null ? this.jobs[j].hasFinished() : false;
                        if (jobStatus) {
                            this.jobs[j].getMonitor().done();
                        }
                        end = end && jobStatus;
                        ++j;
                    }
                    if (CommunicationDebug.INSTANCE.debug) {
                        System.out.println("MONITORING THREAD ENDED=" + end);
                    }
                    ++i;
                }
                try {
                    StatusListener.sleep(2000L);
                }
                catch (Exception exception) {}
            }
        }

        public synchronized LocalLogImportJob[] getJobs() {
            return this.jobs;
        }

        public synchronized void register(LocalLogImportJob job) {
            int len = this.jobs.length;
            int j = 0;
            while (j < len) {
                if (this.jobs[j] == null) {
                    this.jobs[j] = job;
                    break;
                }
                ++j;
            }
        }

        public synchronized boolean hasRegistered(LocalLogImportJob job) {
            int len = this.jobs.length;
            int j = 0;
            while (j < len) {
                if (this.jobs[j] == job) {
                    return true;
                }
                ++j;
            }
            return false;
        }
    }
}

