/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.monitoring.logui.internal.wizards;

import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.ui.filters.internal.util.FilterInformationManager;
import org.eclipse.hyades.ui.filters.internal.util.FilterQueries;
import org.eclipse.hyades.ui.internal.util.XMLUtil;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.tptp.monitoring.logui.internal.LogUIMessages;
import org.eclipse.tptp.monitoring.logui.internal.MonitoringLogUIPlugin;
import org.eclipse.tptp.monitoring.logui.internal.MonitoringLogUIPluginImages;
import org.eclipse.tptp.monitoring.logui.internal.wizards.BasicParserField;
import org.eclipse.tptp.monitoring.logui.internal.wizards.CommonParserField;
import org.eclipse.tptp.monitoring.logui.internal.wizards.DateParserField;
import org.eclipse.tptp.monitoring.logui.internal.wizards.LogFileDetailsUI;
import org.eclipse.tptp.monitoring.logui.internal.wizards.LogFileElement;
import org.eclipse.tptp.monitoring.logui.internal.wizards.LogParserItem;
import org.eclipse.tptp.monitoring.logui.internal.wizards.LogParserSet;
import org.eclipse.tptp.monitoring.logui.internal.wizards.LogSetDialog;
import org.eclipse.tptp.monitoring.logui.internal.wizards.ParserField;
import org.eclipse.tptp.monitoring.logui.internal.wizards.ParserParameter;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ImportLogWizardPage
extends WizardPage
implements SelectionListener {
    public static final int NEW_LOGSET = 0;
    public static final int OPEN_LOGSET = 1;
    public static final int EDIT_LOGSET = 2;
    public static final int RENAME_LOGSET = 3;
    private final String LOGSETS_KEY = "logsets";
    private final String LOGSET_TAG = "logset";
    private final String LOGELEMENT_TAG = "LogFileElement";
    private final String DEFAULT_LOGSET = LogUIMessages._54;
    public static final int ADD = 4;
    public static final int EDIT = 5;
    public static final int BUTTON_WIDTH = 90;
    private Table logsTable;
    private TableViewer fTableViewer;
    private List logElements = new ArrayList();
    private Button addBtn;
    private Button removeBtn;
    private Button editBtn;
    private Button newLogSetBtn;
    private Button openLogSetBtn;
    private Button editLogSetBtn;
    private LogFileElement selection;
    private LogFileDetailsUI dialog;
    private LogSetDialog logSetDialog;
    private Label logset_desc;
    private Label type_label;
    private LogSetManager lsMgr;
    private int dialog_type;

    public ImportLogWizardPage() {
        super("ImportLogWizardPage");
        this.setTitle(LogUIMessages._43);
        this.setDescription(LogUIMessages._44);
        this.setImageDescriptor(MonitoringLogUIPluginImages.getImageDescriptor("importactivitylog_wiz.gif"));
    }

    public void createControl(Composite parent) {
        Composite result = new Composite(parent, 0);
        result.setLayoutData((Object)GridUtil.createFill());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        result.setLayout((Layout)layout);
        this.logset_desc = new Label(result, 0);
        GridData data = GridUtil.createHorizontalFill();
        data.horizontalSpan = 2;
        this.logset_desc.setLayoutData((Object)data);
        this.logset_desc.setFont(JFaceResources.getBannerFont());
        Label logs_desc = new Label(result, 0);
        data = GridUtil.createHorizontalFill();
        data.horizontalSpan = 2;
        logs_desc.setLayoutData((Object)data);
        logs_desc.setText(LogUIMessages._45);
        this.createLogTable(result);
        Composite buttonGrp = new Composite(result, 0);
        GridData btnData = GridUtil.createFill();
        GridLayout btnLayout = new GridLayout();
        btnLayout.numColumns = 1;
        btnData.verticalAlignment = 1;
        buttonGrp.setLayout((Layout)btnLayout);
        buttonGrp.setLayoutData((Object)btnData);
        int len = this.computeButtonsMinWidth((Control)result);
        this.createLogButtons(buttonGrp, len);
        this.createLogSetButtons(buttonGrp, len);
        this.type_label = new Label(result, 64);
        data = GridUtil.createHorizontalFill();
        data.horizontalSpan = 2;
        data.heightHint = 30;
        this.type_label.setLayoutData((Object)data);
        this.loadDefaultLogSet();
        this.setControl((Control)result);
        this.setPageComplete(false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, String.valueOf(MonitoringLogUIPlugin.getPluginId()) + ".pp0000");
        parent.setFocus();
    }

    protected void loadDefaultLogSet() {
        this.lsMgr = new LogSetManager();
        this.lsMgr.initDefault();
        this.lsMgr.loadLogSets();
    }

    private void createLogTable(Composite parent) {
        this.logsTable = new Table(parent, 68354);
        GridData tblData = GridUtil.createFill();
        tblData.heightHint = 75;
        tblData.widthHint = 330;
        this.logsTable.setLayoutData((Object)tblData);
        new TableColumn(this.logsTable, 0);
        TableColumn column1 = new TableColumn(this.logsTable, 0);
        column1.setText(LogUIMessages._17);
        TableColumn column2 = new TableColumn(this.logsTable, 0);
        column2.setText(LogUIMessages._18);
        ColumnWeightData c0Layout = new ColumnWeightData(10, false);
        ColumnWeightData c1Layout = new ColumnWeightData(50, true);
        ColumnWeightData c2Layout = new ColumnWeightData(125, true);
        TableLayout tblLayout = new TableLayout();
        tblLayout.addColumnData((ColumnLayoutData)c0Layout);
        tblLayout.addColumnData((ColumnLayoutData)c1Layout);
        tblLayout.addColumnData((ColumnLayoutData)c2Layout);
        this.logsTable.setLayout((Layout)tblLayout);
        this.logsTable.setHeaderVisible(true);
        this.logsTable.setLinesVisible(true);
        this.fTableViewer = new TableViewer(this.logsTable);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.fTableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.fTableViewer.setInput((Object)this.logElements);
        this.logsTable.addSelectionListener((SelectionListener)this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.logsTable, String.valueOf(MonitoringLogUIPlugin.getPluginId()) + ".pp0000");
    }

    private void createLogButtons(Composite parent, int len) {
        this.addBtn = new Button(parent, 8);
        this.addBtn.setText(LogUIMessages._19);
        GridData btnData = GridUtil.createHorizontalFill();
        btnData.widthHint = len;
        btnData.horizontalAlignment = 2;
        this.addBtn.setLayoutData((Object)btnData);
        this.editBtn = new Button(parent, 8);
        this.editBtn.setText(LogUIMessages._20);
        btnData = GridUtil.createHorizontalFill();
        btnData.widthHint = len;
        btnData.horizontalAlignment = 2;
        this.editBtn.setLayoutData((Object)btnData);
        this.removeBtn = new Button(parent, 8);
        this.removeBtn.setText(LogUIMessages._21);
        btnData = GridUtil.createHorizontalFill();
        btnData.widthHint = len;
        btnData.horizontalAlignment = 2;
        this.removeBtn.setLayoutData((Object)btnData);
        this.addBtn.addSelectionListener((SelectionListener)this);
        this.editBtn.addSelectionListener((SelectionListener)this);
        this.removeBtn.addSelectionListener((SelectionListener)this);
        this.updateButtons();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.addBtn, String.valueOf(MonitoringLogUIPlugin.getPluginId()) + ".pp0010");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.editBtn, String.valueOf(MonitoringLogUIPlugin.getPluginId()) + ".pp0020");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.removeBtn, String.valueOf(MonitoringLogUIPlugin.getPluginId()) + ".pp0030");
    }

    private void createLogSetButtons(Composite parent, int len) {
        Label space = new Label(parent, 0);
        GridData data = GridUtil.createVerticalFill();
        data.heightHint = 120;
        space.setLayoutData((Object)data);
        this.newLogSetBtn = new Button(parent, 8);
        this.newLogSetBtn.setText(LogUIMessages._26);
        GridData btnData = GridUtil.createHorizontalFill();
        btnData.widthHint = len;
        btnData.horizontalAlignment = 2;
        this.newLogSetBtn.setLayoutData((Object)btnData);
        this.openLogSetBtn = new Button(parent, 8);
        this.openLogSetBtn.setText(LogUIMessages._27);
        btnData = GridUtil.createHorizontalFill();
        btnData.widthHint = len;
        btnData.horizontalAlignment = 2;
        this.openLogSetBtn.setLayoutData((Object)btnData);
        this.editLogSetBtn = new Button(parent, 8);
        this.editLogSetBtn.setText(LogUIMessages._28);
        btnData = GridUtil.createHorizontalFill();
        btnData.widthHint = len;
        btnData.horizontalAlignment = 2;
        this.editLogSetBtn.setLayoutData((Object)btnData);
        this.newLogSetBtn.addSelectionListener((SelectionListener)this);
        this.openLogSetBtn.addSelectionListener((SelectionListener)this);
        this.editLogSetBtn.addSelectionListener((SelectionListener)this);
        this.updateButtons();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.newLogSetBtn, String.valueOf(MonitoringLogUIPlugin.getPluginId()) + ".ls0000");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.openLogSetBtn, String.valueOf(MonitoringLogUIPlugin.getPluginId()) + ".ls0010");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.editLogSetBtn, String.valueOf(MonitoringLogUIPlugin.getPluginId()) + ".ls0020");
    }

    private int computeButtonsMinWidth(Control control) {
        int maxLen1 = Math.max(Math.max(LogUIMessages._19.length(), LogUIMessages._20.length()), LogUIMessages._21.length());
        int maxLen2 = Math.max(Math.max(LogUIMessages._26.length(), LogUIMessages._27.length()), LogUIMessages._28.length());
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        FontMetrics fm = gc.getFontMetrics();
        String language = Locale.getDefault().getLanguage();
        int chars = language.equals(Locale.JAPANESE.getLanguage()) || language.equals(Locale.KOREAN.getLanguage()) || language.equals(Locale.CHINESE.getLanguage()) ? Math.max(maxLen1, maxLen2) * 2 + 4 : Math.max(maxLen1, maxLen2) + 4;
        gc.dispose();
        return Math.max(Dialog.convertWidthInCharsToPixels((FontMetrics)fm, (int)chars), 90);
    }

    private void updateButtons() {
        if (this.logElements.size() == 0) {
            this.editBtn.setEnabled(false);
            this.removeBtn.setEnabled(false);
            return;
        }
        this.editBtn.setEnabled(this.logsTable.getSelectionCount() > 0);
        this.removeBtn.setEnabled(this.logsTable.getSelectionCount() > 0);
    }

    public void refresh() {
        this.fTableViewer.refresh();
    }

    public boolean finish() {
        this.lsMgr.saveLogSets();
        return true;
    }

    public void dispose() {
        this.lsMgr.getLogSets().clear();
        this.lsMgr.getLogSetsClone().clear();
        this.lsMgr.getParserRegistry().clear();
        this.lsMgr.getParserSetRegistry().clear();
        super.dispose();
    }

    public void addElement(LogFileElement element) {
        this.logElements.add(element);
        ArrayList<LogFileElement> logList = (ArrayList<LogFileElement>)this.lsMgr.getLogSets().get(this.lsMgr.getDefaultLogSet());
        if (logList == null) {
            logList = new ArrayList<LogFileElement>();
            logList.add(element);
            this.lsMgr.getLogSets().put(this.lsMgr.getDefaultLogSet(), logList);
        } else {
            logList.add(element);
        }
    }

    public void removeElement(LogFileElement element) {
        this.logElements.remove(element);
        List logList = (List)this.lsMgr.getLogSets().get(this.lsMgr.getDefaultLogSet());
        if (logList != null) {
            logList.remove(element);
        }
    }

    public void removeAllElement() {
        List logList = (List)this.lsMgr.getLogSets().get(this.lsMgr.getDefaultLogSet());
        if (logList != null) {
            logList.clear();
        }
        this.setPageComplete(this.isPageComplete());
        this.updateButtons();
    }

    public LogFileElement getSelectedElement() {
        return this.selection;
    }

    public void setSelectedElement(LogFileElement selection) {
        this.selection = selection;
    }

    public List getLogFileElements() {
        return this.logElements;
    }

    public boolean isPageComplete() {
        List elem = this.getLogFileElements();
        boolean complete = elem.size() > 0;
        Iterator iter = elem.iterator();
        while (iter.hasNext()) {
            LogFileElement element = (LogFileElement)iter.next();
            element.setValid(this.isLogElementValid(element));
            boolean bl = complete = complete && element.isValid();
        }
        return complete;
    }

    public LogFileDetailsUI getDialog(int type) {
        if (this.dialog == null || type != this.dialog_type) {
            this.dialog_type = type;
            this.dialog = new LogFileDetailsUI(this.getShell(), this, type);
        }
        return this.dialog;
    }

    public LogFileDetailsUI getDialog() {
        return this.dialog;
    }

    public void setDialog(LogFileDetailsUI _dialog) {
        this.dialog = _dialog;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.addBtn) {
            this.selection = new LogFileElement();
            this.addElement(this.selection);
            this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)this.selection));
            this.getDialog(4).setWindowTitle(LogUIMessages._15);
            if (this.getDialog(4).open() == 0) {
                this.refresh();
            } else {
                this.removeElement(this.selection);
            }
            this.dialog = null;
        } else if (e.widget == this.editBtn) {
            this.getDialog(5).setWindowTitle(LogUIMessages._16);
            if (this.getDialog(5).open() == 0) {
                this.refresh();
            }
            this.dialog = null;
        } else if (e.widget == this.removeBtn) {
            IStructuredSelection sel = (IStructuredSelection)this.fTableViewer.getSelection();
            if (!sel.isEmpty()) {
                Iterator iter = sel.iterator();
                while (iter.hasNext()) {
                    LogFileElement element = (LogFileElement)iter.next();
                    this.removeElement(element);
                }
            }
            this.type_label.setText("");
            this.refresh();
        } else if (e.widget == this.logsTable) {
            int index = this.logsTable.getSelectionIndex();
            this.selection = (LogFileElement)this.logElements.get(index);
            this.type_label.setText(this.selection.getParser().getDescription());
        } else if (e.widget == this.newLogSetBtn) {
            this.onNewLogSetAction();
        } else if (e.widget == this.openLogSetBtn) {
            this.onOpenLogSetAction();
        } else if (e.widget == this.editLogSetBtn) {
            this.onEditLogSetsAction();
        }
        this.setPageComplete(this.isPageComplete());
        this.updateButtons();
    }

    private void onNewLogSetAction() {
        this.logSetDialog = new LogSetDialog(this.getShell(), 0);
        this.logSetDialog.setLogSets(this.lsMgr.getLogSets());
        this.type_label.setText("");
        if (this.logSetDialog.open() == 0) {
            this.addEmptyLogSet(this.logSetDialog.getDefaultLogSet());
        }
    }

    public void addEmptyLogSet(String newLogSetName) {
        this.lsMgr.setDefaultLogSet(newLogSetName);
        this.lsMgr.getLogSets().put(this.lsMgr.getDefaultLogSet(), null);
        this.updateLogSetDescription(this.lsMgr.getDefaultLogSet());
        this.getLogFileElements().clear();
        this.refresh();
        this.setPageComplete(this.isPageComplete());
    }

    public void removeLogSet(String logSetName) {
        this.lsMgr.getLogSets().remove(logSetName);
    }

    private void onOpenLogSetAction() {
        this.logSetDialog = new LogSetDialog(this.getShell(), 1, this);
        this.logSetDialog.setLogSets(this.lsMgr.getLogSets());
        this.logSetDialog.setDefaultLogSet(this.lsMgr.getDefaultLogSet());
        if (this.logSetDialog.open() == 0 && this.logSetDialog.hasLogSetSelectionChanged()) {
            this.lsMgr.setDefaultLogSet(this.logSetDialog.getDefaultLogSet());
            this.updateLogSetDescription(this.logSetDialog.getDefaultLogSet());
            this.lsMgr.openLogSet(this.logSetDialog.getDefaultLogSet());
            this.setPageComplete(this.isPageComplete());
        }
    }

    private void onEditLogSetsAction() {
        this.logSetDialog = new LogSetDialog(this.getShell(), 2, this);
        this.logSetDialog.setLogSets(this.lsMgr.getLogSetsClone());
        this.logSetDialog.setDefaultLogSet(this.lsMgr.getDefaultLogSet());
        if (this.logSetDialog.open() == 0) {
            this.lsMgr.getLogSets().clear();
            this.lsMgr.getLogSets().putAll(this.logSetDialog.getLogSets());
            this.lsMgr.getLogSetsClone().clear();
            if (this.logSetDialog.getDefaultLogSet() == null) {
                this.lsMgr.setDefaultLogSet(this.DEFAULT_LOGSET);
                this.getLogFileElements().clear();
                this.refresh();
            } else if (this.logSetDialog.hasCurrentLogSetChanged()) {
                this.lsMgr.setDefaultLogSet(this.logSetDialog.getDefaultLogSet());
                this.lsMgr.openLogSet(this.logSetDialog.getDefaultLogSet());
            }
            this.setPageComplete(this.isPageComplete());
            this.updateLogSetDescription(this.lsMgr.getDefaultLogSet());
        }
    }

    public boolean isLogElementValid(LogFileElement elem) {
        return true;
    }

    public void initLocation() {
        this.dialog.initializeLocation();
    }

    public void updateLogSetDescription(String desc) {
        String text = LogUIMessages._40;
        text = NLS.bind((String)text, (Object)desc);
        this.logset_desc.setText(text);
    }

    public LogSetManager getLogSetManager() {
        return this.lsMgr;
    }

    public TableViewer getTableViewer() {
        return this.fTableViewer;
    }

    class TableContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ImportLogWizardPage.this.logElements.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private Hashtable images = new Hashtable();

        TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return this.getImageHelper(((LogFileElement)element).getParser());
            }
            return null;
        }

        private Image getImageHelper(LogParserItem parser) {
            Image img = (Image)this.images.get(parser.getDescription());
            if (img == null) {
                if (parser.getImageDescriptor() == null) {
                    return null;
                }
                img = parser.getImageDescriptor().createImage();
                this.images.put(parser.getDescription(), img);
            }
            return img;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 1) {
                return ((LogFileElement)element).getHost();
            }
            if (columnIndex == 2) {
                String logFileLabel = (String)((LogFileElement)element).getValues().get("logFileLabel");
                if (logFileLabel != null) {
                    return logFileLabel;
                }
                String filePath = (String)((LogFileElement)element).getValues().get("file_path");
                if (filePath == null) {
                    filePath = (String)((LogFileElement)element).getValues().get("0");
                    if (filePath == null) {
                        return "";
                    }
                    return filePath;
                }
                return filePath;
            }
            return "";
        }

        public void dispose() {
            Enumeration enum1 = this.images.elements();
            while (enum1.hasMoreElements()) {
                Image image = (Image)enum1.nextElement();
                if (image.isDisposed()) continue;
                image.dispose();
            }
            this.images.clear();
            super.dispose();
        }
    }

    public class LogSetManager {
        private IPreferenceStore preferenceStore = MonitoringLogUIPlugin.getDefault().getPreferenceStore();
        private String defaultLogSet;
        private Map logSetsList = new HashMap();
        private Map parsers = new HashMap();
        private Map parserSets = new HashMap();
        private List parentParserSets = new ArrayList();
        private Map logSetsClone;

        LogSetManager() {
        }

        public void initDefault() {
            this.defaultLogSet = ImportLogWizardPage.this.DEFAULT_LOGSET;
            this.loadParserSetRegistry();
            this.loadParserRegistry();
        }

        public void loadLogSets() {
            String prefXML = this.preferenceStore.getString("logsets");
            if (prefXML.length() == 0) {
                this.logSetsList.put(ImportLogWizardPage.this.DEFAULT_LOGSET, null);
                ImportLogWizardPage.this.updateLogSetDescription(this.defaultLogSet);
                return;
            }
            Element prefElement = XMLUtil.loadDom((String)prefXML, (String)"logsets");
            if (prefElement == null) {
                this.logSetsList.put(ImportLogWizardPage.this.DEFAULT_LOGSET, null);
                ImportLogWizardPage.this.updateLogSetDescription(this.defaultLogSet);
                return;
            }
            NodeList logSetsNodeList = XMLUtil.getChildrenByName((Element)prefElement, (String)"logset");
            int i = 0;
            int maxi = logSetsNodeList.getLength();
            while (i < maxi) {
                if (logSetsNodeList.item(i) instanceof Element) {
                    this.loadLogSet((Element)logSetsNodeList.item(i));
                }
                ++i;
            }
            List logList = (List)this.logSetsList.get(this.defaultLogSet);
            if (logList != null) {
                ImportLogWizardPage.this.logElements.addAll(logList);
            }
            ImportLogWizardPage.this.updateLogSetDescription(this.defaultLogSet);
            ImportLogWizardPage.this.refresh();
        }

        private void loadLogSet(Element logSetElement) {
            if (XMLUtil.getValue((Element)logSetElement, (String)LogUIMessages._54).equals("1")) {
                this.defaultLogSet = XMLUtil.getValue((Element)logSetElement, (String)"name");
            }
            ArrayList<LogFileElement> logElems = new ArrayList<LogFileElement>();
            NodeList logNodeList = XMLUtil.getChildrenByName((Element)logSetElement, (String)"LogFileElement");
            Element element = null;
            int i = 0;
            int maxi = logNodeList.getLength();
            while (i < maxi) {
                if (logNodeList.item(i) instanceof Element) {
                    element = (Element)logNodeList.item(i);
                }
                logElems.add(this.loadElement(element));
                ++i;
            }
            this.logSetsList.put(XMLUtil.getValue((Element)logSetElement, (String)"name"), logElems);
        }

        private LogFileElement loadElement(Element prefElement) {
            LogFileElement logElement = new LogFileElement();
            logElement.setHost(XMLUtil.getValue((Element)prefElement, (String)"host"));
            String port = XMLUtil.getValue((Element)prefElement, (String)"port");
            logElement.setPort(port == null ? 10002 : Integer.parseInt(port));
            logElement.setMonitor(XMLUtil.getValue((Element)prefElement, (String)"monitor"));
            logElement.setProject(XMLUtil.getValue((Element)prefElement, (String)"project"));
            logElement.setValid(XMLUtil.getValue((Element)prefElement, (String)"isValid").equals("true"));
            String uri = XMLUtil.getValue((Element)prefElement, (String)"mergedAgent");
            logElement.setParser((LogParserItem)this.parsers.get(XMLUtil.getValue((Element)prefElement, (String)"parserId")));
            logElement.setUseLargeLogSupport("true".equals(XMLUtil.getValue((Element)prefElement, (String)"useLargeLogSupport")));
            NodeList filterNodes = XMLUtil.getChildrenByName((Element)prefElement, (String)"filter");
            if (filterNodes != null && filterNodes.getLength() > 0) {
                String scope = "ImportLogScope";
                FilterInformationManager filterManager = FilterInformationManager.instance((String)scope);
                Element element = null;
                if (filterNodes.item(0) instanceof Element) {
                    element = (Element)filterNodes.item(0);
                    LogFileElement.Filter filter = new LogFileElement.Filter(logElement);
                    String filterName = element.getAttribute("name");
                    String filterType = element.getAttribute("type");
                    filter.setName(filterName);
                    filter.setType(filterType);
                    FilterQueries fq = filterManager.filter(filterName);
                    if (fq != null && fq.type().equals(filterType)) {
                        filter.setQuery(filterManager.createCombinedFilter(fq));
                    }
                    logElement.setFilter(filter);
                }
            }
            if (uri != null && uri.trim().length() > 0) {
                TRCAgentProxy agent = null;
                try {
                    agent = (TRCAgentProxy)UIPlugin.getDefault().getResourceSet().getEObject(URI.createURI((String)uri), true);
                }
                catch (Exception exception) {}
                logElement.setMergedAgent(agent);
            }
            XMLUtil.getChildrenByName((Element)prefElement, (String)"value");
            NodeList nodeList = XMLUtil.getChildrenByName((Element)prefElement, (String)"value");
            LogParserItem parser = logElement.getParser();
            int s = 0;
            if (parser != null) {
                s = parser.getFields().length;
            }
            int i = 0;
            int maxi = nodeList.getLength();
            while (i < maxi) {
                if (nodeList.item(i) instanceof Element) {
                    String key = XMLUtil.getValue((Element)((Element)nodeList.item(i)), (String)"id");
                    String value = XMLUtil.getValue((Element)((Element)nodeList.item(i)), (String)"val");
                    if (key != null) {
                        logElement.getValues().put(key, value);
                    } else if (s > 0 && i < s && parser.getFields()[i] != null) {
                        logElement.getValues().put(parser.getFields()[i].getId(), value);
                    } else {
                        logElement.getValues().put("" + i, value);
                    }
                }
                ++i;
            }
            return logElement;
        }

        public void openLogSet(String name) {
            List logsList = (List)this.logSetsList.get(name);
            ImportLogWizardPage.this.logElements.clear();
            if (logsList != null) {
                ImportLogWizardPage.this.logElements.addAll(logsList);
            }
            ImportLogWizardPage.this.refresh();
        }

        public Map getLogSets() {
            return this.logSetsList;
        }

        public Map getLogSetsClone() {
            if (this.logSetsClone == null) {
                this.logSetsClone = new HashMap();
            }
            this.logSetsClone.clear();
            this.logSetsClone.putAll(this.logSetsList);
            return this.logSetsClone;
        }

        private void loadParserSetRegistry() {
            IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.hyades.logging.parsers", "logParserSet");
            int idx = 0;
            while (idx < config.length) {
                block7: {
                    String parentId;
                    IConfigurationElement elem = config[idx];
                    LogParserSet parserSet = new LogParserSet(elem.getAttribute("id"), elem.getAttribute("label"), elem.getAttribute("description"));
                    String iconPath = elem.getAttribute("icon");
                    if (iconPath != null && iconPath.length() > 0) {
                        try {
                            URL url = new URL(Platform.getBundle((String)elem.getDeclaringExtension().getNamespace()).getEntry("/"), iconPath);
                            ImageDescriptor image = ImageDescriptor.createFromURL((URL)url);
                            parserSet.setImageDescriptor(image);
                        }
                        catch (Exception exc) {
                            Status status = new Status(4, MonitoringLogUIPlugin.getPluginId(), 2, "exception.malformedURL", (Throwable)exc);
                            MonitoringLogUIPlugin.getDefault().getLog().log((IStatus)status);
                            break block7;
                        }
                    }
                    if ((parentId = elem.getAttribute("parentId")) != null && parentId.length() > 0) {
                        LogParserSet parentSet = (LogParserSet)this.parserSets.get(parentId);
                        if (parentSet != null) {
                            parentSet.getChildren().add(parserSet);
                        }
                    } else {
                        this.parentParserSets.add(parserSet);
                    }
                    parserSet.setParentId(parentId);
                    this.parserSets.put(parserSet.getId(), parserSet);
                }
                ++idx;
            }
        }

        private void loadParserRegistry() {
            IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.hyades.logging.parsers", "logParser");
            int idx = 0;
            while (idx < config.length) {
                block22: {
                    String iconPath;
                    IConfigurationElement elem = config[idx];
                    LogParserItem parser = new LogParserItem(elem.getAttribute("id"), elem.getAttribute("name"), elem.getAttribute("ui_name"), elem.getAttribute("description"));
                    parser.setConfigurationElement(elem);
                    parser.setClass(elem.getAttribute("class"));
                    parser.setUIType(elem.getAttribute("ui_type"));
                    parser.setParentId(elem.getAttribute("parserSetId"));
                    LogParserSet parent = (LogParserSet)this.parserSets.get(parser.getParentId());
                    if (parent != null) {
                        parent.getChildren().add(parser);
                    }
                    if ((iconPath = elem.getAttribute("icon")) != null && iconPath.length() > 0) {
                        try {
                            URL url = new URL(Platform.getBundle((String)elem.getDeclaringExtension().getNamespace()).getEntry("/"), iconPath);
                            ImageDescriptor image = ImageDescriptor.createFromURL((URL)url);
                            parser.setImageDescriptor(image);
                        }
                        catch (Exception exc) {
                            Status status = new Status(4, MonitoringLogUIPlugin.getPluginId(), 2, "exception.malformedURL", (Throwable)exc);
                            MonitoringLogUIPlugin.getDefault().getLog().log((IStatus)status);
                            break block22;
                        }
                    }
                    IConfigurationElement[] felems = elem.getChildren();
                    int l = felems.length;
                    int i = 0;
                    while (i < l) {
                        BasicParserField pfield;
                        IConfigurationElement felem = felems[i];
                        if (felem.getName().equals("field")) {
                            pfield = new ParserField(felem.getAttribute("id"), felem.getAttribute("name"));
                            ((ParserField)pfield).setConfigurationElement(felem);
                            pfield.setDefaultValue(felem.getAttribute("defaultValue"));
                            pfield.setRuntimeValue(felem.getAttribute("defaultRuntimeValue"));
                            ((ParserField)pfield).setContextId(felem.getAttribute("helpContextId"));
                            pfield.setTooltip(felem.getAttribute("tooltip"));
                            ((ParserField)pfield).setFilters(felem.getAttribute("browseType"));
                            ((ParserField)pfield).useBrowse(felem.getAttribute("useBrowse").equals("true"));
                            ((ParserField)pfield).setUiType(felem.getAttribute("ui_type"));
                            ((ParserField)pfield).setListener(felem.getAttribute("listener"));
                            parser.addEntry(pfield);
                        } else if (felem.getName().equals("parserParameter")) {
                            ParserParameter para = new ParserParameter(felem.getAttribute("name"), felem.getAttribute("value"));
                            parser.addParameter(para);
                        } else if (felem.getName().equals("customField")) {
                            pfield = new ParserField(felem.getAttribute("id"), "");
                            ((ParserField)pfield).setCustomFieldClass(felem.getAttribute("customFieldClass"));
                            ((ParserField)pfield).setConfigurationElement(felem);
                            parser.addEntry(pfield);
                        } else if (felem.getName().equals("commonFields")) {
                            IConfigurationElement[] children;
                            if (felem.getAttribute("characterEncoding") != null) {
                                pfield = new CommonParserField(0);
                                pfield.setId("characterEncodingField");
                                pfield.setRuntimeValue(felem.getAttribute("characterEncoding"));
                                pfield.setName(LogUIMessages._91);
                                parser.addEntry(pfield);
                            }
                            if (felem.getAttribute("locale") != null) {
                                pfield = new CommonParserField(1);
                                pfield.setId("localeField");
                                pfield.setRuntimeValue(felem.getAttribute("locale"));
                                pfield.setName(LogUIMessages._92);
                                parser.addEntry(pfield);
                            }
                            if (felem.getAttribute("timeZone") != null) {
                                pfield = new CommonParserField(2);
                                pfield.setId("timeZoneField");
                                pfield.setRuntimeValue(felem.getAttribute("timeZone"));
                                pfield.setName(LogUIMessages._93);
                                parser.addEntry(pfield);
                            }
                            if ((children = felem.getChildren()) != null && children.length > 0) {
                                int l1 = children.length;
                                int k = 0;
                                while (k < l1) {
                                    if (children[k].getName().equals("defaultDate")) {
                                        DateParserField pfield2 = new DateParserField();
                                        pfield2.setId("defaultDateField");
                                        if (children[k].getAttribute("day") != null) {
                                            pfield2.setDayRequired(true);
                                            pfield2.setDefaultDay(children[k].getAttribute("day"));
                                        }
                                        if (children[k].getAttribute("month") != null) {
                                            pfield2.setMonthRequired(true);
                                            pfield2.setDefaultMonth(children[k].getAttribute("month"));
                                        }
                                        if (children[k].getAttribute("year") != null) {
                                            pfield2.setYearRequired(true);
                                            pfield2.setDefaultYear(children[k].getAttribute("year"));
                                        }
                                        parser.addEntry(pfield2);
                                    }
                                    ++k;
                                }
                            }
                        }
                        ++i;
                    }
                    this.parsers.put(parser.getId(), parser);
                }
                ++idx;
            }
        }

        public LogParserItem getLogParser(String key) {
            return (LogParserItem)this.parsers.get(key);
        }

        public Map getParserRegistry() {
            return this.parsers;
        }

        public Map getParserSetRegistry() {
            return this.parserSets;
        }

        public List getParserSets() {
            return this.parentParserSets;
        }

        public void saveLogSets() {
            StringBuffer xmlString = new StringBuffer();
            xmlString.append("<?xml");
            xmlString.append(XMLUtil.createXMLAttribute((String)"version", (String)"1.0", (boolean)false)).append(XMLUtil.createXMLAttribute((String)"encoding", (String)"UTF-8", (boolean)false));
            xmlString.append("?>");
            xmlString.append(" <");
            xmlString.append("logsets");
            xmlString.append("> ");
            Set keySet = this.logSetsList.keySet();
            String key = "";
            Iterator iter = keySet.iterator();
            while (iter.hasNext()) {
                key = (String)iter.next();
                xmlString.append(this.generateLogSetPrefEntry(key));
            }
            xmlString.append(" </");
            xmlString.append("logsets");
            xmlString.append(">");
            this.preferenceStore.setValue("logsets", xmlString.toString());
        }

        private String generateLogSetPrefEntry(String name) {
            StringBuffer xmlString = new StringBuffer();
            xmlString.append(" <");
            xmlString.append("logset");
            xmlString.append(XMLUtil.createXMLAttribute((String)"name", (String)name, (boolean)false));
            xmlString.append(XMLUtil.createXMLAttribute((String)LogUIMessages._54, (String)(name.equals(this.defaultLogSet) ? "1" : "0"), (boolean)false));
            xmlString.append("> ");
            List logSet = (List)this.logSetsList.get(name);
            if (logSet != null) {
                LogFileElement element = null;
                Iterator iter = logSet.iterator();
                while (iter.hasNext()) {
                    element = (LogFileElement)iter.next();
                    xmlString.append(this.generateLogElementPrefEntry(element));
                }
            }
            xmlString.append(" </");
            xmlString.append("logset");
            xmlString.append("> ");
            return xmlString.toString();
        }

        private String generateLogElementPrefEntry(LogFileElement element) {
            StringBuffer xml = new StringBuffer();
            xml.append("<LogFileElement ");
            xml.append(XMLUtil.createXMLAttribute((String)"host", (String)element.getHost(), (boolean)false));
            xml.append(XMLUtil.createXMLAttribute((String)"port", (String)String.valueOf(element.getPort()), (boolean)false));
            xml.append(XMLUtil.createXMLAttribute((String)"monitor", (String)element.getMonitor(), (boolean)false));
            xml.append(XMLUtil.createXMLAttribute((String)"project", (String)element.getProject(), (boolean)false));
            xml.append(XMLUtil.createXMLAttribute((String)"isValid", (String)(element.isValid() ? "true" : "false"), (boolean)false));
            xml.append(XMLUtil.createXMLAttribute((String)"useLargeLogSupport", (String)(element.isUseLargeLogSupport() ? "true" : "false"), (boolean)false));
            xml.append(XMLUtil.createXMLAttribute((String)"parserId", (String)element.getParser().getId(), (boolean)false));
            xml.append(XMLUtil.createXMLAttribute((String)"mergedAgent", (String)(element.getMergedAgent() != null ? EcoreUtil.getURI((EObject)element.getMergedAgent()).toString() : ""), (boolean)false));
            xml.append(">");
            Set values = element.getValues().entrySet();
            int s = values.size();
            Iterator iter = values.iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                xml.append(" <value ");
                xml.append(XMLUtil.createXMLAttribute((String)"id", (String)((String)entry.getKey()), (boolean)false));
                xml.append(XMLUtil.createXMLAttribute((String)"val", (String)((String)entry.getValue()), (boolean)false));
                xml.append("/> ");
            }
            int i = 0;
            while (i < s) {
                ++i;
            }
            if (element.getFilter() != null) {
                xml.append(" <filter ");
                xml.append(XMLUtil.createXMLAttribute((String)"name", (String)element.getFilter().getName(), (boolean)false));
                xml.append(XMLUtil.createXMLAttribute((String)"type", (String)element.getFilter().getType(), (boolean)false));
                xml.append(" /> ");
            }
            xml.append("</LogFileElement>");
            return xml.toString();
        }

        public void setDefaultLogSet(String newValue) {
            this.defaultLogSet = newValue;
        }

        public String getDefaultLogSet() {
            if (this.defaultLogSet == null) {
                this.initDefault();
            }
            return this.defaultLogSet;
        }
    }
}

