/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.monitoring.logui.internal.wizards;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tptp.monitoring.logui.internal.MonitoringLogUIPlugin;
import org.eclipse.tptp.monitoring.logui.internal.wizards.BasicParserField;
import org.eclipse.tptp.monitoring.logui.internal.wizards.IImportWizardWidget;

public class ImportWizardComboBox
implements IImportWizardWidget {
    protected Combo comboBox;
    protected BasicParserField _field = null;
    protected String value;
    private List runtimeValues = new ArrayList();

    public ImportWizardComboBox(BasicParserField field) {
        this._field = field;
    }

    public String getValue() {
        this.value = this.comboBox.getSelectionIndex() > -1 ? (this.runtimeValues.size() == this.comboBox.getItems().length ? (String)this.runtimeValues.get(this.comboBox.getSelectionIndex()) : this.comboBox.getItem(this.comboBox.getSelectionIndex())) : "";
        return this.value;
    }

    public void setValue(String newValue) {
        this.value = newValue;
        if (newValue == null) {
            this.comboBox.setText("");
            return;
        }
        int j = 0;
        while (j < this.comboBox.getItemCount()) {
            if (this.comboBox.getItem(j).equalsIgnoreCase(newValue)) {
                this.comboBox.select(j);
                break;
            }
            ++j;
        }
    }

    public void createControl(Composite composite, String prefix) {
        Composite control = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        control.setLayoutData((Object)GridUtil.createHorizontalFill());
        control.setLayout((Layout)layout);
        Label label = new Label(control, 64);
        GridData data = GridUtil.createHorizontalFill();
        label.setLayoutData((Object)data);
        label.setText(this._field.getName());
        this.comboBox = new Combo(control, 2056);
        this.comboBox.setToolTipText(this._field.getTooltip());
        this.comboBox.setLayoutData((Object)GridUtil.createHorizontalFill());
        this.comboBox.setLayout((Layout)new GridLayout());
        this.initializeWidget(prefix);
    }

    protected void initializeWidget(String prefix) {
        String token;
        IPreferenceStore store = MonitoringLogUIPlugin.getDefault().getPreferenceStore();
        String previousValue = store.getString(String.valueOf(prefix) + this._field.getId());
        StringTokenizer st = new StringTokenizer(this._field.getDefaultValue(), ",");
        int selIndex = 0;
        int index = 0;
        while (st.hasMoreTokens()) {
            token = st.nextToken();
            this.comboBox.add(token);
            if (previousValue != null && previousValue.trim().equals(token)) {
                selIndex = index;
            }
            ++index;
        }
        this.comboBox.select(selIndex);
        if (this._field.getRuntimeValue() != null) {
            st = new StringTokenizer(this._field.getRuntimeValue(), ",");
            index = 0;
            while (st.hasMoreTokens()) {
                token = st.nextToken();
                this.runtimeValues.add(token);
            }
        }
    }

    public BasicParserField getField() {
        return this._field;
    }

    public Combo getComboBox() {
        return this.comboBox;
    }

    public void setComboBox(Combo comboBox) {
        this.comboBox = comboBox;
    }

    public boolean isValid() {
        return true;
    }
}

