/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.monitoring.logui.internal.wizards;

import java.util.Locale;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.tptp.monitoring.logui.internal.LogUIMessages;
import org.eclipse.tptp.monitoring.logui.internal.MonitoringLogUIPlugin;
import org.eclipse.tptp.monitoring.logui.internal.wizards.CharacterEncodings;
import org.eclipse.tptp.monitoring.logui.internal.wizards.CommonParserField;
import org.eclipse.tptp.monitoring.logui.internal.wizards.ImportWizardComboBox;
import org.eclipse.ui.progress.WorkbenchJob;

public class ImportWizardCommonFieldWidget
extends ImportWizardComboBox {
    public ImportWizardCommonFieldWidget(CommonParserField field) {
        super(field);
    }

    public String getValue() {
        int index = this.comboBox.getSelectionIndex();
        if (index < 0) {
            return "";
        }
        if (index == 0) {
            return LogUIMessages._94;
        }
        short fieldType = ((CommonParserField)this._field).getType();
        switch (fieldType) {
            case 0: {
                String[] encodings = CharacterEncodings.getSupportedEncodings();
                return encodings[index - 1];
            }
            case 1: {
                Locale[] locales = Locale.getAvailableLocales();
                if (locales[index - 1].getCountry().trim().length() > 0) {
                    StringBuffer locale = new StringBuffer();
                    locale.append(locales[index - 1].getLanguage());
                    locale.append("_");
                    locale.append(locales[index - 1].getCountry());
                    return locale.toString();
                }
                return locales[index - 1].getLanguage();
            }
        }
        return super.getValue();
    }

    public void setValue(final String newValue) {
        if (newValue.trim().length() == 0 || newValue.equals(LogUIMessages._94)) {
            this.comboBox.select(0);
            this.value = newValue;
            return;
        }
        WorkbenchJob valueSetterJob = new WorkbenchJob("Sets locale value to common field widget"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                short fieldType = ((CommonParserField)ImportWizardCommonFieldWidget.this._field).getType();
                block0 : switch (fieldType) {
                    case 0: {
                        StringBuffer descr = new StringBuffer();
                        descr.append(newValue);
                        descr.append(" - ");
                        descr.append(CharacterEncodings.getDescription(newValue));
                        String newValueTransformed = descr.toString();
                        int j = ImportWizardCommonFieldWidget.this.comboBox.indexOf(newValueTransformed);
                        if (j < 0) break;
                        ImportWizardCommonFieldWidget.this.comboBox.select(j);
                        ImportWizardCommonFieldWidget.this.value = newValueTransformed;
                        return new Status(0, MonitoringLogUIPlugin.getPluginId(), 0, "", null);
                    }
                    case 1: {
                        int idx = newValue.indexOf("_");
                        String countryCode = "";
                        String languageCode = "";
                        if (idx < 0) {
                            languageCode = newValue;
                        } else {
                            languageCode = newValue.substring(0, idx);
                            int idx1 = newValue.indexOf("_", idx + 1);
                            countryCode = idx1 < 0 ? newValue.substring(idx + 1) : newValue.substring(idx + 1, idx1);
                        }
                        Locale[] locales = Locale.getAvailableLocales();
                        StringBuffer item = new StringBuffer();
                        int i = 0;
                        while (i < locales.length) {
                            String currentLanguage = locales[i].getLanguage();
                            String currentCountry = locales[i].getCountry();
                            if (currentLanguage.equals(languageCode) && currentCountry.equals(countryCode)) {
                                String displayName;
                                item.append(languageCode);
                                if (countryCode.length() > 0) {
                                    item.append("_");
                                    item.append(countryCode);
                                }
                                if ((displayName = locales[i].getDisplayName()).trim().length() > 0) {
                                    item.append(" - ");
                                    item.append(displayName);
                                }
                                String newValueT = item.toString();
                                int j = ImportWizardCommonFieldWidget.this.comboBox.indexOf(item.toString());
                                if (j < 0) break block0;
                                ImportWizardCommonFieldWidget.this.comboBox.select(j);
                                ImportWizardCommonFieldWidget.this.value = newValueT;
                                return new Status(0, MonitoringLogUIPlugin.getPluginId(), 0, "", null);
                            }
                            ++i;
                        }
                        break;
                    }
                }
                ImportWizardCommonFieldWidget.this.value = "";
                return new Status(0, MonitoringLogUIPlugin.getPluginId(), 0, "", null);
            }
        };
        valueSetterJob.setSystem(true);
        valueSetterJob.schedule();
    }

    protected void initializeWidget(final String prefix) {
        WorkbenchJob initJob = new WorkbenchJob("Initialize common field widget"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                short fieldType = ((CommonParserField)ImportWizardCommonFieldWidget.this._field).getType();
                switch (fieldType) {
                    case 0: {
                        ImportWizardCommonFieldWidget.this.loadCharacterEncodings();
                        break;
                    }
                    case 1: {
                        ImportWizardCommonFieldWidget.this.loadLocales();
                    }
                }
                return new Status(0, MonitoringLogUIPlugin.getPluginId(), 0, "", null);
            }
        };
        initJob.addJobChangeListener(new IJobChangeListener(){

            public void aboutToRun(IJobChangeEvent event) {
            }

            public void awake(IJobChangeEvent event) {
            }

            public void done(IJobChangeEvent event) {
                int index = -1;
                if (ImportWizardCommonFieldWidget.this.value != null && (index = ImportWizardCommonFieldWidget.this.comboBox.indexOf(ImportWizardCommonFieldWidget.this.value)) >= 0) {
                    ImportWizardCommonFieldWidget.this.comboBox.select(index);
                    return;
                }
                IPreferenceStore store = MonitoringLogUIPlugin.getDefault().getPreferenceStore();
                String previousValue = store.getString(String.valueOf(prefix) + ImportWizardCommonFieldWidget.this._field.getId());
                index = ImportWizardCommonFieldWidget.this.comboBox.indexOf(previousValue);
                if (index >= 0) {
                    ImportWizardCommonFieldWidget.this.comboBox.select(index);
                } else {
                    index = ImportWizardCommonFieldWidget.this.comboBox.indexOf(ImportWizardCommonFieldWidget.this._field.getDefaultValue());
                    if (index >= 0) {
                        ImportWizardCommonFieldWidget.this.comboBox.select(index);
                    }
                }
            }

            public void running(IJobChangeEvent event) {
            }

            public void scheduled(IJobChangeEvent event) {
            }

            public void sleeping(IJobChangeEvent event) {
            }
        });
        initJob.setSystem(true);
        initJob.schedule();
    }

    private void loadLocales() {
        Locale[] locales = Locale.getAvailableLocales();
        StringBuffer item = new StringBuffer();
        this.comboBox.add(LogUIMessages._94);
        int i = 0;
        while (i < locales.length) {
            String displayName;
            String language = locales[i].getLanguage();
            item.append(language);
            String country = locales[i].getCountry();
            if (country.trim().length() > 0) {
                item.append("_");
                item.append(country);
            }
            if ((displayName = locales[i].getDisplayName()).trim().length() > 0) {
                item.append(" - ");
                item.append(displayName);
            }
            this.comboBox.add(item.toString());
            item.setLength(0);
            ++i;
        }
    }

    private void loadCharacterEncodings() {
        String[] encodings = CharacterEncodings.getSupportedEncodings();
        int l = encodings.length;
        this.comboBox.add(LogUIMessages._94);
        StringBuffer descr = new StringBuffer();
        int i = 0;
        while (i < l) {
            descr.append(encodings[i]);
            descr.append(" - ");
            descr.append(CharacterEncodings.getDescription(encodings[i]));
            this.comboBox.add(descr.toString());
            descr.setLength(0);
            ++i;
        }
    }
}

