/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.monitoring.logui.internal.wizards;

import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tptp.monitoring.logui.internal.LogUIMessages;
import org.eclipse.tptp.monitoring.logui.internal.wizards.BasicParserField;
import org.eclipse.tptp.monitoring.logui.internal.wizards.DateParserField;
import org.eclipse.tptp.monitoring.logui.internal.wizards.IImportWizardWidget;

public class ImportWizardDateWidget
implements IImportWizardWidget {
    private DateParserField _field = null;
    private Combo cmbDay;
    private Combo cmbMonth;
    private Combo cmbYear;
    private GregorianCalendar calendar = new GregorianCalendar();
    private int defaultYear;
    private short defaultMonth;
    private short defaultDay;
    private final int START_YEAR = 1970;

    public ImportWizardDateWidget(DateParserField field) {
        this._field = field;
    }

    public boolean isValid() {
        return !(this.cmbYear.isEnabled() && this.cmbYear.getSelectionIndex() < 0 || this.cmbMonth.isEnabled() && this.cmbMonth.getSelectionIndex() < 0) && (!this.cmbDay.isEnabled() || this.cmbDay.getSelectionIndex() >= 0);
    }

    public String getValue() {
        StringBuffer value = new StringBuffer();
        value.append(this.cmbYear.getText());
        value.append("-");
        value.append(this.cmbMonth.getText());
        value.append("-");
        value.append(this.cmbDay.getText());
        return value.toString();
    }

    public void setValue(String newValue) {
        StringTokenizer tokenizer = new StringTokenizer(newValue, "-");
        if (newValue.trim().length() == 0) {
            this.cmbYear.setText(LogUIMessages._90);
            this.cmbMonth.setText(LogUIMessages._90);
            this.cmbDay.setText(LogUIMessages._90);
            return;
        }
        if (tokenizer.hasMoreTokens()) {
            this.cmbYear.setText(tokenizer.nextToken());
            if (tokenizer.hasMoreTokens()) {
                this.cmbMonth.setText(tokenizer.nextToken());
                if (tokenizer.hasMoreTokens()) {
                    this.cmbDay.setText(tokenizer.nextToken());
                } else {
                    this.cmbDay.setText(LogUIMessages._90);
                }
            } else {
                this.cmbMonth.setText(LogUIMessages._90);
                this.cmbDay.setText(LogUIMessages._90);
            }
        }
    }

    public String getYear() {
        return this.cmbYear.getText();
    }

    public String getMonth() {
        return this.cmbMonth.getText();
    }

    public String getDay() {
        return this.cmbDay.getText();
    }

    public void setDay(String newDay) {
        try {
            this.defaultDay = (short)Integer.parseInt(newDay);
        }
        catch (Exception exception) {
            this.defaultDay = 1;
        }
        this.cmbDay.select(this.defaultDay - 1);
    }

    public void setMonth(String newMonth) {
        try {
            this.defaultMonth = (short)Integer.parseInt(newMonth);
        }
        catch (Exception exception) {
            this.defaultMonth = 0;
        }
        this.cmbMonth.select(this.defaultMonth - 1);
    }

    public void setYear(String newYear) {
        try {
            this.defaultYear = (short)Integer.parseInt(newYear);
        }
        catch (Exception exception) {
            this.defaultYear = this.calendar.get(1);
        }
        int i = this.cmbYear.indexOf("" + this.defaultYear);
        this.cmbYear.select(i >= 0 ? i : 0);
    }

    public void createControl(Composite parent, String prefix) {
        Composite date = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 5;
        date.setLayout((Layout)layout);
        Label label = new Label(date, 64);
        GridData data = new GridData();
        data.horizontalSpan = 5;
        label.setLayoutData((Object)data);
        label.setText(LogUIMessages._89);
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                short day = 1;
                short month = 0;
                int year = ImportWizardDateWidget.this.calendar.get(1);
                if (!ImportWizardDateWidget.this.cmbDay.getText().equals(LogUIMessages._90)) {
                    day = (short)Integer.parseInt(ImportWizardDateWidget.this.cmbDay.getText());
                }
                if (!ImportWizardDateWidget.this.cmbMonth.getText().equals(LogUIMessages._90)) {
                    month = (short)Integer.parseInt(ImportWizardDateWidget.this.cmbMonth.getText());
                }
                if (!ImportWizardDateWidget.this.cmbYear.getText().equals(LogUIMessages._90)) {
                    year = Integer.parseInt(ImportWizardDateWidget.this.cmbYear.getText());
                }
                if (ImportWizardDateWidget.this.cmbDay.isEnabled() && year > 0 && year != ImportWizardDateWidget.this.defaultYear || month > 0 && month != ImportWizardDateWidget.this.defaultMonth) {
                    ImportWizardDateWidget.this.initializeDay(year, month, day, false);
                } else {
                    ImportWizardDateWidget.this.defaultDay = day;
                }
                ImportWizardDateWidget.this.defaultYear = year;
                ImportWizardDateWidget.this.defaultMonth = month;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.cmbYear = new Combo(date, 2056);
        this.cmbYear.setToolTipText(this._field.getTooltip());
        this.cmbYear.setLayoutData((Object)GridUtil.createHorizontalFill());
        this.cmbYear.setLayout((Layout)new GridLayout());
        this.cmbYear.setEnabled(this._field.isYearRequired());
        this.defaultYear = this.calendar.get(1);
        this.cmbYear.addSelectionListener(listener);
        data = new GridData();
        label = new Label(date, 0);
        label.setLayoutData((Object)data);
        label.setText("-");
        this.cmbMonth = new Combo(date, 2056);
        this.cmbMonth.setToolTipText(this._field.getTooltip());
        this.cmbMonth.setLayoutData((Object)GridUtil.createHorizontalFill());
        this.cmbMonth.setLayout((Layout)new GridLayout());
        this.cmbMonth.addSelectionListener(listener);
        this.cmbMonth.setEnabled(this._field.isMonthRequired());
        this.defaultMonth = (short)this.calendar.get(2);
        label = new Label(date, 0);
        label.setLayoutData((Object)data);
        label.setText("-");
        this.cmbDay = new Combo(date, 2056);
        this.cmbDay.setToolTipText(this._field.getTooltip());
        this.cmbDay.setLayoutData((Object)GridUtil.createHorizontalFill());
        this.cmbDay.setLayout((Layout)new GridLayout());
        this.cmbDay.setEnabled(this._field.isDayRequired());
        this.defaultDay = (short)this.calendar.get(5);
        this.initializeWidgets();
    }

    public BasicParserField getField() {
        return this._field;
    }

    private void initializeWidgets() {
        int year = this.calendar.get(1);
        short month = (short)this.calendar.get(2);
        short day = (short)this.calendar.get(5);
        if (this.cmbYear.isEnabled()) {
            this.initializeYear();
            if (this._field.getDefaultYear() != null) {
                try {
                    year = Integer.parseInt(this._field.getDefaultYear());
                }
                catch (Exception exception) {}
                this.setYear("" + year);
            }
        } else {
            this.cmbYear.add(LogUIMessages._90);
            this.cmbYear.select(0);
        }
        if (this.cmbMonth.isEnabled()) {
            this.initializeMonth();
            if (this._field.getDefaultMonth() != null) {
                try {
                    month = (short)Integer.parseInt(this._field.getDefaultMonth());
                }
                catch (Exception exception) {}
                this.setMonth("" + month);
            }
        } else {
            this.cmbMonth.add(LogUIMessages._90);
            this.cmbMonth.select(0);
        }
        if (this.cmbDay.isEnabled()) {
            if (this._field.getDefaultDay() != null) {
                try {
                    day = (short)Integer.parseInt(this._field.getDefaultDay());
                }
                catch (Exception exception) {}
                this.initializeDay(year, month, day, true);
            }
        } else {
            this.cmbDay.add(LogUIMessages._90);
            this.cmbDay.select(0);
        }
    }

    private void initializeMonth() {
        int i = 1;
        while (i <= 12) {
            this.cmbMonth.add("" + i);
            ++i;
        }
    }

    private void initializeDay(int year, int month, int day, boolean init) {
        if (init || this.defaultYear != year || this.defaultMonth != month) {
            this.calendar = new GregorianCalendar(year, month - 1, 1);
        }
        int maxDay = this.calendar.getActualMaximum(5);
        this.cmbDay.removeAll();
        int i = 1;
        while (i <= maxDay) {
            this.cmbDay.add("" + i);
            ++i;
        }
        this.setDay(day <= maxDay ? "" + day : "1");
    }

    private void initializeYear() {
        int currentYear;
        int i = currentYear = this.calendar.get(1);
        while (i >= 1970) {
            this.cmbYear.add("" + i);
            --i;
        }
    }
}

