/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.monitoring.logui.internal.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tptp.monitoring.logui.internal.MonitoringLogUIPlugin;
import org.eclipse.tptp.monitoring.logui.internal.wizards.BasicParserField;
import org.eclipse.tptp.monitoring.logui.internal.wizards.IImportWizardWidget;
import org.eclipse.tptp.monitoring.logui.internal.wizards.ParserField;

public class ImportWizardRadioButton
implements IImportWizardWidget {
    protected Collection buttonList = new ArrayList();
    private ParserField _field = null;

    public ImportWizardRadioButton(ParserField field) {
        this._field = field;
    }

    public String getValue() {
        Iterator iter = this.buttonList.iterator();
        StringBuffer value = new StringBuffer();
        while (iter.hasNext()) {
            Button button = (Button)iter.next();
            value.append(button.getSelection() ? "true" : "false");
            if (!iter.hasNext()) continue;
            value.append(",");
        }
        return value.toString();
    }

    public void setValue(String newValue) {
        Iterator iter = this.buttonList.iterator();
        StringTokenizer st = new StringTokenizer(newValue, ",");
        String token = "";
        while (iter.hasNext() && st.hasMoreTokens()) {
            Button button = (Button)iter.next();
            token = st.nextToken();
            button.setSelection(token.equals("true"));
        }
    }

    public void createControl(Composite composite, String prefix) {
        Composite control = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        control.setLayout((Layout)layout);
        control.setLayoutData((Object)GridUtil.createHorizontalFill());
        Label label = new Label(control, 64);
        GridData data = GridUtil.createHorizontalFill();
        label.setLayoutData((Object)data);
        label.setText(this._field.getName());
        IPreferenceStore store = MonitoringLogUIPlugin.getDefault().getPreferenceStore();
        String previousValue = store.getString(String.valueOf(prefix) + this._field.getId());
        StringTokenizer st = new StringTokenizer(this._field.getDefaultValue(), ",");
        int index = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            Button radio = new Button(control, 16);
            data = new GridData();
            radio.setLayoutData((Object)data);
            radio.setToolTipText(this._field.getTooltip());
            radio.setText(token);
            if (previousValue != null && previousValue.trim().equals(token)) {
                radio.setSelection(true);
            } else if ((previousValue == null || previousValue.trim().equals("")) && index == 0) {
                radio.setSelection(true);
            } else {
                radio.setSelection(false);
            }
            ++index;
            this.buttonList.add(radio);
        }
    }

    public Collection getButtonList() {
        return this.buttonList;
    }

    public void setButtonList(Collection buttonList) {
        this.buttonList = buttonList;
    }

    public boolean isValid() {
        return true;
    }

    public BasicParserField getField() {
        return this._field;
    }
}

