/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.monitoring.logui.internal.wizards;

import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tptp.monitoring.logui.internal.MonitoringLogUIPlugin;
import org.eclipse.tptp.monitoring.logui.internal.wizards.BasicParserField;
import org.eclipse.tptp.monitoring.logui.internal.wizards.IImportWizardWidget;
import org.eclipse.tptp.monitoring.logui.internal.wizards.ParserField;

public class ImportWizardTextArea
implements IImportWizardWidget {
    protected Text text;
    private ParserField _field = null;

    public ImportWizardTextArea(ParserField field) {
        this._field = field;
    }

    public String getValue() {
        return this.text.getText().trim();
    }

    public void setValue(String newValue) {
        this.text.setText(newValue);
    }

    public void createControl(Composite composite, String prefix) {
        Composite control = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        control.setLayoutData((Object)GridUtil.createHorizontalFill());
        control.setLayout((Layout)layout);
        Label label = new Label(control, 64);
        GridData data = GridUtil.createHorizontalFill();
        label.setLayoutData((Object)data);
        label.setText(this._field.getName());
        this.text = new Text(control, 2818);
        data = GridUtil.createHorizontalFill();
        data.heightHint = 40;
        this.text.setLayoutData((Object)data);
        this.text.setToolTipText(this._field.getTooltip());
        IPreferenceStore store = MonitoringLogUIPlugin.getDefault().getPreferenceStore();
        String previousValue = store.getString(String.valueOf(prefix) + this._field.getId());
        if (previousValue != null && !previousValue.equals("")) {
            this.text.setText(previousValue);
        } else {
            this.text.setText(this._field.getDefaultValue());
        }
    }

    public boolean isValid() {
        return !this.text.getVisible() || !this.text.getText().trim().equals("");
    }

    public Text getText() {
        return this.text;
    }

    public void setText(Text text) {
        this.text = text;
    }

    public BasicParserField getField() {
        return this._field;
    }
}

