/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.monitoring.logui.internal.wizards;

import java.io.File;
import java.util.Map;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tptp.monitoring.logui.internal.LogUIMessages;
import org.eclipse.tptp.monitoring.logui.internal.wizards.BasicParserField;
import org.eclipse.tptp.monitoring.logui.internal.wizards.IImportWizardWidget;
import org.eclipse.tptp.monitoring.logui.internal.wizards.ParserField;

public class ImportWizardTextField
implements IImportWizardWidget,
Listener,
ModifyListener {
    protected Button btn;
    protected Map _filtersTable;
    protected Text text;
    private ParserField _field;
    protected int _style;

    public ImportWizardTextField(Map _filtersTable, ParserField field, int style) {
        this._filtersTable = _filtersTable;
        this._field = field;
        this._style = style;
    }

    public String getValue() {
        return this.text.getText().trim();
    }

    public void setValue(String newValue) {
        this.text.setText(newValue);
    }

    public void createControl(Composite composite, String prefix) {
        Composite control = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        control.setLayoutData((Object)GridUtil.createHorizontalFill());
        control.setLayout((Layout)layout);
        Label label = new Label(control, 64);
        label.setText(this._field.getName());
        GridData data = GridUtil.createHorizontalFill();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.text = new Text(control, 0x800 | this._style);
        this.text.setToolTipText(this._field.getTooltip());
        this.text.setLayoutData((Object)GridUtil.createHorizontalFill());
        this.text.addModifyListener((ModifyListener)this);
        this.btn = new Button(control, 8);
        if (this._field.browseIdx() == 2) {
            this.btn.setText(LogUIMessages._4);
        } else if (this._field.browseIdx() == 1) {
            this.btn.setText(LogUIMessages._3);
        } else {
            this.btn.setText(LogUIMessages._2);
        }
        data = new GridData();
        data.horizontalAlignment = 131072;
        this.btn.setLayoutData((Object)data);
        this.btn.addListener(13, (Listener)this);
        if (this._field.useBrowse()) {
            this.btn.setVisible(true);
            String filters = this._field.getFilters();
            if (filters != null) {
                this._filtersTable.put(this.btn, filters);
            }
        } else {
            this.btn.setVisible(false);
        }
    }

    public void handleEvent(Event event) {
        if (event.widget == this.btn) {
            Object filters = this._filtersTable.get(this.btn);
            if (filters != null) {
                FileDialog fileDialog = new FileDialog(this.btn.getParent().getShell());
                fileDialog.setFilterPath(this.text.getText().trim());
                fileDialog.setFilterExtensions(new String[]{filters.toString(), "*"});
                fileDialog.open();
                String fileName = fileDialog.getFileName();
                if (fileName != null && !fileName.trim().equals("")) {
                    this.text.setText(fileDialog.getFilterPath().concat(File.separator).concat(fileName));
                }
            } else {
                String wasHomeDir;
                DirectoryDialog directoryDialog = new DirectoryDialog(this.btn.getParent().getShell());
                directoryDialog.setMessage(LogUIMessages._5);
                if (this.text.getText().trim().length() > 0) {
                    directoryDialog.setFilterPath(this.text.getText().trim());
                }
                if ((wasHomeDir = directoryDialog.open()) != null && !wasHomeDir.trim().equals("")) {
                    this.text.setText(wasHomeDir);
                }
            }
        }
    }

    public void modifyText(ModifyEvent e) {
    }

    public boolean isValid() {
        return !this.text.getVisible() || !this.text.isEnabled() || !this.text.getText().trim().equals("");
    }

    public Text getText() {
        return this.text;
    }

    public void setText(Text text) {
        this.text = text;
    }

    public Button getBtn() {
        return this.btn;
    }

    public void setBtn(Button btn) {
        this.btn = btn;
    }

    public BasicParserField getField() {
        return this._field;
    }
}

