/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.monitoring.logui.internal.wizards;

import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.hyades.security.internal.util.ConnectUtil;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.tptp.monitoring.logui.internal.LogUIMessages;
import org.eclipse.tptp.monitoring.logui.internal.MonitoringLogUIPlugin;
import org.eclipse.tptp.monitoring.logui.internal.wizards.ILogParserItem;
import org.eclipse.tptp.monitoring.logui.internal.wizards.ImportLogWizardPage;
import org.eclipse.tptp.monitoring.logui.internal.wizards.LogDestinationUI;
import org.eclipse.tptp.monitoring.logui.internal.wizards.LogFileElement;
import org.eclipse.tptp.monitoring.logui.internal.wizards.LogFilterUI;
import org.eclipse.tptp.monitoring.logui.internal.wizards.LogHostUI;
import org.eclipse.tptp.monitoring.logui.internal.wizards.LogLocationUI;
import org.eclipse.tptp.monitoring.logui.internal.wizards.LogParserItem;
import org.eclipse.tptp.monitoring.logui.internal.wizards.LogParserUI;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class LogFileDetailsUI
extends Dialog
implements SelectionListener {
    private ImportLogWizardPage page;
    private TabFolder details;
    private TabItem hostTab;
    private TabItem logLocationTab;
    private TabItem destinationTab;
    private TabItem filterTab;
    private LogParserUI parserUI;
    private LogHostUI hostUI;
    private LogLocationUI locationUI;
    private LogDestinationUI destinationUI;
    private LogFilterUI filterUI;
    private ILogParserItem parser;
    private String title = "";
    private int type;
    private Section detailsSection;
    private boolean initializingElem = false;
    private String _filter = null;
    private static final String LOG_DETAILS_DIALOG = "logDetailsDialog";

    public LogFileDetailsUI(Shell shell, ImportLogWizardPage page, int type) {
        super(shell);
        this.page = page;
        this.type = type;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(final Composite parent) {
        this.getShell().setText(this.title);
        this.parserUI = new LogParserUI(this);
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        this.parserUI.createControl(parent, toolkit, this._filter);
        this._filter = null;
        this.createSpace(parent);
        this.detailsSection = toolkit.createSection(parent, 194);
        GridLayout detailsLayout = new GridLayout();
        detailsLayout.marginHeight = 2;
        detailsLayout.marginWidth = 2;
        this.detailsSection.setLayout((Layout)detailsLayout);
        GridData data = GridUtil.createFill();
        this.detailsSection.setLayoutData((Object)data);
        Composite result = new Composite((Composite)this.detailsSection, 0);
        data = GridUtil.createFill();
        result.setLayoutData((Object)data);
        result.setLayout((Layout)new GridLayout());
        this.detailsSection.setText(LogUIMessages._88);
        this.detailsSection.setBackground(Display.getDefault().getSystemColor(22));
        Label lblProp = new Label(result, 0);
        data = GridUtil.createHorizontalFill();
        lblProp.setLayoutData((Object)data);
        lblProp.setText(LogUIMessages._25);
        this.details = new TabFolder(result, 0);
        data = GridUtil.createFill();
        data.widthHint = 500;
        data.heightHint = 300;
        this.details.setLayoutData((Object)data);
        this.details.addSelectionListener((SelectionListener)this);
        this.logLocationTab = new TabItem(this.details, 0);
        this.logLocationTab.setText(LogUIMessages._23);
        this.locationUI = new LogLocationUI(this.page, this);
        this.logLocationTab.setControl((Control)this.locationUI.createControl((Composite)this.details));
        this.hostTab = new TabItem(this.details, 0);
        this.hostTab.setText(LogUIMessages._22);
        this.hostUI = new LogHostUI(this.page);
        this.hostTab.setControl((Control)this.hostUI.createControl((Composite)this.details));
        this.destinationTab = new TabItem(this.details, 0);
        this.destinationTab.setText(LogUIMessages._24);
        this.destinationUI = new LogDestinationUI(this.page);
        this.destinationTab.setControl((Control)this.destinationUI.createControl((Composite)this.details));
        this.filterTab = new TabItem(this.details, 0);
        this.filterTab.setText(LogUIMessages._56);
        this.filterUI = new LogFilterUI(this.page);
        this.filterTab.setControl((Control)this.filterUI.createControl((Composite)this.details));
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.filterTab.getControl(), String.valueOf(MonitoringLogUIPlugin.getPluginId()) + ".importlogfilter");
        this.detailsSection.setClient((Control)result);
        this.detailsSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                parent.layout();
            }
        });
        if (this.type == 4) {
            this.initializeUI();
        } else if (this.type == 5) {
            this.startInitElement();
            this.initializeUIFromLogElement();
        }
        return result;
    }

    public void createSpace(Composite parent) {
        Label space = new Label(parent, 0);
        GridData data = new GridData(768);
        space.setLayoutData((Object)data);
    }

    public String getHostName() {
        return this.hostUI.getHost();
    }

    public Section getDetailsSection() {
        return this.detailsSection;
    }

    public boolean isLocalHost() {
        String host = this.hostUI.getHost();
        if (host == null) {
            return false;
        }
        return ConnectUtil.isLocalHost((String)host);
    }

    public int getPort() {
        return this.hostUI.getPort();
    }

    public Map getUserInput(LogParserItem item) {
        return this.locationUI.getUserInput(item);
    }

    public void initializeUI() {
        this.hostUI.initialize(this.page.getSelectedElement());
        this.initializeLocation();
        this.destinationUI.initialize();
        this.filterUI.initialize();
        this.setOKButtonEnabled(this.isTabFolderComplete());
    }

    public void initializeLocation() {
        Composite composite = this.locationUI.getCompositeFor(this.parser);
        if (composite == null) {
            composite = this.locationUI.createControl((Composite)this.details, this.parser);
            if (this.parser instanceof LogParserItem) {
                ((LogParserItem)this.parser).setWidgets(this.locationUI.getWidgets());
                ((LogParserItem)this.parser).setListenersServed(this.locationUI.getListenersServed());
            }
        } else if (this.parser instanceof LogParserItem && ((LogParserItem)this.parser).getListenersServed() != null) {
            this.locationUI.setListenersServed(((LogParserItem)this.parser).getListenersServed());
        }
        this.locationUI.initialize(composite, this.page.getSelectedElement());
        this.logLocationTab.setControl((Control)composite);
        this.setOKButtonEnabled(this.isTabFolderComplete());
    }

    public void initializeUIFromLogElement() {
        LogParserItem parserItem = this.page.getSelectedElement().getParser();
        this.hostUI.initialize(this.page.getSelectedElement());
        Composite composite = this.locationUI.getCompositeFor(parserItem);
        if (composite == null) {
            composite = this.locationUI.createControl((Composite)this.details, parserItem);
            parserItem.setWidgets(this.locationUI.getWidgets());
            parserItem.setListenersServed(this.locationUI.getListenersServed());
        } else if (parserItem.getListenersServed() != null) {
            this.locationUI.setListenersServed(parserItem.getListenersServed());
        }
        this.locationUI.initializeUIFromLogElement(composite, this.page.getSelectedElement());
        this.logLocationTab.setControl((Control)composite);
        this.locationUI.notifyListeners(composite);
        this.destinationUI.initializeUIFromLogElement(this.page.getSelectedElement());
        this.filterUI.initializeUIFromLogElement(this.page.getSelectedElement());
    }

    public boolean isTabFolderComplete() {
        return this.parser != null && this.hostUI.isTabItemComplete() && this.locationUI.isTabItemComplete() && this.destinationUI.isTabItemComplete();
    }

    public void setOKButtonEnabled(boolean enabled) {
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(enabled);
        }
    }

    public ILogParserItem getSelectedParser() {
        return this.parser;
    }

    public Map getParserRegistry() {
        return this.page.getLogSetManager().getParserRegistry();
    }

    public Map getParserSetRegistry() {
        return this.page.getLogSetManager().getParserSetRegistry();
    }

    public List getParserSets() {
        return this.page.getLogSetManager().getParserSets();
    }

    public void setSelectedParser(ILogParserItem newParser) {
        if (this.parser != newParser && !this.initializingElem) {
            this.parser = newParser;
            this.initializeLocation();
        }
        this.parser = newParser;
    }

    public void startInitElement() {
        this.initializingElem = true;
    }

    public void endInitElement() {
        this.initializingElem = false;
    }

    public void setWindowTitle(String title) {
        this.title = title;
    }

    public boolean finish() {
        if (!(this.parser instanceof LogParserItem)) {
            return false;
        }
        this.getLogFileElement().setParser((LogParserItem)this.parser);
        return this.hostUI.finish() && this.parserUI.finish() && this.locationUI.finish() && this.destinationUI.finish() && this.filterUI.finish();
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.item == this.logLocationTab) {
            this.locationUI.enableButtons(this.locationUI.getCompositeFor(this.parser));
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    protected void okPressed() {
        if (!this.finish()) {
            return;
        }
        super.okPressed();
    }

    protected void cancelPressed() {
        this.parserUI.finish();
        super.cancelPressed();
    }

    public boolean close() {
        this.parserUI.dispose();
        this.locationUI.dispose();
        return super.close();
    }

    public void updateListenersServed(Vector listenersServed) {
        if (this.parser != null && this.parser instanceof LogParserItem) {
            ((LogParserItem)this.parser).setListenersServed(listenersServed);
        }
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.setOKButtonEnabled(this.isTabFolderComplete());
        return control;
    }

    public LogFileElement getLogFileElement() {
        return this.page.getSelectedElement();
    }

    public IDialogSettings getDialogSettings() {
        IDialogSettings settings = MonitoringLogUIPlugin.getDefault().getDialogSettings();
        IDialogSettings thisSettings = settings.getSection(LOG_DETAILS_DIALOG);
        if (thisSettings == null) {
            thisSettings = settings.addNewSection(LOG_DETAILS_DIALOG);
        }
        return thisSettings;
    }

    public void setFilter(String filter) {
        this._filter = filter;
    }
}

