/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.monitoring.logui.internal.wizards;

import org.eclipse.hyades.trace.ui.internal.core.ImportFilterUI;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.tptp.monitoring.logui.internal.wizards.ImportLogWizardPage;
import org.eclipse.tptp.monitoring.logui.internal.wizards.LogFileElement;

public class LogFilterUI
implements Listener {
    private ImportFilterUI filterUI;
    private ImportLogWizardPage page;

    public LogFilterUI(ImportLogWizardPage page) {
        this.page = page;
    }

    public Composite createControl(Composite parent) {
        Composite btnGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 0;
        btnGroup.setLayout((Layout)layout);
        btnGroup.setLayoutData((Object)GridUtil.createFill());
        this.filterUI = new ImportFilterUI(this.getFilterScope());
        this.filterUI.createControl(btnGroup);
        new Label(btnGroup, 0);
        return btnGroup;
    }

    public void handleEvent(Event event) {
    }

    public void initialize() {
        this.filterUI.setSelectedFilter(null, null);
    }

    public void initializeUIFromLogElement(LogFileElement element) {
        if (element.getFilter() != null) {
            this.filterUI.setSelectedFilter(element.getFilter().getName(), element.getFilter().getType());
        }
    }

    public boolean isTabItemComplete() {
        return true;
    }

    public boolean finish() {
        if (this.filterUI.getSelectedFilter() != null) {
            LogFileElement element = this.page.getSelectedElement();
            LogFileElement.Filter filter = element.new LogFileElement.Filter();
            filter.setName(this.filterUI.getSelectedFilterName());
            filter.setType(this.filterUI.getSelectedFilterType());
            filter.setQuery(this.filterUI.getSelectedFilter());
            element.setFilter(filter);
        } else {
            LogFileElement element = this.page.getSelectedElement();
            element.setFilter(null);
        }
        return true;
    }

    private String getFilterScope() {
        return "ImportLogScope";
    }
}

