/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.monitoring.logui.internal.wizards;

import org.eclipse.hyades.security.internal.util.SecurityMessages;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceHostUI;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.tptp.monitoring.logui.internal.wizards.ImportLogWizardPage;
import org.eclipse.tptp.monitoring.logui.internal.wizards.LogFileElement;

public class LogHostUI
extends TraceHostUI {
    public LogHostUI(WizardPage wp) {
        super(wp);
    }

    public LogHostUI() {
    }

    private boolean isHostChanged() {
        TableItem[] selected = this.getListUI().getSelection();
        if (selected.length > 0) {
            String text = selected[0].getText();
            if (text.equals(SecurityMessages._75)) {
                String _host1 = SecurityMessages._75;
                String _port1 = "";
                return !this.getHostUI().getText().equals(_host1) || !this.getPortUI().getText().equals(_port1);
            }
            int idx = text.lastIndexOf(":");
            if (idx != -1) {
                String _host1 = text.substring(0, idx);
                String _port1 = idx < text.length() - 1 ? text.substring(idx + 1) : "";
                return !this.getHostUI().getText().equals(_host1) || !this.getPortUI().getText().equals(_port1);
            }
        }
        return true;
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.getListUI() && !this.isHostChanged()) {
            return;
        }
        super.widgetSelected(e);
        ((ImportLogWizardPage)this.getWizardPage()).getDialog().setOKButtonEnabled(this.isTabItemComplete());
        ((ImportLogWizardPage)this.getWizardPage()).initLocation();
    }

    public void initialize(LogFileElement element) {
        String host = element.getHost();
        int port = element.getPort();
        if (host != null) {
            this.selectHost(host, port);
        }
    }

    public boolean isTabItemComplete() {
        return this.getHost() != null;
    }

    public void selectHost(String hostname, int port) {
        if (port == 0) {
            port = 10002;
        }
        super.addHost(String.valueOf(hostname) + ":" + port);
    }

    public boolean finish() {
        LogFileElement element = ((ImportLogWizardPage)this.getWizardPage()).getSelectedElement();
        element.setHost(this.getHost());
        element.setPort(this.getPort());
        IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
        String hosts = "";
        TableItem[] items = this.getHosts();
        if (items.length == 0) {
            return false;
        }
        int idx = 0;
        while (idx < items.length) {
            hosts = String.valueOf(hosts) + "," + items[idx].getText().trim();
            ++idx;
        }
        if (hosts.startsWith(",") && hosts.length() > 1) {
            hosts = hosts.substring(1);
        }
        store.setValue("use_host", hosts);
        return true;
    }
}

