/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.monitoring.logui.internal.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.hyades.logging.parsers.importer.IImportWizardControl;
import org.eclipse.hyades.logging.parsers.importer.IImportWizardControlListener;
import org.eclipse.hyades.logging.parsers.importer.IWidgetListener;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.tptp.monitoring.logui.internal.MonitoringLogUIPlugin;
import org.eclipse.tptp.monitoring.logui.internal.wizards.BasicParserField;
import org.eclipse.tptp.monitoring.logui.internal.wizards.CommonParserField;
import org.eclipse.tptp.monitoring.logui.internal.wizards.DateParserField;
import org.eclipse.tptp.monitoring.logui.internal.wizards.IImportWizardWidget;
import org.eclipse.tptp.monitoring.logui.internal.wizards.ILogParserItem;
import org.eclipse.tptp.monitoring.logui.internal.wizards.ImportLogWizardPage;
import org.eclipse.tptp.monitoring.logui.internal.wizards.ImportWizardCheckBox;
import org.eclipse.tptp.monitoring.logui.internal.wizards.ImportWizardComboBox;
import org.eclipse.tptp.monitoring.logui.internal.wizards.ImportWizardCommonFieldWidget;
import org.eclipse.tptp.monitoring.logui.internal.wizards.ImportWizardDateWidget;
import org.eclipse.tptp.monitoring.logui.internal.wizards.ImportWizardRadioButton;
import org.eclipse.tptp.monitoring.logui.internal.wizards.ImportWizardTextArea;
import org.eclipse.tptp.monitoring.logui.internal.wizards.ImportWizardTextField;
import org.eclipse.tptp.monitoring.logui.internal.wizards.ImportWizardTimeZoneWidget;
import org.eclipse.tptp.monitoring.logui.internal.wizards.LogFileDetailsUI;
import org.eclipse.tptp.monitoring.logui.internal.wizards.LogFileElement;
import org.eclipse.tptp.monitoring.logui.internal.wizards.LogParserItem;
import org.eclipse.tptp.monitoring.logui.internal.wizards.ParserField;
import org.eclipse.ui.PlatformUI;

public class LogLocationUI
implements Listener,
ModifyListener {
    private String prefix = "ImportLogFile.";
    private ImportLogWizardPage page;
    private LogFileDetailsUI details;
    private Map composites = new HashMap();
    private static final short COMBO_BOX = 0;
    private static final short CHECK_BOX = 1;
    private static final short RADIO = 2;
    private static final short TEXT_AREA = 3;
    private static final short TEXT_FIELD = 4;
    private Vector _listenersServed = new Vector();

    public LogLocationUI(ImportLogWizardPage page, LogFileDetailsUI details) {
        this.page = page;
        this.details = details;
    }

    public Composite createControl(Composite parent) {
        ILogParserItem item = this.details.getSelectedParser();
        return this.createControl(parent, item);
    }

    protected Composite createControl(Composite parent, ILogParserItem parser) {
        ParserPropertiesComposite composite = new ParserPropertiesComposite(parent, 768);
        Composite c1 = new Composite((Composite)composite, 0);
        composite.setContent((Control)c1);
        composite.setExpandHorizontal(true);
        composite.setExpandVertical(true);
        GridLayout layout = new GridLayout();
        this._listenersServed = new Vector();
        c1.setLayout((Layout)layout);
        c1.setLayoutData((Object)GridUtil.createFill());
        if (parser != null) {
            if (parser instanceof LogParserItem) {
                BasicParserField[] fields = ((LogParserItem)parser).getFields();
                this.prefix = String.valueOf(this.details.getHostName()) + "." + parser.getDescription() + ".";
                int l = fields.length;
                if (fields != null && l > 0) {
                    int browseIdx = 0;
                    int idx = 0;
                    while (idx < l) {
                        BasicParserField field = fields[idx];
                        if (field != null) {
                            if (field instanceof ParserField) {
                                browseIdx = this.createParserFieldWidget(composite, browseIdx, field, parser);
                            } else if (field instanceof DateParserField) {
                                this.createDateWidget(composite, (DateParserField)field);
                            } else if (field instanceof CommonParserField) {
                                this.createCommonWidget(composite, (CommonParserField)field);
                            }
                        }
                        ++idx;
                    }
                }
            }
            composite.setMinSize(c1.computeSize(-1, -1));
            this.composites.put(parser, composite);
            this.enableButtons((Composite)composite);
        }
        return composite;
    }

    private int createParserFieldWidget(ParserPropertiesComposite composite, int browseIdx, BasicParserField field, ILogParserItem parser) {
        if (((ParserField)field).getCustomFieldClass() != null && ((ParserField)field).getCustomFieldClass().trim().length() > 0) {
            IImportWizardControl customFieldClass = ((ParserField)field).getCustomFieldInstance();
            if (customFieldClass != null) {
                this.createCustomControl(composite, customFieldClass, parser.getId());
                composite.getControlLookup().put(field.getId(), customFieldClass);
                composite.getFieldIDs().add(field.getId());
                composite.getFields().put(field.getId(), field);
            }
        } else {
            if (((ParserField)field).useBrowse()) {
                ((ParserField)field).setBrowseIdx(browseIdx);
                ++browseIdx;
            }
            this.createWidget(composite, (ParserField)field);
        }
        return browseIdx;
    }

    private Control createCustomControl(ParserPropertiesComposite composite, IImportWizardControl customFieldClass, String logParserID) {
        Control control = customFieldClass.createContents((Composite)composite.getContent(), logParserID);
        IImportWizardControlListener listener = new IImportWizardControlListener(){

            public void controlChanged() {
                LogLocationUI.this.details.setOKButtonEnabled(LogLocationUI.this.isTabItemComplete());
            }
        };
        customFieldClass.addControlListener(listener);
        composite.getListeners().put(customFieldClass, listener);
        return control;
    }

    protected void createVerticalSpace(Composite comp, int colSpan) {
        Label label = new Label(comp, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = colSpan;
        label.setLayoutData((Object)gd);
    }

    public void createDateWidget(ParserPropertiesComposite composite, DateParserField field) {
        ImportWizardDateWidget widget = new ImportWizardDateWidget(field);
        widget.createControl((Composite)composite.getContent(), this.prefix);
        composite.getControlLookup().put(field.getId(), widget);
        composite.getFieldIDs().add(field.getId());
    }

    public void createCommonWidget(ParserPropertiesComposite composite, CommonParserField field) {
        ImportWizardComboBox widget = null;
        short t = field.getType();
        switch (t) {
            case 0: {
                widget = new ImportWizardCommonFieldWidget(field);
                widget.createControl((Composite)composite.getContent(), this.prefix);
                break;
            }
            case 1: {
                widget = new ImportWizardCommonFieldWidget(field);
                widget.createControl((Composite)composite.getContent(), this.prefix);
                break;
            }
            case 2: {
                widget = new ImportWizardTimeZoneWidget(field);
                widget.createControl((Composite)composite.getContent(), this.prefix);
            }
        }
        composite.getControlLookup().put(field.getId(), widget);
        composite.getFieldIDs().add(field.getId());
    }

    public void createWidget(ParserPropertiesComposite composite, ParserField field) {
        IImportWizardWidget widget = null;
        String trim = field.getUiType().trim();
        int type = 4;
        if (trim.equals("combobox")) {
            widget = new ImportWizardComboBox(field);
            type = 0;
        } else if (trim.equals("checkbox")) {
            widget = new ImportWizardCheckBox(field);
            type = 1;
        } else if (trim.equals("radio")) {
            widget = new ImportWizardRadioButton(field);
            type = 2;
        } else if (trim.equals("text_area")) {
            widget = new ImportWizardTextArea(field);
            type = 3;
        } else {
            widget = trim.equals("password_field") ? new ImportWizardTextField(composite.getFiltersTable(), field, 0x400000) : new ImportWizardTextField(composite.getFiltersTable(), field, 0);
        }
        widget.createControl((Composite)composite.getContent(), this.prefix);
        IWidgetListener listener = ((ParserField)widget.getField()).getListenerInstance();
        if (type == 0) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)((ImportWizardComboBox)widget).getComboBox(), String.valueOf(MonitoringLogUIPlugin.getPluginId()) + ".importloglocation");
            composite.getWidgets().put(field.getId(), ((ImportWizardComboBox)widget).getComboBox());
            if (listener != null) {
                composite.getListeners().put(((ImportWizardComboBox)widget).getComboBox(), listener);
                ((ImportWizardComboBox)widget).getComboBox().addListener(13, (Listener)this);
            }
        } else if (type == 1) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)((ImportWizardCheckBox)widget).getCheckBox(), String.valueOf(MonitoringLogUIPlugin.getPluginId()) + ".importloglocation");
            composite.getWidgets().put(field.getId(), ((ImportWizardCheckBox)widget).getCheckBox());
            if (listener != null) {
                composite.getListeners().put(((ImportWizardCheckBox)widget).getCheckBox(), listener);
                ((ImportWizardCheckBox)widget).getCheckBox().addListener(13, (Listener)this);
            }
        } else if (type == 2) {
            Iterator buttons = ((ImportWizardRadioButton)widget).getButtonList().iterator();
            int i = 0;
            while (buttons.hasNext()) {
                Button currentButton = (Button)buttons.next();
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)currentButton, String.valueOf(MonitoringLogUIPlugin.getPluginId()) + ".importloglocation");
                composite.getWidgets().put(String.valueOf(field.getId()) + "_" + i, currentButton);
                if (listener != null) {
                    composite.getListeners().put(currentButton, listener);
                    currentButton.addListener(13, (Listener)this);
                }
                ++i;
            }
        } else if (type == 3) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)((ImportWizardTextArea)widget).getText(), String.valueOf(MonitoringLogUIPlugin.getPluginId()) + ".importloglocation");
            composite.getWidgets().put(field.getId(), ((ImportWizardTextArea)widget).getText());
            if (listener != null) {
                composite.getListeners().put(((ImportWizardTextArea)widget).getText(), listener);
                ((ImportWizardTextArea)widget).getText().addListener(13, (Listener)this);
            }
        } else {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)((ImportWizardTextField)widget).getText(), String.valueOf(MonitoringLogUIPlugin.getPluginId()) + ".importloglocation");
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)((ImportWizardTextField)widget).getBtn(), String.valueOf(MonitoringLogUIPlugin.getPluginId()) + ".browsebtn");
            composite.getWidgets().put(field.getId(), ((ImportWizardTextField)widget).getText());
            if (listener != null) {
                composite.getListeners().put(((ImportWizardTextField)widget).getText(), listener);
                ((ImportWizardTextField)widget).getText().addListener(13, (Listener)this);
            }
        }
        if (widget instanceof ImportWizardTextField) {
            ImportWizardTextField textField = (ImportWizardTextField)widget;
            textField.getText().addModifyListener((ModifyListener)this);
            composite.getButtonList().add(((ImportWizardTextField)widget).getBtn());
            composite.getFields().put(field.getId(), field);
        }
        composite.getControlLookup().put(field.getId(), widget);
        composite.getFieldIDs().add(field.getId());
    }

    public void initialize(Composite composite, LogFileElement elem) {
        if (this.details.getSelectedParser() == null) {
            return;
        }
        this.prefix = String.valueOf(this.details.getHostName()) + "." + this.details.getSelectedParser().getDescription() + ".";
        IPreferenceStore store = MonitoringLogUIPlugin.getDefault().getPreferenceStore();
        String previousValue = "";
        BasicParserField field = null;
        Map input = ((ParserPropertiesComposite)composite).getControlLookup();
        List fieldIDs = ((ParserPropertiesComposite)composite).getFieldIDs();
        Object widget = null;
        Iterator iter = fieldIDs.iterator();
        while (iter.hasNext()) {
            String id = (String)iter.next();
            widget = input.get(id);
            if (widget instanceof IImportWizardWidget) {
                field = ((IImportWizardWidget)widget).getField();
                previousValue = store.getString(String.valueOf(this.prefix) + field.getId());
                if (previousValue != null && previousValue.length() > 0) {
                    ((IImportWizardWidget)widget).setValue(previousValue);
                    continue;
                }
                ((IImportWizardWidget)widget).setValue(field.getDefaultValue() != null ? field.getDefaultValue() : "");
                continue;
            }
            if (!(widget instanceof IImportWizardControl)) continue;
            Map userInput = ((IImportWizardControl)widget).getUserInput();
            Iterator iterator = userInput.keySet().iterator();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                previousValue = store.getString(String.valueOf(this.prefix) + key);
                if (previousValue == null || previousValue.length() <= 0) continue;
                userInput.put(key, previousValue);
            }
            ((IImportWizardControl)widget).setUserInput(userInput);
        }
        this.notifyListeners(composite);
    }

    public void initializeUIFromLogElement(Composite composite, LogFileElement elem) {
        Map values = elem.getValues();
        List fieldIDs = ((ParserPropertiesComposite)composite).getFieldIDs();
        Map input = ((ParserPropertiesComposite)composite).getControlLookup();
        Object widget = null;
        Iterator iter = fieldIDs.iterator();
        while (iter.hasNext()) {
            String id = (String)iter.next();
            widget = input.get(id);
            if (widget instanceof IImportWizardWidget) {
                String value = (String)values.get(id);
                if (value == null) continue;
                ((IImportWizardWidget)widget).setValue(value);
                continue;
            }
            if (!(widget instanceof IImportWizardControl)) continue;
            HashMap newValue = new HashMap(values.size());
            Iterator valuesIter = values.entrySet().iterator();
            while (valuesIter.hasNext()) {
                Map.Entry entry = valuesIter.next();
                String fieldPrefix = String.valueOf(id) + ".";
                String key = (String)entry.getKey();
                if (key != null && key.startsWith(fieldPrefix)) {
                    newValue.put(key.substring(fieldPrefix.length()), values.get(key));
                    continue;
                }
                newValue.put(key, values.get(key));
            }
            ((IImportWizardControl)widget).setUserInput(newValue);
        }
    }

    public Map getUserInput(LogParserItem item) {
        ParserPropertiesComposite composite = (ParserPropertiesComposite)((Object)this.composites.get(item));
        return composite.getUserInput();
    }

    public Composite getCompositeFor(ILogParserItem parser) {
        return (Composite)this.composites.get(parser);
    }

    public void dispose() {
        if (this.composites != null && !this.composites.isEmpty()) {
            Collection values = this.composites.values();
            Iterator iter = values.iterator();
            while (iter.hasNext()) {
                ParserPropertiesComposite composite = (ParserPropertiesComposite)((Object)iter.next());
                Map controlLookup = composite.getControlLookup();
                if (controlLookup == null || controlLookup.isEmpty()) continue;
                Iterator iterator = controlLookup.values().iterator();
                while (iterator.hasNext()) {
                    IImportWizardControlListener listener;
                    Object element = iterator.next();
                    if (!(element instanceof IImportWizardControl) || (listener = (IImportWizardControlListener)composite.getListeners().get(element)) == null) continue;
                    ((IImportWizardControl)element).removeControlListener(listener);
                }
            }
        }
        this.composites.clear();
        this.composites = null;
    }

    public boolean finish() {
        ParserField field = null;
        LogFileElement logElem = this.page.getSelectedElement();
        ILogParserItem selectedParser = this.details.getSelectedParser();
        if (!(selectedParser instanceof LogParserItem)) {
            return false;
        }
        Map input = this.getUserInput((LogParserItem)selectedParser);
        this.prefix = String.valueOf(this.details.getHostName()) + "." + this.details.getSelectedParser().getDescription() + ".";
        this.updateElement(logElem, input);
        Composite selected = (Composite)this.composites.get(this.details.getSelectedParser());
        ParserPropertiesComposite composite = (ParserPropertiesComposite)selected;
        Map fields = composite.getFields();
        Object widget = null;
        IPreferenceStore store = MonitoringLogUIPlugin.getDefault().getPreferenceStore();
        if (fields != null && !fields.isEmpty()) {
            Set keys = fields.keySet();
            Iterator iter = keys.iterator();
            while (iter.hasNext()) {
                field = (ParserField)fields.get(iter.next());
                widget = composite.getControlLookup().get(field.getId());
                if (widget instanceof IImportWizardWidget) {
                    Control control = (Control)composite.getWidgets().get(field.getId());
                    if (control != null && !control.isEnabled()) continue;
                    if (((IImportWizardWidget)widget).isValid()) {
                        store.setValue(String.valueOf(this.prefix) + field.getId(), ((IImportWizardWidget)widget).getValue());
                        continue;
                    }
                    return false;
                }
                if (!(widget instanceof IImportWizardControl)) continue;
                Map userInput = ((IImportWizardControl)widget).getUserInput();
                if (!((IImportWizardControl)widget).isValid()) {
                    return false;
                }
                Iterator iterator = userInput.keySet().iterator();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    Object value = userInput.get(key);
                    if (value == null) continue;
                    store.setValue(String.valueOf(this.prefix) + key, value.toString());
                }
            }
        }
        return true;
    }

    public void updateElement(LogFileElement logElem, Map input) {
        Map values = logElem.getValues();
        values.clear();
        values.putAll(input);
    }

    public void modifyText(ModifyEvent e) {
        this.details.setOKButtonEnabled(this.isTabItemComplete());
    }

    public void handleEvent(Event event) {
        ParserPropertiesComposite selected = (ParserPropertiesComposite)((Object)this.composites.get(this.details.getSelectedParser()));
        if (selected.getListeners().containsKey(event.widget)) {
            IWidgetListener listener = (IWidgetListener)selected.getListeners().get(event.widget);
            String value = String.valueOf(listener.hashCode());
            if (!this._listenersServed.contains(value)) {
                this._listenersServed.add(value);
                this.details.updateListenersServed(this._listenersServed);
                listener.storeWidgets(selected.getWidgets());
            }
            listener.takeAction(event);
            this.details.setOKButtonEnabled(this.isTabItemComplete());
        }
    }

    public boolean isTabItemComplete() {
        if (this.details.getSelectedParser() == null) {
            return false;
        }
        ParserPropertiesComposite selected = (ParserPropertiesComposite)((Object)this.composites.get(this.details.getSelectedParser()));
        Iterator iter = selected.getControlLookup().values().iterator();
        while (iter.hasNext()) {
            Object widget = iter.next();
            if (!(widget instanceof IImportWizardWidget ? !((IImportWizardWidget)widget).isValid() : widget instanceof IImportWizardControl && !((IImportWizardControl)widget).isValid())) continue;
            return false;
        }
        return true;
    }

    public void enableButtons(Composite composite) {
        boolean isLocalHost = this.details.isLocalHost();
        List buttons = ((ParserPropertiesComposite)composite).getButtonList();
        int idx = 0;
        while (idx < buttons.size()) {
            Button btn = (Button)buttons.get(idx);
            btn.setEnabled(isLocalHost);
            ++idx;
        }
    }

    public void setWidgets(Map widgets) {
        ((ParserPropertiesComposite)((Object)this.composites.get(this.details.getSelectedParser()))).getWidgets().clear();
        ((ParserPropertiesComposite)((Object)this.composites.get(this.details.getSelectedParser()))).getWidgets().putAll(widgets);
    }

    public Map getWidgets() {
        if (this.details.getSelectedParser() != null) {
            return ((ParserPropertiesComposite)((Object)this.composites.get(this.details.getSelectedParser()))).getWidgets();
        }
        return Collections.EMPTY_MAP;
    }

    public void setListenersServed(Vector listenersServed) {
        this._listenersServed = listenersServed;
    }

    public Vector getListenersServed() {
        return this._listenersServed;
    }

    public void notifyListeners(Composite composite) {
        if (((ParserPropertiesComposite)composite).getListeners() != null) {
            Event event = new Event();
            Iterator iter = ((ParserPropertiesComposite)composite).getListeners().keySet().iterator();
            while (iter.hasNext()) {
                Object object = iter.next();
                if (!(object instanceof Widget)) continue;
                Widget element = (Widget)object;
                IWidgetListener listener = (IWidgetListener)((ParserPropertiesComposite)composite).getListeners().get(element);
                listener.storeWidgets(((ParserPropertiesComposite)composite).getWidgets());
                event.widget = element;
                listener.takeAction(event);
                this.details.setOKButtonEnabled(this.isTabItemComplete());
            }
        }
    }

    class ParserPropertiesComposite
    extends ScrolledComposite {
        private Hashtable _filtersTable = new Hashtable();
        private Map controlLookup = new HashMap();
        private Map _fieldList = new Hashtable();
        private List _buttonList = new ArrayList();
        private List ids = new ArrayList();
        private Map _widgets = new HashMap();
        private Map _listeners = new HashMap();

        public ParserPropertiesComposite(Composite parent, int style) {
            super(parent, style);
        }

        public List getButtonList() {
            return this._buttonList;
        }

        public Map getFields() {
            return this._fieldList;
        }

        public List getFieldIDs() {
            return this.ids;
        }

        public Hashtable getFiltersTable() {
            return this._filtersTable;
        }

        public Map getControlLookup() {
            return this.controlLookup;
        }

        public Map getWidgets() {
            return this._widgets;
        }

        public Map getListeners() {
            return this._listeners;
        }

        public Map getUserInput() {
            HashMap<String, String> table = new HashMap<String, String>();
            Object control = null;
            int s = this.ids.size();
            int i = 0;
            while (i < s) {
                Map userInput;
                String id = (String)this.ids.get(i);
                control = this.controlLookup.get(id);
                if (control instanceof IImportWizardWidget) {
                    table.put(id, ((IImportWizardWidget)control).getValue());
                } else if (control instanceof IImportWizardControl && (userInput = ((IImportWizardControl)control).getUserInput()) != null && !userInput.isEmpty()) {
                    Iterator iter = userInput.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry element = iter.next();
                        if (element.getKey() == null) continue;
                        table.put(String.valueOf(id) + "." + (String)element.getKey(), (String)element.getValue());
                    }
                    table.put("logFileLabel", ((IImportWizardControl)control).getLogElementLabel());
                }
                ++i;
            }
            return table;
        }
    }
}

