/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.monitoring.logui.internal.wizards;

import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.hyades.logging.parsers.importer.ILogParser;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.tptp.monitoring.logui.internal.LogUIMessages;
import org.eclipse.tptp.monitoring.logui.internal.wizards.BasicParserField;
import org.eclipse.tptp.monitoring.logui.internal.wizards.ILogParserItem;
import org.eclipse.tptp.monitoring.logui.internal.wizards.ParserParameter;

public class LogParserItem
implements ILogParserItem {
    private String _id = "";
    private String parserSetId = "";
    private String _name = "";
    private String _uiName = "_unknown";
    private String _desc = "";
    private ImageDescriptor _imgDesc;
    private String _class = "";
    private String _uiType = "text_field";
    private BasicParserField[] _parserFields = new BasicParserField[10];
    private int _currentFieldIndex = 0;
    private IConfigurationElement _config;
    private ArrayList _parserParameters = new ArrayList();
    private Map _widgets;
    private Vector _listenersServed;

    public LogParserItem(String id, String name, String uiName, String desc) {
        if (id != null) {
            this._id = id;
        }
        if (name != null) {
            this._name = name;
        }
        if (uiName != null) {
            this._uiName = uiName;
        }
        if (desc != null) {
            this._desc = desc;
        }
    }

    public void setImageDescriptor(ImageDescriptor imgDesc) {
        this._imgDesc = imgDesc;
    }

    public void setClass(String cls) {
        if (cls != null) {
            this._class = cls;
        }
    }

    public void setUIType(String type) {
        if (type != null) {
            this._uiType = type;
        }
    }

    public void addEntry(BasicParserField field) {
        if (this._currentFieldIndex < this._parserFields.length) {
            this._parserFields[this._currentFieldIndex++] = field;
        } else {
            int newLength = (int)Math.round((double)this._parserFields.length * 1.33);
            BasicParserField[] newParserFields = new BasicParserField[newLength];
            System.arraycopy(this._parserFields, 0, newParserFields, 0, this._parserFields.length);
            this._parserFields = newParserFields;
            this._parserFields[this._currentFieldIndex++] = field;
        }
    }

    public String getName() {
        return this._name;
    }

    public String getUIType() {
        return this._uiType;
    }

    public String getLabel() {
        return this._uiName;
    }

    public String getDescription() {
        return this._desc;
    }

    public ImageDescriptor getImageDescriptor() {
        return this._imgDesc;
    }

    public BasicParserField[] getFields() {
        return this._parserFields;
    }

    public String getId() {
        return this._id;
    }

    public String getParserClass() {
        return this._class;
    }

    public ILogParser getParserInstance() {
        try {
            if (this._config == null) {
                return null;
            }
            Object elem = this._config.createExecutableExtension("class");
            if (elem instanceof ILogParser) {
                return (ILogParser)elem;
            }
            System.err.println(LogUIMessages._46);
        }
        catch (CoreException coreException) {
            return null;
        }
        return null;
    }

    public void setConfigurationElement(IConfigurationElement elem) {
        this._config = elem;
    }

    public void setWidgets(Map widgets) {
        this._widgets = widgets;
    }

    public Map getWidgets() {
        return this._widgets;
    }

    public void setListenersServed(Vector listenersServed) {
        this._listenersServed = listenersServed;
    }

    public Vector getListenersServed() {
        return this._listenersServed;
    }

    public ArrayList getParserParameters() {
        return this._parserParameters;
    }

    public void addParameter(ParserParameter para) {
        this._parserParameters.add(para);
    }

    public String getNamespace() {
        if (this._config.getDeclaringExtension() != null) {
            return this._config.getDeclaringExtension().getNamespace();
        }
        return null;
    }

    public String getParentId() {
        return this.parserSetId;
    }

    public void setParentId(String parserSetId) {
        this.parserSetId = parserSetId;
    }
}

