/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.monitoring.logui.internal.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.hyades.models.hierarchy.util.internal.QueryUtils;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.tptp.monitoring.logui.internal.LogUIMessages;
import org.eclipse.tptp.monitoring.logui.internal.MonitoringLogUIPlugin;
import org.eclipse.tptp.monitoring.logui.internal.wizards.ILogParserItem;
import org.eclipse.tptp.monitoring.logui.internal.wizards.LogFileDetailsUI;
import org.eclipse.tptp.monitoring.logui.internal.wizards.LogParserItem;
import org.eclipse.tptp.monitoring.logui.internal.wizards.LogParserSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.progress.WorkbenchJob;

public class LogParserUI {
    private Combo _filter;
    private Button _viewBy;
    private TreeViewer _parserViewer;
    private Label _description;
    private Map _images = new HashMap();
    private ArrayList _parserList = new ArrayList();
    private ILogParserItem _parser;
    private LogFileDetailsUI _detailsUI;
    private Comparator _comparator;
    private static final String FILTER_HISTORY = "filterHistory";
    private static final String SHOW_CATEGORY = "showCategory";
    private static final int maxNrItems = 10;
    private Section typesSection;
    private Job refreshJob;
    private Job initJob;
    private String _userFilter = null;

    public LogParserUI(LogFileDetailsUI detailsUI) {
        this._detailsUI = detailsUI;
        this._comparator = new LogParserItemComparator();
    }

    public Composite createControl(Composite parent, FormToolkit toolkit) {
        return this.createControl(parent, toolkit, null);
    }

    public Composite createControl(Composite parent, FormToolkit toolkit, String initFilter) {
        this._userFilter = initFilter;
        this._detailsUI.createSpace(parent);
        this.createTypesSection(parent, toolkit);
        this.createInitJob();
        this.initJob.addJobChangeListener(new IJobChangeListener(){

            public void aboutToRun(IJobChangeEvent event) {
            }

            public void awake(IJobChangeEvent event) {
            }

            public void done(IJobChangeEvent event) {
                LogParserUI.this.initializeUI();
            }

            public void running(IJobChangeEvent event) {
            }

            public void scheduled(IJobChangeEvent event) {
            }

            public void sleeping(IJobChangeEvent event) {
            }
        });
        this._filter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LogParserUI.this.refreshJob.schedule();
            }
        });
        this._filter.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                String[] textValues = LogParserUI.this._filter.getItems();
                String newText = LogParserUI.this._filter.getText();
                if (newText.equals("") || newText.equals(LogUIMessages._83)) {
                    return;
                }
                int i = 0;
                while (i < textValues.length) {
                    if (textValues[i].equals(newText)) {
                        return;
                    }
                    ++i;
                }
                if (textValues.length >= 10) {
                    LogParserUI.this._filter.remove(9);
                }
                LogParserUI.this._filter.add(newText, 0);
            }
        });
        this._viewBy.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                LogParserUI.this.refreshJob.schedule();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.createRefreshJob();
        return parent;
    }

    protected void createTypesSection(final Composite parent, FormToolkit toolkit) {
        this.typesSection = toolkit.createSection(parent, 194);
        GridLayout detailsLayout = new GridLayout();
        detailsLayout.marginHeight = 2;
        detailsLayout.marginWidth = 2;
        this.typesSection.setLayout((Layout)detailsLayout);
        GridData data = GridUtil.createHorizontalFill();
        this.typesSection.setLayoutData((Object)data);
        this.typesSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                parent.layout();
            }
        });
        this.typesSection.setText(LogUIMessages._87);
        this.typesSection.setBackground(Display.getDefault().getSystemColor(22));
        Composite types = new Composite((Composite)this.typesSection, 0);
        types.setLayoutData((Object)GridUtil.createHorizontalFill());
        GridLayout layout = new GridLayout();
        types.setLayout((Layout)layout);
        Label label = new Label(types, 0);
        label.setLayoutData((Object)new GridData());
        label.setText(LogUIMessages._84);
        Composite filter = new Composite(types, 0);
        filter.setLayoutData((Object)GridUtil.createHorizontalFill());
        layout = new GridLayout();
        layout.numColumns = 2;
        filter.setLayout((Layout)layout);
        this._filter = new Combo(filter, 0);
        data = new GridData();
        data.widthHint = 200;
        this._filter.setLayoutData((Object)data);
        this._viewBy = new Button(filter, 32);
        this._viewBy.setText(LogUIMessages._85);
        data = new GridData();
        data.horizontalAlignment = 131072;
        data.grabExcessHorizontalSpace = true;
        this._viewBy.setLayoutData((Object)data);
        this.initializeCategoriesButton();
        Tree _list = new Tree(types, 68356);
        data = GridUtil.createHorizontalFill();
        data.heightHint = 100;
        _list.setLayoutData((Object)data);
        this._parserViewer = new TreeViewer(_list);
        this._parserViewer.setContentProvider((IContentProvider)new LogParserUIContentProvider());
        this._parserViewer.setLabelProvider((IBaseLabelProvider)new LogParserUILabelProvider());
        this._parserViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (sel != null && !sel.isEmpty()) {
                    LogParserUI.this._parser = (ILogParserItem)sel.getFirstElement();
                    LogParserUI.this._detailsUI.setSelectedParser(LogParserUI.this._parser);
                    LogParserUI.this._description.setText(LogParserUI.this._parser != null ? LogParserUI.this._parser.getDescription() : "");
                }
            }
        });
        this._description = new Label(types, 64);
        data = GridUtil.createHorizontalFill();
        this._description.setLayoutData((Object)data);
        this.typesSection.setClient((Control)types);
        this.initializeFilterCombo();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)_list, String.valueOf(MonitoringLogUIPlugin.getPluginId()) + ".parserlist");
    }

    private void initializeCategoriesButton() {
        IDialogSettings settings = this._detailsUI.getDialogSettings();
        this._viewBy.setSelection(settings.getBoolean(SHOW_CATEGORY));
    }

    private void createInitJob() {
        this.initJob = new WorkbenchJob("Initialize Parser UI"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                LogParserUI.this.initializeValues();
                return new Status(0, MonitoringLogUIPlugin.getPluginId(), 0, "", null);
            }
        };
        this.initJob.setSystem(true);
        this.initJob.schedule();
    }

    private void createRefreshJob() {
        this.refreshJob = new WorkbenchJob("Refresh Parser Tree"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (LogParserUI.this._parserViewer.getControl().isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                LogParserUI.this._parserViewer.getControl().setRedraw(false);
                LogParserUI.this._parserViewer.refresh(true);
                LogParserUI.this._parserViewer.getControl().setRedraw(true);
                return Status.OK_STATUS;
            }
        };
        this.refreshJob.setSystem(true);
    }

    private void initializeFilterCombo() {
        IDialogSettings settings = this._detailsUI.getDialogSettings();
        String[] filter = settings.getArray(FILTER_HISTORY);
        if (filter == null) {
            this._filter.add(LogUIMessages._83);
            this._filter.setText(LogUIMessages._83);
            return;
        }
        int i = 0;
        while (i < filter.length) {
            this._filter.add(filter[i]);
            ++i;
        }
        this._filter.setText(LogUIMessages._83);
    }

    private void initFilter(String initFilter) {
        boolean existed = false;
        if (initFilter != null) {
            String[] filters = this._filter.getItems();
            int i = 0;
            while (i < filters.length) {
                if (filters[i].equals(initFilter)) {
                    this._filter.setText(filters[i]);
                    existed = true;
                    break;
                }
                ++i;
            }
            if (!existed && initFilter != null) {
                this._filter.add(initFilter);
                this._filter.setText(initFilter);
            }
            if (this.hasFilteredChildren(this._parserList)) {
                return;
            }
            if (!existed) {
                this._filter.remove(initFilter);
            }
            this._filter.setText(LogUIMessages._83);
        }
    }

    private void initializeValues() {
        Collection parsers = this._detailsUI.getParserRegistry().values();
        LogParserItem parser = null;
        Iterator iter = parsers.iterator();
        while (iter.hasNext()) {
            parser = (LogParserItem)iter.next();
            if (parser.getParentId() != null && parser.getParentId().length() != 0) continue;
            this._parserList.add(parser);
        }
        List parserSets = this._detailsUI.getParserSets();
        this._parserList.addAll(parserSets);
        if (this._userFilter != null) {
            this.initFilter(this._userFilter);
        }
        Collections.sort(this._parserList, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((ILogParserItem)o1).getLabel().compareToIgnoreCase(((ILogParserItem)o2).getLabel());
            }
        });
    }

    private void initializeUI() {
        this._parserViewer.getControl().setRedraw(false);
        this._parserViewer.setInput((Object)this._parserList);
        this._parserViewer.getControl().setRedraw(true);
        if (this._parserList.size() > 0) {
            LogParserItem item = this._detailsUI.getLogFileElement().getParser();
            if (item == null) {
                item = this.getFirstParser(this._parserList);
                if (item != null) {
                    ILogParserItem parent = this._parser = item;
                    while ((parent = (ILogParserItem)((LogParserUIContentProvider)this._parserViewer.getContentProvider()).getParent(parent)) != null) {
                        this._parserViewer.setExpandedState((Object)parent, true);
                    }
                    this._parserViewer.setSelection((ISelection)new StructuredSelection((Object)this._parser), true);
                }
            } else {
                ILogParserItem parent = this._parser = item;
                while ((parent = (ILogParserItem)((LogParserUIContentProvider)this._parserViewer.getContentProvider()).getParent(parent)) != null) {
                    this._parserViewer.setExpandedState((Object)parent, true);
                }
                this._parserViewer.setSelection((ISelection)new StructuredSelection((Object)this._parser), true);
            }
            this._detailsUI.setSelectedParser(this._parser);
            this._description.setText(this._parser.getDescription());
            this._detailsUI.endInitElement();
            this._detailsUI.setOKButtonEnabled(this._detailsUI.isTabFolderComplete());
        }
    }

    public ILogParserItem getParser() {
        return this._parser;
    }

    public void dispose() {
        Image element = null;
        Iterator iter = this._images.values().iterator();
        while (iter.hasNext()) {
            element = (Image)iter.next();
            if (element == null || element.isDisposed()) continue;
            element.dispose();
        }
        this._images.clear();
        this._images = null;
        this._parserList.clear();
        this._parserList = null;
    }

    public Section getTypesSection() {
        return this.typesSection;
    }

    public TreeViewer getViewer() {
        return this._parserViewer;
    }

    public boolean finish() {
        IDialogSettings settings = this._detailsUI.getDialogSettings();
        settings.put(FILTER_HISTORY, this._filter.getItems());
        settings.put(SHOW_CATEGORY, this._viewBy.getSelection());
        return this._parserViewer.getSelection() != null && !this._parserViewer.getSelection().isEmpty();
    }

    private List filter(List input, boolean byName) {
        ArrayList<Object> result = new ArrayList<Object>();
        Object item = null;
        int s = input.size();
        int i = 0;
        while (i < s) {
            item = input.get(i);
            if (!byName || !(item instanceof LogParserSet)) {
                if (!byName && item != null && item instanceof LogParserSet && this.hasFilteredChildren((LogParserSet)item)) {
                    result.add(item);
                } else if (item != null && item instanceof LogParserItem && LogParserUI.like(((LogParserItem)item).getLabel().toLowerCase(), this._filter.getText().endsWith("*") ? this._filter.getText().toLowerCase() : String.valueOf(this._filter.getText().toLowerCase()) + "*") == 0) {
                    result.add(item);
                }
            }
            ++i;
        }
        return result;
    }

    private List getAllParserItems(List list) {
        ArrayList result = new ArrayList();
        Object item = null;
        int s = list.size();
        int i = 0;
        while (i < s) {
            item = list.get(i);
            if (item != null) {
                if (item != null && item instanceof LogParserItem) {
                    result.add(item);
                } else if (item instanceof LogParserSet && ((LogParserSet)item).getChildren() != null && ((LogParserSet)item).getChildren().size() > 0) {
                    result.addAll(this.getAllParserItems(((LogParserSet)item).getChildren()));
                }
            }
            ++i;
        }
        return result;
    }

    private boolean hasFilteredChildren(LogParserSet parserSet) {
        if (this._filter.getText().equals(LogUIMessages._83) || this._filter.getText().trim().length() == 0) {
            return true;
        }
        return this.hasFilteredChildren(parserSet.getChildren());
    }

    private boolean hasFilteredChildren(List input) {
        Object item = null;
        int s = input.size();
        int i = 0;
        while (i < s) {
            item = input.get(i);
            if (item != null && item instanceof LogParserItem) {
                if (this._filter.getText().equals(LogUIMessages._83) || this._filter.getText().trim().length() == 0) {
                    return true;
                }
                if (LogParserUI.like(((LogParserItem)item).getLabel().toLowerCase(), this._filter.getText().endsWith("*") ? this._filter.getText().toLowerCase() : String.valueOf(this._filter.getText().toLowerCase()) + "*") == 0) {
                    return true;
                }
            } else if (item != null && item instanceof LogParserSet && ((LogParserSet)item).getChildren().size() > 0) {
                return this.hasFilteredChildren(((LogParserSet)item).getChildren());
            }
            ++i;
        }
        return false;
    }

    private LogParserItem getFirstParser(List list) {
        int s = list.size();
        Object item = null;
        int i = 0;
        while (i < s) {
            item = list.get(i);
            if (item != null) {
                if (item instanceof LogParserItem) {
                    return item;
                }
                if (item instanceof LogParserSet) {
                    return this.getFirstParser(((LogParserSet)item).getChildren());
                }
            }
            ++i;
        }
        return null;
    }

    public static int like(String lhs, String rhs) {
        String delimiters = "/ ,.:;<>?|\\[]{}-+_*&^%$#@!'\"\t\n\r\f";
        int i = 0;
        while (i < lhs.length()) {
            if ((i == 0 || delimiters.indexOf(lhs.charAt(i - 1)) >= 0) && QueryUtils.like((String)lhs.substring(i), (String)rhs) == 0) {
                return 0;
            }
            ++i;
        }
        return QueryUtils.like((String)lhs, (String)rhs);
    }

    private class LogParserItemComparator
    implements Comparator {
        LogParserItemComparator() {
        }

        public int compare(Object o1, Object o2) {
            LogParserItem p1 = (LogParserItem)o1;
            LogParserItem p2 = (LogParserItem)o2;
            return p1.getDescription().compareTo(p2.getDescription());
        }
    }

    class LogParserUIContentProvider
    implements ITreeContentProvider {
        LogParserUIContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement == LogParserUI.this._parserList) {
                List<Object> result;
                if (LogParserUI.this._filter.getText().equals(LogUIMessages._83) || LogParserUI.this._filter.getText().trim().length() == 0) {
                    if (LogParserUI.this._viewBy.getSelection()) {
                        result = LogParserUI.this._parserList;
                    } else {
                        result = LogParserUI.this.getAllParserItems(LogParserUI.this._parserList);
                        Object[] items = result.toArray(new Object[result.size()]);
                        Arrays.sort(items, LogParserUI.this._comparator);
                        result.clear();
                        int i = 0;
                        while (i < items.length) {
                            result.add(items[i]);
                            ++i;
                        }
                    }
                } else {
                    result = LogParserUI.this._viewBy.getSelection() ? LogParserUI.this.filter((List)parentElement, false) : LogParserUI.this.filter(LogParserUI.this.getAllParserItems(LogParserUI.this._parserList), true);
                }
                return result.toArray(new Object[result.size()]);
            }
            if (parentElement instanceof LogParserItem) {
                return null;
            }
            if (parentElement instanceof LogParserSet) {
                List result = LogParserUI.this._filter.getText().equals(LogUIMessages._83) || LogParserUI.this._filter.getText().trim().length() == 0 ? ((LogParserSet)parentElement).getChildren() : LogParserUI.this.filter(((LogParserSet)parentElement).getChildren(), !LogParserUI.this._viewBy.getSelection());
                return result.toArray(new Object[result.size()]);
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element == null) {
                return null;
            }
            if (element instanceof LogParserItem) {
                if (((LogParserItem)element).getParentId() != null) {
                    return LogParserUI.this._detailsUI.getParserSetRegistry().get(((LogParserItem)element).getParentId());
                }
            } else if (element instanceof LogParserSet && ((LogParserSet)element).getParentId() != null) {
                return LogParserUI.this._detailsUI.getParserSetRegistry().get(((LogParserSet)element).getParentId());
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof List) {
                return LogParserUI.this.hasFilteredChildren((List)element);
            }
            if (element instanceof LogParserItem) {
                return false;
            }
            if (element instanceof LogParserSet) {
                return LogParserUI.this.hasFilteredChildren(((LogParserSet)element).getChildren());
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class LogParserUILabelProvider
    extends LabelProvider {
        LogParserUILabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof LogParserItem) {
                Image image = (Image)LogParserUI.this._images.get(element);
                if (image == null) {
                    image = ((LogParserItem)element).getImageDescriptor() != null ? ((LogParserItem)element).getImageDescriptor().createImage() : null;
                    LogParserUI.this._images.put(element, image);
                }
                return image;
            }
            if (element instanceof LogParserSet) {
                Image image = (Image)LogParserUI.this._images.get(element);
                if (image == null && (image = ((LogParserSet)element).getImageDescriptor().createImage()) != null) {
                    LogParserUI.this._images.put(element, image);
                }
                return image;
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof LogParserItem) {
                return ((LogParserItem)element).getLabel();
            }
            if (element instanceof LogParserSet) {
                return ((LogParserSet)element).getLabel();
            }
            return null;
        }
    }
}

