/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.analysis.codereview.java;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.tptp.platform.analysis.codereview.java.CodeReviewResource;
import org.eclipse.tptp.platform.analysis.codereview.java.internal.CodeReviewRealtimeResult;
import org.eclipse.tptp.platform.analysis.core.category.IAnalysisCategory;
import org.eclipse.tptp.platform.analysis.core.element.IAnalysisElement;
import org.eclipse.tptp.platform.analysis.core.history.AnalysisHistory;
import org.eclipse.tptp.platform.analysis.core.logging.Log;
import org.eclipse.tptp.platform.analysis.core.provider.AbstractAnalysisProvider;

public class CodeReviewProvider
extends AbstractAnalysisProvider {
    private static final String EMPTY = "";
    private static final String COMMA = "";
    private static final String JAVA_EXT = "java";
    public static final String RESOURCE_PROPERTY = "resource";
    private static final String ANALYSIS_OLDREALTIME = "OLDREALTIME";

    public void analyze(IProgressMonitor monitor, AnalysisHistory history) {
        if (history.getProviderPropertyHash().get("realtimeResource") == null) {
            List filteredResources = this.getFilteredResources(JAVA_EXT);
            monitor.beginTask("", filteredResources.size());
            Iterator it = filteredResources.iterator();
            while (it.hasNext()) {
                if (monitor.isCanceled()) {
                    return;
                }
                CodeReviewResource codeReviewRes = new CodeReviewResource((IResource)it.next());
                this.setProperty(history.getHistoryId(), RESOURCE_PROPERTY, (Object)codeReviewRes);
                Iterator it2 = this.getOwnedElements().iterator();
                while (it2.hasNext()) {
                    if (monitor.isCanceled()) {
                        return;
                    }
                    IAnalysisCategory category = (IAnalysisCategory)it2.next();
                    if (!history.containsAnalysisElement((IAnalysisElement)category)) continue;
                    category.analyze(history);
                }
                this.getProviderManager().notifyAnalysisListeners((IAnalysisElement)this);
                monitor.worked(1);
            }
        } else {
            CodeReviewRealtimeResult crresult;
            IResource resource = (IResource)history.getProviderPropertyHash().get("realtimeResource");
            CompilationUnit resourceCompilationUnit = (CompilationUnit)history.getProviderPropertyHash().get("realtimeCompUnit");
            ICompilationUnit compilationUnit = (ICompilationUnit)history.getProviderPropertyHash().get("realtimeCompUnit");
            String propertyName = "REALTIME" + resource.getFullPath().toOSString();
            String oldPropertyName = ANALYSIS_OLDREALTIME + resource.getFullPath().toOSString();
            this.setProperty(history.getHistoryId(), propertyName, new ArrayList());
            CodeReviewResource codeReviewRes = new CodeReviewResource(resource, resourceCompilationUnit, compilationUnit);
            this.setProperty(history.getHistoryId(), RESOURCE_PROPERTY, (Object)codeReviewRes);
            Iterator it2 = this.getOwnedElements().iterator();
            while (it2.hasNext()) {
                if (monitor.isCanceled()) {
                    return;
                }
                IAnalysisCategory category = (IAnalysisCategory)it2.next();
                if (!history.containsAnalysisElement((IAnalysisElement)category)) continue;
                category.analyze(history);
            }
            ArrayList oldResults = (ArrayList)this.getProperty(history.getHistoryId(), oldPropertyName);
            if (oldResults == null) {
                oldResults = new ArrayList();
            }
            List results = (List)this.getProperty(history.getHistoryId(), propertyName);
            Iterator it = results.iterator();
            while (it.hasNext()) {
                crresult = (CodeReviewRealtimeResult)it.next();
                boolean found = false;
                Iterator itOld = oldResults.iterator();
                while (itOld.hasNext() && !found) {
                    CodeReviewRealtimeResult croldresult = (CodeReviewRealtimeResult)itOld.next();
                    if (!crresult.equals(croldresult)) continue;
                    found = true;
                    itOld.remove();
                }
                if (!found) continue;
                it.remove();
            }
            it = results.iterator();
            while (it.hasNext()) {
                crresult = (CodeReviewRealtimeResult)it.next();
                crresult.createMarker();
            }
            Iterator itOld = oldResults.iterator();
            while (itOld.hasNext()) {
                CodeReviewRealtimeResult croldresult = (CodeReviewRealtimeResult)itOld.next();
                croldresult.destroyMarker();
            }
            results = (List)this.getProperty(history.getHistoryId(), propertyName);
            this.setProperty(history.getHistoryId(), oldPropertyName, results);
        }
        this.removeProperty(history.getHistoryId(), RESOURCE_PROPERTY);
    }

    private List getFilteredResources(String filter) {
        ArrayList javaResources = new ArrayList();
        Iterator resIter = this.getResources().iterator();
        while (resIter.hasNext()) {
            javaResources.addAll(this.extractFilteredResources(filter, (IResource)resIter.next()));
        }
        return javaResources;
    }

    private List extractFilteredResources(String filter, IResource resource) {
        ArrayList<IResource> toReturn = new ArrayList<IResource>();
        if (resource.getType() == 1) {
            String fileExt = ((IFile)resource).getFileExtension();
            if (fileExt != null && (fileExt.equals(filter) || filter.indexOf(String.valueOf(fileExt)) != -1 || filter.indexOf(fileExt) != -1)) {
                toReturn.add(resource);
            }
        } else {
            try {
                IResource[] resourceMembers = ((IContainer)resource).members();
                int i = 0;
                while (i < resourceMembers.length) {
                    toReturn.addAll(this.extractFilteredResources(filter, resourceMembers[i]));
                    ++i;
                }
            }
            catch (CoreException e) {
                Log.severe((String)"", (Throwable)e);
            }
        }
        return toReturn;
    }
}

