/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.analysis.codereview.java;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.tptp.platform.analysis.codereview.java.CodeReviewResult;
import org.eclipse.tptp.platform.analysis.codereview.java.CodeReviewVisitor;
import org.eclipse.tptp.platform.analysis.codereview.java.internal.CodeReviewRealtimeResult;
import org.eclipse.tptp.platform.analysis.core.element.IAnalysisElement;
import org.eclipse.tptp.platform.analysis.core.result.IAnalysisResult;
import org.eclipse.tptp.platform.analysis.core.rule.IAnalysisRule;

public class CodeReviewResource
extends ASTVisitor {
    private static final String UNDERSCORE = "_";
    private static final String EMPTY = "";
    private static ASTParser parser = ASTParser.newParser((int)3);
    private CompilationUnit resourceCompUnit = null;
    private ICompilationUnit compilationUnit = null;
    private IResource resource;
    private Hashtable cacheMap;

    public CodeReviewResource(IResource resource) {
        this.resource = resource;
        this.cacheMap = new Hashtable();
        this.compilationUnit = JavaCore.createCompilationUnitFrom((IFile)((IFile)resource));
        parser.setSource(this.compilationUnit);
        parser.setResolveBindings(true);
        this.resourceCompUnit = (CompilationUnit)parser.createAST(null);
    }

    public CodeReviewResource(IResource resource, CompilationUnit resourceCompUnit, ICompilationUnit compilationUnit) {
        this.resource = resource;
        this.cacheMap = new Hashtable();
        this.compilationUnit = compilationUnit;
        parser.setSource(this.compilationUnit);
        parser.setResolveBindings(true);
        this.resourceCompUnit = resourceCompUnit;
    }

    public List getTypedNodeList(ASTNode node, int nodeType) {
        return this.getTypedNodeList(node, nodeType, true);
    }

    public List getTypedNodeList(ASTNode node, int nodeType, boolean searchChildren) {
        return this.getTypedNodeList(node, nodeType, searchChildren, false);
    }

    public List getTypedNodeList(ASTNode node, int nodeType, boolean searchChildren, boolean includeRoot) {
        String key = node.hashCode() + UNDERSCORE + nodeType + UNDERSCORE + searchChildren + UNDERSCORE + includeRoot;
        List result = (List)this.cacheMap.get(key);
        if (result == null) {
            CodeReviewVisitor visitor = new CodeReviewVisitor(nodeType, searchChildren);
            node.accept((ASTVisitor)visitor);
            result = visitor.getAstNodeList();
            if (!includeRoot) {
                result.remove(node);
            }
            this.cacheMap.put(key, result);
        }
        LinkedList output = new LinkedList();
        output.addAll(result);
        return output;
    }

    public List getTypedNodeList(ASTNode node, int[] nodeTypes) {
        return this.getTypedNodeList(node, nodeTypes, true);
    }

    public List getTypedNodeList(ASTNode node, int[] nodeTypes, boolean searchChildren) {
        CodeReviewVisitor visitor = new CodeReviewVisitor(nodeTypes, searchChildren);
        node.accept((ASTVisitor)visitor);
        visitor.getAstNodeList().remove(node);
        return visitor.getAstNodeList();
    }

    public IResource getIResource() {
        return this.resource;
    }

    public CompilationUnit getResourceCompUnit() {
        return this.resourceCompUnit;
    }

    public void generateResultsForASTNode(IAnalysisRule rule, String historyId, ASTNode node) {
        if (historyId.equals("REALTIME")) {
            String propertyName = "REALTIME" + this.getICompilationUnit().getResource().getFullPath().toOSString();
            List results = (List)rule.getProvider().getProperty(historyId, propertyName);
            results.add(new CodeReviewRealtimeResult(this.getICompilationUnit().getResource(), rule, node.getStartPosition(), node.getStartPosition() + node.getLength(), this.getResourceCompUnit().getLineNumber(node.getStartPosition())));
        } else {
            CodeReviewResult result = new CodeReviewResult(this.getIResource().getFullPath().toString(), this.getResourceCompUnit().getLineNumber(node.getStartPosition()), node.getStartPosition(), node.getLength(), node, this);
            result.setOwner((IAnalysisElement)rule);
            rule.addHistoryResultSet(historyId, (IAnalysisResult)result);
        }
    }

    public boolean generateResultsForASTNodes(IAnalysisRule rule, String historyId, List list) {
        boolean addedResult = false;
        Iterator it = list.iterator();
        while (it.hasNext()) {
            ASTNode mi = (ASTNode)it.next();
            this.generateResultsForASTNode(rule, historyId, mi);
            addedResult = true;
        }
        return addedResult;
    }

    public ICompilationUnit getICompilationUnit() {
        return this.compilationUnit;
    }
}

