/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.analysis.codereview.java;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.tptp.platform.analysis.codereview.java.CodeReviewResource;
import org.eclipse.tptp.platform.analysis.core.AnalysisCorePlugin;
import org.eclipse.tptp.platform.analysis.core.element.IAnalysisElement;
import org.eclipse.tptp.platform.analysis.core.history.AnalysisHistory;
import org.eclipse.tptp.platform.analysis.core.logging.Log;
import org.eclipse.tptp.platform.analysis.core.result.AbstractAnalysisResult;

public class CodeReviewResult
extends AbstractAnalysisResult {
    private static final String EMPTY = "";
    private static final String INVALID_MARKER = "Invalid marker";
    private String resourceName = null;
    private CodeReviewResource resource = null;
    private ASTNode myNode = null;
    private IMarker marker;
    private static final char LINE_SEP = ':';

    public CodeReviewResult(String resName, int p_lineNumber, int p_startPosSelection, int p_lengthSelection, ASTNode node, CodeReviewResource resource) {
        try {
            this.marker = resource.getIResource().createMarker("org.eclipse.core.resources.textmarker");
            this.marker.setAttribute("lineNumber", p_lineNumber);
            this.marker.setAttribute("charStart", p_startPosSelection);
            this.marker.setAttribute("charEnd", p_startPosSelection + p_lengthSelection);
        }
        catch (CoreException e) {
            Log.severe((String)INVALID_MARKER, (Throwable)e);
        }
        this.resourceName = resName;
        this.resource = resource;
        this.myNode = node;
    }

    public String getLabel() {
        String label = super.getLabel();
        if (label == null || label.length() == 0) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.shortName(this.resourceName, '/')).append(':').append(this.getLineNumber()).append(' ').append(this.getLabelWithVariables());
            label = sb.toString();
            this.setLabel(label);
        }
        return label;
    }

    public int getLengthSelection() {
        return this.marker.getAttribute("charEnd", 0) - this.marker.getAttribute("charStart", 0);
    }

    public int getLineNumber() {
        return this.marker.getAttribute("lineNumber", 0);
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public int getStartPositionSelection() {
        return this.marker.getAttribute("charStart", 0);
    }

    public ASTNode getMyNode() {
        return this.myNode;
    }

    public CodeReviewResource getResource() {
        return this.resource;
    }

    private String shortName(String sFile, char cSep) {
        int idx = sFile.lastIndexOf(cSep);
        return idx == -1 ? sFile : sFile.substring(idx + 1);
    }

    public String exportXML(AnalysisHistory history) {
        String indent = EMPTY;
        CodeReviewResult element = this;
        while (element != null) {
            indent = String.valueOf(indent) + "\t";
            element = element.getOwner();
        }
        StringBuffer result = new StringBuffer();
        result.append(indent).append("\t<").append(IAnalysisElement.XML_ELEMENT_TAGS[this.getElementType()]).append(" name=\"").append(AnalysisCorePlugin.encodeForXML((String)this.getLabelWithVariables())).append("\" id=\"").append(this.getId()).append("\">\r\n");
        result.append(indent).append("\t<file>").append(this.getResourceName()).append("</file>\r\n");
        result.append(indent).append("\t<line>").append(this.getLineNumber()).append("</line>\r\n");
        result.append(indent).append("</").append(IAnalysisElement.XML_ELEMENT_TAGS[this.getElementType()]).append(">\r\n");
        return result.toString();
    }

    public IMarker getMarker() {
        return this.marker;
    }
}

