/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.analysis.codereview.java.ast;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.tptp.platform.analysis.codereview.java.CodeReviewVisitor;
import org.eclipse.tptp.platform.analysis.codereview.java.ast.RuleFilter;
import org.eclipse.tptp.platform.analysis.codereview.java.ast.internal.ASTHelperSatisfy;
import org.eclipse.tptp.platform.analysis.codereview.java.ast.internal.ASTHelperUtils;
import org.eclipse.tptp.platform.analysis.codereview.java.ast.internal.ITypeBindingIterator;

public class ASTHelper {
    private static final int[] EXPRESSION_TYPES = new int[]{81, 2, 3, 4, 7, 9, 11, 13, 14, 16, 22, 27, 62, 32, 40, 42, 33, 34, 36, 37, 38, 45, 47, 48, 52, 57, 58};
    private static final int[] VARIABLE_DECLARATION_TYPES = new int[]{44, 59};
    private static final int[] DATA_TYPES = new int[]{5, 74, 39, 75, 43, 76};
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static void satisfy(List fullList, List filterList) {
        Iterator it = fullList.iterator();
        while (it.hasNext()) {
            ASTNode node = (ASTNode)it.next();
            boolean isFinished = false;
            Iterator it2 = filterList.iterator();
            while (it2.hasNext() && !isFinished) {
                RuleFilter filter = (RuleFilter)it2.next();
                if (ASTHelper.statisfies(node, filter)) continue;
                it.remove();
                isFinished = true;
            }
        }
    }

    public static String getDataType(ASTNode node) {
        try {
            switch (node.getNodeType()) {
                case 23: {
                    return ((FieldDeclaration)node).getType().resolveBinding().getQualifiedName();
                }
                case 44: 
                case 59: {
                    return ((VariableDeclaration)node).resolveBinding().getType().getQualifiedName();
                }
                case 5: 
                case 39: 
                case 43: 
                case 74: 
                case 75: 
                case 76: {
                    return ((Type)node).resolveBinding().getQualifiedName();
                }
                case 2: 
                case 3: 
                case 4: 
                case 7: 
                case 9: 
                case 11: 
                case 13: 
                case 14: 
                case 16: 
                case 22: 
                case 27: 
                case 32: 
                case 33: 
                case 34: 
                case 36: 
                case 37: 
                case 38: 
                case 40: 
                case 42: 
                case 45: 
                case 47: 
                case 48: 
                case 52: 
                case 57: 
                case 58: 
                case 62: 
                case 77: 
                case 78: 
                case 79: {
                    return ((Expression)node).resolveTypeBinding().getQualifiedName();
                }
            }
            throw new UnsupportedOperationException();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isCheckedException(ITypeBinding bind) {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.RuntimeException");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (ASTHelper.instanceOf(bind, clazz.getName())) return false;
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.lang.Error");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!ASTHelper.instanceOf(bind, clazz2.getName())) return true;
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean regex(String input, String regexExp) {
        return Pattern.compile(regexExp).matcher(input).matches();
    }

    public static boolean instanceOf(ITypeBinding binding, String name) {
        if (binding == null) {
            return false;
        }
        boolean result = false;
        String bname = binding.getQualifiedName();
        if (bname.equals(name)) {
            result = true;
        }
        ITypeBinding above = binding.getSuperclass();
        if (!result && above != null) {
            result = ASTHelper.instanceOf(above, name);
        }
        if (!result) {
            ITypeBinding[] interfaces = binding.getInterfaces();
            int index = 0;
            while (index < interfaces.length) {
                if (ASTHelper.instanceOf(interfaces[index], name)) {
                    result = true;
                }
                ++index;
            }
        }
        return result;
    }

    public static boolean isDeclaredInParent(MethodDeclaration decl) {
        return ASTHelper.getFirstParentDeclaring(decl) != null;
    }

    public static IMethodBinding getFirstParentDeclaring(MethodDeclaration decl) {
        IMethodBinding binding = decl.resolveBinding();
        if (binding != null) {
            ITypeBinding declaring = binding.getDeclaringClass();
            ITypeBindingIterator iter = new ITypeBindingIterator(declaring);
            while (iter.hasNext()) {
                ITypeBinding curBinding = (ITypeBinding)iter.next();
                if (curBinding == declaring) continue;
                int index = 0;
                while (index < curBinding.getDeclaredMethods().length) {
                    if (ASTHelperUtils.same(decl.resolveBinding(), curBinding.getDeclaredMethods()[index])) {
                        return curBinding.getDeclaredMethods()[index];
                    }
                    ++index;
                }
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static IMethodBinding getFirstParentOverriden(MethodDeclaration decl) {
        end = false;
        declaring = decl.resolveBinding().getDeclaringClass();
        if (declaring != null) ** GOTO lbl12
        return null;
        while ((declaring = declaring.getSuperclass()) != null) {
            index = 0;
            while (index < declaring.getDeclaredMethods().length) {
                if (ASTHelperUtils.same(decl.resolveBinding(), declaring.getDeclaredMethods()[index])) {
                    return declaring.getDeclaredMethods()[index];
                }
                ++index;
            }
lbl12:
            // 2 sources

            if (!end) continue;
        }
        return null;
    }

    public static boolean isInParentOfType(ASTNode node, String typeParent, ASTNode maxParent) {
        return ASTHelper.getParentOfType(node, typeParent, maxParent) != null;
    }

    public static ASTNode getParentOfType(ASTNode node, String typeParent) {
        return ASTHelper.getParentOfType(node, typeParent, node.getRoot());
    }

    private static ASTNode getParentOfType(ASTNode node, String typeParent, ASTNode maxParent) {
        ASTNode parent = node.getParent();
        if (parent != null) {
            while (parent != null) {
                if (parent.getClass().getName().equals(typeParent)) {
                    return parent;
                }
                if (!(parent = parent.getParent()).equals((Object)maxParent)) continue;
                return null;
            }
        }
        return null;
    }

    public static int levelNest(ASTNode current, ASTNode root) {
        Class<?> cls = current.getClass();
        ASTNode currentIterator = current;
        int level = 0;
        while (!currentIterator.equals((Object)root)) {
            if ((currentIterator = currentIterator.getParent()) == null) {
                return level;
            }
            if (!currentIterator.getClass().equals(cls)) continue;
            ++level;
        }
        return level;
    }

    public static List getExpressionList(ASTNode node) {
        return ASTHelper.getExpressionList(node, true);
    }

    public static List getExpressionList(ASTNode node, boolean seachChildren) {
        if (node == null) {
            return new LinkedList();
        }
        CodeReviewVisitor visitor = new CodeReviewVisitor(EXPRESSION_TYPES, seachChildren);
        node.accept((ASTVisitor)visitor);
        return visitor.getAstNodeList();
    }

    public static List getVariableDeclarationList(ASTNode node) {
        return ASTHelper.getVariableDeclarationList(node, true);
    }

    public static List getVariableDeclarationList(ASTNode node, boolean seachChildren) {
        if (node == null) {
            return new LinkedList();
        }
        CodeReviewVisitor visitor = new CodeReviewVisitor(VARIABLE_DECLARATION_TYPES, seachChildren);
        node.accept((ASTVisitor)visitor);
        return visitor.getAstNodeList();
    }

    public static List getTypeList(ASTNode node) {
        CodeReviewVisitor visitor = new CodeReviewVisitor(DATA_TYPES);
        node.accept((ASTVisitor)visitor);
        return visitor.getAstNodeList();
    }

    private static boolean statisfies(ASTNode node, RuleFilter filter) {
        boolean match = false;
        switch (filter.getOperator()) {
            case 0: {
                match = ASTHelperSatisfy.satisfiesArgumentType(node, filter);
                break;
            }
            case 1: {
                match = ASTHelperSatisfy.satisfiesConstructors(node, filter);
                break;
            }
            case 2: {
                match = ASTHelperSatisfy.satisfiesDeclaringClass(node, filter);
                break;
            }
            case 3: {
                match = ASTHelperSatisfy.satisfiesEnclosingNode(node, filter);
                break;
            }
            case 4: {
                match = ASTHelperSatisfy.satisfiesExceptionCount(node, filter);
                break;
            }
            case 5: {
                match = ASTHelperSatisfy.satisfiesExpression(node, filter);
                break;
            }
            case 6: {
                match = ASTHelperSatisfy.satisfiesForInitializerCount(node, filter);
                break;
            }
            case 7: {
                match = ASTHelperSatisfy.satisfiesForUpdateCount(node, filter);
                break;
            }
            case 8: {
                match = ASTHelperSatisfy.satisfiesFragmentSize(node, filter);
                break;
            }
            case 9: {
                match = ASTHelperSatisfy.satisfiesIfElseStatement(node, filter);
                break;
            }
            case 10: {
                match = ASTHelperSatisfy.satisfiesIfElseStatementCount(node, filter);
                break;
            }
            case 11: {
                match = ASTHelperSatisfy.satisfiesIfThenStatement(node, filter);
                break;
            }
            case 12: {
                match = ASTHelperSatisfy.satisfiesIfThenStatementCount(node, filter);
                break;
            }
            case 13: {
                match = ASTHelperSatisfy.satisfiesImplementedInterface(node, filter);
                break;
            }
            case 15: {
                match = ASTHelperSatisfy.satisfiesMethodName(node, filter);
                break;
            }
            case 14: {
                match = ASTHelperSatisfy.satisfiesLeftOperand(node, filter);
                break;
            }
            case 16: {
                match = ASTHelperSatisfy.satisfiesModifier(node, filter);
                break;
            }
            case 17: {
                match = ASTHelperSatisfy.satisfiesOperator(node, filter);
                break;
            }
            case 18: {
                match = ASTHelperSatisfy.satisfiesParameterCount(node, filter);
                break;
            }
            case 19: {
                match = ASTHelperSatisfy.satisfiesParameterType(node, filter);
                break;
            }
            case 20: {
                match = ASTHelperSatisfy.satisfiesReturnType(node, filter);
                break;
            }
            case 21: {
                match = ASTHelperSatisfy.satisfiesRightOperand(node, filter);
                break;
            }
            case 22: {
                match = ASTHelperSatisfy.satisfiesSuperClass(node, filter);
                break;
            }
            case 23: {
                match = ASTHelperSatisfy.satisfiesType(node, filter);
            }
        }
        return (!filter.isInclusive() || match) && (filter.isInclusive() || !match);
    }

    public static ASTNode getEnclosingTypeDeclaration(ASTNode node) {
        ASTNode currentNode = node;
        while (currentNode != null && currentNode.getNodeType() != 55) {
            currentNode = currentNode.getParent();
        }
        return currentNode;
    }

    public static List getInterfaceList(ITypeBinding type) {
        try {
            List allInterfaces = ASTHelper.getAllExtendedInterfaceTypes(type);
            List superClasses = ASTHelper.getSuperTypes(type);
            Iterator iter = superClasses.iterator();
            while (iter.hasNext()) {
                ITypeBinding superClass = (ITypeBinding)iter.next();
                allInterfaces.addAll(ASTHelper.getAllExtendedInterfaceTypes(superClass));
            }
            return allInterfaces;
        }
        catch (NullPointerException nullPointerException) {
            return new LinkedList();
        }
    }

    private static List getAllExtendedInterfaceTypes(ITypeBinding type) {
        ArrayList<ITypeBinding> toReturn = new ArrayList<ITypeBinding>();
        ITypeBinding[] extendedInterfaces = type.getInterfaces();
        int numExtendedInterfaces = extendedInterfaces.length;
        if (numExtendedInterfaces == 0) {
            return toReturn;
        }
        int i = 0;
        while (i < numExtendedInterfaces) {
            toReturn.add(extendedInterfaces[i]);
            toReturn.addAll(ASTHelper.getAllExtendedInterfaceTypes(extendedInterfaces[i]));
            ++i;
        }
        return toReturn;
    }

    private static List getSuperTypes(ITypeBinding type) {
        ArrayList<ITypeBinding> toReturn = new ArrayList<ITypeBinding>();
        if (!type.isClass()) {
            return toReturn;
        }
        ITypeBinding superType = type.getSuperclass();
        while (superType != null) {
            toReturn.add(superType);
            superType = superType.getSuperclass();
        }
        return toReturn;
    }

    public static boolean doesAnyLineContain(String source, ASTNode node, String value) {
        CompilationUnit root = (CompilationUnit)node.getRoot();
        int startPosition = node.getStartPosition();
        int length = node.getLength();
        int start = root.getLineNumber(startPosition);
        int end = root.getLineNumber(startPosition + length);
        StringReader sr = new StringReader(source);
        BufferedReader br = new BufferedReader(sr);
        try {
            int i = 1;
            while (i <= end) {
                String line = br.readLine();
                if (i >= start && line.indexOf(value) > 0) {
                    return true;
                }
                ++i;
            }
        }
        catch (IOException iOException) {}
        return false;
    }

    public static int getLineCount(ASTNode node) {
        CompilationUnit root = (CompilationUnit)node.getRoot();
        int startPosition = node.getStartPosition();
        int length = node.getLength();
        int start = root.getLineNumber(startPosition);
        int end = root.getLineNumber(startPosition + length);
        return end - start;
    }
}

