/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.analysis.codereview.java.ast.internal;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.tptp.platform.analysis.codereview.java.Messages;
import org.eclipse.tptp.platform.analysis.codereview.java.ast.RuleFilter;
import org.eclipse.tptp.platform.analysis.codereview.java.ast.internal.ASTHelperUtils;
import org.eclipse.tptp.platform.analysis.core.logging.Log;

public class ASTHelperSatisfy {
    private static final String SATISFIES_CONSTRUCTORS = "satisfiesConstructors";
    private static final String SATISFIES_ARGUMENT_TYPE = "satisfiesArgumentType";

    public static boolean satisfiesArgumentType(ASTNode node, RuleFilter filter) {
        try {
            switch (node.getNodeType()) {
                case 32: {
                    return ((Expression)((MethodInvocation)node).arguments().get(filter.getIntValue())).resolveTypeBinding().getQualifiedName().equals(filter.getStringValue());
                }
                case 48: {
                    return ((Expression)((SuperMethodInvocation)node).arguments().get(filter.getIntValue())).resolveTypeBinding().getQualifiedName().equals(filter.getStringValue());
                }
                case 46: {
                    return ((Expression)((SuperConstructorInvocation)node).arguments().get(filter.getIntValue())).resolveTypeBinding().getQualifiedName().equals(filter.getStringValue());
                }
            }
            Log.severe((String)Messages.bind((String)Messages.RULE_FILTER_ERROR_, (Object[])new Object[]{SATISFIES_ARGUMENT_TYPE, node.getClass().getName()}));
        }
        catch (Exception exception) {}
        return false;
    }

    public static boolean satisfiesConstructors(ASTNode node, RuleFilter filter) {
        try {
            switch (node.getNodeType()) {
                case 31: {
                    return ((MethodDeclaration)node).isConstructor();
                }
            }
            Log.severe((String)Messages.bind((String)Messages.RULE_FILTER_ERROR_, (Object[])new Object[]{SATISFIES_CONSTRUCTORS, node.getClass().getName()}));
        }
        catch (NullPointerException nullPointerException) {}
        return false;
    }

    public static boolean satisfiesDeclaringClass(ASTNode node, RuleFilter filter) {
        try {
            switch (node.getNodeType()) {
                case 32: {
                    return ((MethodInvocation)node).resolveMethodBinding().getDeclaringClass().getQualifiedName().equals(filter.getStringValue());
                }
                case 48: {
                    return ((SuperMethodInvocation)node).resolveMethodBinding().getDeclaringClass().getQualifiedName().equals(filter.getStringValue());
                }
                case 31: {
                    return ((MethodDeclaration)node).resolveBinding().getDeclaringClass().getQualifiedName().equals(filter.getStringValue());
                }
                case 46: {
                    return ((SuperConstructorInvocation)node).resolveConstructorBinding().getDeclaringClass().getQualifiedName().equals(filter.getStringValue());
                }
                case 14: {
                    return ((ClassInstanceCreation)node).resolveConstructorBinding().getDeclaringClass().getQualifiedName().equals(filter.getStringValue());
                }
            }
            Log.severe((String)Messages.bind((String)Messages.RULE_FILTER_ERROR_, (Object[])new Object[]{"satisfiesDeclaringClass", node.getClass().getName()}));
        }
        catch (NullPointerException nullPointerException) {}
        return false;
    }

    public static boolean satisfiesEnclosingNode(ASTNode node, RuleFilter filter) {
        try {
            switch (node.getNodeType()) {
                case 25: {
                    return ASTHelperUtils.getEnclosingASTNodeType(node).equals((Object)filter.getNodeValue());
                }
                case 32: {
                    return ASTHelperUtils.getEnclosingASTNodeType(node).equals((Object)filter.getNodeValue());
                }
            }
            Log.severe((String)Messages.bind((String)Messages.RULE_FILTER_ERROR_, (Object[])new Object[]{"satisfiesEnclosingNode", node.getClass().getName()}));
        }
        catch (NullPointerException nullPointerException) {}
        return false;
    }

    public static boolean satisfiesExceptionCount(ASTNode node, RuleFilter filter) {
        try {
            switch (node.getNodeType()) {
                case 31: {
                    return ((MethodDeclaration)node).resolveBinding().getExceptionTypes().length == filter.getIntValue();
                }
                case 32: {
                    return ((MethodInvocation)node).resolveMethodBinding().getExceptionTypes().length == filter.getIntValue();
                }
                case 48: {
                    return ((SuperMethodInvocation)node).resolveMethodBinding().getExceptionTypes().length == filter.getIntValue();
                }
            }
            Log.severe((String)Messages.bind((String)Messages.RULE_FILTER_ERROR_, (Object[])new Object[]{"satisfiesExceptionCount", node.getClass().getName()}));
        }
        catch (NullPointerException nullPointerException) {}
        return false;
    }

    public static boolean satisfiesExpression(ASTNode node, RuleFilter filter) {
        try {
            switch (node.getNodeType()) {
                case 24: {
                    return ((ForStatement)node).getExpression() == filter.getNodeValue();
                }
            }
            Log.severe((String)Messages.bind((String)Messages.RULE_FILTER_ERROR_, (Object[])new Object[]{"satisfiesExpression", node.getClass().getName()}));
        }
        catch (NullPointerException nullPointerException) {}
        return false;
    }

    public static boolean satisfiesForInitializerCount(ASTNode node, RuleFilter filter) {
        try {
            switch (node.getNodeType()) {
                case 24: {
                    return ((ForStatement)node).initializers().size() == filter.getIntValue();
                }
            }
            Log.severe((String)Messages.bind((String)Messages.RULE_FILTER_ERROR_, (Object[])new Object[]{"satisfiesForInitializerCount", node.getClass().getName()}));
        }
        catch (NullPointerException nullPointerException) {}
        return false;
    }

    public static boolean satisfiesForUpdateCount(ASTNode node, RuleFilter filter) {
        try {
            switch (node.getNodeType()) {
                case 24: {
                    return ((ForStatement)node).updaters().size() == filter.getIntValue();
                }
            }
            Log.severe((String)Messages.bind((String)Messages.RULE_FILTER_ERROR_, (Object[])new Object[]{"satisfiesForUpdateCount", node.getClass().getName()}));
        }
        catch (NullPointerException nullPointerException) {}
        return false;
    }

    public static boolean satisfiesFragmentSize(ASTNode node, RuleFilter filter) {
        try {
            switch (node.getNodeType()) {
                case 60: {
                    return ((VariableDeclarationStatement)node).fragments().size() == filter.getIntValue();
                }
                case 23: {
                    return ((FieldDeclaration)node).fragments().size() == filter.getIntValue();
                }
            }
            Log.severe((String)Messages.bind((String)Messages.RULE_FILTER_ERROR_, (Object[])new Object[]{"satisfiesFragmentSize", node.getClass().getName()}));
        }
        catch (NullPointerException nullPointerException) {}
        return false;
    }

    public static boolean satisfiesIfElseStatementCount(ASTNode node, RuleFilter filter) {
        try {
            switch (node.getNodeType()) {
                case 25: {
                    return ASTHelperSatisfy.getStatementLength((ASTNode)((IfStatement)node).getElseStatement()) == filter.getIntValue();
                }
            }
            Log.severe((String)Messages.bind((String)Messages.RULE_FILTER_ERROR_, (Object[])new Object[]{"satisfiesIfElseStatementCount", node.getClass().getName()}));
        }
        catch (NullPointerException nullPointerException) {}
        return false;
    }

    public static boolean satisfiesIfElseStatement(ASTNode node, RuleFilter filter) {
        try {
            switch (node.getNodeType()) {
                case 25: {
                    return ((IfStatement)node).getElseStatement() != null;
                }
            }
            Log.severe((String)Messages.bind((String)Messages.RULE_FILTER_ERROR_, (Object[])new Object[]{"satisfiesIfElseStatement", node.getClass().getName()}));
        }
        catch (NullPointerException nullPointerException) {}
        return false;
    }

    public static boolean satisfiesIfThenStatementCount(ASTNode node, RuleFilter filter) {
        try {
            switch (node.getNodeType()) {
                case 25: {
                    return ASTHelperSatisfy.getStatementLength((ASTNode)((IfStatement)node).getThenStatement()) == filter.getIntValue();
                }
            }
            Log.severe((String)Messages.bind((String)Messages.RULE_FILTER_ERROR_, (Object[])new Object[]{"satisfiesIfThenStatementCount", node.getClass().getName()}));
        }
        catch (NullPointerException nullPointerException) {}
        return false;
    }

    public static boolean satisfiesIfThenStatement(ASTNode node, RuleFilter filter) {
        try {
            switch (node.getNodeType()) {
                case 25: {
                    return ((IfStatement)node).getThenStatement() != null;
                }
            }
            Log.severe((String)Messages.bind((String)Messages.RULE_FILTER_ERROR_, (Object[])new Object[]{"satisfiesIfThenStatement", node.getClass().getName()}));
        }
        catch (NullPointerException nullPointerException) {}
        return false;
    }

    public static boolean satisfiesImplementedInterface(ASTNode node, RuleFilter filter) {
        block21: {
            try {
                if (filter.getStringValues() == null) {
                    switch (node.getNodeType()) {
                        case 55: {
                            List interfaceList = ASTHelperUtils.getInterfaceList(((TypeDeclaration)node).resolveBinding());
                            Iterator it2 = interfaceList.iterator();
                            while (it2.hasNext()) {
                                String typeName = ((ITypeBinding)it2.next()).getQualifiedName();
                                if (!filter.getStringValue().equals(typeName)) continue;
                                return true;
                            }
                            break block21;
                        }
                        case 23: {
                            List interfaceList = ASTHelperUtils.getInterfaceList(((FieldDeclaration)node).getType().resolveBinding());
                            Iterator it2 = interfaceList.iterator();
                            while (it2.hasNext()) {
                                String typeName = ((ITypeBinding)it2.next()).getQualifiedName();
                                if (!filter.getStringValue().equals(typeName)) continue;
                                return true;
                            }
                            break block21;
                        }
                        case 1: {
                            List interfaceList = ASTHelperUtils.getInterfaceList(((AnonymousClassDeclaration)node).resolveBinding());
                            Iterator it2 = interfaceList.iterator();
                            while (it2.hasNext()) {
                                String typeName = ((ITypeBinding)it2.next()).getQualifiedName();
                                if (!filter.getStringValue().equals(typeName)) continue;
                                return true;
                            }
                            break block21;
                        }
                        default: {
                            Log.severe((String)Messages.bind((String)Messages.RULE_FILTER_ERROR_, (Object[])new Object[]{"satisfiesImplementedInterface", node.getClass().getName()}));
                            break;
                        }
                    }
                    break block21;
                }
                switch (node.getNodeType()) {
                    case 55: {
                        List interfaceList = ASTHelperUtils.getInterfaceList(((TypeDeclaration)node).resolveBinding());
                        Iterator it2 = interfaceList.iterator();
                        while (it2.hasNext()) {
                            String typeName = ((ITypeBinding)it2.next()).getQualifiedName();
                            int iCtr = 0;
                            while (iCtr < filter.getStringValues().length) {
                                String interfaceName = filter.getStringValues()[iCtr];
                                if (interfaceName.equals(typeName)) {
                                    return true;
                                }
                                ++iCtr;
                            }
                        }
                        break;
                    }
                    case 1: {
                        List interfaceList = ASTHelperUtils.getInterfaceList(((AnonymousClassDeclaration)node).resolveBinding());
                        Iterator it2 = interfaceList.iterator();
                        while (it2.hasNext()) {
                            String typeName = ((ITypeBinding)it2.next()).getQualifiedName();
                            int iCtr = 0;
                            while (iCtr < filter.getStringValues().length) {
                                if (filter.getStringValues()[iCtr].equals(typeName)) {
                                    return true;
                                }
                                ++iCtr;
                            }
                        }
                        break;
                    }
                    default: {
                        Log.severe((String)Messages.bind((String)Messages.RULE_FILTER_ERROR_, (Object[])new Object[]{"satisfiesImplementedInterface", node.getClass().getName()}));
                        break;
                    }
                }
            }
            catch (Exception exception) {}
        }
        return false;
    }

    public static boolean satisfiesLeftOperand(ASTNode node, RuleFilter filter) {
        block11: {
            try {
                if (filter.getIntValues() == null) {
                    switch (node.getNodeType()) {
                        case 27: {
                            return ASTHelperUtils.matchTypeModifier(((InfixExpression)node).getLeftOperand().resolveTypeBinding(), filter.getIntValue());
                        }
                    }
                    Log.severe((String)Messages.bind((String)Messages.RULE_FILTER_ERROR_, (Object[])new Object[]{"satisfiesLeftOperand", node.getClass().getName()}));
                    break block11;
                }
                switch (node.getNodeType()) {
                    case 27: {
                        int iCtr = 0;
                        while (iCtr < filter.getIntValues().length) {
                            if (ASTHelperUtils.matchTypeModifier(((InfixExpression)node).getLeftOperand().resolveTypeBinding(), filter.getIntValues()[iCtr])) {
                                return true;
                            }
                            ++iCtr;
                        }
                        break;
                    }
                    default: {
                        Log.severe((String)Messages.bind((String)Messages.RULE_FILTER_ERROR_, (Object[])new Object[]{"satisfiesLeftOperand", node.getClass().getName()}));
                        break;
                    }
                }
            }
            catch (Exception exception) {}
        }
        return false;
    }

    public static boolean satisfiesMethodName(ASTNode node, RuleFilter filter) {
        block31: {
            try {
                if (filter.getStringValues() == null) {
                    switch (node.getNodeType()) {
                        case 32: {
                            return ((MethodInvocation)node).getName().getIdentifier().equals(filter.getStringValue());
                        }
                        case 48: {
                            return ((SuperMethodInvocation)node).getName().getIdentifier().equals(filter.getStringValue());
                        }
                        case 31: {
                            return ((MethodDeclaration)node).getName().getIdentifier().equals(filter.getStringValue());
                        }
                        case 55: {
                            return ((TypeDeclaration)node).getName().getIdentifier().equals(filter.getStringValue());
                        }
                        case 59: {
                            return ((VariableDeclarationFragment)node).getName().getIdentifier().equals(filter.getStringValue());
                        }
                        case 40: {
                            return ((QualifiedName)node).getFullyQualifiedName().equals(filter.getStringValue());
                        }
                    }
                    Log.severe((String)Messages.bind((String)Messages.RULE_FILTER_ERROR_, (Object[])new Object[]{"satisfiesMethodName", node.getClass().getName()}));
                    break block31;
                }
                switch (node.getNodeType()) {
                    case 32: {
                        int iCtr = 0;
                        while (iCtr < filter.getStringValues().length) {
                            if (((MethodInvocation)node).getName().getIdentifier().equals(filter.getStringValues()[iCtr])) {
                                return true;
                            }
                            ++iCtr;
                        }
                        break;
                    }
                    case 48: {
                        int iCtr = 0;
                        while (iCtr < filter.getStringValues().length) {
                            if (((SuperMethodInvocation)node).getName().getIdentifier().equals(filter.getStringValues()[iCtr])) {
                                return true;
                            }
                            ++iCtr;
                        }
                        break;
                    }
                    case 31: {
                        int iCtr = 0;
                        while (iCtr < filter.getStringValues().length) {
                            if (((MethodDeclaration)node).getName().getIdentifier().equals(filter.getStringValues()[iCtr])) {
                                return true;
                            }
                            ++iCtr;
                        }
                        break;
                    }
                    case 55: {
                        int iCtr = 0;
                        while (iCtr < filter.getStringValues().length) {
                            if (((TypeDeclaration)node).getName().getIdentifier().equals(filter.getStringValues()[iCtr])) {
                                return true;
                            }
                            ++iCtr;
                        }
                        break;
                    }
                    case 59: {
                        int iCtr = 0;
                        while (iCtr < filter.getStringValues().length) {
                            if (((VariableDeclarationFragment)node).getName().getIdentifier().equals(filter.getStringValues()[iCtr])) {
                                return true;
                            }
                            ++iCtr;
                        }
                        break;
                    }
                    case 40: {
                        int iCtr = 0;
                        while (iCtr < filter.getStringValues().length) {
                            if (((QualifiedName)node).getFullyQualifiedName().equals(filter.getStringValues()[iCtr])) {
                                return true;
                            }
                            ++iCtr;
                        }
                        break;
                    }
                    default: {
                        Log.severe((String)Messages.bind((String)Messages.RULE_FILTER_ERROR_, (Object[])new Object[]{"satisfiesMethodName", node.getClass().getName()}));
                        break;
                    }
                }
            }
            catch (NullPointerException nullPointerException) {}
        }
        return false;
    }

    public static boolean satisfiesModifier(ASTNode node, RuleFilter filter) {
        block33: {
            try {
                if (filter.getIntValues() == null) {
                    switch (node.getNodeType()) {
                        case 23: {
                            FieldDeclaration fd = (FieldDeclaration)node;
                            return ASTHelperUtils.matchModifier(fd.getModifiers(), filter.getIntValue()) || ASTHelperUtils.matchTypeModifier(fd.getType().resolveBinding(), filter.getIntValue());
                        }
                        case 32: {
                            return ASTHelperUtils.matchBindingModifier((IBinding)((MethodInvocation)node).resolveMethodBinding(), filter.getIntValue());
                        }
                        case 48: {
                            return ASTHelperUtils.matchBindingModifier((IBinding)((SuperMethodInvocation)node).resolveMethodBinding(), filter.getIntValue());
                        }
                        case 31: {
                            MethodDeclaration md = (MethodDeclaration)node;
                            boolean match = ASTHelperUtils.matchModifier(md.getModifiers(), filter.getIntValue());
                            if (!match && md.getReturnType2() != null) {
                                match = ASTHelperUtils.matchTypeModifier(md.getReturnType2().resolveBinding(), filter.getIntValue());
                            }
                            return match;
                        }
                        case 1: {
                            return ASTHelperUtils.matchBindingModifier((IBinding)((AnonymousClassDeclaration)node).resolveBinding(), filter.getIntValue());
                        }
                        case 55: {
                            TypeDeclaration td = (TypeDeclaration)node;
                            ITypeBinding binding = td.resolveBinding();
                            return ASTHelperUtils.matchBindingModifier((IBinding)binding, filter.getIntValue()) || ASTHelperUtils.matchTypeModifier(binding, filter.getIntValue());
                        }
                    }
                    Log.severe((String)Messages.bind((String)Messages.RULE_FILTER_ERROR_, (Object[])new Object[]{"satisfiesModifier", node.getClass().getName()}));
                    break block33;
                }
                switch (node.getNodeType()) {
                    case 23: {
                        FieldDeclaration fd = (FieldDeclaration)node;
                        int iCtr = 0;
                        while (iCtr < filter.getIntValues().length) {
                            if (ASTHelperUtils.matchModifier(fd.getModifiers(), filter.getIntValues()[iCtr]) || ASTHelperUtils.matchTypeModifier(fd.getType().resolveBinding(), filter.getIntValues()[iCtr])) {
                                return true;
                            }
                            ++iCtr;
                        }
                        break;
                    }
                    case 32: {
                        int iCtr = 0;
                        while (iCtr < filter.getIntValues().length) {
                            if (ASTHelperUtils.matchBindingModifier((IBinding)((MethodInvocation)node).resolveMethodBinding(), filter.getIntValues()[iCtr])) {
                                return true;
                            }
                            ++iCtr;
                        }
                        break;
                    }
                    case 48: {
                        int iCtr = 0;
                        while (iCtr < filter.getIntValues().length) {
                            if (ASTHelperUtils.matchBindingModifier((IBinding)((SuperMethodInvocation)node).resolveMethodBinding(), filter.getIntValues()[iCtr])) {
                                return true;
                            }
                            ++iCtr;
                        }
                        break;
                    }
                    case 1: {
                        int iCtr = 0;
                        while (iCtr < filter.getIntValues().length) {
                            if (ASTHelperUtils.matchBindingModifier((IBinding)((AnonymousClassDeclaration)node).resolveBinding(), filter.getIntValues()[iCtr])) {
                                return true;
                            }
                            ++iCtr;
                        }
                        break;
                    }
                    case 31: {
                        MethodDeclaration md = (MethodDeclaration)node;
                        int iCtr = 0;
                        while (iCtr < filter.getIntValues().length) {
                            boolean match = ASTHelperUtils.matchModifier(md.getModifiers(), filter.getIntValues()[iCtr]);
                            if (!match && md.getReturnType2() != null) {
                                match = ASTHelperUtils.matchTypeModifier(md.getReturnType2().resolveBinding(), filter.getIntValues()[iCtr]);
                            }
                            if (match) {
                                return true;
                            }
                            ++iCtr;
                        }
                        break;
                    }
                    case 55: {
                        ITypeBinding binding = ((TypeDeclaration)node).resolveBinding();
                        int iCtr = 0;
                        while (iCtr < filter.getIntValues().length) {
                            if (ASTHelperUtils.matchBindingModifier((IBinding)binding, filter.getIntValues()[iCtr]) || ASTHelperUtils.matchTypeModifier(binding, filter.getIntValues()[iCtr])) {
                                return true;
                            }
                            ++iCtr;
                        }
                        break;
                    }
                    default: {
                        Log.severe((String)Messages.bind((String)Messages.RULE_FILTER_ERROR_, (Object[])new Object[]{"satisfiesModifier", node.getClass().getName()}));
                        break;
                    }
                }
            }
            catch (NullPointerException nullPointerException) {}
        }
        return false;
    }

    public static boolean satisfiesOperator(ASTNode node, RuleFilter filter) {
        block19: {
            try {
                if (filter.getStringValues() == null) {
                    switch (node.getNodeType()) {
                        case 27: {
                            return ((InfixExpression)node).getOperator().toString().equals(filter.getStringValue());
                        }
                        case 37: {
                            return ((PostfixExpression)node).getOperator().toString().equals(filter.getStringValue());
                        }
                        case 38: {
                            return ((PrefixExpression)node).getOperator().toString().equals(filter.getStringValue());
                        }
                    }
                    Log.severe((String)Messages.bind((String)Messages.RULE_FILTER_ERROR_, (Object[])new Object[]{"satisfiesOperator", node.getClass().getName()}));
                    break block19;
                }
                switch (node.getNodeType()) {
                    case 27: {
                        int iCtr = 0;
                        while (iCtr < filter.getStringValues().length) {
                            if (((InfixExpression)node).getOperator().toString().equals(filter.getStringValues()[iCtr])) {
                                return true;
                            }
                            ++iCtr;
                        }
                        break;
                    }
                    case 37: {
                        int iCtr = 0;
                        while (iCtr < filter.getStringValues().length) {
                            if (((PostfixExpression)node).getOperator().toString().equals(filter.getStringValues()[iCtr])) {
                                return true;
                            }
                            ++iCtr;
                        }
                        break;
                    }
                    case 38: {
                        int iCtr = 0;
                        while (iCtr < filter.getStringValues().length) {
                            if (((PrefixExpression)node).getOperator().toString().equals(filter.getStringValues()[iCtr])) {
                                return true;
                            }
                            ++iCtr;
                        }
                        break;
                    }
                    default: {
                        Log.severe((String)Messages.bind((String)Messages.RULE_FILTER_ERROR_, (Object[])new Object[]{"satisfiesOperator", node.getClass().getName()}));
                        break;
                    }
                }
            }
            catch (NullPointerException nullPointerException) {}
        }
        return false;
    }

    public static boolean satisfiesParameterCount(ASTNode node, RuleFilter filter) {
        try {
            switch (node.getNodeType()) {
                case 32: {
                    return ((MethodInvocation)node).arguments().size() == filter.getIntValue();
                }
                case 48: {
                    return ((SuperMethodInvocation)node).arguments().size() == filter.getIntValue();
                }
                case 46: {
                    return ((SuperConstructorInvocation)node).resolveConstructorBinding().getParameterTypes().length == filter.getIntValue();
                }
                case 31: {
                    return ((MethodDeclaration)node).parameters().size() == filter.getIntValue();
                }
                case 14: {
                    return ((ClassInstanceCreation)node).arguments().size() == filter.getIntValue();
                }
            }
            Log.severe((String)Messages.bind((String)Messages.RULE_FILTER_ERROR_, (Object[])new Object[]{"satisfiesParameterCount", node.getClass().getName()}));
        }
        catch (NullPointerException nullPointerException) {}
        return false;
    }

    public static boolean satisfiesParameterType(ASTNode node, RuleFilter filter) {
        try {
            switch (node.getNodeType()) {
                case 32: {
                    ITypeBinding[] mitypes = ((MethodInvocation)node).resolveMethodBinding().getParameterTypes();
                    if (mitypes.length > 0) {
                        return filter.getStringValue().equals(mitypes[filter.getIntValue()].getQualifiedName());
                    }
                    break;
                }
                case 31: {
                    ITypeBinding[] mdtypes = ((MethodDeclaration)node).resolveBinding().getParameterTypes();
                    if (mdtypes.length > 0) {
                        return filter.getStringValue().equals(mdtypes[filter.getIntValue()].getQualifiedName());
                    }
                    break;
                }
                case 48: {
                    ITypeBinding[] smitypes = ((SuperMethodInvocation)node).resolveMethodBinding().getParameterTypes();
                    if (smitypes.length > 0) {
                        return filter.getStringValue().equals(smitypes[filter.getIntValue()].getQualifiedName());
                    }
                    break;
                }
                case 46: {
                    ITypeBinding[] scitypes = ((SuperConstructorInvocation)node).resolveConstructorBinding().getParameterTypes();
                    if (scitypes.length > 0) {
                        return filter.getStringValue().equals(scitypes[filter.getIntValue()].getQualifiedName());
                    }
                    break;
                }
                case 14: {
                    ITypeBinding[] types = ((ClassInstanceCreation)node).resolveConstructorBinding().getParameterTypes();
                    if (types.length > 0) {
                        return filter.getStringValue().equals(types[filter.getIntValue()].getQualifiedName());
                    }
                    break;
                }
                default: {
                    Log.severe((String)Messages.bind((String)Messages.RULE_FILTER_ERROR_, (Object[])new Object[]{"satisfiesParameterType", node.getClass().getName()}));
                    break;
                }
            }
        }
        catch (NullPointerException nullPointerException) {}
        return false;
    }

    public static boolean satisfiesReturnType(ASTNode node, RuleFilter filter) {
        try {
            switch (node.getNodeType()) {
                case 32: {
                    return ((MethodInvocation)node).resolveMethodBinding().getReturnType().getQualifiedName().equals(filter.getStringValue());
                }
                case 48: {
                    return ((SuperMethodInvocation)node).resolveMethodBinding().getReturnType().getQualifiedName().equals(filter.getStringValue());
                }
                case 31: {
                    return ((MethodDeclaration)node).getReturnType2().resolveBinding().getQualifiedName().equals(filter.getStringValue());
                }
            }
            Log.severe((String)Messages.bind((String)Messages.RULE_FILTER_ERROR_, (Object[])new Object[]{"satisfiesReturnType", node.getClass().getName()}));
        }
        catch (NullPointerException nullPointerException) {}
        return false;
    }

    public static boolean satisfiesRightOperand(ASTNode node, RuleFilter filter) {
        block11: {
            try {
                if (filter.getIntValues() == null) {
                    switch (node.getNodeType()) {
                        case 27: {
                            return ASTHelperUtils.matchTypeModifier(((InfixExpression)node).getRightOperand().resolveTypeBinding(), filter.getIntValue());
                        }
                    }
                    Log.severe((String)Messages.bind((String)Messages.RULE_FILTER_ERROR_, (Object[])new Object[]{"satisfiesRightOperand", node.getClass().getName()}));
                    break block11;
                }
                switch (node.getNodeType()) {
                    case 27: {
                        int iCtr = 0;
                        while (iCtr < filter.getIntValues().length) {
                            if (ASTHelperUtils.matchTypeModifier(((InfixExpression)node).getRightOperand().resolveTypeBinding(), filter.getIntValues()[iCtr])) {
                                return true;
                            }
                            ++iCtr;
                        }
                        break;
                    }
                    default: {
                        Log.severe((String)Messages.bind((String)Messages.RULE_FILTER_ERROR_, (Object[])new Object[]{"satisfiesRightOperand", node.getClass().getName()}));
                        break;
                    }
                }
            }
            catch (NullPointerException nullPointerException) {}
        }
        return false;
    }

    public static boolean satisfiesSuperClass(ASTNode node, RuleFilter filter) {
        try {
            switch (node.getNodeType()) {
                case 55: {
                    Type superClassType = ((TypeDeclaration)node).getSuperclassType();
                    if (superClassType != null) {
                        return superClassType.resolveBinding().getQualifiedName().equals(filter.getStringValue());
                    }
                    break;
                }
                default: {
                    Log.severe((String)Messages.bind((String)Messages.RULE_FILTER_ERROR_, (Object[])new Object[]{"satisfiesSuperClass", node.getClass().getName()}));
                    break;
                }
            }
        }
        catch (NullPointerException nullPointerException) {}
        return false;
    }

    public static boolean satisfiesType(ASTNode node, RuleFilter filter) {
        try {
            switch (node.getNodeType()) {
                case 44: {
                    IVariableBinding binding = ((SingleVariableDeclaration)node).resolveBinding();
                    return binding.getType() != null && binding.getType().getQualifiedName().equals(filter.getStringValue());
                }
                case 59: {
                    IVariableBinding binding = ((VariableDeclarationFragment)node).resolveBinding();
                    return binding.getType() != null && binding.getType().getQualifiedName().equals(filter.getStringValue());
                }
            }
            Log.severe((String)Messages.bind((String)Messages.RULE_FILTER_ERROR_, (Object[])new Object[]{"satisfiesType", node.getClass().getName()}));
        }
        catch (NullPointerException nullPointerException) {}
        return false;
    }

    private static int getStatementLength(ASTNode node) {
        if (node instanceof Block) {
            return ((Block)node).statements().size();
        }
        return 1;
    }
}

